/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.ovmcompliance.IOVMComplianceStatistic;
import ro.amiq.edt.ovmcompliance.IOVMComplianceStatisticHit;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheckBase;
import ro.amiq.edt.ovmcompliance.OVMComplianceManager;
import ro.amiq.edt.ovmcompliance.OVMComplianceStatisticHit;
import ro.amiq.edt.ovmcompliance.OVMProject;

public abstract class OVMComplianceStatistic
extends OVMComplianceCheckBase
implements IOVMComplianceStatistic {
    private ArrayList<IOVMComplianceStatisticHit> fStatisticHits;
    protected boolean fGenerated = false;

    public OVMComplianceStatistic(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.fStatisticHits = new ArrayList();
        if (category != null) {
            category.addStatistic(this);
        }
    }

    public OVMComplianceStatistic(OVMProject oVMProject, OVMComplianceCategory category, OVMComplianceCheckBase parentCheck) {
        super(oVMProject, category, parentCheck);
        if (parentCheck != null) {
            this.fGenerated = true;
        }
        this.fStatisticHits = new ArrayList();
        if (category != null) {
            category.addStatistic(this);
        }
    }

    @Override
    public ArrayList<IOVMComplianceStatisticHit> getHits() {
        Collections.sort(this.fStatisticHits, new OVMComplianceStatisticComparator());
        if (OVMComplianceManager.getInstance().isLimited()) {
            ArrayList<IOVMComplianceStatisticHit> result = new ArrayList<IOVMComplianceStatisticHit>(this.fStatisticHits.size());
            int i = 0;
            while (i < this.fStatisticHits.size()) {
                if (i == 0) {
                    result.add(this.fStatisticHits.get(0));
                } else {
                    result.add(new OVMComplianceStatisticHit("limited version - will show only first hit", null, 0, 1));
                }
                ++i;
            }
            return result;
        }
        if (OVMComplianceManager.getInstance().isNotLimited()) {
            return this.fStatisticHits;
        }
        return null;
    }

    @Override
    public int getNofHits() {
        if (OVMComplianceManager.getInstance().isLimited()) {
            return Math.min(this.getHits(this.fStatisticHits), 1);
        }
        if (OVMComplianceManager.getInstance().isNotLimited()) {
            return this.getHits(this.fStatisticHits);
        }
        return -1;
    }

    private int getHits(ArrayList<IOVMComplianceStatisticHit> statisticHits) {
        if (statisticHits == null) {
            return 0;
        }
        int result = 0;
        for (IOVMComplianceStatisticHit hit : statisticHits) {
            result += hit.getNumberOfHits();
        }
        return result;
    }

    @Override
    protected void resetResultInfo() {
        this.fStatisticHits.clear();
    }

    protected void addAllHits(OVMComplianceStatistic satistic) {
        this.fStatisticHits.addAll(satistic.fStatisticHits);
    }

    protected void addHit(RfNamedElement elm, String details) {
        if (elm == null) {
            this.addHit("none", 0, details, 1);
        } else {
            this.addHit(elm.getModule().getParserPath().path, elm.getLine(), details, 1);
        }
    }

    protected void addHit(RfDefElement elm, int numberOfHits, String details) {
        if (elm == null) {
            this.addHit("none", 0, details, numberOfHits);
        } else {
            this.addHit(elm.getLayerModule().getParserPath().path, elm.getStartLine(), details, numberOfHits);
        }
    }

    protected void addHit(String file, int line, String details, int numberOfHits) {
        this.addHitNoDuplicates(new OVMComplianceStatisticHit(file, details, line, numberOfHits));
    }

    private void addHitNoDuplicates(OVMComplianceStatisticHit newHit) {
        boolean found = false;
        int i = 0;
        while (i < this.fStatisticHits.size()) {
            OVMComplianceStatisticHit hit = (OVMComplianceStatisticHit)this.fStatisticHits.get(i);
            if (Utils.canonicPath((String)hit.getFile()).equals(Utils.canonicPath((String)newHit.getFile())) && hit.getLine() == newHit.getLine() && hit.getDetails().equals(newHit.getDetails())) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.fStatisticHits.add(newHit);
        }
    }

    @Override
    public boolean isGenerated() {
        return this.fGenerated;
    }

    static class OVMComplianceStatisticComparator
    implements Comparator<IOVMComplianceStatisticHit> {
        OVMComplianceStatisticComparator() {
        }

        @Override
        public int compare(IOVMComplianceStatisticHit o1, IOVMComplianceStatisticHit o2) {
            int stringCompareResult = o1.getFile().compareTo(o2.getFile());
            if (stringCompareResult != 0) {
                return stringCompareResult;
            }
            return o1.getLine() - o2.getLine();
        }
    }
}

