/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.base.test.AbstractTestHelper;
import ro.amiq.edt.base.ui.preferences.PrefConst;
import ro.amiq.edt.core.EDTPlugin;
import ro.amiq.edt.model.reflection.RfManager;
import ro.amiq.edt.ovmcompliance.CheckARAA;
import ro.amiq.edt.ovmcompliance.CheckARAC;
import ro.amiq.edt.ovmcompliance.CheckARBF;
import ro.amiq.edt.ovmcompliance.CheckARIN;
import ro.amiq.edt.ovmcompliance.CheckARMN;
import ro.amiq.edt.ovmcompliance.CheckARMP;
import ro.amiq.edt.ovmcompliance.CheckARNM;
import ro.amiq.edt.ovmcompliance.CheckAROA;
import ro.amiq.edt.ovmcompliance.CheckAROB;
import ro.amiq.edt.ovmcompliance.CheckAROC;
import ro.amiq.edt.ovmcompliance.CheckAROE;
import ro.amiq.edt.ovmcompliance.CheckAROM;
import ro.amiq.edt.ovmcompliance.CheckAROS;
import ro.amiq.edt.ovmcompliance.CheckARSA;
import ro.amiq.edt.ovmcompliance.CheckARSD;
import ro.amiq.edt.ovmcompliance.CheckARSM;
import ro.amiq.edt.ovmcompliance.CheckCHCE;
import ro.amiq.edt.ovmcompliance.CheckCHDM;
import ro.amiq.edt.ovmcompliance.CheckCHEX;
import ro.amiq.edt.ovmcompliance.CheckMSLI;
import ro.amiq.edt.ovmcompliance.CheckMSMA;
import ro.amiq.edt.ovmcompliance.CheckMSMT;
import ro.amiq.edt.ovmcompliance.CheckMSSN;
import ro.amiq.edt.ovmcompliance.CheckPKDN;
import ro.amiq.edt.ovmcompliance.CheckPKEE;
import ro.amiq.edt.ovmcompliance.CheckPKEN;
import ro.amiq.edt.ovmcompliance.CheckPKFN;
import ro.amiq.edt.ovmcompliance.CheckPKGE;
import ro.amiq.edt.ovmcompliance.CheckPKGN;
import ro.amiq.edt.ovmcompliance.CheckPKIM;
import ro.amiq.edt.ovmcompliance.CheckPKPR;
import ro.amiq.edt.ovmcompliance.CheckPKTE;
import ro.amiq.edt.ovmcompliance.CheckPKTP;
import ro.amiq.edt.ovmcompliance.CheckSQBS;
import ro.amiq.edt.ovmcompliance.CheckSQPT;
import ro.amiq.edt.ovmcompliance.CheckSQRWa;
import ro.amiq.edt.ovmcompliance.CheckSQRWb;
import ro.amiq.edt.ovmcompliance.CheckSQSD;
import ro.amiq.edt.ovmcompliance.CheckSQSS;
import ro.amiq.edt.ovmcompliance.CheckSQVP;
import ro.amiq.edt.ovmcompliance.CheckSQWRa;
import ro.amiq.edt.ovmcompliance.CheckSQWRb;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheckBase;
import ro.amiq.edt.ovmcompliance.OVMComplianceManualCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMComplianceStatistic;
import ro.amiq.edt.ovmcompliance.StatisticCHCE;
import ro.amiq.edt.ovmcompliance.StatisticCHCE_Checks;
import ro.amiq.edt.ovmcompliance.StatisticCHCE_Expects;
import ro.amiq.edt.ovmcompliance.StatisticCVCG;
import ro.amiq.edt.ovmcompliance.StatisticCVCI;
import ro.amiq.edt.ovmcompliance.StatisticCVCR;
import ro.amiq.edt.ovmcompliance.StatisticCVTR;
import ro.amiq.edt.ovmcompliance.StatisticSQPT;
import ro.amiq.edt.ovmcompliance.StatisticSQSS_BFM;
import ro.amiq.edt.ovmcompliance.StatisticSQSS_Total;
import ro.amiq.edt.ovmcompliance.StatisticSQSS_Virtual;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;

public class OVMProject {
    private static final String XML_USER_PROPERTIES = "User_properties";
    private static final String XML_CHECK = "check";
    private static final String XML_STATISTIC = "statistic";
    private static final String XML_INTERNAL_ID = "internal_ID";
    private static final String XML_USER_ID = "user_ID";
    private static final String XML_IS_ENABLED = "is_enabled";
    private static final String XML_STATUS = "status";
    private IProject fProject;
    private int xvmMode;
    boolean fCheckErrors;
    private LinkedHashMap<String, List<RfStruct>> fCategories;
    protected List<RfStruct> fBFMs;
    protected List<RfStruct> fEnvs;
    protected List<RfStruct> fAgents;
    protected List<RfStruct> fMonitors;
    protected List<RfStruct> fSequenceDrivers;
    protected List<RfStruct> fSignalMaps;
    protected List<RfStruct> fCollectors;
    protected List<RfStruct> fSequences;
    protected List<RfStruct> fSequenceItems;
    private RfProject fRfProject;
    private boolean fAlsoCheckOVMClasses;
    private List<RfStruct> fAllClasses = null;
    private ArrayList<OVMComplianceCheck> fChecks;
    private ArrayList<OVMComplianceStatistic> fStatistics;
    private ArrayList<OVMComplianceCategory> fComplianceCategories;
    private ArrayList<RfCoverLayer> fAllCoverGroups;
    private String fPackageName;

    public OVMProject(IProject project, int aXVMMode) {
        this.xvmMode = aXVMMode;
        this.fProject = project;
        this.fCheckErrors = false;
        this.fBFMs = new ArrayList<RfStruct>();
        this.fEnvs = new ArrayList<RfStruct>();
        this.fAgents = new ArrayList<RfStruct>();
        this.fMonitors = new ArrayList<RfStruct>();
        this.fSequenceDrivers = new ArrayList<RfStruct>();
        this.fSignalMaps = new ArrayList<RfStruct>();
        this.fCollectors = new ArrayList<RfStruct>();
        this.fSequences = new ArrayList<RfStruct>();
        this.fSequenceItems = new ArrayList<RfStruct>();
        this.fCategories = new LinkedHashMap();
        this.fCategories.put("Environments", this.fEnvs);
        this.fCategories.put("Agents", this.fAgents);
        this.fCategories.put("Monitors", this.fMonitors);
        this.fCategories.put("Collectors", this.fCollectors);
        this.fCategories.put("Sequences", this.fSequences);
        this.fCategories.put("Sequence Drivers", this.fSequenceDrivers);
        this.fCategories.put("Sequence Items", this.fSequenceItems);
        this.fCategories.put("BFMs", this.fBFMs);
        this.fCategories.put("Signal Maps", this.fSignalMaps);
        this.fAlsoCheckOVMClasses = false;
        this.fComplianceCategories = new ArrayList();
        this.fComplianceCategories.add(new OVMComplianceCategory("Architecture", OVMComplianceMessages.ARCHITECTURE_COMPLIANCE_Description));
        this.fComplianceCategories.add(new OVMComplianceCategory("Package", OVMComplianceMessages.PACKAGE_COMPLIANCE_Description));
        this.fComplianceCategories.add(new OVMComplianceCategory("Sequences", OVMComplianceMessages.SEQUENCES_COMPLIANCE_Description));
        this.fComplianceCategories.add(new OVMComplianceCategory("Checking", OVMComplianceMessages.CHECKING_COMPLIANCE_Description));
        this.fComplianceCategories.add(new OVMComplianceCategory("Coverage", OVMComplianceMessages.COVERAGE_COMPLIANCE_Description));
        this.fComplianceCategories.add(new OVMComplianceCategory("Reset and Clock", OVMComplianceMessages.RESET_COMPLIANCE_Description));
        this.fComplianceCategories.add(new OVMComplianceCategory("End of Test", OVMComplianceMessages.END_OF_TEST_COMPLIANCE_Description));
        this.fComplianceCategories.add(new OVMComplianceCategory("Messaging", OVMComplianceMessages.MESSAGING_COMPLIANCE_Description));
        this.fComplianceCategories.add(new OVMComplianceCategory("Documentation", OVMComplianceMessages.DOCUMENTATION_COMPLIANCE_Description));
        this.fComplianceCategories.add(new OVMComplianceCategory("General Deliverables", OVMComplianceMessages.GENERAL_DELIVERABLES_COMPLIANCE_Description));
        this.fChecks = new ArrayList();
        this.fStatistics = new ArrayList();
        StatisticCHCE statisticCHCE = new StatisticCHCE(this, this.getCategory("Checking"));
        this.fStatistics.add(statisticCHCE);
        this.fStatistics.add(new StatisticCHCE_Expects(this, this.getCategory("Checking"), statisticCHCE));
        this.fStatistics.add(new StatisticCHCE_Checks(this, this.getCategory("Checking"), statisticCHCE));
        this.fStatistics.add(new StatisticCVCG(this, this.getCategory("Coverage")));
        this.fStatistics.add(new StatisticCVCI(this, this.getCategory("Coverage")));
        this.fStatistics.add(new StatisticCVCR(this, this.getCategory("Coverage")));
        this.fStatistics.add(new StatisticCVTR(this, this.getCategory("Coverage")));
        StatisticSQSS_Total statisticSQSS = new StatisticSQSS_Total(this, this.getCategory("Sequences"));
        this.fStatistics.add(statisticSQSS);
        this.fStatistics.add(new StatisticSQSS_BFM(this, this.getCategory("Sequences"), statisticSQSS));
        this.fStatistics.add(new StatisticSQSS_Virtual(this, this.getCategory("Sequences"), statisticSQSS));
        this.fStatistics.add(new StatisticSQPT(this, this.getCategory("Sequences")));
        this.fChecks.add(new CheckARAA(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckARAC(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckARBF(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckARIN(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckAROE(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckAROA(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckAROB(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckAROC(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckAROM(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckAROS(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckARMN(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckARMP(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckARNM(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckARSA(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckARSD(this, this.getCategory("Architecture")));
        this.fChecks.add(new CheckARSM(this, this.getCategory("Architecture")));
        this.fChecks.add(new OVMComplianceManualCheck("PKCT", OVMComplianceMessages.PKCT_User_Id, OVMComplianceMessages.PKCT_Title, OVMComplianceMessages.PKCT_Description, this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKDN(this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKEE(this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKEN(this, this.getCategory("Package")));
        this.fChecks.add(new OVMComplianceManualCheck("PKEX", OVMComplianceMessages.PKEX_User_Id, OVMComplianceMessages.PKEX_Title, OVMComplianceMessages.PKEX_Description, this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKFN(this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKGE(this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKGN(this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKIM(this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKPR(this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKTE(this, this.getCategory("Package")));
        this.fChecks.add(new CheckPKTP(this, this.getCategory("Package")));
        this.fChecks.add(new OVMComplianceManualCheck("PKVN", OVMComplianceMessages.PKVN_User_Id, OVMComplianceMessages.PKVN_Title, OVMComplianceMessages.PKVN_Description, this, this.getCategory("Package")));
        this.fChecks.add(new OVMComplianceManualCheck("PKVR", OVMComplianceMessages.PKVR_User_Id, OVMComplianceMessages.PKVR_Title, OVMComplianceMessages.PKVR_Description, this, this.getCategory("Package")));
        this.fChecks.add(new CheckCHCE(this, this.getCategory("Checking")));
        this.fChecks.add(new CheckCHDM(this, this.getCategory("Checking")));
        this.fChecks.add(new OVMComplianceManualCheck("CHEM", OVMComplianceMessages.CHEM_User_Id, OVMComplianceMessages.CHEM_Title, OVMComplianceMessages.CHEM_Description, this, this.getCategory("Checking")));
        this.fChecks.add(new OVMComplianceManualCheck("CHED", OVMComplianceMessages.CHED_User_Id, OVMComplianceMessages.CHED_Title, OVMComplianceMessages.CHED_Description, this, this.getCategory("Checking")));
        this.fChecks.add(new CheckCHEX(this, this.getCategory("Checking")));
        this.fChecks.add(new OVMComplianceManualCheck("CHPC", OVMComplianceMessages.CHPC_User_Id, OVMComplianceMessages.CHPC_Title, OVMComplianceMessages.CHPC_Description, this, this.getCategory("Checking")));
        this.fChecks.add(new OVMComplianceManualCheck("MSFL", OVMComplianceMessages.MSFL_User_Id, OVMComplianceMessages.MSFL_Title, OVMComplianceMessages.MSFL_Description, this, this.getCategory("Messaging")));
        this.fChecks.add(new OVMComplianceManualCheck("MSLG", OVMComplianceMessages.MSLG_User_Id, OVMComplianceMessages.MSLG_Title, OVMComplianceMessages.MSLG_Description, this, this.getCategory("Messaging")));
        this.fChecks.add(new CheckMSLI(this, this.getCategory("Messaging")));
        this.fChecks.add(new CheckMSMA(this, this.getCategory("Messaging")));
        this.fChecks.add(new CheckMSMT(this, this.getCategory("Messaging")));
        this.fChecks.add(new CheckMSSN(this, this.getCategory("Messaging")));
        this.fChecks.add(new CheckSQBS(this, this.getCategory("Sequences")));
        this.fChecks.add(new CheckSQSD(this, this.getCategory("Sequences")));
        this.fChecks.add(new CheckSQPT(this, this.getCategory("Sequences")));
        this.fChecks.add(new CheckSQRWa(this, this.getCategory("Sequences")));
        this.fChecks.add(new CheckSQRWb(this, this.getCategory("Sequences")));
        this.fChecks.add(new CheckSQSS(this, this.getCategory("Sequences")));
        this.fChecks.add(new CheckSQVP(this, this.getCategory("Sequences")));
        this.fChecks.add(new CheckSQWRa(this, this.getCategory("Sequences")));
        this.fChecks.add(new CheckSQWRb(this, this.getCategory("Sequences")));
        this.fChecks.add(new OVMComplianceManualCheck("DCBF", OVMComplianceMessages.DCBF_User_Id, OVMComplianceMessages.DCBF_Title, OVMComplianceMessages.DCBF_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCCF", OVMComplianceMessages.DCCF_User_Id, OVMComplianceMessages.DCCF_Title, OVMComplianceMessages.DCCF_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCDC", OVMComplianceMessages.DCDC_User_Id, OVMComplianceMessages.DCDC_Title, OVMComplianceMessages.DCDC_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCRN", OVMComplianceMessages.DCRN_User_Id, OVMComplianceMessages.DCRN_Title, OVMComplianceMessages.DCRN_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCEX", OVMComplianceMessages.DCEX_User_Id, OVMComplianceMessages.DCEX_Title, OVMComplianceMessages.DCEX_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCFC", OVMComplianceMessages.DCFC_User_Id, OVMComplianceMessages.DCFC_Title, OVMComplianceMessages.DCFC_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCID", OVMComplianceMessages.DCID_User_Id, OVMComplianceMessages.DCID_Title, OVMComplianceMessages.DCID_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCPA", OVMComplianceMessages.DCPA_User_Id, OVMComplianceMessages.DCPA_Title, OVMComplianceMessages.DCPA_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCPR", OVMComplianceMessages.DCPR_User_Id, OVMComplianceMessages.DCPR_Title, OVMComplianceMessages.DCPR_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCRP", OVMComplianceMessages.DCRP_User_Id, OVMComplianceMessages.DCRP_Title, OVMComplianceMessages.DCRP_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCRS", OVMComplianceMessages.DCRS_User_Id, OVMComplianceMessages.DCRS_Title, OVMComplianceMessages.DCRS_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCSD", OVMComplianceMessages.DCSD_User_Id, OVMComplianceMessages.DCSD_Title, OVMComplianceMessages.DCSD_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCSP", OVMComplianceMessages.DCSP_User_Id, OVMComplianceMessages.DCSP_Title, OVMComplianceMessages.DCSP_Description, this, this.getCategory("Documentation")));
        this.fChecks.add(new OVMComplianceManualCheck("DCST", OVMComplianceMessages.DCST_User_Id, OVMComplianceMessages.DCST_Title, OVMComplianceMessages.DCST_Description, this, this.getCategory("Documentation")));
    }

    private Path getPathToPropertyFile(IProject project, String fileName) {
        return new Path(String.valueOf(project.getLocation().toOSString()) + '/' + ".dvt" + '/' + ".edt_" + fileName);
    }

    public void clean() {
        this.fBFMs.clear();
        this.fEnvs.clear();
        this.fAgents.clear();
        this.fMonitors.clear();
        this.fSequenceDrivers.clear();
        this.fSignalMaps.clear();
        this.fCollectors.clear();
        this.fSequences.clear();
        this.fSequenceItems.clear();
        this.fAllCoverGroups = null;
        this.fAllClasses = null;
    }

    public LinkedHashMap<String, List<RfStruct>> getCategories() {
        return this.fCategories;
    }

    public void initialize(int aXVMMode) {
        this.clean();
        this.xvmMode = aXVMMode;
        this.fRfProject = RfManager.getInstance().getRfProject(this.fProject);
        if (this.fRfProject == null) {
            return;
        }
        List<RfStruct> allStructs = this.getAllStructs();
        if (allStructs == null) {
            return;
        }
        for (RfStruct struct : allStructs) {
            if (struct.isLike(XVMModeUtils.getBFMStructName(this.xvmMode))) {
                this.fBFMs.add(struct);
                continue;
            }
            if (struct.isLike(XVMModeUtils.getAgentStructName(this.xvmMode))) {
                this.fAgents.add(struct);
                continue;
            }
            if (struct.isLike(XVMModeUtils.getMonitorStructName(this.xvmMode))) {
                this.fMonitors.add(struct);
                continue;
            }
            if (struct.isLike(XVMModeUtils.getCollectorStructName(this.xvmMode))) {
                this.fCollectors.add(struct);
                continue;
            }
            if (struct.isLike("any_sequence_driver")) {
                this.fSequenceDrivers.add(struct);
                continue;
            }
            if (struct.isLike(XVMModeUtils.getSignalMapStructName(this.xvmMode))) {
                this.fSignalMaps.add(struct);
                continue;
            }
            if (struct.isLike("any_sequence")) {
                this.fSequences.add(struct);
                continue;
            }
            if (struct.isLike("any_sequence_item")) {
                this.fSequenceItems.add(struct);
                continue;
            }
            if (!struct.isLike(XVMModeUtils.getEnvStructName(this.xvmMode))) continue;
            this.fEnvs.add(struct);
        }
    }

    protected void populateByName() {
        if (this.fBFMs == null || this.fBFMs.isEmpty()) {
            this.fBFMs = this.getClassesWithNameContaining("bfm", null, null);
        }
        if (this.fEnvs == null || this.fEnvs.isEmpty()) {
            this.fEnvs = this.getClassesWithNameContaining("env", null, null);
        }
        if (this.fAgents == null || this.fAgents.isEmpty()) {
            this.fAgents = this.getClassesWithNameContaining("agent", null, null);
        }
        if (this.fMonitors == null || this.fMonitors.isEmpty()) {
            this.fMonitors = this.getClassesWithNameContaining("monitor", null, null);
        }
        if (this.fSequenceDrivers == null || this.fSequenceDrivers.isEmpty()) {
            this.fSequenceDrivers = this.getClassesWithNameContaining("driver", null, null);
        }
        if (this.fSignalMaps == null || this.fSignalMaps.isEmpty()) {
            this.fSignalMaps = this.getClassesWithNameContaining("signal_map", null, null);
        }
        if (this.fSequences == null || this.fSequences.isEmpty()) {
            this.fSequences = this.getClassesWithNameContaining("sequence", "sequencer", "sequence_item");
        }
        if (this.fSequenceItems == null || this.fSequenceItems.isEmpty()) {
            this.fSequenceItems = this.getClassesWithNameContaining("sequence_item", null, null);
        }
    }

    private List<RfStruct> getClassesWithNameContaining(String toBeContained, String notToBeContained1, String notToBeContained2) {
        ArrayList<RfStruct> result = new ArrayList<RfStruct>();
        List<RfStruct> allClasses = this.getAllStructs();
        if (allClasses == null) {
            return result;
        }
        for (RfStruct elm : allClasses) {
            if (!elm.getName().toLowerCase().contains(toBeContained.toLowerCase()) || notToBeContained1 != null && elm.getName().toLowerCase().contains(notToBeContained1.toLowerCase()) || notToBeContained2 != null && elm.getName().toLowerCase().contains(notToBeContained2.toLowerCase()) || this.isOVMElement((RfNamedElement)elm)) continue;
            result.add(elm);
        }
        return result;
    }

    public void printComponents() {
        AbstractTestHelper.out.println("BFMs:");
        for (RfStruct struct : this.fBFMs) {
            AbstractTestHelper.out.println(struct.getName());
        }
        AbstractTestHelper.out.println("Envs:");
        for (RfStruct struct : this.fEnvs) {
            AbstractTestHelper.out.println(struct.getName());
        }
        AbstractTestHelper.out.println("Agents:");
        for (RfStruct struct : this.fAgents) {
            AbstractTestHelper.out.println(struct.getName());
        }
        AbstractTestHelper.out.println("Monitors:");
        for (RfStruct struct : this.fMonitors) {
            AbstractTestHelper.out.println(struct.getName());
        }
        AbstractTestHelper.out.println("Drivers:");
        for (RfStruct struct : this.fSequenceDrivers) {
            AbstractTestHelper.out.println(struct.getName());
        }
        AbstractTestHelper.out.println("Sequencers:");
        for (RfStruct struct : this.fSignalMaps) {
            AbstractTestHelper.out.println(struct.getName());
        }
        AbstractTestHelper.out.println("Sequences:");
        for (RfStruct struct : this.fSequences) {
            AbstractTestHelper.out.println(struct.getName());
        }
        AbstractTestHelper.out.println("Data items:");
        for (RfStruct struct : this.fSequenceItems) {
            AbstractTestHelper.out.println(struct.getName());
        }
    }

    public ArrayList<RfCoverLayer> getAllCovergroups() {
        if (this.fAllCoverGroups != null) {
            return this.fAllCoverGroups;
        }
        if (this.fRfProject == null) {
            return null;
        }
        ArrayList<RfType> types = this.getAllTypes();
        this.fAllCoverGroups = new ArrayList();
        for (RfType type : types) {
            if (!(type instanceof RfStruct)) continue;
            RfStruct struct = (RfStruct)type;
            List events = struct.getEvents();
            for (RfStructMember event : events) {
                this.fAllCoverGroups.addAll(this.getCoverLayers((RfEvent)event));
            }
        }
        return this.fAllCoverGroups;
    }

    private ArrayList<RfCoverLayer> getCoverLayers(RfEvent event) {
        List layers = event.getLayers();
        if (layers == null) {
            return null;
        }
        ArrayList<RfCoverLayer> result = new ArrayList<RfCoverLayer>();
        for (RfDefElement layer : layers) {
            if (!(layer instanceof RfCoverLayer)) continue;
            if (layer.getLayerKind() == 378) {
                result.add((RfCoverLayer)layer);
                continue;
            }
            if (layer.getLayerKind() != 376) continue;
            result.add((RfCoverLayer)layer);
        }
        return result;
    }

    protected boolean isOVMElement(RfNamedElement elm) {
        boolean prefClass = PrefConst.getOVMComplianceCheckOVMClasses((AbstractUIPlugin)EDTPlugin.getDefault());
        boolean prefFile = PrefConst.getOVMComplianceCheckOVMFiles((AbstractUIPlugin)EDTPlugin.getDefault());
        if (prefClass && prefFile) {
            return false;
        }
        int i = 0;
        while (i < XVMModeUtils.XVM_CLASS_PREFIXES.length) {
            String name = elm.getName();
            if (elm.getModule() == null) {
                return false;
            }
            String file = elm.getModule().getName();
            if (!prefClass && name.startsWith(XVMModeUtils.XVM_CLASS_PREFIXES[i]) || !prefFile && file.startsWith(XVMModeUtils.XVM_CLASS_PREFIXES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<RfStruct> getAllStructs() {
        if (this.fAllClasses != null) {
            return this.fAllClasses;
        }
        if (this.fRfProject == null) {
            return null;
        }
        if (this.fAlsoCheckOVMClasses) {
            this.fAllClasses = this.fRfProject.getAllStructs();
            return this.fAllClasses;
        }
        this.fAllClasses = new NullProtectedList();
        for (RfStruct elm : this.fRfProject.getAllStructs()) {
            if (this.isOVMElement((RfNamedElement)elm)) continue;
            this.fAllClasses.add(elm);
        }
        return this.fAllClasses;
    }

    public ArrayList<RfType> getAllTypes() {
        if (this.fRfProject == null) {
            return null;
        }
        NullProtectedList result = new NullProtectedList();
        for (RfNamedElement type : this.fRfProject.getAllTypes(false, false)) {
            RfDefElement declaration = type.getDeclaration(false);
            if (declaration == null || this.isOVMElement((RfNamedElement)declaration.getLayerModule())) continue;
            result.add((Object)((RfType)type));
        }
        return result;
    }

    public NullProtectedList<RfModule> getAllModules() {
        if (this.fRfProject == null) {
            return null;
        }
        NullProtectedList result = new NullProtectedList();
        for (RfModule module : this.fRfProject.getAllModules()) {
            if (this.isOVMElement((RfNamedElement)module) || !this.isProjectModule(module)) continue;
            result.add((Object)module);
        }
        return result;
    }

    public ArrayList<RfMacro> getAllMacros() {
        if (this.fRfProject == null) {
            return null;
        }
        NullProtectedList result = new NullProtectedList();
        for (RfMacro macro : this.fRfProject.getAllMacros(false, false)) {
            RfDefElement declaration = macro.getDeclaration(false);
            if (declaration == null || this.isOVMElement((RfNamedElement)declaration.getLayerModule())) continue;
            result.add((Object)macro);
        }
        return result;
    }

    public RfProject getRfProject() {
        return this.fRfProject;
    }

    private void decodeCheckPreferences(String internalId, String isEnabled, String status, String userId, boolean actualValues, boolean defaultValues) throws IOException {
        boolean enabledValue;
        OVMComplianceCheck check = this.getCheck(internalId);
        if (check == null) {
            return;
        }
        if ("ENABLED".equals(isEnabled)) {
            enabledValue = true;
        } else if ("DISABLED".equals(isEnabled)) {
            enabledValue = false;
        } else {
            throw new IOException("XVMProject.decodePreference(): Wrong enable: " + isEnabled + "(id = " + internalId + ") ");
        }
        if (check instanceof OVMComplianceManualCheck) {
            int statusValue;
            OVMComplianceManualCheck manualCheck = (OVMComplianceManualCheck)check;
            if ("N_A".equals(status)) {
                statusValue = 0;
            } else if ("PASSED".equals(status)) {
                statusValue = 1;
            } else if ("FAILED".equals(status)) {
                statusValue = 2;
            } else {
                throw new IOException("XVMProject.decodePreference(): Wrong status: " + status + "(id = " + internalId + ") ");
            }
            if (actualValues) {
                manualCheck.setEnabled(enabledValue);
                manualCheck.setStatus(statusValue);
            }
            if (defaultValues) {
                manualCheck.setDefaultEnabled(enabledValue);
            }
        } else {
            int severityValue;
            if ("ERROR".equals(status)) {
                severityValue = 0;
            } else if ("WARNING".equals(status)) {
                severityValue = 1;
            } else if ("NOTE".equals(status)) {
                severityValue = 2;
            } else {
                throw new IOException("XVMProject.decodePreference(): Wrong severity: " + status + "(id = " + internalId + ") ");
            }
            if (actualValues) {
                check.setEnabled(enabledValue);
                check.setSeverity(severityValue);
            }
            if (defaultValues) {
                check.setDefaultEnabled(enabledValue);
                check.setDefaultSeverity(severityValue);
            }
        }
    }

    private void decodeStatisticPreferences(String internalId, String isEnabled, String userId, boolean actualValues, boolean defaultValues) throws IOException {
        boolean enabledValue;
        OVMComplianceStatistic statistic = this.getStatistic(internalId);
        if (statistic == null) {
            throw new IOException("XVMProject.decodePreference(): Wrong id: " + internalId);
        }
        if ("ENABLED".equals(isEnabled)) {
            enabledValue = true;
        } else if ("DISABLED".equals(isEnabled)) {
            enabledValue = false;
        } else {
            throw new IOException("XVMProject.decodePreference(): Wrong enable: " + isEnabled + "(id = " + internalId + ") ");
        }
        if (actualValues) {
            statistic.setEnabled(enabledValue);
        }
        if (defaultValues) {
            statistic.setDefaultEnabled(enabledValue);
        }
    }

    private boolean loadXMLFromFile(IProject project, File file, boolean actualValues, boolean defaultValues) {
        InputSource input = null;
        boolean wrongXML = false;
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (BufferedReader fileReader = new BufferedReader(new FileReader(file));){
                try {
                    input = new InputSource(fileReader);
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder parser = factory.newDocumentBuilder();
                    parser.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
                    Document document = parser.parse(input);
                    NodeList elements = document.getElementsByTagName(XML_USER_PROPERTIES);
                    if (elements.getLength() == 1) {
                        Node userPropNode = elements.item(0);
                        NodeList checksList = userPropNode.getChildNodes();
                        int j = 0;
                        while (j < checksList.getLength()) {
                            Node checkNode = checksList.item(j);
                            if (XML_CHECK.equals(checkNode.getNodeName())) {
                                attributes = checkNode.getAttributes();
                                if (attributes == null) {
                                    wrongXML = true;
                                } else {
                                    internalIdNode = attributes.getNamedItem(XML_INTERNAL_ID);
                                    if (internalIdNode == null) {
                                        wrongXML = true;
                                    } else {
                                        internalId = internalIdNode.getNodeValue();
                                        isEnabledNode = attributes.getNamedItem(XML_IS_ENABLED);
                                        if (isEnabledNode == null) {
                                            wrongXML = true;
                                        } else {
                                            isEnabled = isEnabledNode.getNodeValue();
                                            Node statusNode = attributes.getNamedItem(XML_STATUS);
                                            if (statusNode == null) {
                                                wrongXML = true;
                                            } else {
                                                String status = statusNode.getNodeValue();
                                                Node userIdNode = attributes.getNamedItem(XML_USER_ID);
                                                if (userIdNode == null) {
                                                    wrongXML = true;
                                                } else {
                                                    String userId = userIdNode.getNodeValue();
                                                    this.decodeCheckPreferences(internalId, isEnabled, status, userId, actualValues, defaultValues);
                                                }
                                            }
                                        }
                                    }
                                }
                            } else if (XML_STATISTIC.equals(checkNode.getNodeName())) {
                                attributes = checkNode.getAttributes();
                                if (attributes == null) {
                                    wrongXML = true;
                                } else {
                                    internalIdNode = attributes.getNamedItem(XML_INTERNAL_ID);
                                    if (internalIdNode == null) {
                                        wrongXML = true;
                                    } else {
                                        internalId = internalIdNode.getNodeValue();
                                        isEnabledNode = attributes.getNamedItem(XML_IS_ENABLED);
                                        if (isEnabledNode == null) {
                                            wrongXML = true;
                                        } else {
                                            isEnabled = isEnabledNode.getNodeValue();
                                            Node userIdNode = attributes.getNamedItem(XML_USER_ID);
                                            if (userIdNode == null) {
                                                wrongXML = true;
                                            } else {
                                                String userId = userIdNode.getNodeValue();
                                                this.decodeStatisticPreferences(internalId, isEnabled, userId, actualValues, defaultValues);
                                            }
                                        }
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    Assert.isTrue((boolean)false);
                }
                catch (SAXException e) {
                    Throwable t = e.getCause();
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    if (t != null) {
                        throw new IOException(t.getMessage());
                    }
                    throw new IOException(e.getMessage());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return wrongXML;
    }

    public void load(IProject project) {
        File defaultUserFile;
        boolean wrongXML1 = false;
        boolean wrongXML2 = false;
        this.loadProgramDefault();
        if (project == null) {
            return;
        }
        File userFile = this.getPathToPropertyFile(project, XVMModeUtils.getUserPropertiesFileName(this.xvmMode)).toFile();
        if (userFile.exists()) {
            wrongXML1 = this.loadXMLFromFile(project, userFile, true, false);
        }
        if ((defaultUserFile = this.getPathToPropertyFile(project, XVMModeUtils.getDefaultPropertiesFileName(this.xvmMode)).toFile()).exists()) {
            wrongXML2 = this.loadXMLFromFile(project, userFile, wrongXML1, true);
        }
        if (wrongXML1 || wrongXML2) {
            this.save();
        }
    }

    private void loadProgramDefault() {
        for (OVMComplianceCheck oVMComplianceCheck : this.fChecks) {
            oVMComplianceCheck.loadProgramDefault();
        }
        for (OVMComplianceStatistic oVMComplianceStatistic : this.fStatistics) {
            if (oVMComplianceStatistic.isGenerated()) continue;
            oVMComplianceStatistic.loadProgramDefault();
        }
    }

    public void save() {
        try {
            File userFile = this.getPathToPropertyFile(this.fProject, XVMModeUtils.getUserPropertiesFileName(this.xvmMode)).toFile();
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (BufferedWriter output = new BufferedWriter(new FileWriter(userFile));){
                    Attr isEnabled;
                    Attr internalId;
                    NamedNodeMap attributes;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.newDocument();
                    StreamResult result = new StreamResult(output);
                    Element root = document.createElement(XML_USER_PROPERTIES);
                    document.appendChild(root);
                    for (OVMComplianceCheck check : this.fChecks) {
                        Element checkNode = document.createElement(XML_CHECK);
                        root.appendChild(checkNode);
                        attributes = checkNode.getAttributes();
                        internalId = document.createAttribute(XML_INTERNAL_ID);
                        internalId.setValue(check.getInternalId());
                        attributes.setNamedItem(internalId);
                        isEnabled = document.createAttribute(XML_IS_ENABLED);
                        isEnabled.setValue(check.isEnabled() ? "ENABLED" : "DISABLED");
                        attributes.setNamedItem(isEnabled);
                        Attr status = document.createAttribute(XML_STATUS);
                        status.setValue(check.encodePreference());
                        attributes.setNamedItem(status);
                        Attr userId = document.createAttribute(XML_USER_ID);
                        userId.setValue(check.getUserId(true));
                        attributes.setNamedItem(userId);
                    }
                    for (OVMComplianceStatistic statistic : this.fStatistics) {
                        if (statistic.isGenerated()) continue;
                        Element statNode = document.createElement(XML_STATISTIC);
                        root.appendChild(statNode);
                        attributes = statNode.getAttributes();
                        internalId = document.createAttribute(XML_INTERNAL_ID);
                        internalId.setValue(statistic.getInternalId());
                        attributes.setNamedItem(internalId);
                        isEnabled = document.createAttribute(XML_IS_ENABLED);
                        isEnabled.setValue(statistic.isEnabled() ? "ENABLED" : "DISABLED");
                        attributes.setNamedItem(isEnabled);
                        Attr userId = document.createAttribute(XML_USER_ID);
                        userId.setValue(statistic.getUserId(true));
                        attributes.setNamedItem(userId);
                    }
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("indent", "yes");
                    DOMSource source = new DOMSource(document);
                    transformer.transform(source, result);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Assert.isTrue((boolean)false);
            }
            catch (TransformerException e) {
                if (e.getException() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                Assert.isTrue((boolean)false);
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    public OVMComplianceCategory getCategory(String name) {
        if (name == null) {
            return null;
        }
        for (OVMComplianceCategory categ : this.fComplianceCategories) {
            if (!name.equals(categ.getName())) continue;
            return categ;
        }
        return null;
    }

    public ArrayList<OVMComplianceCategory> getComplianceCategories() {
        return this.fComplianceCategories;
    }

    public void build() {
        this.load(this.fProject);
        this.addDynamicStatistics();
        this.performChecks();
    }

    private void addDynamicStatistics() {
        OVMComplianceStatistic statisticSQPT = this.getStatistic("SSQPT");
        if (statisticSQPT.getSubChecks() != null) {
            OVMComplianceCategory sequencesCategory = this.getCategory("Sequences");
            for (OVMComplianceCheckBase subCheck : statisticSQPT.getSubChecks()) {
                sequencesCategory.removeStatistic((OVMComplianceStatistic)subCheck);
            }
            statisticSQPT.clearSubChecks();
        }
        for (RfStruct sequence : this.fSequences) {
            this.fStatistics.add(new StatisticSQPT(sequence.getName(), this, this.getCategory("Sequences"), statisticSQPT));
        }
    }

    public OVMComplianceCheck getCheck(String id) {
        if (id == null) {
            return null;
        }
        for (OVMComplianceCheck check : this.fChecks) {
            if (!id.equals(check.getInternalId())) continue;
            return check;
        }
        return null;
    }

    public OVMComplianceStatistic getStatistic(String id) {
        if (id == null) {
            return null;
        }
        for (OVMComplianceStatistic statistic : this.fStatistics) {
            if (!id.equals(statistic.getInternalId())) continue;
            return statistic;
        }
        return null;
    }

    public void performChecks() {
        this.fCheckErrors = false;
        for (OVMComplianceCheck check : this.fChecks) {
            check.performCheck();
        }
        for (OVMComplianceStatistic statistic : this.fStatistics) {
            if (statistic.isGenerated()) continue;
            statistic.performCheck();
        }
    }

    public String getPackageName() {
        return this.fPackageName;
    }

    public void setPackageName(String packageName) {
        this.fPackageName = packageName;
    }

    public boolean isProjectModule(RfModule module) {
        if (module == null) {
            return false;
        }
        IPath modulePath = Path.fromOSString((String)module.getParserPath().path);
        IPath projectPath = this.fProject.getLocation();
        return projectPath.isPrefixOf(modulePath);
    }

    public IProject getIProject() {
        return this.fProject;
    }

    public int getXVMMode() {
        return this.xvmMode;
    }

    public void notifyCheckError() {
        this.fCheckErrors = true;
    }

    public ArrayList<String> getAllRelevantPackages() {
        NullProtectedList<RfModule> modules = this.getAllModules();
        HashMap<String, Integer> packages = new HashMap<String, Integer>();
        boolean hasMainPackage = false;
        for (RfModule module : modules) {
            String packageName = module.getPackageName();
            if (packageName.equals("main")) {
                hasMainPackage = true;
                continue;
            }
            if (packages.containsKey(packageName)) {
                packages.put(packageName, (Integer)packages.get(packageName) + 1);
                continue;
            }
            packages.put(packageName, 1);
        }
        Object[] indexes = packages.values().toArray(new Integer[packages.size()]);
        Arrays.sort(indexes);
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = (Integer)objectArray[n2];
            Iterator iter = packages.keySet().iterator();
            while (iter.hasNext()) {
                String packageName = (String)iter.next();
                if ((Integer)packages.get(packageName) != index) continue;
                result.add(0, packageName);
                iter.remove();
                break;
            }
            ++n2;
        }
        if (hasMainPackage) {
            result.add("main");
        }
        return result;
    }
}

