/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.IOVMComplianceStatistic;
import ro.amiq.edt.ovmcompliance.IReportInfoProvider;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;

public class OVMReportInfoProvider
implements IReportInfoProvider {
    private OVMProject fOVMProject;

    public OVMReportInfoProvider(OVMProject project) {
        this.fOVMProject = project;
    }

    @Override
    public String getOutputPath() {
        if (this.fOVMProject == null) {
            return "";
        }
        return this.fOVMProject.getIProject().getLocation().toOSString();
    }

    @Override
    public String getOutputFolder() {
        return XVMModeUtils.getHTMLOutputFolder(this.fOVMProject.getXVMMode());
    }

    @Override
    public ArrayList<IOVMComplianceCategory> getCategories() {
        ArrayList<IOVMComplianceCategory> cats = new ArrayList<IOVMComplianceCategory>();
        for (OVMComplianceCategory cat : this.fOVMProject.getComplianceCategories()) {
            cats.add(cat);
        }
        return cats;
    }

    @Override
    public String getProjectName() {
        if (this.fOVMProject == null) {
            return "";
        }
        return this.fOVMProject.getIProject().getName();
    }

    @Override
    public ArrayList<IOVMComplianceCheck> getComplianceChecks(String categoryID) {
        OVMComplianceCategory category = this.fOVMProject.getCategory(categoryID);
        if (category == null) {
            return null;
        }
        return category.getChecks();
    }

    @Override
    public ArrayList<IOVMComplianceStatistic> getComplianceStatistics(String categoryID) {
        OVMComplianceCategory category = this.fOVMProject.getCategory(categoryID);
        if (category == null) {
            return null;
        }
        return category.getStatistics();
    }

    @Override
    public OVMProject getOVMProject() {
        return this.fOVMProject;
    }

    @Override
    public void restoreDefaultChecksSettings() {
        ArrayList<OVMComplianceCategory> categories = this.fOVMProject.getComplianceCategories();
        for (OVMComplianceCategory category : categories) {
            ArrayList<IOVMComplianceCheck> autoChecks = category.getChecks();
            for (IOVMComplianceCheck check : autoChecks) {
                check.restoreDefaults();
                check.performCheck();
            }
        }
    }

    @Override
    public void restoreDefaultStatisticsSettings() {
        ArrayList<OVMComplianceCategory> categories = this.fOVMProject.getComplianceCategories();
        for (OVMComplianceCategory category : categories) {
            ArrayList<IOVMComplianceStatistic> statistics = category.getStatistics();
            for (IOVMComplianceStatistic statistic : statistics) {
                statistic.restoreDefaults();
                statistic.performCheck();
            }
        }
    }
}

