/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.Collection;
import java.util.List;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMComplianceStatistic;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.StatisticCHCE;

public class StatisticCHCE_Expects
extends OVMComplianceStatistic {
    public StatisticCHCE_Expects(OVMProject oVMProject, OVMComplianceCategory category, StatisticCHCE statisticCHCE) {
        super(oVMProject, category, statisticCHCE);
    }

    @Override
    public String getInternalId() {
        return "CHCE - Expects";
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.SCHCE_Expects_Title;
    }

    @Override
    public String getUserId(boolean isCustom) {
        if (isCustom) {
            return OVMComplianceMessages.SCHCE_Expects_User_Id;
        }
        return OVMComplianceMessages.SCHCE_User_Id;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SCHCE_Expects_Description;
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList expects = new NullProtectedList();
        for (RfType type : this.fOVMProject.getAllTypes()) {
            if (!(type instanceof RfStruct)) continue;
            expects.addAll((Collection)((RfStruct)type).getExpects());
        }
        for (RfStructMember expect : expects) {
            RfExpectLayer layer = (RfExpectLayer)this.getRelevantLayer(expect);
            if (layer == null) continue;
            this.addHit((RfNamedElement)expect, layer.getLiteral());
        }
    }

    private RfDefElement getRelevantLayer(RfStructMember expect) {
        List layers = expect.getLayers();
        if (layers == null) {
            return null;
        }
        RfDefElement result = null;
        for (RfDefElement layer : layers) {
            if (layer.getLayerKind() == 378) {
                result = layer;
                continue;
            }
            if (layer.getLayerKind() != 377) continue;
            return layer;
        }
        return result;
    }
}

