/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.text.MessageFormat;
import java.util.List;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheckBase;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMComplianceStatistic;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class StatisticSQPT
extends OVMComplianceStatistic {
    private String fSequenceName;

    public StatisticSQPT(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    public StatisticSQPT(String sequencerName, OVMProject oVMProject, OVMComplianceCategory category, OVMComplianceStatistic statisticSQPT) {
        super(oVMProject, category, statisticSQPT);
        this.fSequenceName = sequencerName;
        this.fGenerated = true;
    }

    @Override
    public String getInternalId() {
        if (this.fSequenceName == null) {
            return "SSQPT";
        }
        return "SSQPT - " + this.fSequenceName;
    }

    @Override
    public String getUserId(boolean isCustom) {
        if (this.fSequenceName == null || !isCustom) {
            return OVMComplianceMessages.SSQPT_User_Id;
        }
        return String.valueOf(OVMComplianceMessages.SSQPT_User_Id) + " - " + this.fSequenceName;
    }

    @Override
    public String getDefaultTitle() {
        if (this.fSequenceName == null) {
            return MessageFormat.format(OVMComplianceMessages.SSQPT_Title, "sequence");
        }
        return MessageFormat.format(OVMComplianceMessages.SSQPT_Title, "'" + this.fSequenceName + "'");
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SSQPT_Description;
    }

    @Override
    public void performCheckImpl() {
        if (this.fSequenceName == null) {
            if (this.fSubChecks == null) {
                return;
            }
            for (OVMComplianceCheckBase subCheck : this.fSubChecks) {
                if (!(subCheck instanceof OVMComplianceStatistic)) continue;
                ((OVMComplianceStatistic)subCheck).performCheck();
                this.addAllHits((OVMComplianceStatistic)subCheck);
            }
            return;
        }
        for (RfStruct sequence : this.fOVMProject.fSequences) {
            List enums;
            RfScalarType sequenceKindType;
            if (!sequence.isSequence() || (sequenceKindType = sequence.getSequenceKind()) == null || this.fSequenceName != null && !this.fSequenceName.equals(sequence.getName()) || (enums = sequenceKindType.getEnumsWithPrefix(2, "")) == null || enums.isEmpty()) continue;
            for (RfEnum elem : enums) {
                if (elem.getName().equals("MAIN") || elem.getName().equals("RANDOM") || !sequence.isSequenceVirtual() && elem.getName().equals("SIMPLE")) continue;
                this.addHit((RfNamedElement)sequenceKindType, elem.getName());
            }
        }
    }
}

