/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.ui.preferences.PrefConst;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.edt.core.EDTPlugin;
import ro.amiq.edt.ovmcompliance.ui.ArchitectureDoublePanelElement;
import ro.amiq.edt.ovmcompliance.ui.ArchitectureModel;
import ro.amiq.edt.ovmcompliance.ui.FontFactory;
import ro.amiq.edt.ovmcompliance.ui.IArchitectureChangedListener;
import ro.amiq.edt.ovmcompliance.ui.Messages;

public class ArchitectureDoublePanel
extends Composite {
    private static final Object FAMILY_FILTER = new Object();
    private RightPanelFilterTriggerJob fRightPanelFilterTriggerJob = new RightPanelFilterTriggerJob();
    private StringMatcher fRightPanelFilterStringMatcher;
    private LeftPanelFilterTriggerJob fLeftPanelFilterTriggerJob = new LeftPanelFilterTriggerJob();
    private StringMatcher fLeftPanelFilterStringMatcher;
    private TreeViewer fLeftPanel;
    private TableViewer fRightPanel;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fAutoAddButton;
    private Button fClearButton;
    private Text fRightPanelFilterTextBox;
    private Text fLeftPanelFilterTextBox;
    private Text fStatusBar;
    private FontFactory fFontFactory;
    private ArrayList<ArchitectureDoublePanelElement> fLeftPanelData;
    private ArrayList<ArchitectureDoublePanelElement> fRightPanelData;
    private ArrayList<IArchitectureChangedListener> fArchitectureChangedListeners;
    private Color fBackgroundColor = DVTColorUtil.INSTANCE.getColor(PrefConst.getVerissimoBackgroundColor((AbstractUIPlugin)EDTPlugin.getDefault()));
    private Color fInfoBackgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor");

    public ArchitectureDoublePanel(Composite parent, int style) {
        super(parent, style);
        this.fFontFactory = new FontFactory(parent.getDisplay());
        this.fArchitectureChangedListeners = new ArrayList();
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        Composite titleComposite = new Composite((Composite)this, 0);
        titleComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        titleComposite.setLayout((Layout)new GridLayout(1, true));
        DVTColorUtil.INSTANCE.setBackground((Control)titleComposite, this.fBackgroundColor);
        Composite subTitleComposite = new Composite(titleComposite, 0);
        subTitleComposite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        subTitleComposite.setLayout((Layout)new GridLayout(2, true));
        DVTColorUtil.INSTANCE.setBackground((Control)subTitleComposite, this.fBackgroundColor);
        Label titleLabel = new Label(subTitleComposite, 64);
        titleLabel.setLayoutData((Object)new GridData(0, 0x1000000, false, false, 1, 1));
        titleLabel.setFont(this.fFontFactory.createFont("title", 18, 1));
        titleLabel.setText(Messages.ArchitectureDoublePanel_Page_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)titleLabel, this.fBackgroundColor, true);
        Button reset = new Button(subTitleComposite, 0);
        reset.setToolTipText(Messages.ArchitectureDoublePanel_Restore_Button_TT);
        reset.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_RESTORE_DEFAULTS));
        reset.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        DVTColorUtil.INSTANCE.setBackground((Control)reset, this.fBackgroundColor);
        reset.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ArchitectureDoublePanel.this.clearAll(false);
                ArchitectureDoublePanel.this.autoAdd();
            }
        });
        Label descriptionLabel = new Label(titleComposite, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        descriptionLabel.setFont(this.fFontFactory.createFont("description", 0));
        descriptionLabel.setText(Messages.ArchitectureDoublePanel_Page_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)descriptionLabel, this.fBackgroundColor, true);
        Composite panelContainer = new Composite((Composite)this, 0);
        panelContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        panelContainer.setLayout((Layout)new GridLayout(3, false));
        DVTColorUtil.INSTANCE.setBackground((Control)panelContainer, this.fBackgroundColor);
        Composite leftContainer = new Composite(panelContainer, 0);
        leftContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        leftContainer.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)leftContainer, this.fBackgroundColor);
        this.fLeftPanelFilterTextBox = new Text(leftContainer, 2048);
        this.fLeftPanelFilterTextBox.setLayoutData((Object)new GridData(4, 128, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fLeftPanelFilterTextBox, this.fBackgroundColor, true);
        this.fLeftPanelFilterTextBox.setText("");
        this.fLeftPanelFilterStringMatcher = new StringMatcher("**", false, false);
        this.fLeftPanelFilterTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                ArchitectureDoublePanel.this.fLeftPanelFilterStringMatcher = new StringMatcher(String.valueOf('*') + text + '*', false, false);
                ArchitectureDoublePanel.this.fLeftPanelFilterTriggerJob.cancel();
                ArchitectureDoublePanel.this.fLeftPanelFilterTriggerJob.schedule(250L);
                ArchitectureDoublePanel.this.setFilterTextColor(ArchitectureDoublePanel.this.fLeftPanelFilterTextBox);
            }
        });
        this.fLeftPanel = new TreeViewer(leftContainer);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        this.fLeftPanel.getControl().setLayoutData((Object)gridData);
        LeftPanelProvider leftPanelProvider = new LeftPanelProvider();
        this.fLeftPanel.setContentProvider((IContentProvider)leftPanelProvider);
        this.fLeftPanel.setLabelProvider((IBaseLabelProvider)leftPanelProvider);
        DVTColorUtil.INSTANCE.setBackground(this.fLeftPanel.getControl(), this.fBackgroundColor);
        this.fLeftPanel.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ArchitectureDoublePanel.this.openSelected(true);
            }
        });
        this.fLeftPanel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element != null && element instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)element).getElement() instanceof RfStruct) {
                    RfStruct struct = (RfStruct)((ArchitectureDoublePanelElement)element).getElement();
                    ArchitectureDoublePanel.this.fStatusBar.setText(String.valueOf(struct.getPackageName()) + "::" + struct.getName() + struct.getParametersInfo(false));
                }
            }
        });
        this.fLeftPanel.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)element).getElement() instanceof RfStruct) {
                    return 1;
                }
                return 0;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                String name1 = cat1 != 0 ? ((ArchitectureDoublePanelElement)e1).getText() : "";
                String name2 = cat2 != 0 ? ((ArchitectureDoublePanelElement)e2).getText() : "";
                return this.getComparator().compare(name1, name2);
            }
        });
        this.fLeftPanel.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (viewer instanceof TreeViewer && element instanceof ArchitectureDoublePanelElement) {
                    if (((ArchitectureDoublePanelElement)element).getElement() instanceof RfStruct) {
                        return ArchitectureDoublePanel.this.fLeftPanelFilterStringMatcher.match(((ArchitectureDoublePanelElement)element).getText());
                    }
                    return true;
                }
                return false;
            }
        });
        Composite buttonContainer = new Composite(panelContainer, 0);
        buttonContainer.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        buttonContainer.setLayout((Layout)new RowLayout(512));
        DVTColorUtil.INSTANCE.setBackground((Control)buttonContainer, this.fBackgroundColor);
        this.fAddButton = new Button(buttonContainer, 8);
        this.fAddButton.setLayoutData((Object)new RowData(31, 31));
        this.fAddButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_ARROW_RIGHT_LEFT_IMG));
        this.fAddButton.setToolTipText(Messages.ArchitectureDoublePanel_Add_Button_TT);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fAddButton, this.fBackgroundColor);
        this.fAddButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ArchitectureDoublePanel.this.addItem();
            }
        });
        this.fRemoveButton = new Button(buttonContainer, 8);
        this.fRemoveButton.setLayoutData((Object)new RowData(31, 31));
        this.fRemoveButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_ARROW_LEFT_RIGHT_IMG));
        this.fRemoveButton.setToolTipText(Messages.ArchitectureDoublePanel_Remove_Button_TT);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fRemoveButton, this.fBackgroundColor);
        this.fRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ArchitectureDoublePanel.this.removeItem();
            }
        });
        Composite separator = new Composite(buttonContainer, 0);
        separator.setLayoutData((Object)new RowData(31, 100));
        DVTColorUtil.INSTANCE.setBackground((Control)separator, this.fBackgroundColor);
        this.fAutoAddButton = new Button(buttonContainer, 8);
        this.fAutoAddButton.setLayoutData((Object)new RowData(31, 31));
        this.fAutoAddButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_DARROW_RIGHT_LEFT_IMG));
        this.fAutoAddButton.setToolTipText(Messages.ArchitectureDoublePanel_Auto_Add_Button_TT);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fAutoAddButton, this.fBackgroundColor);
        this.fAutoAddButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ArchitectureDoublePanel.this.autoAdd();
            }
        });
        this.fClearButton = new Button(buttonContainer, 8);
        this.fClearButton.setLayoutData((Object)new RowData(31, 31));
        this.fClearButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_DARROW_LEFT_RIGHT_IMG));
        this.fClearButton.setToolTipText(Messages.ArchitectureDoublePanel_Remove_All_Button_TT);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fClearButton, this.fBackgroundColor);
        this.fClearButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ArchitectureDoublePanel.this.clearAll(true);
            }
        });
        Composite rightContainer = new Composite(panelContainer, 0);
        rightContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        rightContainer.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)rightContainer, this.fBackgroundColor);
        this.fRightPanelFilterTextBox = new Text(rightContainer, 2048);
        this.fRightPanelFilterTextBox.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fRightPanelFilterTextBox.setText("");
        this.fRightPanelFilterStringMatcher = new StringMatcher("**", false, false);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fRightPanelFilterTextBox, this.fBackgroundColor, true);
        this.fRightPanelFilterTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                ArchitectureDoublePanel.this.fRightPanelFilterStringMatcher = new StringMatcher(String.valueOf('*') + text + '*', false, false);
                ArchitectureDoublePanel.this.fRightPanelFilterTriggerJob.cancel();
                ArchitectureDoublePanel.this.fRightPanelFilterTriggerJob.schedule(250L);
                ArchitectureDoublePanel.this.setFilterTextColor(ArchitectureDoublePanel.this.fRightPanelFilterTextBox);
            }
        });
        this.fRightPanel = new TableViewer(rightContainer);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        this.fRightPanel.getControl().setLayoutData((Object)gridData);
        RightPanelProvider rightPanelProvider = new RightPanelProvider();
        this.fRightPanel.setContentProvider((IContentProvider)rightPanelProvider);
        this.fRightPanel.setLabelProvider((IBaseLabelProvider)rightPanelProvider);
        DVTColorUtil.INSTANCE.setBackground(this.fRightPanel.getControl(), this.fBackgroundColor);
        this.fRightPanel.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ArchitectureDoublePanel.this.openSelected(false);
            }
        });
        this.fRightPanel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element != null && element instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)element).getElement() instanceof RfStruct) {
                    RfStruct struct = (RfStruct)((ArchitectureDoublePanelElement)element).getElement();
                    ArchitectureDoublePanel.this.fStatusBar.setText(String.valueOf(struct.getPackageName()) + "::" + struct.getName() + struct.getParametersInfo(false));
                }
            }
        });
        this.fRightPanel.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof ArchitectureDoublePanelElement) {
                    return 1;
                }
                return 0;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                String name1 = cat1 != 0 ? ((ArchitectureDoublePanelElement)e1).getText() : "";
                String name2 = cat2 != 0 ? ((ArchitectureDoublePanelElement)e2).getText() : "";
                return this.getComparator().compare(name1, name2);
            }
        });
        this.fRightPanel.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return viewer instanceof TableViewer && ArchitectureDoublePanel.this.fRightPanelFilterStringMatcher.match(((ArchitectureDoublePanelElement)element).getText());
            }
        });
        this.fStatusBar = new Text(panelContainer, 2056);
        this.fStatusBar.setLayoutData((Object)new GridData(4, 1024, true, false, 3, 0));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor, true);
    }

    public void setInput(ArchitectureModel architectureModel) {
        Assert.isNotNull((Object)architectureModel);
        this.fRightPanelData = architectureModel.getRightPanelData();
        this.fLeftPanelData = architectureModel.getLeftPanelData();
        this.fLeftPanel.setInput(this.fLeftPanelData);
        if (this.fLeftPanel.getTree().getItemCount() > 0) {
            this.fLeftPanel.getTree().setSelection(this.fLeftPanel.getTree().getItem(0));
        }
        this.fLeftPanel.expandAll();
        this.fRightPanel.setInput(this.fRightPanelData);
        if (this.fRightPanel.getTable().getItemCount() > 0) {
            this.fRightPanel.getTable().setSelection(0);
        }
        this.architectureChanged();
        architectureModel.setUpdateListener(this);
    }

    private void setFilterTextColor(Text textBox) {
        DVTColorUtil.INSTANCE.setBackground((Control)textBox, this.fInfoBackgroundColor);
    }

    private void addItem() {
        Object leftSelection = ((IStructuredSelection)this.fLeftPanel.getSelection()).getFirstElement();
        if (leftSelection == null) {
            return;
        }
        Object[] rightSelection = ((IStructuredSelection)this.fRightPanel.getSelection()).toArray();
        if (rightSelection == null || rightSelection.length < 1) {
            return;
        }
        ArchitectureDoublePanelElement selectedCategory = null;
        if (((ArchitectureDoublePanelElement)leftSelection).getElement() instanceof String) {
            selectedCategory = (ArchitectureDoublePanelElement)leftSelection;
        } else if (((ArchitectureDoublePanelElement)leftSelection).getElement() instanceof RfStruct) {
            selectedCategory = ((ArchitectureDoublePanelElement)leftSelection).getParent();
        } else {
            return;
        }
        int rightSelectionIndex = this.fRightPanel.getTable().getSelectionIndex();
        Object[] objectArray = rightSelection;
        int n = rightSelection.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (((ArchitectureDoublePanelElement)element).getElement() instanceof RfStruct) {
                ((ArchitectureDoublePanelElement)element).setParent(selectedCategory);
                selectedCategory.addChild((ArchitectureDoublePanelElement)element);
                this.fRightPanelData.remove(element);
            }
            ++n2;
        }
        this.fLeftPanel.refresh();
        this.fRightPanel.refresh();
        this.fLeftPanel.expandToLevel((Object)selectedCategory, -1);
        if (this.fRightPanel.getTable().getItemCount() > 0) {
            if (rightSelectionIndex >= this.fRightPanel.getTable().getItemCount()) {
                rightSelectionIndex = this.fRightPanel.getTable().getItemCount() - 1;
            }
            this.fRightPanel.getTable().setSelection(rightSelectionIndex);
        }
        this.architectureChanged();
    }

    private void openSelected(boolean leftNotRight) {
        if (leftNotRight) {
            Object selection = ((IStructuredSelection)this.fLeftPanel.getSelection()).getFirstElement();
            if (selection == null) {
                return;
            }
            TreeItem[] selectionTreeItems = this.fLeftPanel.getTree().getSelection();
            if (selectionTreeItems == null || selectionTreeItems.length == 0) {
                return;
            }
            Object element = ((ArchitectureDoublePanelElement)selectionTreeItems[0].getData()).getElement();
            if (element instanceof RfNamedElement) {
                int line = ((RfNamedElement)element).getLine();
                RfDefElement declaration = ((RfNamedElement)element).getDeclaration(false);
                if (declaration == null) {
                    return;
                }
                IFile file = (IFile)declaration.getInternalAdapter(IResource.class);
                if (file != null) {
                    EDTFileUtils.getInstance().openEditor(file, line, ((RfNamedElement)element).getName());
                }
            }
        } else {
            Object selection = ((IStructuredSelection)this.fRightPanel.getSelection()).getFirstElement();
            if (selection == null) {
                return;
            }
            Object element = ((ArchitectureDoublePanelElement)selection).getElement();
            if (element instanceof RfNamedElement) {
                int line = ((RfNamedElement)element).getLine();
                RfDefElement declaration = ((RfNamedElement)element).getDeclaration(false);
                if (declaration == null) {
                    return;
                }
                IFile file = (IFile)declaration.getInternalAdapter(IResource.class);
                if (file != null) {
                    EDTFileUtils.getInstance().openEditor(file, line, ((RfNamedElement)element).getName());
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeItem() {
        block10: {
            block9: {
                leftSelection = ((IStructuredSelection)this.fLeftPanel.getSelection()).toArray();
                if (leftSelection == null || leftSelection.length < 1) {
                    return;
                }
                leftSelectionIndex = -1;
                leftSelectionParentIndex = -1;
                leftSelectionTreeItems = this.fLeftPanel.getTree().getSelection();
                if (leftSelectionTreeItems.length > 0) {
                    parentItem = leftSelectionTreeItems[0].getParentItem();
                    if (parentItem == null) {
                        leftSelectionParentIndex = leftSelectionTreeItems[0].getParent().indexOf(leftSelectionTreeItems[0]);
                    } else {
                        leftSelectionParentIndex = parentItem.getParent().indexOf(parentItem);
                        leftSelectionIndex = parentItem.indexOf(leftSelectionTreeItems[0]);
                    }
                }
                var8_6 = leftSelection;
                var7_7 = leftSelection.length;
                var6_8 = 0;
                while (var6_8 < var7_7) {
                    element = var8_6[var6_8];
                    if (((ArchitectureDoublePanelElement)element).getElement() instanceof RfStruct) {
                        ((ArchitectureDoublePanelElement)element).getParent().removeChild((ArchitectureDoublePanelElement)element);
                        ((ArchitectureDoublePanelElement)element).setParent(null);
                        this.fRightPanelData.add((ArchitectureDoublePanelElement)element);
                    }
                    ++var6_8;
                }
                this.fLeftPanel.refresh();
                this.fRightPanel.refresh();
                newSelection = null;
                parentItem = this.fLeftPanel.getTree().getItem(leftSelectionParentIndex);
                if (parentItem.getItemCount() <= 0 || leftSelectionIndex < 0) break block9;
                if (leftSelectionIndex >= parentItem.getItemCount()) {
                    leftSelectionIndex = parentItem.getItemCount() - 1;
                }
                newSelection = parentItem.getItem(leftSelectionIndex);
                break block10;
            }
            if (leftSelectionIndex >= 0) ** GOTO lbl-1000
            newSelection = parentItem;
            break block10;
            while ((parentItem = this.fLeftPanel.getTree().getItem(--leftSelectionParentIndex)).getItemCount() <= 0) lbl-1000:
            // 2 sources

            {
                if (leftSelectionParentIndex > 0) continue;
            }
            newSelection = parentItem.getItemCount() > 0 ? parentItem.getItem(parentItem.getItemCount() - 1) : parentItem;
        }
        this.fLeftPanel.getTree().setSelection(newSelection);
        if (this.fRightPanel.getTable().getSelectionCount() == 0 && this.fRightPanel.getTable().getItemCount() > 0) {
            this.fRightPanel.getTable().setSelection(0);
        }
        this.architectureChanged();
    }

    private void autoAdd() {
        Iterator<ArchitectureDoublePanelElement> iterator = this.fRightPanelData.iterator();
        while (iterator.hasNext()) {
            ArchitectureDoublePanelElement element = iterator.next();
            ArchitectureDoublePanelElement autoParent = element.getDefaultParent();
            if (autoParent == null) continue;
            element.setParent(autoParent);
            autoParent.addChild(element);
            iterator.remove();
        }
        this.fLeftPanel.refresh();
        this.fRightPanel.refresh();
        this.fLeftPanel.expandAll();
        if (this.fRightPanel.getTable().getSelectionCount() == 0 && this.fRightPanel.getTable().getItemCount() > 0) {
            this.fRightPanel.getTable().setSelection(0);
        }
        this.architectureChanged();
    }

    private void clearAll(boolean refresh) {
        for (ArchitectureDoublePanelElement element : this.fLeftPanelData) {
            ArchitectureDoublePanelElement[] children;
            if (!(element.getElement() instanceof String) || (children = element.getChildren()) == null || children.length <= 0) continue;
            ArchitectureDoublePanelElement[] architectureDoublePanelElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ArchitectureDoublePanelElement child = architectureDoublePanelElementArray[n2];
                child.getParent().removeChild(child);
                child.setParent(null);
                this.fRightPanelData.add(child);
                ++n2;
            }
        }
        if (refresh) {
            this.fLeftPanel.refresh();
            this.fRightPanel.refresh();
            if (this.fRightPanel.getTable().getSelectionCount() == 0 && this.fRightPanel.getTable().getItemCount() > 0) {
                this.fRightPanel.getTable().setSelection(0);
            }
        }
        this.architectureChanged();
    }

    public void addArchitectureChangedListener(IArchitectureChangedListener listener) {
        Assert.isNotNull((Object)listener);
        this.fArchitectureChangedListeners.add(listener);
    }

    private void architectureChanged() {
        for (IArchitectureChangedListener listener : this.fArchitectureChangedListeners) {
            listener.architectureChaged();
        }
    }

    public void dispose() {
        if (this.fArchitectureChangedListeners != null) {
            this.fArchitectureChangedListeners.clear();
        }
        if (this.fFontFactory != null) {
            this.fFontFactory.dispose();
        }
        super.dispose();
    }

    public void refresh() {
        this.fLeftPanel.refresh();
        this.fLeftPanel.expandAll();
        this.fRightPanel.refresh();
    }

    private final class LeftPanelFilterTriggerJob
    extends UIJob {
        public LeftPanelFilterTriggerJob() {
            super("Filter Left Panel");
            this.setPriority(50);
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_FILTER;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                ArchitectureDoublePanel.this.fLeftPanel.refresh();
                ArchitectureDoublePanel.this.fLeftPanel.expandAll();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    private static final class LeftPanelProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private LeftPanelProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement != null && parentElement instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)parentElement).childrenCount() > 0) {
                return ((ArchitectureDoublePanelElement)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element != null && element instanceof ArchitectureDoublePanelElement) {
                return ((ArchitectureDoublePanelElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element != null && element instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)element).childrenCount() > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            Object unWrapped;
            if (element != null && element instanceof ArchitectureDoublePanelElement && (unWrapped = ((ArchitectureDoublePanelElement)element).getElement()) instanceof RfStruct) {
                RfStruct struct = (RfStruct)unWrapped;
                if (struct.isUnit()) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT);
                }
                if (struct.isLike("any_sequence")) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE);
                }
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT);
            }
            return null;
        }

        public String getText(Object element) {
            if (element != null && element instanceof ArchitectureDoublePanelElement) {
                return ((ArchitectureDoublePanelElement)element).getText();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class RightPanelFilterTriggerJob
    extends UIJob {
        public RightPanelFilterTriggerJob() {
            super("Filter Right Panel");
            this.setPriority(50);
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_FILTER;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                ArchitectureDoublePanel.this.fRightPanel.refresh();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    private static final class RightPanelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private RightPanelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Object unWrapped = ((ArchitectureDoublePanelElement)element).getElement();
            if (unWrapped instanceof RfStruct) {
                RfStruct struct = (RfStruct)unWrapped;
                if (struct.isUnit()) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_UNIT);
                }
                if (struct.isLike("any_sequence")) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE);
                }
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof ArchitectureDoublePanelElement) {
                return ((ArchitectureDoublePanelElement)element).getText();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

