/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.model.reflection.RfManager;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;
import ro.amiq.edt.ovmcompliance.ui.ArchitectureDoublePanel;
import ro.amiq.edt.ovmcompliance.ui.ArchitectureDoublePanelElement;

public class ArchitectureModel {
    private final IProject fProject;
    private final OVMProject fOVMProject;
    private final ArrayList<ArchitectureDoublePanelElement> fArchitectureLeftPanelData;
    private final ArrayList<ArchitectureDoublePanelElement> fArchitectureRightPanelData;
    private LinkedHashMap<String, List<RfStruct>> fOVMArchitectureCategories;
    private ArchitectureDoublePanel fArchitectureDoublePanel;

    public ArchitectureModel(OVMProject ovmProject, IProject project) {
        this.fOVMProject = ovmProject;
        this.fProject = project;
        this.fArchitectureLeftPanelData = new ArrayList();
        this.fArchitectureRightPanelData = new ArrayList();
        this.wrapArchitectureElements();
    }

    private void wrapArchitectureElements() {
        ArchitectureDoublePanelElement structWrapper;
        ArchitectureDoublePanelElement categoryWraper;
        String categoryName;
        LinkedHashMap<String, ArchitectureDoublePanelElement> categoryWrappers = new LinkedHashMap<String, ArchitectureDoublePanelElement>();
        LinkedHashMap<RfStruct, ArchitectureDoublePanelElement> structWrappers = new LinkedHashMap<RfStruct, ArchitectureDoublePanelElement>();
        RfProject rfProject = RfManager.getInstance().getRfProject(this.fProject);
        List<RfStruct> allStructs = this.fOVMProject.getAllStructs();
        if (allStructs != null) {
            for (RfStruct struct : allStructs) {
                if (struct.isPredefined()) continue;
                structWrappers.put(struct, new ArchitectureDoublePanelElement(struct));
            }
        }
        this.fOVMArchitectureCategories = this.fOVMProject.getCategories();
        for (String categoryName2 : this.fOVMArchitectureCategories.keySet()) {
            categoryWrappers.put(categoryName2, new ArchitectureDoublePanelElement(categoryName2));
        }
        LinkedHashMap<String, List<RfStruct>> OVMLoadedCategories = this.loadArchitectureDataFromFile(this.fOVMArchitectureCategories.keySet(), allStructs, rfProject);
        for (Map.Entry<String, List<RfStruct>> entry : this.fOVMArchitectureCategories.entrySet()) {
            categoryName = entry.getKey();
            categoryWraper = (ArchitectureDoublePanelElement)categoryWrappers.get(categoryName);
            List<RfStruct> inheritedStructs = entry.getValue();
            for (RfStruct struct : inheritedStructs) {
                structWrapper = (ArchitectureDoublePanelElement)structWrappers.get(struct);
                if (structWrapper == null) continue;
                structWrapper.setAutoParent(categoryWraper);
            }
        }
        for (Map.Entry<String, List<RfStruct>> entry : this.fOVMArchitectureCategories.entrySet()) {
            categoryName = entry.getKey();
            categoryWraper = (ArchitectureDoublePanelElement)categoryWrappers.get(categoryName);
            List<RfStruct> loadedStructs = OVMLoadedCategories == null ? entry.getValue() : OVMLoadedCategories.get(categoryName);
            for (RfStruct struct : loadedStructs) {
                structWrapper = (ArchitectureDoublePanelElement)structWrappers.get(struct);
                if (structWrapper == null) continue;
                structWrapper.setParent(categoryWraper);
                categoryWraper.addChild(structWrapper);
                structWrappers.remove(struct);
            }
        }
        this.fArchitectureLeftPanelData.addAll(categoryWrappers.values());
        this.fArchitectureRightPanelData.addAll(structWrappers.values());
    }

    private void unwrapArchitectureElements() {
        RfProject rfProject = RfManager.getInstance().getRfProject(this.fProject);
        if (rfProject == null) {
            return;
        }
        for (ArchitectureDoublePanelElement category : this.fArchitectureLeftPanelData) {
            List<RfStruct> OVMCategory = this.fOVMArchitectureCategories.get(category.getText());
            if (OVMCategory == null) continue;
            OVMCategory.clear();
            ArchitectureDoublePanelElement[] architectureDoublePanelElementArray = category.getChildren();
            int n = architectureDoublePanelElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArchitectureDoublePanelElement element = architectureDoublePanelElementArray[n2];
                OVMCategory.add((RfStruct)element.getElement());
                ++n2;
            }
        }
    }

    private LinkedHashMap<String, List<RfStruct>> loadArchitectureDataFromFile(Set<String> categories, List<RfStruct> allStructs, RfProject rfProject) {
        LinkedHashMap<String, List<RfStruct>> loadedCategories = new LinkedHashMap<String, List<RfStruct>>();
        boolean notEmpty = false;
        try {
            DialogSettings settings = new DialogSettings("ReportSettings");
            settings.load(this.getArchitectureFileName());
            for (String category : categories) {
                ArrayList<RfStruct> loadedStructs = new ArrayList<RfStruct>();
                loadedCategories.put(category, loadedStructs);
                IDialogSettings section = settings.getSection(category);
                if (section != null) {
                    String[] elements;
                    String[] stringArray = elements = section.getArray("elements");
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fullName = stringArray[n2];
                        List candidates = rfProject.getStructsWithPrefix(1, fullName);
                        if (candidates != null && !candidates.isEmpty() && allStructs.contains(candidates.get(0))) {
                            loadedStructs.add((RfStruct)candidates.get(0));
                        }
                        ++n2;
                    }
                }
                boolean bl = notEmpty = notEmpty || !loadedStructs.isEmpty();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        return notEmpty ? loadedCategories : null;
    }

    private void saveArchitectureDataToFile() {
        try {
            DialogSettings settings = new DialogSettings("ReportSettings");
            for (ArchitectureDoublePanelElement category : this.fArchitectureLeftPanelData) {
                IDialogSettings section = settings.addNewSection(category.getText());
                String[] childrenFullNames = new String[category.childrenCount()];
                ArchitectureDoublePanelElement[] categoryChildren = category.getChildren();
                int i = 0;
                while (i < categoryChildren.length) {
                    childrenFullNames[i] = ((RfStruct)categoryChildren[i].getElement()).getName();
                    ++i;
                }
                section.put("elements", childrenFullNames);
            }
            settings.save(this.getArchitectureFileName());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Path getPathToPropertyFile(IProject project, String fileName) {
        return new Path(String.valueOf(project.getLocation().toOSString()) + '/' + ".dvt" + '/' + ".edt_" + fileName);
    }

    private String getArchitectureFileName() {
        File architectureFile = this.getPathToPropertyFile(this.fProject, XVMModeUtils.getArchitectureFileName(this.fOVMProject.getXVMMode())).toFile();
        if (!architectureFile.exists()) {
            try {
                architectureFile.createNewFile();
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return architectureFile.toString();
    }

    public ArrayList<ArchitectureDoublePanelElement> getRightPanelData() {
        return this.fArchitectureRightPanelData;
    }

    public ArrayList<ArchitectureDoublePanelElement> getLeftPanelData() {
        return this.fArchitectureLeftPanelData;
    }

    public void updateOVMProject(boolean updateContent) {
        this.saveArchitectureDataToFile();
        if (updateContent) {
            this.fArchitectureLeftPanelData.clear();
            this.fArchitectureRightPanelData.clear();
            this.wrapArchitectureElements();
            this.fArchitectureDoublePanel.refresh();
        }
        this.unwrapArchitectureElements();
    }

    public void setUpdateListener(ArchitectureDoublePanel architectureDoublePanel) {
        this.fArchitectureDoublePanel = architectureDoublePanel;
    }
}

