/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance.ui;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.ui.preferences.PrefConst;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.edt.core.EDTPlugin;
import ro.amiq.edt.model.EModelManager;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheckBase;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheckHit;
import ro.amiq.edt.ovmcompliance.IOVMComplianceManualCheck;
import ro.amiq.edt.ovmcompliance.ui.FontFactory;
import ro.amiq.edt.ovmcompliance.ui.IReportUpdateListener;
import ro.amiq.edt.ovmcompliance.ui.Messages;
import ro.amiq.edt.ovmcompliance.ui.OVMComplianceChecksUtil;
import ro.amiq.edt.ovmcompliance.ui.OVMComplianceReport;

public class ChecksTreeBrowser
implements IReportUpdateListener {
    private FontFactory fFontFactory;
    private Composite fRightPartComposite;
    private Composite fLeftPartComposite;
    private TreeViewer fTree;
    private Button fMarkAsPassedButton;
    private Button fMarkAsFailedButton;
    private Button fMarkAsNotAppliedButton;
    private Combo fFiltersList;
    private Button fHidePassedButton;
    private Button fHideErrorButton;
    private Button fHideWarningButton;
    private Button fHideInfoButton;
    private Button fHideNotAppliedButton;
    private Button fHideDisabledButton;
    private Button fHideAutomaticButton;
    private Button fHideManualButton;
    private Label fDetailsTitle;
    private Label fDetailsDescription;
    private Composite fCheckStatusDetailsContainer;
    private Label fCheckStatusIcon;
    private Label fCheckStatusText;
    private Button fCheckProperties;
    private StackLayout fContentsStack;
    private Composite fSummaryComposite;
    private TableViewer fSummaryTable;
    private Text fSummaryTableDetails;
    private Composite fCategoriesComposite;
    private TableViewer fCategoriesTable;
    private Text fCategoriesTableDetails;
    private Composite fChecksComposite;
    private TableViewer fChecksTable;
    private Composite fManualChecksComposite;
    private Object fSelectedItem;
    private final IProject fProject;
    private OVMComplianceReport fComplianceReport;
    private Color fBackgroundColor;
    private Color fInfoBackgroundColor;

    public ChecksTreeBrowser(Composite parent, Object layoutData, IProject project, OVMComplianceReport complianceReport) {
        this.fProject = project;
        this.fComplianceReport = complianceReport;
        this.fBackgroundColor = DVTColorUtil.INSTANCE.getColor(PrefConst.getVerissimoBackgroundColor((AbstractUIPlugin)EDTPlugin.getDefault()));
        this.fInfoBackgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        if (layoutData != null) {
            composite.setLayoutData(layoutData);
        }
        DVTColorUtil.INSTANCE.setBackground((Control)composite, this.fBackgroundColor);
        this.fFontFactory = new FontFactory(parent.getDisplay());
        SashForm sashForm = new SashForm(composite, 256);
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor);
        this.createLeftPart((Composite)sashForm);
        this.createRightPart((Composite)sashForm);
        int[] componentWeight = new int[]{2, 5};
        sashForm.setWeights(componentWeight);
    }

    private void createLeftPart(Composite parent) {
        this.fLeftPartComposite = new Composite(parent, 0);
        this.fLeftPartComposite.setLayout((Layout)new GridLayout(1, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fLeftPartComposite, this.fBackgroundColor);
        Composite titleComposite = new Composite(this.fLeftPartComposite, 0);
        titleComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)titleComposite, this.fBackgroundColor);
        this.createTitle(titleComposite);
        Composite filterBarComposite = new Composite(this.fLeftPartComposite, 0);
        filterBarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)filterBarComposite, this.fBackgroundColor);
        this.createFilterBar(filterBarComposite);
        this.fTree = new TreeViewer(this.fLeftPartComposite, 2820);
        this.fTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTree.setContentProvider((IContentProvider)new ChecksTreeContentProvider());
        this.fTree.setLabelProvider((IBaseLabelProvider)new ChecksTreeLabelProvider());
        this.fTree.addSelectionChangedListener((ISelectionChangedListener)new ChecksTreeSelectionChangedListener());
        this.fTree.addFilter((ViewerFilter)new ComplianceCheckFilter());
        DVTColorUtil.INSTANCE.setBackground(this.fTree.getControl(), this.fBackgroundColor);
    }

    private void createTitle(Composite parent) {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginTop = 0;
        gl.marginBottom = 5;
        parent.setLayout((Layout)gl);
        Label titleLabel = new Label(parent, 64);
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        titleLabel.setFont(this.fFontFactory.createFont("title", 18, 1));
        titleLabel.setText(Messages.ChecksTreeBrowser_Page_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)titleLabel, this.fBackgroundColor, true);
        Button reset = new Button(parent, 0);
        reset.setToolTipText(Messages.OVMComplianceReport_Main_Page_Checks_Restore_Button_TT);
        reset.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_RESTORE_DEFAULTS));
        reset.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        DVTColorUtil.INSTANCE.setBackground((Control)reset, this.fBackgroundColor);
        reset.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ChecksTreeBrowser.this.fComplianceReport.getOVMInfoProvider().restoreDefaultChecksSettings();
                ChecksTreeBrowser.this.fComplianceReport.updateListeners();
            }
        });
        Label descriptionLabel = new Label(parent, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        descriptionLabel.setFont(this.fFontFactory.createFont("description", 0));
        descriptionLabel.setText(Messages.ChecksTreeBrowser_Page_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)descriptionLabel, this.fBackgroundColor, true);
    }

    private void createFilterBar(final Composite parent) {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        parent.setLayout((Layout)gl);
        this.fFiltersList = new Combo(parent, 12);
        this.fFiltersList.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Label);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Show_All);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Errors);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Errors_Not_Applied);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Disabled);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Not_Applied);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Automatic);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Manual);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Passed);
        this.fFiltersList.addSelectionListener((SelectionListener)new FiltersListSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fFiltersList, this.fBackgroundColor, true);
        this.fFiltersList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ChecksTreeBrowser.this.fFiltersList.setItem(0, "");
                DVTColorUtil.INSTANCE.setForeground((Control)ChecksTreeBrowser.this.fFiltersList, DVTColorUtil.INSTANCE.getForeground((Control)parent));
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.fFiltersList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (ChecksTreeBrowser.this.fFiltersList.getSelectionIndex() == 0) {
                    ChecksTreeBrowser.this.resetFiltersList();
                } else {
                    ChecksTreeBrowser.this.fFiltersList.setItem(0, "");
                    ChecksTreeBrowser.this.fFiltersList.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
                    DVTColorUtil.INSTANCE.setForeground((Control)ChecksTreeBrowser.this.fFiltersList, DVTColorUtil.INSTANCE.getForeground((Control)parent));
                }
            }
        });
        this.resetFiltersList();
        Label buttonsText = new Label(parent, 0x1000040);
        buttonsText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        buttonsText.setText(Messages.ChecksTreeBrowser_Filter_Hide_Label);
        DVTColorUtil.INSTANCE.setBackground((Control)buttonsText, this.fBackgroundColor, true);
        RowLayout rl = new RowLayout();
        rl.fill = true;
        rl.type = 256;
        rl.marginBottom = 0;
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.marginTop = 0;
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonsComposite.setLayout((Layout)rl);
        DVTColorUtil.INSTANCE.setBackground((Control)buttonsComposite, this.fBackgroundColor);
        this.fHidePassedButton = new Button(buttonsComposite, 2);
        this.fHidePassedButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_PASSED));
        this.fHidePassedButton.setData((Object)"Passed");
        this.fHidePassedButton.addSelectionListener((SelectionListener)new FilterButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHidePassedButton, this.fBackgroundColor);
        this.fHideErrorButton = new Button(buttonsComposite, 2);
        this.fHideErrorButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_ERROR));
        this.fHideErrorButton.setData((Object)"Errors");
        this.fHideErrorButton.addSelectionListener((SelectionListener)new FilterButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideErrorButton, this.fBackgroundColor);
        this.fHideWarningButton = new Button(buttonsComposite, 2);
        this.fHideWarningButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_WARNING));
        this.fHideWarningButton.setData((Object)"Warnings");
        this.fHideWarningButton.addSelectionListener((SelectionListener)new FilterButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideWarningButton, this.fBackgroundColor);
        this.fHideInfoButton = new Button(buttonsComposite, 2);
        this.fHideInfoButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_INFO));
        this.fHideInfoButton.setData((Object)"Info");
        this.fHideInfoButton.addSelectionListener((SelectionListener)new FilterButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideInfoButton, this.fBackgroundColor);
        this.fHideNotAppliedButton = new Button(buttonsComposite, 2);
        this.fHideNotAppliedButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_NOT_APPLIED));
        this.fHideNotAppliedButton.setData((Object)"Not Applied");
        this.fHideNotAppliedButton.addSelectionListener((SelectionListener)new FilterButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideNotAppliedButton, this.fBackgroundColor);
        this.fHideDisabledButton = new Button(buttonsComposite, 2);
        this.fHideDisabledButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_DISABLED));
        this.fHideDisabledButton.setData((Object)"Disabled");
        this.fHideDisabledButton.addSelectionListener((SelectionListener)new FilterButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideDisabledButton, this.fBackgroundColor);
        this.fHideAutomaticButton = new Button(buttonsComposite, 2);
        this.fHideAutomaticButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_AUTOMATIC));
        this.fHideAutomaticButton.setData((Object)"Automatic");
        this.fHideAutomaticButton.addSelectionListener((SelectionListener)new FilterButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideAutomaticButton, this.fBackgroundColor);
        this.fHideManualButton = new Button(buttonsComposite, 2);
        this.fHideManualButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_MANUAL));
        this.fHideManualButton.setData((Object)"Manual");
        this.fHideManualButton.addSelectionListener((SelectionListener)new FilterButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideManualButton, this.fBackgroundColor);
        this.updateAllFilterButtonsTooltTips();
    }

    private void resetFiltersList() {
        this.fFiltersList.setItem(0, Messages.ChecksTreeBrowser_Predefined_Filter_Label);
        this.fFiltersList.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        DVTColorUtil.INSTANCE.setForeground((Control)this.fFiltersList, DVTColorUtil.INSTANCE.getColor(130, 130, 130));
        this.fFiltersList.select(0);
    }

    private void createRightPart(Composite parent) {
        this.fRightPartComposite = new Composite(parent, 0);
        this.fRightPartComposite.setLayout((Layout)new GridLayout(1, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fRightPartComposite, this.fBackgroundColor);
        Group detailsComposite = new Group(this.fRightPartComposite, 0);
        detailsComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)detailsComposite, this.fBackgroundColor);
        this.createDetails(detailsComposite);
        Composite contentsComposite = new Composite(this.fRightPartComposite, 0);
        contentsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setBackground((Control)contentsComposite, this.fBackgroundColor);
        this.createContents(contentsComposite);
    }

    private void createDetails(Group parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.fDetailsTitle = new Label((Composite)parent, 64);
        this.fDetailsTitle.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fDetailsTitle.setFont(this.fFontFactory.createFont("title", 14, 1));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fDetailsTitle, this.fBackgroundColor, true);
        this.fCheckProperties = new Button((Composite)parent, 0);
        this.fCheckProperties.setToolTipText(Messages.ChecksTreeBrowser_Check_Properties_Button_TT);
        this.fCheckProperties.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_CHECK_PROPERTIES));
        this.fCheckProperties.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fCheckProperties.addSelectionListener((SelectionListener)new ChecksPropertiesButtonListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCheckProperties, this.fBackgroundColor);
        GridData gd = new GridData(4, 1, true, false, 2, 1);
        gd.exclude = true;
        this.fCheckStatusDetailsContainer = new Composite((Composite)parent, 0);
        this.fCheckStatusDetailsContainer.setLayoutData((Object)gd);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCheckStatusDetailsContainer, this.fBackgroundColor);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.fCheckStatusDetailsContainer.setLayout((Layout)gl);
        this.fCheckStatusIcon = new Label(this.fCheckStatusDetailsContainer, 0);
        this.fCheckStatusIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCheckStatusIcon, this.fBackgroundColor);
        this.fCheckStatusText = new Label(this.fCheckStatusDetailsContainer, 16448);
        this.fCheckStatusText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCheckStatusText, this.fBackgroundColor);
        this.fDetailsDescription = new Label((Composite)parent, 64);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fDetailsDescription, this.fBackgroundColor, true);
        this.fDetailsDescription.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fDetailsDescription.setFont(this.fFontFactory.createFont("description", 0));
    }

    private void createContents(Composite parent) {
        this.fContentsStack = new StackLayout();
        parent.setLayout((Layout)this.fContentsStack);
        this.fSummaryComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fSummaryComposite, this.fBackgroundColor);
        this.createSummaryTable(this.fSummaryComposite);
        this.fCategoriesComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCategoriesComposite, this.fBackgroundColor);
        this.createCategoriesTable(this.fCategoriesComposite);
        this.fChecksComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fChecksComposite, this.fBackgroundColor);
        this.createChecksTable(this.fChecksComposite);
        this.fManualChecksComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fManualChecksComposite, this.fBackgroundColor);
        this.createManualChecksPage(this.fManualChecksComposite);
    }

    private void createSummaryTable(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 512);
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor, true);
        this.fSummaryTable = new TableViewer((Composite)sashForm, 68356);
        this.fSummaryTable.setContentProvider((IContentProvider)new SummaryTableContentProvider());
        this.fSummaryTable.setLabelProvider((IBaseLabelProvider)new SummaryTableLabelProvider());
        this.fSummaryTable.addSelectionChangedListener((ISelectionChangedListener)new SummaryTableSelectionChangedListener());
        this.fSummaryTable.addDoubleClickListener((IDoubleClickListener)new SummaryTableDubleClickListener());
        DVTColorUtil.INSTANCE.setBackground(this.fSummaryTable.getControl(), this.fBackgroundColor);
        Table table = this.fSummaryTable.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        DVTColorUtil.INSTANCE.setBackground((Control)table, this.fBackgroundColor);
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Summary_Table_Column_1);
        column.setWidth(200);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Summary_Table_Column_2);
        column.setWidth(75);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Summary_Table_Column_3);
        column.setAlignment(0x1000000);
        column.setWidth(90);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Summary_Table_Column_4);
        column.setWidth(85);
        this.fSummaryTableDetails = new Text((Composite)sashForm, 2634);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fSummaryTableDetails, this.fInfoBackgroundColor, true);
        int[] componentWeight = new int[]{4, 1};
        sashForm.setWeights(componentWeight);
    }

    private void createCategoriesTable(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 512);
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor, true);
        this.fCategoriesTable = new TableViewer((Composite)sashForm, 68356);
        this.fCategoriesTable.setContentProvider((IContentProvider)new CategoriesTableContentProvider());
        this.fCategoriesTable.setLabelProvider((IBaseLabelProvider)new CategoriesTableLabelProvider());
        this.fCategoriesTable.addSelectionChangedListener((ISelectionChangedListener)new CategoriesTableSelectionChangedListener());
        this.fCategoriesTable.addDoubleClickListener((IDoubleClickListener)new CategoriesTableDubleClickListener());
        this.fCategoriesTable.addFilter((ViewerFilter)new ComplianceCheckFilter());
        Table table = this.fCategoriesTable.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        DVTColorUtil.INSTANCE.setBackground((Control)table, this.fBackgroundColor);
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Categories_Table_Column_1);
        column.setWidth(200);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Categories_Table_Column_2);
        column.setWidth(75);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Categories_Table_Column_3);
        column.setAlignment(0x1000000);
        column.setWidth(75);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Categories_Table_Column_4);
        column.setWidth(100);
        this.fCategoriesTableDetails = new Text((Composite)sashForm, 2634);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCategoriesTableDetails, this.fInfoBackgroundColor, true);
        int[] componentWeight = new int[]{4, 1};
        sashForm.setWeights(componentWeight);
    }

    private void createChecksTable(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 512);
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor, true);
        this.fChecksTable = new TableViewer((Composite)sashForm, 68356);
        this.fChecksTable.setContentProvider((IContentProvider)new ChecksTableContentProvider());
        this.fChecksTable.setLabelProvider((IBaseLabelProvider)new ChecksTableLabelProvider());
        this.fChecksTable.addDoubleClickListener((IDoubleClickListener)new ChecksTableDubleClickListener());
        DVTColorUtil.INSTANCE.setBackground(this.fChecksTable.getControl(), this.fBackgroundColor);
        Table table = this.fChecksTable.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        DVTColorUtil.INSTANCE.setBackground((Control)table, this.fBackgroundColor);
        TableColumn column = new TableColumn(table, 0);
        column.setResizable(false);
        column.setWidth(25);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Checks_Table_Column_2);
        column.setWidth(50);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Checks_Table_Column_3);
        column.setWidth(280);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Checks_Table_Column_4);
        column.setWidth(220);
        Composite downPartComposite = new Composite((Composite)sashForm, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginTop = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 5;
        downPartComposite.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)downPartComposite, this.fBackgroundColor);
    }

    private void createManualChecksPage(Composite parent) {
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        parent.setLayout((Layout)gl);
        Group buttonsComposite = new Group(parent, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        buttonsComposite.setLayout((Layout)new GridLayout(2, false));
        DVTColorUtil.INSTANCE.setBackground((Control)buttonsComposite, this.fBackgroundColor);
        Label description = new Label((Composite)buttonsComposite, 16448);
        description.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        description.setText(Messages.ChecksTreeBrowser_Manual_Checks_Description_Label);
        DVTColorUtil.INSTANCE.setBackground((Control)description, this.fBackgroundColor, true);
        this.fMarkAsPassedButton = new Button((Composite)buttonsComposite, 16);
        this.fMarkAsPassedButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fMarkAsPassedButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_MARK_AS_PASSED));
        this.fMarkAsPassedButton.setData((Object)1);
        this.fMarkAsPassedButton.addSelectionListener((SelectionListener)new MarkAsButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fMarkAsPassedButton, this.fBackgroundColor);
        Label markAsPassedDescription = new Label((Composite)buttonsComposite, 16448);
        markAsPassedDescription.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        markAsPassedDescription.setText(Messages.ChecksTreeBrowser_Manual_Checks_Radio_Passed);
        DVTColorUtil.INSTANCE.setBackground((Control)markAsPassedDescription, this.fBackgroundColor, true);
        this.fMarkAsFailedButton = new Button((Composite)buttonsComposite, 16);
        this.fMarkAsFailedButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fMarkAsFailedButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_MARK_AS_FAILED));
        this.fMarkAsFailedButton.setData((Object)2);
        this.fMarkAsFailedButton.addSelectionListener((SelectionListener)new MarkAsButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fMarkAsFailedButton, this.fBackgroundColor);
        Label markAsFailedDescription = new Label((Composite)buttonsComposite, 16448);
        markAsFailedDescription.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        markAsFailedDescription.setText(Messages.ChecksTreeBrowser_Manual_Checks_Radio_Failed);
        DVTColorUtil.INSTANCE.setBackground((Control)markAsFailedDescription, this.fBackgroundColor, true);
        this.fMarkAsNotAppliedButton = new Button((Composite)buttonsComposite, 16);
        this.fMarkAsNotAppliedButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fMarkAsNotAppliedButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_MARK_AS_NOT_APPLIED));
        this.fMarkAsNotAppliedButton.setData((Object)0);
        this.fMarkAsNotAppliedButton.addSelectionListener((SelectionListener)new MarkAsButtonSelectionListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fMarkAsNotAppliedButton, this.fBackgroundColor);
        Label markAsNotAppliedDescription = new Label((Composite)buttonsComposite, 16448);
        markAsNotAppliedDescription.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        markAsNotAppliedDescription.setText(Messages.ChecksTreeBrowser_Manual_Checks_Radio_Not_Applied);
        DVTColorUtil.INSTANCE.setBackground((Control)markAsNotAppliedDescription, this.fBackgroundColor, true);
    }

    private void updateTree() {
        if (this.fSelectedItem == null || ((IStructuredSelection)this.fTree.getSelection()).getFirstElement() == null) {
            StructuredSelection selection = new StructuredSelection((Object)Messages.ChecksTreeBrowser_Summary_Item);
            this.fTree.setSelection((ISelection)selection, true);
        }
        this.fTree.expandAll();
        this.fTree.refresh();
        this.fCategoriesTable.refresh();
    }

    private void updateLeftPart() {
        if (this.fSelectedItem != null) {
            if (this.fSelectedItem instanceof String && ((String)this.fSelectedItem).equals(Messages.ChecksTreeBrowser_Summary_Item)) {
                this.updateSummaryComposite();
            } else if (this.fSelectedItem instanceof IOVMComplianceCategory) {
                this.updateCategoriesComposite((IOVMComplianceCategory)this.fSelectedItem);
            } else if (this.fSelectedItem instanceof IOVMComplianceManualCheck) {
                this.updateManualChecksComposite((IOVMComplianceManualCheck)this.fSelectedItem);
            } else if (this.fSelectedItem instanceof IOVMComplianceCheck) {
                this.updateChecksComposite((IOVMComplianceCheck)this.fSelectedItem);
            }
            Object element = ((IStructuredSelection)this.fCategoriesTable.getSelection()).getFirstElement();
            if (element == null) {
                this.fCategoriesTableDetails.setText("");
            } else if (element instanceof IOVMComplianceCheckBase) {
                this.fCategoriesTableDetails.setText(((IOVMComplianceCheckBase)element).getDescription());
            }
            this.fRightPartComposite.layout(true, true);
        }
    }

    private void updateSummaryComposite() {
        this.fSummaryTable.setInput(this.fTree.getInput());
        this.updateCheckStatusAndPropertiesControls(null);
        this.updateTitleAndDescription(Messages.ChecksTreeBrowser_Summary_Table_Title, Messages.ChecksTreeBrowser_Summary_Table_Description);
        this.fContentsStack.topControl = this.fSummaryComposite;
    }

    private void updateCategoriesComposite(IOVMComplianceCategory category) {
        ArrayList<IOVMComplianceCheck> checks = new ArrayList<IOVMComplianceCheck>();
        checks.addAll(category.getChecks());
        this.fCategoriesTable.setInput(checks);
        this.updateCheckStatusAndPropertiesControls(null);
        this.updateTitleAndDescription(category.getName(), category.getDescription());
        this.fContentsStack.topControl = this.fCategoriesComposite;
    }

    private void updateChecksComposite(IOVMComplianceCheck check) {
        this.fChecksTable.setInput(check.getHits());
        this.updateCheckStatusAndPropertiesControls(check);
        this.updateTitleAndDescription(String.valueOf(check.getUserId(false)) + ": " + check.getTitle(), check.getDescription());
        this.fContentsStack.topControl = this.fChecksComposite;
    }

    private void updateManualChecksComposite(IOVMComplianceManualCheck check) {
        if (check.isEnabled()) {
            this.updateManualChecksButtons(true);
            int status = ((IOVMComplianceManualCheck)this.fSelectedItem).getStatus();
            this.fMarkAsNotAppliedButton.setSelection(status == 0);
            this.fMarkAsPassedButton.setSelection(status == 1);
            this.fMarkAsFailedButton.setSelection(status == 2);
        } else {
            this.updateManualChecksButtons(false);
        }
        this.updateCheckStatusAndPropertiesControls(check);
        this.updateTitleAndDescription(String.valueOf(check.getUserId(false)) + ": " + check.getTitle(), check.getDescription());
        this.fContentsStack.topControl = this.fManualChecksComposite;
    }

    private void updateManualChecksButtons(boolean enabled) {
        this.fMarkAsNotAppliedButton.setEnabled(enabled);
        this.fMarkAsPassedButton.setEnabled(enabled);
        this.fMarkAsFailedButton.setEnabled(enabled);
    }

    private void updateTitleAndDescription(String title, String description) {
        this.fDetailsTitle.setText(title == null ? "" : title);
        this.fDetailsDescription.setText(description == null ? "" : description);
    }

    private void updateCheckStatusAndPropertiesControls(IOVMComplianceCheckBase check) {
        boolean visible = false;
        if (check != null) {
            this.fCheckStatusIcon.setImage(OVMComplianceChecksUtil.getImage(check));
            this.fCheckStatusText.setText(String.valueOf(Messages.ChecksTreeBrowser_Checks_Status) + OVMComplianceChecksUtil.getDetailsText(check));
            visible = true;
        }
        this.fCheckProperties.setVisible(visible);
        this.fCheckStatusDetailsContainer.setVisible(visible);
        ((GridData)this.fCheckStatusDetailsContainer.getLayoutData()).exclude = !visible;
        ((GridData)this.fDetailsTitle.getLayoutData()).grabExcessHorizontalSpace = !visible;
        ((GridData)this.fCheckProperties.getLayoutData()).grabExcessHorizontalSpace = visible;
    }

    private void updateFilterButtonsTooltTips(Button button) {
        String buttonToolTip = (String)button.getData();
        button.setToolTipText(String.valueOf(button.getSelection() ? "Show " : "Hide ") + (buttonToolTip == null ? "" : buttonToolTip) + " Checks");
    }

    private void updateAllFilterButtonsTooltTips() {
        this.updateFilterButtonsTooltTips(this.fHidePassedButton);
        this.updateFilterButtonsTooltTips(this.fHideErrorButton);
        this.updateFilterButtonsTooltTips(this.fHideWarningButton);
        this.updateFilterButtonsTooltTips(this.fHideInfoButton);
        this.updateFilterButtonsTooltTips(this.fHideNotAppliedButton);
        this.updateFilterButtonsTooltTips(this.fHideDisabledButton);
        this.updateFilterButtonsTooltTips(this.fHideAutomaticButton);
        this.updateFilterButtonsTooltTips(this.fHideManualButton);
    }

    private String getFileShortName(String fileName) {
        if (fileName == null) {
            return "";
        }
        File f = new File(fileName);
        String name = f.getName();
        return name == null ? "" : name;
    }

    public void setInput(ArrayList<IOVMComplianceCategory> input) {
        this.fTree.setInput(input);
        this.updateTree();
    }

    @Override
    public void reportUpdate() {
        this.updateTree();
        this.updateLeftPart();
    }

    public void dispose() {
        if (this.fFontFactory != null) {
            this.fFontFactory.dispose();
        }
    }

    private static final class CategoriesTableContentProvider
    implements IStructuredContentProvider {
        private CategoriesTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                ArrayList inputList = (ArrayList)inputElement;
                return inputList.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class CategoriesTableDubleClickListener
    implements IDoubleClickListener {
        private CategoriesTableDubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && (element = selection.getFirstElement()) instanceof IOVMComplianceCheckBase) {
                ChecksTreeBrowser.this.fTree.setSelection((ISelection)selection);
            }
        }
    }

    private static final class CategoriesTableLabelProvider
    implements ITableLabelProvider {
        private CategoriesTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1 && element != null && element instanceof IOVMComplianceCheckBase) {
                return OVMComplianceChecksUtil.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof IOVMComplianceCheckBase) {
                IOVMComplianceCheckBase check = (IOVMComplianceCheckBase)element;
                if (columnIndex == 0) {
                    return check.getUserId(true);
                }
                if (columnIndex == 2) {
                    if (check instanceof IOVMComplianceManualCheck) {
                        return "Manual";
                    }
                    if (check instanceof IOVMComplianceCheck) {
                        return String.valueOf(Integer.toString(((IOVMComplianceCheck)check).getNofPassed())) + " / " + Integer.toString(((IOVMComplianceCheck)check).getNofHits());
                    }
                } else if (columnIndex == 3) {
                    return String.valueOf(check.getTitle()) + ": " + check.getDescription();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class CategoriesTableSelectionChangedListener
    implements ISelectionChangedListener {
        private CategoriesTableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof IOVMComplianceCheckBase) {
                ChecksTreeBrowser.this.fCategoriesTableDetails.setText(((IOVMComplianceCheckBase)element).getDescription());
            }
        }
    }

    private static final class CheckPropertiesDialog
    extends MessageDialog {
        private Button fErrorRadio;
        private Button fWarningRadio;
        private Button fInfoRadio;
        private Button fEnableRadio;
        private Button fDisableRadio;
        private final IOVMComplianceCheckBase fCheck;

        public CheckPropertiesDialog(IOVMComplianceCheckBase check) {
            super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.ChecksTreeBrowser_Check_Properties_Dialog_Title, null, Messages.ChecksTreeBrowser_Check_Properties_Dialog_Description, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.fCheck = check;
        }

        public int open() {
            if (this.fCheck != null) {
                return super.open();
            }
            return -1;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                if (this.fCheck instanceof IOVMComplianceManualCheck) {
                    IOVMComplianceManualCheck check = (IOVMComplianceManualCheck)this.fCheck;
                    if (this.fEnableRadio.getSelection() && !check.isEnabled()) {
                        check.setEnabledAndSave(true);
                    } else if (this.fDisableRadio.getSelection() && check.isEnabled()) {
                        check.setEnabledAndSave(false);
                    }
                } else if (this.fCheck instanceof IOVMComplianceCheck) {
                    IOVMComplianceCheck check = (IOVMComplianceCheck)this.fCheck;
                    if (this.fErrorRadio.getSelection()) {
                        check.setSeverityAndSave(0);
                    } else if (this.fWarningRadio.getSelection()) {
                        check.setSeverityAndSave(1);
                    } else if (this.fInfoRadio.getSelection()) {
                        check.setSeverityAndSave(2);
                    }
                    if (this.fEnableRadio.getSelection() && !check.isEnabled()) {
                        check.setEnabledAndSave(true);
                        check.performCheck();
                    } else if (this.fDisableRadio.getSelection() && check.isEnabled()) {
                        check.setEnabledAndSave(false);
                        check.performCheck();
                    }
                }
            }
            this.setReturnCode(buttonId);
            this.close();
        }

        protected Control createDialogArea(Composite parent) {
            Composite contents = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, true);
            gl.horizontalSpacing = 20;
            gl.verticalSpacing = 15;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            contents.setLayout((Layout)gl);
            Group endisGroup = new Group(contents, 4);
            endisGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            endisGroup.setText(Messages.ChecksTreeBrowser_Check_Properties_Dialog_Enable_Disable_Group);
            endisGroup.setLayout((Layout)new GridLayout(1, false));
            this.fEnableRadio = new Button((Composite)endisGroup, 16);
            this.fEnableRadio.setText(Messages.ChecksTreeBrowser_Check_Properties_Dialog_Enable_Radio);
            this.fEnableRadio.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fDisableRadio = new Button((Composite)endisGroup, 16);
            this.fDisableRadio.setText(Messages.ChecksTreeBrowser_Check_Properties_Dialog_Disable_Radio);
            this.fDisableRadio.setLayoutData((Object)new GridData(4, 4, true, true));
            if (this.fCheck.isEnabled()) {
                this.fEnableRadio.setSelection(true);
            } else {
                this.fDisableRadio.setSelection(true);
            }
            if (this.fCheck instanceof IOVMComplianceCheck && !(this.fCheck instanceof IOVMComplianceManualCheck)) {
                IOVMComplianceCheck check = (IOVMComplianceCheck)this.fCheck;
                Group severityGroup = new Group(contents, 4);
                severityGroup.setLayoutData((Object)new GridData(4, 4, true, true));
                severityGroup.setText(Messages.ChecksTreeBrowser_Check_Properties_Dialog_Severity_Group);
                severityGroup.setLayout((Layout)new GridLayout(1, false));
                this.fErrorRadio = new Button((Composite)severityGroup, 16);
                this.fErrorRadio.setText(Messages.ChecksTreeBrowser_Check_Properties_Dialog_Severity_Error);
                this.fErrorRadio.setLayoutData((Object)new GridData(4, 4, true, true));
                this.fWarningRadio = new Button((Composite)severityGroup, 16);
                this.fWarningRadio.setText(Messages.ChecksTreeBrowser_Check_Properties_Dialog_Severity_Warning);
                this.fWarningRadio.setLayoutData((Object)new GridData(4, 4, true, true));
                this.fInfoRadio = new Button((Composite)severityGroup, 16);
                this.fInfoRadio.setText(Messages.ChecksTreeBrowser_Check_Properties_Dialog_Severity_Info);
                this.fInfoRadio.setLayoutData((Object)new GridData(4, 4, true, true));
                if (check.getSeverity() == 0) {
                    this.fErrorRadio.setSelection(true);
                } else if (check.getSeverity() == 1) {
                    this.fWarningRadio.setSelection(true);
                } else if (check.getSeverity() == 2) {
                    this.fInfoRadio.setSelection(true);
                }
            } else {
                Label dummy = new Label(contents, 0);
                dummy.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            }
            Button defaultPush = new Button(contents, 8);
            defaultPush.setText(Messages.OVMComplianceReport_Main_Page_Checks_Restore_Button);
            defaultPush.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            defaultPush.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    fCheck.restoreDefaults();
                    if (fCheck instanceof IOVMComplianceCheck) {
                        IOVMComplianceCheck check = (IOVMComplianceCheck)fCheck;
                        if (check.getSeverity() == 0) {
                            fErrorRadio.setSelection(true);
                            fWarningRadio.setSelection(false);
                            fInfoRadio.setSelection(false);
                        } else if (check.getSeverity() == 1) {
                            fErrorRadio.setSelection(false);
                            fWarningRadio.setSelection(true);
                            fInfoRadio.setSelection(false);
                        } else if (check.getSeverity() == 2) {
                            fErrorRadio.setSelection(false);
                            fWarningRadio.setSelection(false);
                            fInfoRadio.setSelection(true);
                        }
                    }
                    if (fCheck.isEnabled()) {
                        fEnableRadio.setSelection(true);
                        fDisableRadio.setSelection(false);
                    } else {
                        fEnableRadio.setSelection(false);
                        fDisableRadio.setSelection(true);
                    }
                }
            });
            return contents;
        }
    }

    private final class ChecksPropertiesButtonListener
    implements SelectionListener {
        private ChecksPropertiesButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CheckPropertiesDialog propertiesDialog;
                    int status;
                    if (((ChecksPropertiesButtonListener)ChecksPropertiesButtonListener.this).ChecksTreeBrowser.this.fSelectedItem != null && ((ChecksPropertiesButtonListener)ChecksPropertiesButtonListener.this).ChecksTreeBrowser.this.fSelectedItem instanceof IOVMComplianceCheckBase && (status = (propertiesDialog = new CheckPropertiesDialog((IOVMComplianceCheckBase)((ChecksPropertiesButtonListener)ChecksPropertiesButtonListener.this).ChecksTreeBrowser.this.fSelectedItem)).open()) == 0) {
                        if (((ChecksPropertiesButtonListener)ChecksPropertiesButtonListener.this).ChecksTreeBrowser.this.fSelectedItem instanceof IOVMComplianceManualCheck) {
                            ChecksTreeBrowser.this.updateManualChecksButtons(((IOVMComplianceManualCheck)((ChecksPropertiesButtonListener)ChecksPropertiesButtonListener.this).ChecksTreeBrowser.this.fSelectedItem).isEnabled());
                        } else if (((ChecksPropertiesButtonListener)ChecksPropertiesButtonListener.this).ChecksTreeBrowser.this.fSelectedItem instanceof IOVMComplianceCheck) {
                            ((ChecksPropertiesButtonListener)ChecksPropertiesButtonListener.this).ChecksTreeBrowser.this.fChecksTable.refresh();
                        }
                        ChecksTreeBrowser.this.updateCheckStatusAndPropertiesControls((IOVMComplianceCheckBase)((ChecksPropertiesButtonListener)ChecksPropertiesButtonListener.this).ChecksTreeBrowser.this.fSelectedItem);
                        ((ChecksPropertiesButtonListener)ChecksPropertiesButtonListener.this).ChecksTreeBrowser.this.fRightPartComposite.layout(true, true);
                        ChecksTreeBrowser.this.updateTree();
                    }
                }
            });
        }
    }

    private static final class ChecksTableContentProvider
    implements IStructuredContentProvider {
        private ChecksTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ChecksTableDubleClickListener
    implements IDoubleClickListener {
        private ChecksTableDubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && (element = selection.getFirstElement()) instanceof IOVMComplianceCheckHit) {
                EDTFileUtils.getInstance().openFile((AbstractEModelManager)EModelManager.getInstance(), ChecksTreeBrowser.this.fProject, ((IOVMComplianceCheckHit)element).getFile(), ((IOVMComplianceCheckHit)element).getLine(), null);
            }
        }
    }

    private final class ChecksTableLabelProvider
    implements ITableLabelProvider {
        private ChecksTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element != null && element instanceof IOVMComplianceCheckHit) {
                return OVMComplianceChecksUtil.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof IOVMComplianceCheckHit) {
                IOVMComplianceCheckHit hit = (IOVMComplianceCheckHit)element;
                if (columnIndex == 1) {
                    return Integer.toString(hit.getLine());
                }
                if (columnIndex == 2) {
                    return ChecksTreeBrowser.this.getFileShortName(String.valueOf(hit.getFile()) + hit.getMacroPath());
                }
                if (columnIndex == 3) {
                    return ChecksTreeBrowser.this.getFileShortName(hit.getDetails());
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class ChecksTreeContentProvider
    implements ITreeContentProvider {
        private ChecksTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IOVMComplianceCategory) {
                ArrayList<IOVMComplianceCheck> children = new ArrayList<IOVMComplianceCheck>();
                children.addAll(((IOVMComplianceCategory)parentElement).getChecks());
                return children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IOVMComplianceCheckBase) {
                return ((IOVMComplianceCheckBase)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ArrayList || element instanceof IOVMComplianceCategory;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                ArrayList inputElementTmp = (ArrayList)inputElement;
                ArrayList<Object> children = new ArrayList<Object>();
                children.add(Messages.ChecksTreeBrowser_Summary_Item);
                for (IOVMComplianceCategory category : inputElementTmp) {
                    if (category.getNofChecks() <= 0) continue;
                    children.add(category);
                }
                return children.toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static final class ChecksTreeLabelProvider
    implements ILabelProvider {
        private ChecksTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return OVMComplianceChecksUtil.getImage(element);
        }

        public String getText(Object element) {
            return OVMComplianceChecksUtil.getTreeText(element);
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    private final class ChecksTreeSelectionChangedListener
    implements ISelectionChangedListener {
        private ChecksTreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element;
            ChecksTreeBrowser.this.fSelectedItem = element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            ChecksTreeBrowser.this.updateLeftPart();
        }
    }

    private final class ComplianceCheckFilter
    extends ViewerFilter {
        private ComplianceCheckFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IOVMComplianceCheckBase) {
                if (element instanceof IOVMComplianceCheck && ChecksTreeBrowser.this.fHideAutomaticButton.getSelection()) {
                    return false;
                }
                if (element instanceof IOVMComplianceManualCheck && ChecksTreeBrowser.this.fHideManualButton.getSelection()) {
                    return false;
                }
                int status = OVMComplianceChecksUtil.getStatus(element);
                if (status == 6 && ChecksTreeBrowser.this.fHideDisabledButton.getSelection()) {
                    return false;
                }
                if (status == 1 && ChecksTreeBrowser.this.fHidePassedButton.getSelection()) {
                    return false;
                }
                if (status == 2 && ChecksTreeBrowser.this.fHideErrorButton.getSelection()) {
                    return false;
                }
                if (status == 3 && ChecksTreeBrowser.this.fHideWarningButton.getSelection()) {
                    return false;
                }
                if (status == 4 && ChecksTreeBrowser.this.fHideInfoButton.getSelection()) {
                    return false;
                }
                return status != 5 || !ChecksTreeBrowser.this.fHideNotAppliedButton.getSelection();
            }
            return element instanceof String || element instanceof IOVMComplianceCategory;
        }
    }

    private final class FilterButtonSelectionListener
    implements SelectionListener {
        private FilterButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget != null && e.widget instanceof Button) {
                Button button = (Button)e.widget;
                ChecksTreeBrowser.this.updateFilterButtonsTooltTips(button);
                ChecksTreeBrowser.this.resetFiltersList();
                ChecksTreeBrowser.this.updateTree();
            }
        }
    }

    private final class FiltersListSelectionListener
    implements SelectionListener {
        private FiltersListSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = ChecksTreeBrowser.this.fFiltersList.getSelectionIndex();
            String selection = ChecksTreeBrowser.this.fFiltersList.getItem(index);
            if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Show_All)) {
                ChecksTreeBrowser.this.fHidePassedButton.setSelection(false);
                ChecksTreeBrowser.this.fHideErrorButton.setSelection(false);
                ChecksTreeBrowser.this.fHideWarningButton.setSelection(false);
                ChecksTreeBrowser.this.fHideInfoButton.setSelection(false);
                ChecksTreeBrowser.this.fHideNotAppliedButton.setSelection(false);
                ChecksTreeBrowser.this.fHideDisabledButton.setSelection(false);
                ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(false);
                ChecksTreeBrowser.this.fHideManualButton.setSelection(false);
            } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Errors)) {
                ChecksTreeBrowser.this.fHidePassedButton.setSelection(true);
                ChecksTreeBrowser.this.fHideErrorButton.setSelection(false);
                ChecksTreeBrowser.this.fHideWarningButton.setSelection(true);
                ChecksTreeBrowser.this.fHideInfoButton.setSelection(true);
                ChecksTreeBrowser.this.fHideNotAppliedButton.setSelection(true);
                ChecksTreeBrowser.this.fHideDisabledButton.setSelection(true);
                ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(false);
                ChecksTreeBrowser.this.fHideManualButton.setSelection(false);
            } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Errors_Not_Applied)) {
                ChecksTreeBrowser.this.fHidePassedButton.setSelection(true);
                ChecksTreeBrowser.this.fHideErrorButton.setSelection(false);
                ChecksTreeBrowser.this.fHideWarningButton.setSelection(true);
                ChecksTreeBrowser.this.fHideInfoButton.setSelection(true);
                ChecksTreeBrowser.this.fHideNotAppliedButton.setSelection(false);
                ChecksTreeBrowser.this.fHideDisabledButton.setSelection(true);
                ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(false);
                ChecksTreeBrowser.this.fHideManualButton.setSelection(false);
            } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Not_Applied)) {
                ChecksTreeBrowser.this.fHidePassedButton.setSelection(true);
                ChecksTreeBrowser.this.fHideErrorButton.setSelection(true);
                ChecksTreeBrowser.this.fHideWarningButton.setSelection(true);
                ChecksTreeBrowser.this.fHideInfoButton.setSelection(true);
                ChecksTreeBrowser.this.fHideNotAppliedButton.setSelection(false);
                ChecksTreeBrowser.this.fHideDisabledButton.setSelection(true);
                ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(false);
                ChecksTreeBrowser.this.fHideManualButton.setSelection(false);
            } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Disabled)) {
                ChecksTreeBrowser.this.fHidePassedButton.setSelection(true);
                ChecksTreeBrowser.this.fHideErrorButton.setSelection(true);
                ChecksTreeBrowser.this.fHideWarningButton.setSelection(true);
                ChecksTreeBrowser.this.fHideInfoButton.setSelection(true);
                ChecksTreeBrowser.this.fHideNotAppliedButton.setSelection(true);
                ChecksTreeBrowser.this.fHideDisabledButton.setSelection(false);
                ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(false);
                ChecksTreeBrowser.this.fHideManualButton.setSelection(false);
            } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Manual)) {
                ChecksTreeBrowser.this.fHidePassedButton.setSelection(false);
                ChecksTreeBrowser.this.fHideErrorButton.setSelection(false);
                ChecksTreeBrowser.this.fHideWarningButton.setSelection(false);
                ChecksTreeBrowser.this.fHideInfoButton.setSelection(false);
                ChecksTreeBrowser.this.fHideNotAppliedButton.setSelection(false);
                ChecksTreeBrowser.this.fHideDisabledButton.setSelection(false);
                ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(false);
                ChecksTreeBrowser.this.fHideManualButton.setSelection(true);
            } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Automatic)) {
                ChecksTreeBrowser.this.fHidePassedButton.setSelection(false);
                ChecksTreeBrowser.this.fHideErrorButton.setSelection(false);
                ChecksTreeBrowser.this.fHideWarningButton.setSelection(false);
                ChecksTreeBrowser.this.fHideInfoButton.setSelection(false);
                ChecksTreeBrowser.this.fHideNotAppliedButton.setSelection(false);
                ChecksTreeBrowser.this.fHideDisabledButton.setSelection(false);
                ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(true);
                ChecksTreeBrowser.this.fHideManualButton.setSelection(false);
            } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Passed)) {
                ChecksTreeBrowser.this.fHidePassedButton.setSelection(true);
                ChecksTreeBrowser.this.fHideErrorButton.setSelection(false);
                ChecksTreeBrowser.this.fHideWarningButton.setSelection(false);
                ChecksTreeBrowser.this.fHideInfoButton.setSelection(false);
                ChecksTreeBrowser.this.fHideNotAppliedButton.setSelection(false);
                ChecksTreeBrowser.this.fHideDisabledButton.setSelection(false);
                ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(false);
                ChecksTreeBrowser.this.fHideManualButton.setSelection(false);
            }
            ChecksTreeBrowser.this.updateAllFilterButtonsTooltTips();
            ChecksTreeBrowser.this.updateTree();
        }
    }

    private final class MarkAsButtonSelectionListener
    implements SelectionListener {
        private MarkAsButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Integer status;
            if (ChecksTreeBrowser.this.fSelectedItem != null && ChecksTreeBrowser.this.fSelectedItem instanceof IOVMComplianceManualCheck && (status = (Integer)e.widget.getData()) != null) {
                ((IOVMComplianceManualCheck)ChecksTreeBrowser.this.fSelectedItem).setStatusAndSave(status);
                ChecksTreeBrowser.this.updateManualChecksComposite((IOVMComplianceManualCheck)ChecksTreeBrowser.this.fSelectedItem);
                ChecksTreeBrowser.this.fRightPartComposite.layout(true, true);
                ChecksTreeBrowser.this.updateTree();
            }
        }
    }

    private static final class SummaryTableContentProvider
    implements IStructuredContentProvider {
        private SummaryTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                ArrayList inputElementTmp = (ArrayList)inputElement;
                ArrayList<IOVMComplianceCategory> children = new ArrayList<IOVMComplianceCategory>();
                for (IOVMComplianceCategory category : inputElementTmp) {
                    if (category.getNofChecks() <= 0) continue;
                    children.add(category);
                }
                return children.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class SummaryTableDubleClickListener
    implements IDoubleClickListener {
        private SummaryTableDubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && (element = selection.getFirstElement()) instanceof IOVMComplianceCategory) {
                ChecksTreeBrowser.this.fTree.setSelection((ISelection)selection);
            }
        }
    }

    private static final class SummaryTableLabelProvider
    implements ITableLabelProvider {
        private SummaryTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1 && element != null && element instanceof IOVMComplianceCategory) {
                return OVMComplianceChecksUtil.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof IOVMComplianceCategory) {
                IOVMComplianceCategory category = (IOVMComplianceCategory)element;
                if (columnIndex == 0) {
                    return category.getName();
                }
                if (columnIndex == 2) {
                    return String.valueOf(Integer.toString(category.getNofEnabledChecks())) + " / " + Integer.toString(category.getNofChecks());
                }
                if (columnIndex == 3) {
                    return category.getDescription();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class SummaryTableSelectionChangedListener
    implements ISelectionChangedListener {
        private SummaryTableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof IOVMComplianceCategory) {
                ChecksTreeBrowser.this.fSummaryTableDetails.setText(((IOVMComplianceCategory)element).getDescription());
            }
        }
    }
}

