/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance.ui;

import java.util.HashMap;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class FontFactory {
    private HashMap<String, Font> fFonts = new HashMap();
    private Font fDefaultFont;

    public FontFactory(Display display) {
        this.fDefaultFont = display.getSystemFont();
        if (this.fDefaultFont == null) {
            this.fDefaultFont = new Font(null, new FontData());
        }
    }

    public Font createFont(String name, int size, int style) {
        String internalName = String.valueOf(name) + " " + Integer.toString(size) + " " + Integer.toString(style);
        Font font = this.fFonts.get(internalName);
        if (font == null) {
            FontData[] fd;
            FontData[] fontDataArray = fd = (FontData[])this.fDefaultFont.getFontData().clone();
            int n = fd.length;
            int n2 = 0;
            while (n2 < n) {
                FontData data = fontDataArray[n2];
                if (size > 0) {
                    data.setHeight(size);
                }
                data.setStyle(style);
                ++n2;
            }
            font = new Font(null, fd);
            this.fFonts.put(internalName, font);
        }
        return font;
    }

    public Font createFont(String name, int style) {
        return this.createFont(name, -1, style);
    }

    public synchronized void dispose() {
        for (Font font : this.fFonts.values()) {
            font.dispose();
        }
        this.fFonts.clear();
    }
}

