/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance.ui;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheckHit;
import ro.amiq.edt.ovmcompliance.IOVMComplianceManualCheck;
import ro.amiq.edt.ovmcompliance.IOVMComplianceStatistic;
import ro.amiq.edt.ovmcompliance.IOVMComplianceStatisticHit;
import ro.amiq.edt.ovmcompliance.IOVMComponent;
import ro.amiq.edt.ovmcompliance.IOVMComponentCategory;
import ro.amiq.edt.ovmcompliance.IReportInfoProvider;
import ro.amiq.edt.ovmcompliance.OVMComponent;
import ro.amiq.edt.ovmcompliance.OVMComponentCategory;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;

public class HTMLReportGenerator {
    IReportInfoProvider fReportInfoProvider;
    String fOutputFolderPath;
    public static final int DISABLED = 0;
    public static final int PASSED = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    public static final int INFO = 4;
    public static final int STATISTIC = 5;
    public static final int EXPAND = 5;
    public static final int COLLAPSE = 6;
    public static final int EXPAND_ALL = 7;
    public static final int COLLAPSE_ALL = 8;
    public static final int NOT_APPLIED = 9;
    private ArrayList<IOVMComponentCategory> fOVMComponentCategories;

    public HTMLReportGenerator(IReportInfoProvider reportInfoProvider) {
        this.fReportInfoProvider = reportInfoProvider;
    }

    public void generateReport() {
        this.buildArchitectureData();
        if (!this.createOutputFolder()) {
            return;
        }
        if (!this.writeDesignFiles()) {
            return;
        }
        if (!this.writeToOutputFile("architecture.html", this.buildArchitecture())) {
            return;
        }
        if (!this.writeToOutputFile("legend.html", this.buildLegend())) {
            return;
        }
        if (!this.writeToOutputFile("index.html", this.buildSummary())) {
            return;
        }
        if (!this.writeToOutputFile("checks.html", this.buildChecks())) {
            return;
        }
        ArrayList<IOVMComplianceCategory> checkCategories = this.fReportInfoProvider.getCategories();
        int i = 0;
        for (IOVMComplianceCategory checkCategory : checkCategories) {
            if (checkCategory.getChecks().isEmpty() || this.writeToOutputFile("checks" + ++i + ".html", this.buildCategoryChecks(checkCategory, i))) continue;
            return;
        }
        if (!this.writeToOutputFile("stats.html", this.buildStatistics())) {
            return;
        }
        ArrayList<IOVMComplianceCategory> statisticCategories = this.fReportInfoProvider.getCategories();
        i = 0;
        for (IOVMComplianceCategory statsCategory : statisticCategories) {
            if (statsCategory.getStatistics().isEmpty() || this.writeToOutputFile("stats" + ++i + ".html", this.buildStatisticChecks(statsCategory, i))) continue;
            return;
        }
        this.performResourceRefresh();
        this.openInBrowser();
    }

    IProject getProject() {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fReportInfoProvider.getProjectName());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void performResourceRefresh() {
        try {
            IProject project = this.getProject();
            if (project == null) {
                return;
            }
            IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new File(this.fOutputFolderPath).toURI());
            if (containers.length == 0) {
                return;
            }
            containers[0].refreshLocal(2, null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void openInBrowser() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    int xvmMode = HTMLReportGenerator.this.fReportInfoProvider.getOVMProject().getXVMMode();
                    File reportFile = new File(String.valueOf(HTMLReportGenerator.this.fOutputFolderPath) + File.separator + XVMModeUtils.getHTMLReportFile(xvmMode));
                    IPath reportLocation = Path.fromOSString((String)reportFile.getAbsolutePath());
                    IFile reportIFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(reportLocation);
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)reportIFile, (boolean)true);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    private String buildSummary() {
        return String.valueOf(this.buildHeader()) + this.buildMenu("summary") + this.buildSummaryBody() + this.buildFooter();
    }

    private String buildChecks() {
        return String.valueOf(this.buildHeader()) + this.buildMenu("checks") + this.buildChecksBody() + this.buildFooter();
    }

    private String buildCategoryChecks(IOVMComplianceCategory checkCategory, int id) {
        return String.valueOf(this.buildHeader()) + this.buildMenu("checks" + id) + this.buildChecksCategoryBody(checkCategory) + this.buildFooter();
    }

    private String buildStatistics() {
        return String.valueOf(this.buildHeader()) + this.buildMenu("statistics") + this.buildStatisticsBody() + this.buildFooter();
    }

    private String buildStatisticChecks(IOVMComplianceCategory statisticCategory, int id) {
        return String.valueOf(this.buildHeader()) + this.buildMenu("statistics" + id) + this.buildStatsCategoryBody(statisticCategory) + this.buildFooter();
    }

    private String buildArchitecture() {
        return String.valueOf(this.buildHeader()) + this.buildMenu("architecture") + this.buildArchitectureBody() + this.buildFooter();
    }

    private String buildLegend() {
        return String.valueOf(this.buildHeader()) + this.buildMenu("legend") + this.buildLegendBody() + this.buildFooter();
    }

    private boolean writeDesignFiles() {
        try {
            ArrayList<String> designFiles = new ArrayList<String>();
            designFiles.add("/resources/ovmcompliancereport/style.css");
            designFiles.add(XVMModeUtils.getHTMLReportXVMLogoResource(this.fReportInfoProvider.getOVMProject().getXVMMode()));
            designFiles.add("/resources/ovmcompliancereport/DVT.jpg");
            designFiles.add("/resources/ovmcompliancereport/hit.gif");
            designFiles.add("/resources/ovmcompliancereport/more.jpg");
            designFiles.add("/resources/ovmcompliancereport/less.jpg");
            designFiles.add("/resources/ovmcompliancereport/passed.gif");
            designFiles.add("/resources/ovmcompliancereport/passed_small.gif");
            designFiles.add("/resources/ovmcompliancereport/disabled.gif");
            designFiles.add("/resources/ovmcompliancereport/disabled_small.gif");
            designFiles.add("/resources/ovmcompliancereport/error.gif");
            designFiles.add("/resources/ovmcompliancereport/error_small.gif");
            designFiles.add("/resources/ovmcompliancereport/warning.gif");
            designFiles.add("/resources/ovmcompliancereport/warning_small.gif");
            designFiles.add("/resources/ovmcompliancereport/unknown.gif");
            designFiles.add("/resources/ovmcompliancereport/unknown_small.gif");
            designFiles.add("/resources/ovmcompliancereport/info.gif");
            designFiles.add("/resources/ovmcompliancereport/info_small.gif");
            for (String path : designFiles) {
                URL fileURL = Platform.getBundle((String)"ro.amiq.edt").getEntry(path);
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream is = fileURL.openStream();){
                    File outputFile = new File(String.valueOf(this.fOutputFolderPath) + File.separator + path.split("/")[path.split("/").length - 1]);
                    Throwable throwable2 = null;
                    Object var10_13 = null;
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
                        int readByte;
                        while ((readByte = is.read()) >= 0) {
                            ((OutputStream)outputStream).write(readByte);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            return true;
        }
        catch (Exception exception) {
            this.popUp("Error Writing Report Files Content", "A problem occurred while writing compliance report report files to disk. Please check that you have write permissions in the output folder.", null);
            return false;
        }
    }

    private boolean createOutputFolder() {
        this.fOutputFolderPath = String.valueOf(this.fReportInfoProvider.getOutputPath()) + File.separator + this.fReportInfoProvider.getOutputFolder();
        File outputFolder = new File(this.fOutputFolderPath);
        outputFolder.mkdir();
        int xvmMode = this.fReportInfoProvider.getOVMProject().getXVMMode();
        File linterReportFile = new File(this.fOutputFolderPath, XVMModeUtils.getHTMLReportFile(xvmMode));
        try {
            linterReportFile.createNewFile();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        return true;
    }

    private boolean writeToOutputFile(String fileName, String content) {
        BufferedWriter fileWriter = null;
        try {
            fileWriter = new BufferedWriter(new FileWriter(String.valueOf(this.fOutputFolderPath) + File.separator + fileName));
        }
        catch (IOException iOException) {
            this.popUp("Error Writing Report Files Content", "A problem occurred while writing compliance report report files to disk. Please check that you have write permissions in the output folder.", null);
            return false;
        }
        try {
            fileWriter.write(content);
            return true;
        }
        catch (IOException iOException) {
            this.popUp("Error Writing Report Files Content", "A problem occurred while writing compliance report report files to disk. Please check that you have write permissions in the output folder and that the destination disk is not full.", null);
            return false;
        }
        finally {
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)fileWriter);
        }
    }

    private String buildHeader() {
        int xvmMode = this.fReportInfoProvider.getOVMProject().getXVMMode();
        String reportTitle = XVMModeUtils.getHTMLReportTitle(xvmMode);
        String xvmWorldHttpAddress = XVMModeUtils.getHTMLReportXVMWorldReportAddress(xvmMode);
        String xvmCSSStyle = XVMModeUtils.getHTMLReportXVMCSSStyle(xvmMode);
        return "<html>\n<head>\n<title>" + reportTitle + " on " + this.fReportInfoProvider.getProjectName() + "</title>\n" + "<meta name=\"Creation-Date\" content=\"" + this.buildDate() + "\"/>\n" + "<meta name=\"Author\" content=\"" + System.getProperty("user.name") + "\"/>\n" + "<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />\n" + "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"style.css\" />\n" + this.buildScript() + "</head>\n" + "<body>\n" + "<div id=\"mainPage\">\n" + "<div id=\"topPart\">\n" + "<div id=\"BannerContainer\">\n" + "<a href=\"http://eda.amiq.com\" target=\"_new\"><div id=\"AMIQBanner\"></div></a>\n" + "<a href=\"" + xvmWorldHttpAddress + "\" target=\"_new\"><div id=\"" + xvmCSSStyle + "\"></div></a>\n" + "<h1>Project: " + this.fReportInfoProvider.getProjectName() + "</h1>\n" + "<h2>" + reportTitle + "</h2>" + "</div>\n" + "</div>\n";
    }

    private String buildMenu(String pageName) {
        return "<div id=\"leftPart\">\n<div id=\"leftListContainer\">\n<ul id=\"leftList\">\n<li><a " + (pageName.equals("summary") ? "id=\"current\" " : "") + " href=\"index.html\">Summary</a>\n" + "<ul>\n" + "\t<li><a " + (pageName.equals("architecture") ? "id=\"current\" " : "") + "href=\"architecture.html\">Architecture</a></li>\n" + "\t<li><a " + (pageName.equals("checks") ? "id=\"current\" " : "") + "href=\"checks.html\">Checks</a>\n" + "\t<ul>\n" + this.buildChecksMenu(pageName) + "\t</ul>\n" + "\t</li>\n" + "\t<li><a " + (pageName.equals("statistics") ? "id=\"current\" " : "") + "href=\"stats.html\">Statistics</a>\n" + "\t<ul>\n" + this.buildStatsMenu(pageName) + "\t</ul>\n" + "\t</li>\n" + "\t<li><a " + (pageName.equals("legend") ? "id=\"current\" " : "") + "href=\"legend.html\">Legend</a></li>\n" + "</ul>\n" + "</li>\n" + "</ul>\n" + "</div>\n" + "</div>\n" + "<div id=\"rightPart\">\n";
    }

    private String buildSummaryBody() {
        return String.valueOf(this.buildArchitectureSummaryBody()) + this.buildChecksBody() + this.buildStatisticsBody() + this.buildLegendBody();
    }

    private String buildChecksBody() {
        StringBuilder result = new StringBuilder();
        result.append("<p class=\"bt\">Checks</p>\n").append("<p class=\"mt\">\n").append("<table>\n").append("<tr>\n").append("<th>Category</th>\n").append("<th class=\"status\">Status</th>\n").append("<th class=\"enabled\">Enabled</th>\n").append("<th title=\"").append(this.getTooltip(7)).append("\" ").append("class=\"toggleTrigger\" ").append("id=\"cdescriptionTrigger\" ").append("onclick=\"toggleAllDescriptions('cdescription')\">Description</th>\n").append("</tr>\n");
        ArrayList<IOVMComplianceCategory> complianceCategories = this.fReportInfoProvider.getCategories();
        int i = 0;
        for (IOVMComplianceCategory complianceCategory : complianceCategories) {
            if (complianceCategory.getChecks().isEmpty()) continue;
            result.append("<tr>\n");
            result.append("<td class=\"category\"><a href=\"checks").append(++i).append(".html\">").append(complianceCategory.getName()).append("</a></td>\n");
            if (complianceCategory.getNofEnabledChecks() == 0) {
                result.append("<td><div class=\"disabledIcon\" title=\"").append(this.getTooltip(0)).append("\"></div></td>\n");
            } else if (complianceCategory.getNofFailedChecks() > 0 || complianceCategory.getNofFailedManualChecks() > 0 || complianceCategory.getNofNotAppliedManualChecks() > 0) {
                result.append("<td><div class=\"errorIcon\" title=\"").append(this.getTooltip(2)).append("\"></div></td>\n");
            } else {
                result.append("<td><div class=\"passedIcon\" title=\"").append(this.getTooltip(1)).append("\"></div></td>\n");
            }
            result.append("<td><a href=\"checks").append(i).append(".html\">").append(complianceCategory.getNofEnabledChecks()).append(" / ").append(complianceCategory.getNofChecks()).append("</a></td>\n");
            if (complianceCategory.getDescription().length() > 60) {
                result.append("<td id=\"cdescriptionTrigger").append(i).append("\" ").append("class=\"toggleTrigger description\" onclick=\"toggleDescription('cdescription', '").append(i).append("')\"").append("title=\"").append(this.getTooltip(5)).append("\">\n");
                result.append("<div id=\"cdescriptionCollapsed").append(i).append("\">");
                result.append(complianceCategory.getDescription().substring(0, 60)).append("...\n");
                result.append("</div>");
                result.append("<div id=\"cdescriptionExpanded").append(i).append("\" class=\"toggleHidden\">");
                result.append(complianceCategory.getDescription()).append("\n");
                result.append("</div>");
                result.append("</td>");
            } else {
                result.append("<td class=\"description\">\n").append(complianceCategory.getDescription()).append("</td>\n");
            }
            result.append("</tr>\n");
        }
        result.append("</table>\n").append("</p>\n");
        return result.toString();
    }

    private String buildStatisticsBody() {
        StringBuilder result = new StringBuilder();
        result.append("<p class=\"bt\">Statistics</p>\n");
        result.append("<p class=\"mt\">\n");
        result.append("<table>\n");
        result.append("<tr>\n");
        result.append("<th>Category</th>\n");
        result.append("<th>Enabled</th>\n");
        result.append("<th title=\"").append(this.getTooltip(7)).append("\" ").append("class=\"toggleTrigger\" ").append("id=\"sdescriptionTrigger\" ").append("onclick=\"toggleAllDescriptions('sdescription')\">Description</th>\n");
        result.append("</tr>\n");
        ArrayList<IOVMComplianceCategory> complianceCategories = this.fReportInfoProvider.getCategories();
        int i = 0;
        for (IOVMComplianceCategory complianceCategory : complianceCategories) {
            if (complianceCategory.getStatistics().isEmpty()) continue;
            result.append("<tr>\n").append("<td class=\"category\"><a href=\"stats").append(++i).append(".html\" ").append(" title=\"").append(complianceCategory.getDescription()).append("\">").append(complianceCategory.getName()).append("</a></td>\n");
            result.append("<td class=\"enabled\"><a href=\"stats").append(i).append(".html\">").append(complianceCategory.getNofEnabledStatistics()).append("/").append(complianceCategory.getNofStatistics()).append("<a></td>\n");
            if (complianceCategory.getDescription().length() > 60) {
                result.append("<td id=\"sdescriptionTrigger").append(i).append("\" ").append("class=\"toggleTrigger description\" ").append("onclick=\"toggleDescription('sdescription', '").append(i).append("')\" ").append("title=\"").append(this.getTooltip(5)).append("\">\n");
                result.append("<div id=\"sdescriptionCollapsed").append(i).append("\">");
                result.append(complianceCategory.getDescription().substring(0, 60)).append("...\n");
                result.append("</div>");
                result.append("<div id=\"sdescriptionExpanded").append(i).append("\" class=\"toggleHidden\">");
                result.append(complianceCategory.getDescription()).append("\n");
                result.append("</div>");
                result.append("</td>");
            } else {
                result.append("<td class=\"description\">\n").append(complianceCategory.getDescription()).append("</td>\n");
            }
            result.append("</tr>\n");
        }
        result.append("</table>\n").append("</p>\n");
        return result.toString();
    }

    private String buildChecksCategoryBody(IOVMComplianceCategory checkCategory) {
        StringBuilder result = new StringBuilder();
        result.append("<p class=\"bt\">").append(checkCategory.getName()).append(" Checks </p>\n");
        result.append("<p class=\"mt\">\n");
        result.append(checkCategory.getDescription());
        result.append("</p>\n");
        result.append("<p class=\"mt\">\n");
        result.append("<table>\n");
        result.append("<tr>\n");
        result.append("<th>ID</th>\n");
        result.append("<th class=\"status\">Status</th>\n");
        result.append("<th title=\"").append(this.getTooltip(7)).append("\" ").append("class=\"toggleTrigger passed\" ").append("id=\"detailsTrigger\" ").append("onclick=\"toggleAllDetails()\">Passed</th>\n");
        result.append("<th title=\"").append(this.getTooltip(7)).append("\" ").append("class=\"toggleTrigger\" ").append("id=\"descriptionTrigger\" ").append("onclick=\"toggleAllDescriptions('description')\">Description</th>\n");
        result.append("</tr>\n");
        ArrayList<IOVMComplianceCheck> checkResults = checkCategory.getChecks();
        int i = 0;
        while (i < checkResults.size()) {
            IOVMComplianceCheck checkInfo = checkResults.get(i);
            if (checkInfo instanceof IOVMComplianceManualCheck) {
                result.append(this.getManualCheckInfoReport((IOVMComplianceManualCheck)checkInfo, i + 1));
            } else {
                result.append(this.getCheckInfoReport(checkInfo, i + 1));
            }
            ++i;
        }
        result.append("</table>\n").append("</p>\n");
        return result.toString();
    }

    private String getManualCheckInfoReport(IOVMComplianceManualCheck checkInfo, int index) {
        String result = "<tr>";
        result = String.valueOf(result) + "<td class=\"checkID\">" + checkInfo.getUserId(true) + "</td>\n";
        result = !checkInfo.isEnabled() ? String.valueOf(result) + "<td><div class=\"disabledIcon\" title=\"" + this.getTooltip(0) + "\"></div></td>\n" : (checkInfo.getStatus() == 2 ? String.valueOf(result) + "<td><div class=\"errorIcon\" title=\"" + this.getTooltip(2) + "\"></div></td>\n" : (checkInfo.getStatus() == 0 ? String.valueOf(result) + "<td><div class=\"unknownIcon\" title=\"" + this.getTooltip(9) + "\"></div></td>\n" : (checkInfo.getStatus() == 1 ? String.valueOf(result) + "<td><div class=\"passedIcon\" title=\"" + this.getTooltip(1) + "\"></div></td>\n" : String.valueOf(result) + "<td><div class=\"unknownIcon\" title=\"" + this.getTooltip(9) + "\"></div></td>\n")));
        result = String.valueOf(result) + "<td class=\"enabled\"> Manual </td>\n";
        if (this.cleanupSpecialChars(checkInfo.getDescription()).length() > 60) {
            result = String.valueOf(result) + "<td id=\"descriptionTrigger" + index + "\" " + "class=\"toggleTrigger description\" " + "onclick=\"toggleDescription('description', '" + index + "')\" " + "title=\"" + this.getTooltip(5) + "\">\n";
            result = String.valueOf(result) + "<div id=\"descriptionCollapsed" + index + "\">";
            result = String.valueOf(result) + this.cleanupSpecialChars(checkInfo.getDescription()).substring(0, 60) + "...\n";
            result = String.valueOf(result) + "</div>";
            result = String.valueOf(result) + "<div id=\"descriptionExpanded" + index + "\" class=\"toggleHidden\">";
            result = String.valueOf(result) + this.cleanupSpecialChars(checkInfo.getDescription()) + "\n";
            result = String.valueOf(result) + "</div>";
            result = String.valueOf(result) + "</td>";
        } else {
            result = String.valueOf(result) + "<td class=\"description\">\n" + this.cleanupSpecialChars(checkInfo.getDescription()) + "</td>\n";
        }
        result = String.valueOf(result) + "</tr>\n";
        return result;
    }

    private String getCheckInfoReport(IOVMComplianceCheck checkInfo, int index) {
        StringBuilder result = new StringBuilder("<tr>");
        result.append("<td class=\"checkID\">").append(checkInfo.getUserId(true)).append("</td>\n");
        if (!checkInfo.isEnabled()) {
            result.append("<td><div class=\"disabledIcon\" title=\"").append(this.getTooltip(0)).append("\"></div></td>\n");
        } else if (checkInfo.getNofHits() == 0) {
            result.append("<td><div class=\"unknownIcon\" title=\"").append(this.getTooltip(9)).append("\"></div></td>\n");
        } else if (checkInfo.getNofPassed() == checkInfo.getNofHits()) {
            result.append("<td><div class=\"passedIcon\" title=\"").append(this.getTooltip(1)).append("\"></div></td>\n");
        } else if (checkInfo.getSeverity() == 0) {
            result.append("<td><div class=\"errorIcon\" title=\"").append(this.getTooltip(2)).append("\"></div></td>\n");
        } else if (checkInfo.getSeverity() == 1) {
            result.append("<td><div class=\"warningIcon\" title=\"").append(this.getTooltip(3)).append("\"></div></td>\n");
        } else if (checkInfo.getSeverity() == 2) {
            result.append("<td><div class=\"infoIcon\" title=\"").append(this.getTooltip(0)).append("\"></div></td>\n");
        } else {
            result.append("<td><div class=\"unknownIcon\" title=\"").append(this.getTooltip(9)).append("\"></div></td>\n");
        }
        if (!checkInfo.getHits().isEmpty()) {
            result.append("<td id=\"detailsTrigger").append(index).append("\" ").append("onclick=\"toggleDetails(").append(index).append(")\" ").append("class=\"enabled toggleTrigger\" ").append("title=\"").append(this.getTooltip(5)).append("\">").append(checkInfo.getNofPassed()).append("/").append(checkInfo.getNofHits()).append("</td>\n");
        } else {
            result.append("<td class=\"enabled\">").append(checkInfo.getNofPassed()).append("/").append(checkInfo.getNofHits()).append("</td>\n");
        }
        if (this.cleanupSpecialChars(checkInfo.getDescription()).length() > 60) {
            result.append("<td id=\"descriptionTrigger").append(index).append("\" ").append("class=\"toggleTrigger description\" ").append("onclick=\"toggleDescription('description', '").append(index).append("')\" ").append("title=\"").append(this.getTooltip(5)).append("\">\n");
            result.append("<div id=\"descriptionCollapsed").append(index).append("\">");
            result.append(this.cleanupSpecialChars(checkInfo.getDescription()).substring(0, 60)).append("...\n");
            result.append("</div>");
            result.append("<div id=\"descriptionExpanded").append(index).append("\" class=\"toggleHidden\">");
            result.append(this.cleanupSpecialChars(checkInfo.getDescription())).append("\n");
            result.append("</div>");
            result.append("</td>");
        } else {
            result.append("<td class=\"description\">\n").append(this.cleanupSpecialChars(checkInfo.getDescription())).append("</td>\n");
        }
        result.append("</tr>\n");
        if (!checkInfo.getHits().isEmpty()) {
            result.append("<tr class=\"toggleHidden\" title=\"").append(this.getTooltip(5)).append("\" id=\"details").append(index).append("\">\n");
            result.append("<td><b>Details:</b></td>\n");
            result.append("<td colspan=\"3\">");
            for (IOVMComplianceCheckHit checkHit : checkInfo.getHits()) {
                if (checkHit.isFailure()) {
                    if (!checkInfo.isEnabled()) {
                        result.append("<div class=\"disabledSmallIcon\" title=\"").append(this.getTooltip(0)).append("\">\n");
                    } else if (checkInfo.getNofHits() == 0) {
                        result.append("<div class=\"unknownSmallIcon\" title=\"").append(this.getTooltip(9)).append("\">\n");
                    } else if (checkInfo.getSeverity() == 0) {
                        result.append("<div class=\"errorSmallIcon\" title=\"").append(this.getTooltip(2)).append("\">\n");
                    } else if (checkInfo.getSeverity() == 1) {
                        result.append("<div class=\"warningSmallIcon\" title=\"").append(this.getTooltip(3)).append("\">\n");
                    } else if (checkInfo.getSeverity() == 2) {
                        result.append("<div class=\"infoSmallIcon\" title=\"").append(this.getTooltip(4)).append("\">\n");
                    } else {
                        result.append("<div class=\"unknownSmallIcon\" title=\"").append(this.getTooltip(9)).append("\">\n");
                    }
                } else {
                    result.append("<div class=\"passedSmallIcon\" title=\"").append(this.getTooltip(1)).append("\">\n");
                }
                File f = new File(checkHit.getFile());
                String canonicalPath = "";
                boolean detailsAbsent = checkHit.getDetails() == null || "".equals(checkHit.getDetails());
                try {
                    canonicalPath = f.getCanonicalPath();
                    result.append("<a href=\"").append(canonicalPath).append("?line=").append(checkHit.getLine()).append("\" ").append("target=\"_new\" ").append("title=\"").append(checkHit.getFile()).append("\">").append(" at line ").append(checkHit.getLine()).append(" in ").append(f.getName()).append(detailsAbsent ? "" : " - " + checkHit.getDetails()).append("</div>\n");
                }
                catch (IOException iOException) {
                    result.append("<a \"title=\"").append(checkHit.getFile()).append("\">").append(" at line ").append(checkHit.getLine()).append(" in ").append(f.getName()).append(detailsAbsent ? "" : " - " + checkHit.getDetails()).append("</a></div>\n");
                }
            }
            result.append("</td>\n");
            result.append("</tr>");
        }
        return result.toString();
    }

    private String buildStatsCategoryBody(IOVMComplianceCategory category) {
        StringBuilder result = new StringBuilder();
        result.append("<p class=\"bt\">").append(category.getName()).append(" Statistics</p>\n");
        result.append("<p class=\"mt\">\n");
        result.append(category.getDescription());
        result.append("</p>\n");
        result.append("<p class=\"mt\">\n");
        result.append("<table>");
        result.append("<tr>");
        result.append("<th>ID</th>");
        result.append("<th title=\"").append(this.getTooltip(7)).append("\" ").append("class=\"toggleTrigger\" ").append("id=\"detailsTrigger\" onclick=\"toggleAllDetails()\">Hits</th>");
        result.append("<th title=\"").append(this.getTooltip(7)).append("\" ").append("class=\"toggleTrigger\" ").append("id=\"descriptionTrigger\" ").append("onclick=\"toggleAllDescriptions('description')\">Description</th>");
        result.append("</tr>");
        ArrayList<IOVMComplianceStatistic> statisticsResults = category.getStatistics();
        int i = 0;
        for (IOVMComplianceStatistic statisticInfo : statisticsResults) {
            ++i;
            result.append("<tr>\n");
            result.append("<td class=\"checkID\">").append(statisticInfo.getUserId(true)).append("</td>\n");
            if (!statisticInfo.isEnabled()) {
                result.append("<td class=\"hits\"><div class=\"disabledIcon\"  title=\"").append(this.getTooltip(0)).append("\"></div></td>\n");
            } else if (!statisticInfo.getHits().isEmpty()) {
                result.append("<td id=\"detailsTrigger").append(i).append("\" ").append("onclick=\"toggleDetails(").append(i).append(")\" ").append("class=\"toggleTrigger hits\"  ").append("title=\"").append(this.getTooltip(5)).append("\">").append(statisticInfo.getNofHits()).append("</td>\n");
            } else {
                result.append("<td class=\"hits\">0</td>\n");
            }
            if (statisticInfo.getDescription().length() > 60) {
                result.append("<td id=\"descriptionTrigger").append(i).append("\" ").append("class=\"toggleTrigger description\" ").append("onclick=\"toggleDescription('description', '").append(i).append("')\" ").append("title=\"").append(this.getTooltip(5)).append("\">\n");
                result.append("<div id=\"descriptionCollapsed").append(i).append("\">");
                result.append(statisticInfo.getDescription().substring(0, 60)).append("...\n");
                result.append("</div>");
                result.append("<div id=\"descriptionExpanded").append(i).append("\" class=\"toggleHidden\">");
                result.append(statisticInfo.getDescription()).append("\n");
                result.append("</div>");
                result.append("</td>");
            } else {
                result.append("<td>\n").append(statisticInfo.getDescription()).append("</td>\n");
            }
            result.append("</tr>\n");
            if (statisticInfo.getNofHits() == 0) continue;
            result.append("<tr class=\"toggleHidden\" id=\"details").append(i).append("\">\n");
            result.append("<td><b>Details:</b></td>\n");
            result.append("<td colspan=\"2\">");
            for (IOVMComplianceStatisticHit checkHit : statisticInfo.getHits()) {
                File f = new File(checkHit.getFile());
                String canonicalPath = "";
                boolean detailsAbsent = checkHit.getDetails() == null || "".equals(checkHit.getDetails());
                try {
                    canonicalPath = f.getCanonicalPath();
                    result.append("<div class=\"hitSmallIcon\">");
                    result.append("<a href=\"").append(canonicalPath).append("?line=").append(checkHit.getLine()).append("\" target=\"_new\" ").append("title=\"").append(checkHit.getFile()).append("\">").append(" at line ").append(checkHit.getLine()).append(" in ").append(f.getName()).append(detailsAbsent ? "" : " - " + checkHit.getDetails()).append("</div>\n");
                }
                catch (IOException iOException) {
                    result.append("<div class=\"hitSmallIcon\"><a \"title=\"").append(checkHit.getFile()).append("\">").append(" at line ").append(checkHit.getLine()).append(" in ").append(f.getName()).append(" - ").append(detailsAbsent ? "" : " - " + checkHit.getDetails()).append("</a></div>\n");
                }
            }
            result.append("</td>\n");
            result.append("</tr>");
        }
        result.append("</p>\n").append("</table>\n");
        return result.toString();
    }

    private String buildArchitectureSummaryBody() {
        StringBuilder result = new StringBuilder();
        result.append("<p class=\"bt\">Architecture</p>\n");
        result.append("<p class=\"mt\">\n");
        result.append("<table>\n");
        result.append("<tr>\n");
        result.append("<th class=\"category\">Category</th>\n");
        result.append("<th>Name</th>\n");
        result.append("</tr>\n");
        ArrayList<IOVMComponentCategory> componentCats = this.getOVMComponentCategories();
        for (IOVMComponentCategory componentCategory : componentCats) {
            ArrayList<IOVMComponent> components = componentCategory.getComponents();
            result.append("<tr>\n");
            result.append("<td class=\"category\"> ").append(componentCategory.getName()).append("</td>\n");
            result.append("<td>");
            for (IOVMComponent component : components) {
                result.append(component.getName()).append(", ");
            }
            if (result.charAt(result.length() - 2) == ',' && result.charAt(result.length() - 1) == ' ') {
                result.delete(result.length() - 2, result.length());
            }
            result.append("</td></tr>");
        }
        result.append("</table>");
        return result.toString();
    }

    private String buildArchitectureBody() {
        StringBuilder result = new StringBuilder();
        result.append("<p class=\"bt\">Architecture</p>\n");
        result.append("<p class=\"mt\">\n");
        result.append("<table>\n");
        result.append("<tr>\n");
        result.append("<th class=\"category\">Category</th>\n");
        result.append("<th class=\"className\">Name</th>\n");
        result.append("<th title=\"").append(this.getTooltip(7)).append("\" ").append("class=\"toggleTrigger\" ").append("id=\"adescriptionTrigger\" ").append("onclick=\"toggleAllDescriptions('adescription')\">Comment</th>\n");
        result.append("</tr>\n");
        ArrayList<IOVMComponentCategory> componentCats = this.getOVMComponentCategories();
        int i = 0;
        for (IOVMComponentCategory componentCategory : componentCats) {
            ArrayList<IOVMComponent> components = componentCategory.getComponents();
            ++i;
            boolean firstRow = true;
            for (IOVMComponent component : components) {
                ++i;
                result.append("<tr>\n");
                if (firstRow) {
                    result.append("<td class=\"category\" ").append("rowspan=\"").append(components.size()).append("\"> ").append(componentCategory.getName()).append("</td>\n");
                    firstRow = false;
                }
                result.append("<td>").append(component.getName()).append("</td>\n");
                if (component.getComment().length() > 60) {
                    result.append("<td id=\"adescriptionTrigger").append(i).append("\" ").append("class=\"toggleTrigger description\" ").append("onclick=\"toggleDescription('adescription', '").append(i).append("')\" ").append("title=\"").append(this.getTooltip(5)).append("\">\n");
                    result.append("<div id=\"adescriptionCollapsed").append(i).append("\">");
                    result.append(component.getComment().substring(0, 60)).append("...\n");
                    result.append("</div>");
                    result.append("<div id=\"adescriptionExpanded").append(i).append("\" class=\"toggleHidden\">");
                    result.append(component.getComment()).append("\n");
                    result.append("</div>");
                    result.append("</td>");
                } else {
                    result.append("<td>\n").append(component.getComment()).append("</td>\n");
                }
                result.append("</tr>\n");
            }
        }
        result.append("</table>\n");
        result.append("</p>\n");
        return result.toString();
    }

    private String buildLegendBody() {
        StringBuilder result = new StringBuilder();
        result.append("<p class=\"bt\">Legend</p>\n");
        result.append("<p class=\"mt\">\n");
        result.append("<table>\n");
        result.append("<tr>\n");
        result.append("<th width=\"25\">Icon</th>\n");
        result.append("<th width=\"50\">Meaning</th>\n");
        result.append("<th>Description</th>\n");
        result.append("</tr>\n");
        result.append(this.buildLegendRow(2, "Indicates that at least an error has occurred. "));
        result.append(this.buildLegendRow(3, "Indicates that at least a warning has occurred."));
        result.append(this.buildLegendRow(4, "Indicates that at least an info message has been issued."));
        result.append(this.buildLegendRow(1, "Indicates that everything is fine."));
        result.append(this.buildLegendRow(0, "Indicates disabled checks."));
        result.append(this.buildLegendRow(9, "Indicates that check was not triggered (for example no monitors in the environment)."));
        result.append("</table>\n");
        result.append("</p>\n");
        return result.toString();
    }

    private String buildLegendRow(int iconId, String description) {
        StringBuilder result = new StringBuilder();
        result.append("<tr>\n");
        result.append("<td><div class=\"").append(this.getIconClass(iconId)).append("\" title=\"").append(this.getTooltip(iconId)).append("\"></td>\n");
        result.append("<td>").append(this.getTooltip(iconId)).append("</td>\n");
        result.append("<td>").append(description).append("</td>\n");
        result.append("</tr>\n");
        return result.toString();
    }

    private String buildChecksMenu(String pageName) {
        StringBuilder result = new StringBuilder();
        ArrayList<IOVMComplianceCategory> complianceCategories = this.fReportInfoProvider.getCategories();
        int i = 0;
        for (IOVMComplianceCategory complianceCategory : complianceCategories) {
            if (complianceCategory.getChecks().isEmpty()) continue;
            result.append("\t\t<li><a ").append(pageName.equals("checks" + ++i) ? "id=\"current\" " : "").append("href=\"checks").append(i).append(".html\">").append(complianceCategory.getName()).append("</a></li>\n");
        }
        return result.toString();
    }

    private String buildStatsMenu(String pageName) {
        StringBuilder result = new StringBuilder();
        ArrayList<IOVMComplianceCategory> complianceCategories = this.fReportInfoProvider.getCategories();
        int i = 0;
        for (IOVMComplianceCategory complianceCategory : complianceCategories) {
            if (complianceCategory.getStatistics().isEmpty()) continue;
            result.append("\t\t<li><a ").append(pageName.equals("statistics" + ++i) ? "id=\"current\" " : "").append("href=\"stats").append(i).append(".html\">").append(complianceCategory.getName()).append("</a></li>\n");
        }
        return result.toString();
    }

    private String buildDate() {
        return Calendar.getInstance().getTime().toString();
    }

    private String buildScript() {
        return "<script>\nvar browser=navigator.appName;\nvar tableRowDisplay='table-row'\nif (browser.indexOf(\"Microsoft\") >= 0) {\n\ttableRowDisplay='inline'\n}\n\nfunction toggleDescription(id, index) {\n\tvar trigger = document.getElementById(id + 'Trigger' + index);\n\tvar expandedStyle = document.getElementById(id + 'Expanded' + index).style;\n\tvar collapsedStyle = document.getElementById(id + 'Collapsed' + index).style;\n\tif (expandedStyle.display == 'block') {\n\t\ttrigger.title = '" + this.getTooltip(5) + "';\n" + "\t\ttrigger.style.backgroundImage = 'url(more.jpg)';\n" + "\t\texpandedStyle.display = 'none';\n" + "\t\tcollapsedStyle.display = 'block';\n" + "\t} else {\n" + "\t\ttrigger.title = '" + this.getTooltip(6) + "';\n" + "\t\ttrigger.style.backgroundImage = 'url(less.jpg)';\n" + "\t\texpandedStyle.display = 'block';\n" + "\t\tcollapsedStyle.display = 'none';\n" + "\t} \n" + "} \n" + "function toggleAllDescriptions(id) {\n" + "\tvar trigger = document.getElementById(id + 'Trigger');\n" + "\tif(trigger.title != '" + this.getTooltip(8) + "') {\n" + "\t\ttrigger.title = '" + this.getTooltip(8) + "';\n" + "\t\ttrigger.style.backgroundImage = 'url(less.jpg)';\n" + "\t\tfor(var index=0;index<100;index++) {\n;" + "\t\t\tif(document.getElementById(id + 'Expanded' + index)) {\n" + "\t\t\t\tvar trigger = document.getElementById(id + 'Trigger' + index);\n" + "\t\t\t\tvar expandedStyle = document.getElementById(id + 'Expanded' + index).style;\n" + "\t\t\t\tvar collapsedStyle = document.getElementById(id + 'Collapsed' + index).style;\n" + "\t\t\t\ttrigger.title = '" + this.getTooltip(6) + "';\n" + "\t\t\t\ttrigger.style.backgroundImage = 'url(less.jpg)';\n" + "\t\t\t\texpandedStyle.display = 'block';\n" + "\t\t\t\tcollapsedStyle.display = 'none';\n" + "\t\t\t} \n" + "\t\t} \n" + "\t} else {\n" + "\t\ttrigger.title = '" + this.getTooltip(7) + "';\n" + "\t\ttrigger.style.backgroundImage = 'url(more.jpg)';\n" + "\t\tfor(var index=0;index<100;index++) {" + "\t\t\tif(document.getElementById(id + 'Expanded' + index)) {\n" + "\t\t\t\tvar trigger = document.getElementById(id + 'Trigger' + index);\n" + "\t\t\t\tvar expandedStyle = document.getElementById(id + 'Expanded' + index).style;\n" + "\t\t\t\tvar collapsedStyle = document.getElementById(id + 'Collapsed' + index).style;\n" + "\t\t\t\ttrigger.title = '" + this.getTooltip(5) + "';\n" + "\t\t\t\ttrigger.style.backgroundImage = 'url(more.jpg)';\n" + "\t\t\t\texpandedStyle.display = 'none';\n" + "\t\t\t\tcollapsedStyle.display = 'block';\n" + "\t\t\t} \n" + "\t\t} \n" + "\t}\n" + "}\n" + "function toggleDetails(id) {\n" + "\tvar detailsTrigger = document.getElementById('detailsTrigger'+id); \n" + "\tvar details = document.getElementById('details'+id); \n" + "\tvar notes = document.getElementById('notes'+id); \n" + "   if (details != null) { \n" + "       var rowStyle = details.style; \n" + "       if (rowStyle.display != tableRowDisplay) { \n" + "\t\t    rowStyle.display=tableRowDisplay; \n" + "\t\t    detailsTrigger.style.backgroundImage = 'url(less.jpg)'; \n" + "\t\t    detailsTrigger.title = '" + this.getTooltip(6) + "'; \n" + "\t    } else { \n" + "\t\t    rowStyle.display = 'none'; \n" + "\t\t    detailsTrigger.style.backgroundImage = 'url(more.jpg)'; \n" + "\t\t    detailsTrigger.title = '" + this.getTooltip(5) + "'; \n" + "\t    } \n" + "\t} \n" + "   if (notes != null) { \n" + "       var rowNotesStyle = notes.style; \n" + "   \tif (rowNotesStyle.display != tableRowDisplay) { \n" + "\t\t\trowNotesStyle.display=tableRowDisplay; \n" + "\t\t\tdetailsTrigger.style.backgroundImage = 'url(less.jpg)'; \n" + "\t\t\tdetailsTrigger.title = '" + this.getTooltip(6) + "'; \n" + "\t\t} else { \n" + "\t\t\trowNotesStyle.display = 'none'; \n" + "\t\t\tdetailsTrigger.style.backgroundImage = 'url(more.jpg)'; \n" + "\t\t\tdetailsTrigger.title = '" + this.getTooltip(5) + "'; \n" + "\t\t} \n" + "\t} \n" + "} \n" + "function toggleAllDetails() {\n" + "\tvar detailsTrigger = document.getElementById('detailsTrigger'); \n" + "   if (detailsTrigger.title != '" + this.getTooltip(8) + "') { \n" + "\t\tdetailsTrigger.style.backgroundImage = 'url(less.jpg)'; \n" + "\t\tdetailsTrigger.title = '" + this.getTooltip(8) + "'; \n" + "\t\tfor(var index=0;index<100;index++) {\n" + "\t\t\tif(document.getElementById('detailsTrigger' + index)) {\n" + "\t\t\t\tvar detailsTrigger = document.getElementById('detailsTrigger' + index);\n" + "\t\t\t\tvar details =  document.getElementById('details'+index); \n" + "               if (details != null) { \n" + "\t\t\t\t\tvar rowStyle = details.style; \n" + "\t\t\t\t\tdetailsTrigger.style.backgroundImage = 'url(less.jpg)'; \n" + "\t\t\t\t\tdetailsTrigger.title = '" + this.getTooltip(6) + "'; \n" + "\t\t\t\t\trowStyle.display=tableRowDisplay; \n" + "\t\t\t\t} \n" + "\t\t\t\tvar notes =  document.getElementById('notes'+index); \n" + "               if (notes != null) { \n" + "\t\t\t\t\tvar rowStyle = notes.style; \n" + "\t\t\t\t\tdetailsTrigger.style.backgroundImage = 'url(less.jpg)'; \n" + "\t\t\t\t\tdetailsTrigger.title = '" + this.getTooltip(6) + "'; \n" + "\t\t\t\t\trowStyle.display=tableRowDisplay; \n" + "\t\t\t\t} \n" + "\t\t\t} \n" + "\t\t} \n" + "\t} else { \n" + "\t\tdetailsTrigger.style.backgroundImage = 'url(more.jpg)'; \n" + "\t\tdetailsTrigger.title = '" + this.getTooltip(7) + "'; \n" + "\t\tfor(var index=0;index<100;index++) {\n" + "\t\t\tif(document.getElementById('detailsTrigger' + index)) {\n" + "\t\t\t\tvar detailsTrigger = document.getElementById('detailsTrigger' + index);\n" + "\t\t\t\tvar details =  document.getElementById('details'+index); \n" + "               if (details != null) { \n" + "\t\t\t\t\tvar rowStyle = details.style; \n" + "\t\t\t\t\tdetailsTrigger.style.backgroundImage = 'url(more.jpg)'; \n" + "\t\t\t\t\tdetailsTrigger.title = '" + this.getTooltip(5) + "'; \n" + "\t\t\t\t\trowStyle.display='none'; \n" + "\t\t\t\t} \n" + "\t\t\t\tvar notes =  document.getElementById('notes'+index); \n" + "               if (notes != null) { \n" + "\t\t\t\t\tvar rowStyle = notes.style; \n" + "\t\t\t\t\tdetailsTrigger.style.backgroundImage = 'url(more.jpg)'; \n" + "\t\t\t\t\tdetailsTrigger.title = '" + this.getTooltip(5) + "'; \n" + "\t\t\t\t\trowStyle.display='none'; \n" + "\t\t\t\t} \n" + "\t\t\t} \n" + "\t\t} \n" + "\t} \n" + "} \n" + "</script>";
    }

    private String buildFooter() {
        return "</div>\n<div id=\"bottomPart\">\n<p>Generated by <b>" + System.getProperty("user.name") + "</b> " + "on " + this.buildDate() + " " + "using <a href=\"http://eda.amiq.com/\" target=\"_new\">DVT " + (String)DVTPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version") + " Eclipse Plugin</a>, " + "\u24d2 <a href=\"http://www.amiq.ro\" target=\"_new\">AMIQ</a></p>\n" + "</div>\n" + "</div>\n" + "</body>\n" + "</html>\n";
    }

    private String getTooltip(int iconId) {
        switch (iconId) {
            case 0: {
                return "Disabled";
            }
            case 1: {
                return "Passed";
            }
            case 2: {
                return "Error";
            }
            case 3: {
                return "Warning";
            }
            case 4: {
                return "Info";
            }
            case 9: {
                return "Not Applied";
            }
            case 5: {
                return "Expand";
            }
            case 6: {
                return "Collapse";
            }
            case 7: {
                return "Expand all";
            }
            case 8: {
                return "Collapse all";
            }
        }
        return "";
    }

    private String getIconClass(int iconId) {
        switch (iconId) {
            case 0: {
                return "disabledIcon";
            }
            case 1: {
                return "passedIcon";
            }
            case 2: {
                return "errorIcon";
            }
            case 3: {
                return "warningIcon";
            }
            case 4: {
                return "infoIcon";
            }
            case 9: {
                return "unknownIcon";
            }
        }
        return "";
    }

    private void popUp(final String title, final String content, final String note) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                new PopupMessage(title, content, note).open();
            }
        });
    }

    public ArrayList<IOVMComponentCategory> getOVMComponentCategories() {
        return this.fOVMComponentCategories;
    }

    private void buildArchitectureData() {
        OVMProject ovmp = this.fReportInfoProvider.getOVMProject();
        this.fOVMComponentCategories = new ArrayList();
        Set<String> catNames = ovmp.getCategories().keySet();
        for (String catName : catNames) {
            OVMComponentCategory cat = new OVMComponentCategory(catName);
            List<RfStruct> components = ovmp.getCategories().get(catName);
            for (RfStruct struct : components) {
                cat.addComponent(new OVMComponent(struct.getName(), struct.getComment()));
            }
            this.fOVMComponentCategories.add(cat);
        }
    }

    public String cleanupSpecialChars(String comment) {
        comment = comment.replace(">", "&gt;");
        comment = comment.replace("<", "&lt;");
        return comment;
    }

    static class PopupMessage
    extends MessageDialog {
        private String fNote;

        public PopupMessage(String title, String content, String note) {
            super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, content, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.fNote = note;
        }

        protected Control createCustomArea(Composite parent) {
            if (this.fNote != null) {
                Text text = new Text(parent, 4);
                DVTColorUtil.INSTANCE.setBackground((Control)text, parent.getBackground(), true);
                text.setText(this.fNote);
                return text;
            }
            return null;
        }
    }
}

