/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance.ui;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheckHit;
import ro.amiq.edt.ovmcompliance.IOVMComplianceManualCheck;

public class OVMComplianceChecksUtil {
    public static final int OTHER = 0;
    public static final int PASSED = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    public static final int INFO = 4;
    public static final int NOT_APPLIED = 5;
    public static final int DISABLED = 6;

    public static int getStatus(Object element) {
        if (element instanceof IOVMComplianceCategory) {
            IOVMComplianceCategory tmpElement = (IOVMComplianceCategory)element;
            if (tmpElement.getNofEnabledChecks() == 0) {
                return 6;
            }
            if (tmpElement.getNofFailedChecks() + tmpElement.getNofFailedManualChecks() + tmpElement.getNofNotAppliedManualChecks() > 0) {
                return 2;
            }
            return 1;
        }
        if (element instanceof IOVMComplianceManualCheck) {
            IOVMComplianceManualCheck tmpElement = (IOVMComplianceManualCheck)element;
            if (!tmpElement.isEnabled()) {
                return 6;
            }
            if (tmpElement.getStatus() == 0) {
                return 5;
            }
            if (tmpElement.getStatus() == 1) {
                return 1;
            }
            if (tmpElement.getStatus() == 2) {
                return 2;
            }
        } else {
            if (element instanceof IOVMComplianceCheck) {
                IOVMComplianceCheck tmpElement = (IOVMComplianceCheck)element;
                if (!tmpElement.isEnabled()) {
                    return 6;
                }
                if (tmpElement.getNofHits() == 0) {
                    return 5;
                }
                if (tmpElement.getNofPassed() == tmpElement.getNofHits()) {
                    return 1;
                }
                if (tmpElement.getSeverity() == 0) {
                    return 2;
                }
                if (tmpElement.getSeverity() == 1) {
                    return 3;
                }
                if (tmpElement.getSeverity() == 2) {
                    return 4;
                }
                return 5;
            }
            if (element instanceof IOVMComplianceCheckHit) {
                IOVMComplianceCheckHit tmpElement = (IOVMComplianceCheckHit)element;
                if (tmpElement.isFailure()) {
                    return OVMComplianceChecksUtil.getStatus(tmpElement.getCheck());
                }
                return 1;
            }
        }
        return 0;
    }

    public static Image getImage(Object element) {
        if (element instanceof String && ((String)element).equals("Summary")) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_SUMMARY);
        }
        int status = OVMComplianceChecksUtil.getStatus(element);
        if (status == 1) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_PASSED);
        }
        if (status == 2) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_ERROR);
        }
        if (status == 3) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_WARNING);
        }
        if (status == 4) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_INFO);
        }
        if (status == 5) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_NOT_APPLIED);
        }
        if (status == 6) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_DISABLED);
        }
        return null;
    }

    public static String getTreeText(Object element) {
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof IOVMComplianceCategory) {
            return ((IOVMComplianceCategory)element).getName();
        }
        if (element instanceof IOVMComplianceManualCheck) {
            return String.valueOf(((IOVMComplianceManualCheck)element).getUserId(true)) + " [Manual]";
        }
        if (element instanceof IOVMComplianceCheck) {
            IOVMComplianceCheck tmpElement = (IOVMComplianceCheck)element;
            return String.valueOf(tmpElement.getUserId(true)) + " [" + Integer.toString(tmpElement.getNofPassed()) + "/" + Integer.toString(tmpElement.getNofHits()) + "]";
        }
        return "???";
    }

    public static String getDetailsText(Object element) {
        int status = OVMComplianceChecksUtil.getStatus(element);
        if (status == 1) {
            return "PASSED";
        }
        if (status == 2) {
            return "ERROR";
        }
        if (status == 3) {
            return "WARNING";
        }
        if (status == 4) {
            return "INFO";
        }
        if (status == 5) {
            return "NOT_APPLIED";
        }
        if (status == 6) {
            return "DISABLED";
        }
        return "???";
    }
}

