/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.model.IDVTReparseListener;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.ui.preferences.PrefConst;
import ro.amiq.edt.core.EDTPlugin;
import ro.amiq.edt.model.EModelManager;
import ro.amiq.edt.model.reflection.RfManager;
import ro.amiq.edt.ovmcompliance.IReportInfoProvider;
import ro.amiq.edt.ovmcompliance.OVMComplianceBuilder;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.OVMReportInfoProvider;
import ro.amiq.edt.ovmcompliance.ui.ArchitectureDoublePanel;
import ro.amiq.edt.ovmcompliance.ui.ArchitectureModel;
import ro.amiq.edt.ovmcompliance.ui.ChecksTreeBrowser;
import ro.amiq.edt.ovmcompliance.ui.FontFactory;
import ro.amiq.edt.ovmcompliance.ui.HTMLReportGenerator;
import ro.amiq.edt.ovmcompliance.ui.IArchitectureChangedListener;
import ro.amiq.edt.ovmcompliance.ui.IReportUpdateListener;
import ro.amiq.edt.ovmcompliance.ui.Messages;
import ro.amiq.edt.ovmcompliance.ui.OVMComplianceReportInput;
import ro.amiq.edt.ovmcompliance.ui.StatisticsTreeBrowser;

public class OVMComplianceReport
extends EditorPart
implements IArchitectureChangedListener,
IDVTReparseListener,
IResourceChangeListener,
ISelectionProvider {
    private IProject fProject;
    private IReportInfoProvider fOVMInfoProvider;
    private ArchitectureModel fArchitectureModel;
    private ArrayList<IReportUpdateListener> fReportUpdateListeners;
    private FontFactory fFontFactory;
    private Label fDate;
    private Text fStatusBar;
    private Group fTopBar;
    private TabFolder fTabFolder;
    private Color fBackgroundColor;
    private Color fInfoBackgroundColor;
    private ChecksTreeBrowser fChecksTreeBrowser;
    private StatisticsTreeBrowser fStatisticsTreeBrowser;
    List<ISelectionChangedListener> fSelectionListeners = new ArrayList<ISelectionChangedListener>();

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fBackgroundColor = DVTColorUtil.INSTANCE.getColor(PrefConst.getVerissimoBackgroundColor((AbstractUIPlugin)EDTPlugin.getDefault()));
        this.fInfoBackgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.addResourceChangeListener((IResourceChangeListener)this);
        }
        if (input instanceof OVMComplianceReportInput) {
            this.fReportUpdateListeners = new ArrayList();
            this.fProject = ((OVMComplianceReportInput)input).getProject();
            this.setPartName(((OVMComplianceReportInput)input).getName());
            EModelManager.getInstance().addReparseListener(this);
            OVMProject ovmProject = OVMComplianceBuilder.getInstance().initializeOVMProject(this.fProject, ((OVMComplianceReportInput)input).getXVMMode());
            this.fArchitectureModel = new ArchitectureModel(ovmProject, this.fProject);
            this.fOVMInfoProvider = new OVMReportInfoProvider(ovmProject);
            this.fArchitectureModel.updateOVMProject(false);
            OVMComplianceBuilder.getInstance().build(ovmProject);
        }
        site.setSelectionProvider((ISelectionProvider)this);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        DVTColorUtil.INSTANCE.setBackground((Control)parent, this.fBackgroundColor);
        if (this.fArchitectureModel == null) {
            Label label = new Label(parent, 0);
            DVTColorUtil.INSTANCE.setForeground((Control)label, PlatformUI.getWorkbench().getDisplay().getSystemColor(3));
            DVTColorUtil.INSTANCE.setBackground((Control)label, DVTColorUtil.INSTANCE.getBackground((Control)label.getParent()));
            label.setText("The Compliance Review editor can only be invoked by the compliance review flow!");
            return;
        }
        this.fFontFactory = new FontFactory(parent.getDisplay());
        this.fTopBar = new Group(parent, 0);
        this.fTopBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fTopBar, this.fBackgroundColor);
        this.createTopBar((Composite)this.fTopBar);
        this.fTabFolder = new TabFolder(parent, 1024);
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fTabFolder, this.fBackgroundColor);
        this.createTabs();
    }

    void createTopBar(final Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        this.fDate = new Label(parent, 0x1000040);
        this.fDate.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        SimpleDateFormat dateFormat = new SimpleDateFormat(Messages.OVMComplianceReport_Top_Bar_Date_Format);
        this.fDate.setText(dateFormat.format(new Date()));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fDate, this.fBackgroundColor, true);
        this.fStatusBar = new Text(parent, 2056);
        this.fStatusBar.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fBackgroundColor, true);
        Button applyButton = new Button(parent, 8);
        applyButton.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        applyButton.setText(Messages.OVMComplianceReport_Top_Bar_Refresh_Button);
        applyButton.setToolTipText(Messages.OVMComplianceReport_Top_Bar_Refresh_Button_TT);
        applyButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_REPORT_REFRESH));
        DVTColorUtil.INSTANCE.setBackground((Control)applyButton, this.fBackgroundColor, true);
        applyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OVMComplianceReport.this.buildReportAction(parent.getShell());
            }
        });
    }

    private void createTabs() {
        this.createMainTab(this.fTabFolder);
        this.createArchitectureTab(this.fTabFolder);
        this.createChecksTab(this.fTabFolder);
        this.createStatisticsTab(this.fTabFolder);
    }

    private void createMainTab(TabFolder tabFolder) {
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new FillLayout());
        DVTColorUtil.INSTANCE.setBackground((Control)tabComposite, this.fBackgroundColor);
        final ScrolledComposite scrolledComposite = new ScrolledComposite(tabComposite, 512);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        DVTColorUtil.INSTANCE.setBackground((Control)scrolledComposite, this.fBackgroundColor);
        final Composite centerComposite = new Composite((Composite)scrolledComposite, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)centerComposite, this.fBackgroundColor);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 30;
        gl.marginHeight = 40;
        gl.marginWidth = 40;
        centerComposite.setLayout((Layout)gl);
        Button button1 = new Button(centerComposite, 8);
        button1.setToolTipText(Messages.OVMComplianceReport_Main_Page_Architecture_Big_Button_TT);
        button1.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        button1.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_ARCHITECTURE_BUTTON));
        DVTColorUtil.INSTANCE.setBackground((Control)button1, this.fBackgroundColor);
        button1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OVMComplianceReport.this.fTabFolder.setSelection(1);
            }
        });
        Composite textContainer1 = new Composite(centerComposite, 0);
        textContainer1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)textContainer1, this.fBackgroundColor);
        gl = new GridLayout(1, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 20;
        textContainer1.setLayout((Layout)gl);
        Label title1 = new Label(textContainer1, 64);
        title1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        title1.setFont(this.fFontFactory.createFont("default", 16, 1));
        title1.setText(Messages.OVMComplianceReport_Main_Page_Architecture_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)title1, this.fBackgroundColor, true);
        Label description1 = new Label(textContainer1, 64);
        description1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        description1.setText(Messages.OVMComplianceReport_Main_Page_Architecture_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)description1, this.fBackgroundColor, true);
        Button button2 = new Button(centerComposite, 8);
        button2.setToolTipText(Messages.OVMComplianceReport_Main_Page_Checks_Big_Button_TT);
        button2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        button2.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_CHECKS_BUTTON));
        DVTColorUtil.INSTANCE.setBackground((Control)button2, this.fBackgroundColor);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OVMComplianceReport.this.fTabFolder.setSelection(2);
            }
        });
        Composite textContainer2 = new Composite(centerComposite, 0);
        textContainer2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)textContainer2, this.fBackgroundColor);
        gl = new GridLayout(1, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 20;
        textContainer2.setLayout((Layout)gl);
        Label title2 = new Label(textContainer2, 64);
        title2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        title2.setFont(this.fFontFactory.createFont("default", 16, 1));
        title2.setText(Messages.OVMComplianceReport_Main_Page_Checks_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)title2, this.fBackgroundColor, true);
        Label description2 = new Label(textContainer2, 64);
        description2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        description2.setText(Messages.OVMComplianceReport_Main_Page_Checks_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)description2, this.fBackgroundColor, true);
        Button button3 = new Button(centerComposite, 8);
        button3.setToolTipText(Messages.OVMComplianceReport_Main_Page_Statistics_Big_Button_TT);
        button3.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        button3.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATISTICS_BUTTON));
        DVTColorUtil.INSTANCE.setBackground((Control)button3, this.fBackgroundColor);
        button3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OVMComplianceReport.this.fTabFolder.setSelection(3);
            }
        });
        Composite textContainer3 = new Composite(centerComposite, 0);
        textContainer3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)textContainer3, this.fBackgroundColor);
        gl = new GridLayout(1, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 20;
        textContainer3.setLayout((Layout)gl);
        Label title3 = new Label(textContainer3, 64);
        title3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        title3.setFont(this.fFontFactory.createFont("default", 16, 1));
        title3.setText(Messages.OVMComplianceReport_Main_Page_Statistics_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)title3, this.fBackgroundColor, true);
        Label description3 = new Label(textContainer3, 64);
        description3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        description3.setText(Messages.OVMComplianceReport_Main_Page_Statistics_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)description3, this.fBackgroundColor, true);
        Button button4 = new Button(centerComposite, 8);
        button4.setToolTipText(Messages.OVMComplianceReport_Main_Page_Export_Big_Button_TT);
        button4.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        button4.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_EXPORT_HTML_BUTTON));
        DVTColorUtil.INSTANCE.setBackground((Control)button4, this.fBackgroundColor);
        button4.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                new HTMLReportGenerator(OVMComplianceReport.this.fOVMInfoProvider).generateReport();
            }
        });
        Composite textContainer4 = new Composite(centerComposite, 0);
        textContainer4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)textContainer4, this.fBackgroundColor);
        gl = new GridLayout(1, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 20;
        textContainer4.setLayout((Layout)gl);
        Label title4 = new Label(textContainer4, 64);
        title4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        title4.setFont(this.fFontFactory.createFont("default", 16, 1));
        title4.setText(Messages.OVMComplianceReport_Main_Page_Export_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)title4, this.fBackgroundColor, true);
        Label description4 = new Label(textContainer4, 64);
        description4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        description4.setText(Messages.OVMComplianceReport_Main_Page_Export_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)description4, this.fBackgroundColor, true);
        scrolledComposite.setContent((Control)centerComposite);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrolledComposite.getClientArea();
                scrolledComposite.setMinSize(centerComposite.computeSize(r.width, -1));
            }
        });
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.OVMComplianceReport_Main_Tab);
        tabItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_LINTER));
        tabItem.setControl((Control)tabComposite);
        DVTColorUtil.INSTANCE.setBackground(tabItem.getControl(), this.fBackgroundColor, true);
    }

    private void createArchitectureTab(TabFolder tabFolder) {
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new FillLayout());
        DVTColorUtil.INSTANCE.setBackground((Control)tabComposite, this.fBackgroundColor);
        ArchitectureDoublePanel fArchitecturePanel = new ArchitectureDoublePanel(tabComposite, 0);
        fArchitecturePanel.setInput(this.fArchitectureModel);
        fArchitecturePanel.addArchitectureChangedListener(this);
        DVTColorUtil.INSTANCE.setBackground((Control)fArchitecturePanel, this.fBackgroundColor);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.OVMComplianceReport_Architecture_Tab);
        tabItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_TAB_OVM_ARCH));
        tabItem.setControl((Control)tabComposite);
        DVTColorUtil.INSTANCE.setBackground(tabItem.getControl(), this.fBackgroundColor, true);
    }

    private void createChecksTab(TabFolder tabFolder) {
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new FillLayout());
        DVTColorUtil.INSTANCE.setBackground((Control)tabComposite, this.fBackgroundColor);
        this.fChecksTreeBrowser = new ChecksTreeBrowser(tabComposite, null, this.fProject, this);
        this.fChecksTreeBrowser.setInput(this.fOVMInfoProvider.getCategories());
        this.addUpdateListener(this.fChecksTreeBrowser);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.OVMComplianceReport_Checks_Tab);
        tabItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_TAB_OVM_CHECKS));
        tabItem.setControl((Control)tabComposite);
        DVTColorUtil.INSTANCE.setBackground(tabItem.getControl(), this.fBackgroundColor, true);
    }

    private void createStatisticsTab(TabFolder tabFolder) {
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new FillLayout());
        DVTColorUtil.INSTANCE.setBackground((Control)tabComposite, this.fBackgroundColor);
        this.fStatisticsTreeBrowser = new StatisticsTreeBrowser(tabComposite, null, this.fProject, this);
        this.fStatisticsTreeBrowser.setInput(this.fOVMInfoProvider.getCategories());
        this.addUpdateListener(this.fStatisticsTreeBrowser);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.OVMComplianceReport_Statistics_Tab);
        tabItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_TAB_OVM_STATS));
        tabItem.setControl((Control)tabComposite);
        DVTColorUtil.INSTANCE.setBackground(tabItem.getControl(), this.fBackgroundColor, true);
    }

    private void buildReportAction(Shell shell) {
        OVMProject ovmProject = OVMComplianceBuilder.getInstance().initializeOVMProject(this.fProject, ((OVMComplianceReportInput)this.getEditorInput()).getXVMMode());
        this.fArchitectureModel.updateOVMProject(true);
        OVMComplianceBuilder.getInstance().build(ovmProject);
        boolean errors = OVMComplianceBuilder.getInstance().checkErrors(ovmProject);
        if (errors) {
            MessageDialog.openError((Shell)shell, null, (String)"Cannot reapply the checks. Please rebuild the project.");
            return;
        }
        this.updateTopBar(true);
        this.updateListeners();
    }

    void updateTopBar(boolean reportBuilt) {
        if (reportBuilt) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(Messages.OVMComplianceReport_Top_Bar_Date_Format);
            this.fDate.setText(dateFormat.format(new Date()));
            this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_Status_Updated);
            DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fBackgroundColor);
            this.fTopBar.layout(true, true);
        } else {
            this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_status_Dirty_1);
            DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
        }
    }

    @Override
    public void architectureChaged() {
        this.updateTopBar(false);
    }

    public void addUpdateListener(IReportUpdateListener listener) {
        this.fReportUpdateListeners.add(listener);
    }

    protected void updateListeners() {
        for (IReportUpdateListener listener : this.fReportUpdateListeners) {
            listener.reportUpdate();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (this.fReportUpdateListeners != null) {
            this.fReportUpdateListeners.clear();
        }
        if (this.fFontFactory != null) {
            this.fFontFactory.dispose();
        }
        EModelManager.getInstance().removeReparseListener(this);
        if (this.fChecksTreeBrowser != null) {
            this.fChecksTreeBrowser.dispose();
        }
        if (this.fStatisticsTreeBrowser != null) {
            this.fStatisticsTreeBrowser.dispose();
        }
        super.dispose();
    }

    protected IReportInfoProvider getOVMInfoProvider() {
        return this.fOVMInfoProvider;
    }

    public RfProject getRfProject() {
        if (this.fProject == null) {
            return null;
        }
        return RfManager.getInstance().getRfProject(this.fProject);
    }

    public void reparsed(int buildKind, int type, IResource resource, List errors, List warnings, List tasks) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                OVMComplianceReport.this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_status_Dirty_2);
                DVTColorUtil.INSTANCE.setBackground((Control)OVMComplianceReport.this.fStatusBar, OVMComplianceReport.this.fBackgroundColor);
            }
        });
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fProject == null) {
            return;
        }
        int type = event.getType();
        if (this.fProject.equals((Object)event.getResource()) && (type == 4 || type == 2)) {
            this.doClose();
        }
    }

    public void doClose() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                OVMComplianceReport.this.getSite().getPage().closeEditor((IEditorPart)OVMComplianceReport.this, true);
            }
        });
    }

    public Object getAdapter(Class adapter) {
        IProject project = this.fProject;
        if (project != null) {
            if (IResource.class.equals((Object)adapter)) {
                return project;
            }
            if (IFile.class.equals((Object)adapter)) {
                IFile file = project.getFile(".project");
                if (file.isAccessible()) {
                    return file;
                }
                return project;
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.fSelectionListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.fProject);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.fSelectionListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
    }

    public void setFocus() {
    }
}

