/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import ro.amiq.dvt.linter.ui.ILinterReportInput;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;

public class OVMComplianceReportInput
implements ILinterReportInput {
    private final IProject fProject;
    private final int xvmMode;

    public OVMComplianceReportInput(IProject project, int aXVMMode) {
        this.fProject = project;
        this.xvmMode = aXVMMode;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return String.valueOf(XVMModeUtils.getTitle(this.xvmMode)) + " on " + this.fProject.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        IProject project = this.getProject();
        if (project != null) {
            if (IResource.class.equals((Object)adapter)) {
                return project;
            }
            if (IFile.class.equals((Object)adapter)) {
                IFile file = project.getFile(".project");
                if (file.isAccessible()) {
                    return file;
                }
                return project;
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public int getXVMMode() {
        return this.xvmMode;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OVMComplianceReportInput) {
            return ((OVMComplianceReportInput)obj).getProject().equals((Object)this.getProject()) && ((OVMComplianceReportInput)obj).getXVMMode() == this.getXVMMode();
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

