/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance.ui;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.ui.preferences.PrefConst;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.edt.core.EDTPlugin;
import ro.amiq.edt.model.EModelManager;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheckBase;
import ro.amiq.edt.ovmcompliance.IOVMComplianceStatistic;
import ro.amiq.edt.ovmcompliance.IOVMComplianceStatisticHit;
import ro.amiq.edt.ovmcompliance.ui.FontFactory;
import ro.amiq.edt.ovmcompliance.ui.IReportUpdateListener;
import ro.amiq.edt.ovmcompliance.ui.Messages;
import ro.amiq.edt.ovmcompliance.ui.OVMComplianceReport;
import ro.amiq.edt.ovmcompliance.ui.OVMComplianceStatisticsUtil;

public class StatisticsTreeBrowser
implements IReportUpdateListener {
    private FontFactory fFontFactory;
    private Composite fRightPartComposite;
    private Composite fLeftPartComposite;
    private TreeViewer fTree;
    private Label fDetailsTitle;
    private Label fDetailsDescription;
    private Composite fStatisticStatusDetailsContainer;
    private Label fStatisticStatusIcon;
    private Label fStatisticStatusText;
    private Button fStatisticProperties;
    private StackLayout fContentsStack;
    private Composite fSummaryComposite;
    private TableViewer fSummaryTable;
    private Text fSummaryTableDetails;
    private Composite fCategoriesComposite;
    private TableViewer fCategoriesTable;
    private Text fCategoriesTableDetails;
    private Composite fStatisticsComposite;
    private TableViewer fStatisticsTable;
    private Object fSelectedItem;
    private final IProject fProject;
    private OVMComplianceReport fComplianceReport;
    private Color fBackgroundColor = DVTColorUtil.INSTANCE.getColor(PrefConst.getVerissimoBackgroundColor((AbstractUIPlugin)EDTPlugin.getDefault()));

    public StatisticsTreeBrowser(Composite parent, Object layoutData, IProject project, OVMComplianceReport complianceReport) {
        this.fProject = project;
        this.fComplianceReport = complianceReport;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        if (layoutData != null) {
            composite.setLayoutData(layoutData);
        }
        DVTColorUtil.INSTANCE.setBackground((Control)composite, this.fBackgroundColor);
        this.fFontFactory = new FontFactory(parent.getDisplay());
        SashForm sashForm = new SashForm(composite, 256);
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor);
        this.createLeftPart((Composite)sashForm);
        this.createRightPart((Composite)sashForm);
        int[] componentWeight = new int[]{2, 5};
        sashForm.setWeights(componentWeight);
    }

    private void createLeftPart(Composite parent) {
        this.fLeftPartComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginTop = 0;
        gl.marginBottom = 5;
        this.fLeftPartComposite.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fLeftPartComposite, this.fBackgroundColor);
        Composite titleComposite = new Composite(this.fLeftPartComposite, 0);
        titleComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)titleComposite, this.fBackgroundColor, true);
        this.createTitle(titleComposite);
        this.fTree = new TreeViewer(this.fLeftPartComposite, 2820);
        this.fTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTree.setContentProvider((IContentProvider)new StatisticsTreeContentProvider());
        this.fTree.setLabelProvider((IBaseLabelProvider)new StatisticsTreeLabelProvider());
        this.fTree.addSelectionChangedListener((ISelectionChangedListener)new StatisticsTreeSelectionChangedListener());
        DVTColorUtil.INSTANCE.setBackground(this.fTree.getControl(), this.fBackgroundColor);
    }

    private void createTitle(Composite parent) {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginTop = 0;
        gl.marginBottom = 5;
        parent.setLayout((Layout)gl);
        Label titleLabel = new Label(parent, 64);
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        titleLabel.setFont(this.fFontFactory.createFont("title", 18, 1));
        titleLabel.setText(Messages.StatisticsTreeBrowser_Page_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)titleLabel, this.fBackgroundColor, true);
        Button reset = new Button(parent, 0);
        reset.setToolTipText(Messages.OVMComplianceReport_Main_Page_Checks_Restore_Button_TT);
        reset.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_RESTORE_DEFAULTS));
        reset.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        DVTColorUtil.INSTANCE.setBackground((Control)reset, this.fBackgroundColor);
        reset.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                StatisticsTreeBrowser.this.fComplianceReport.getOVMInfoProvider().restoreDefaultStatisticsSettings();
                StatisticsTreeBrowser.this.fComplianceReport.updateListeners();
            }
        });
        Label descriptionLabel = new Label(parent, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        descriptionLabel.setFont(this.fFontFactory.createFont("description", 0));
        descriptionLabel.setText(Messages.StatisticsTreeBrowser_Page_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)descriptionLabel, this.fBackgroundColor, true);
    }

    private void createRightPart(Composite parent) {
        this.fRightPartComposite = new Composite(parent, 0);
        this.fRightPartComposite.setLayout((Layout)new GridLayout(1, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fRightPartComposite, this.fBackgroundColor);
        Group detailsComposite = new Group(this.fRightPartComposite, 0);
        detailsComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)detailsComposite, this.fBackgroundColor);
        this.createDetails(detailsComposite);
        Composite contentsComposite = new Composite(this.fRightPartComposite, 0);
        contentsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setBackground((Control)contentsComposite, this.fBackgroundColor);
        this.createContents(contentsComposite);
    }

    private void createDetails(Group parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.fDetailsTitle = new Label((Composite)parent, 64);
        this.fDetailsTitle.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fDetailsTitle.setFont(this.fFontFactory.createFont("title", 14, 1));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fDetailsTitle, this.fBackgroundColor);
        this.fStatisticProperties = new Button((Composite)parent, 0);
        this.fStatisticProperties.setToolTipText(Messages.StatisticsTreeBrowser_Statistic_Properties_Button_TT);
        this.fStatisticProperties.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_CHECK_PROPERTIES));
        this.fStatisticProperties.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fStatisticProperties.addSelectionListener((SelectionListener)new StatisticsPropertiesButtonListener());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatisticProperties, this.fBackgroundColor);
        GridData gd = new GridData(4, 1, true, false, 2, 1);
        gd.exclude = true;
        this.fStatisticStatusDetailsContainer = new Composite((Composite)parent, 0);
        this.fStatisticStatusDetailsContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.fStatisticStatusDetailsContainer.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatisticStatusDetailsContainer, this.fBackgroundColor);
        this.fStatisticStatusIcon = new Label(this.fStatisticStatusDetailsContainer, 0);
        this.fStatisticStatusIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatisticStatusIcon, this.fBackgroundColor);
        this.fStatisticStatusText = new Label(this.fStatisticStatusDetailsContainer, 16448);
        this.fStatisticStatusText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatisticStatusText, this.fBackgroundColor);
        this.fDetailsDescription = new Label((Composite)parent, 64);
        this.fDetailsDescription.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fDetailsDescription.setFont(this.fFontFactory.createFont("description", 0));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fDetailsDescription, this.fBackgroundColor);
    }

    private void createContents(Composite parent) {
        this.fContentsStack = new StackLayout();
        parent.setLayout((Layout)this.fContentsStack);
        this.fSummaryComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fSummaryComposite, this.fBackgroundColor);
        this.createSummaryTable(this.fSummaryComposite);
        this.fCategoriesComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCategoriesComposite, this.fBackgroundColor);
        this.createCategoriesTable(this.fCategoriesComposite);
        this.fStatisticsComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatisticsComposite, this.fBackgroundColor);
        this.createStatisticsTable(this.fStatisticsComposite);
    }

    private void createSummaryTable(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 512);
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor, true);
        this.fSummaryTable = new TableViewer((Composite)sashForm, 68356);
        this.fSummaryTable.setContentProvider((IContentProvider)new SummaryTableContentProvider());
        this.fSummaryTable.setLabelProvider((IBaseLabelProvider)new SummaryTableLabelProvider());
        this.fSummaryTable.addSelectionChangedListener((ISelectionChangedListener)new SummaryTableSelectionChangedListener());
        this.fSummaryTable.addDoubleClickListener((IDoubleClickListener)new SummaryTableDubleClickListener());
        DVTColorUtil.INSTANCE.setBackground(this.fSummaryTable.getControl(), this.fBackgroundColor);
        Table table = this.fSummaryTable.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.StatisticsTreeBrowser_Summary_Table_Column_1);
        column.setWidth(200);
        column = new TableColumn(table, 0);
        column.setText(Messages.StatisticsTreeBrowser_Summary_Table_Column_2);
        column.setAlignment(0x1000000);
        column.setWidth(90);
        column = new TableColumn(table, 0);
        column.setText(Messages.StatisticsTreeBrowser_Summary_Table_Column_3);
        column.setWidth(85);
        this.fSummaryTableDetails = new Text((Composite)sashForm, 2634);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fSummaryTableDetails, this.fBackgroundColor);
        int[] componentWeight = new int[]{4, 1};
        sashForm.setWeights(componentWeight);
    }

    private void createCategoriesTable(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 512);
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor);
        this.fCategoriesTable = new TableViewer((Composite)sashForm, 68356);
        this.fCategoriesTable.setContentProvider((IContentProvider)new CategoriesTableContentProvider());
        this.fCategoriesTable.setLabelProvider((IBaseLabelProvider)new CategoriesTableLabelProvider());
        this.fCategoriesTable.addSelectionChangedListener((ISelectionChangedListener)new CategoriesTableSelectionChangedListener());
        this.fCategoriesTable.addDoubleClickListener((IDoubleClickListener)new CategoriesTableDubleClickListener());
        DVTColorUtil.INSTANCE.setBackground(this.fCategoriesTable.getControl(), this.fBackgroundColor, true);
        Table table = this.fCategoriesTable.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.StatisticsTreeBrowser_Categories_Table_Column_1);
        column.setWidth(200);
        column = new TableColumn(table, 0);
        column.setText(Messages.StatisticsTreeBrowser_Categories_Table_Column_2);
        column.setAlignment(0x1000000);
        column.setWidth(75);
        column = new TableColumn(table, 0);
        column.setText(Messages.StatisticsTreeBrowser_Categories_Table_Column_3);
        column.setWidth(100);
        this.fCategoriesTableDetails = new Text((Composite)sashForm, 2634);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCategoriesTableDetails, this.fBackgroundColor);
        int[] componentWeight = new int[]{4, 1};
        sashForm.setWeights(componentWeight);
    }

    private void createStatisticsTable(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.fStatisticsTable = new TableViewer(parent, 68356);
        this.fStatisticsTable.setContentProvider((IContentProvider)new StatisticsTableContentProvider());
        this.fStatisticsTable.setLabelProvider((IBaseLabelProvider)new StatisticsTableLabelProvider());
        this.fStatisticsTable.addDoubleClickListener((IDoubleClickListener)new StatisticsTableDubleClickListener());
        DVTColorUtil.INSTANCE.setBackground(this.fStatisticsTable.getControl(), this.fBackgroundColor);
        Table table = this.fStatisticsTable.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setResizable(false);
        column.setWidth(25);
        column = new TableColumn(table, 0);
        column.setText(Messages.StatisticsTreeBrowser_Statistics_Table_Column_1);
        column.setWidth(50);
        column = new TableColumn(table, 0);
        column.setText(Messages.StatisticsTreeBrowser_Statistics_Table_Column_2);
        column.setWidth(300);
        column = new TableColumn(table, 0);
        column.setText(Messages.StatisticsTreeBrowser_Statistics_Table_Column_3);
        column.setWidth(70);
    }

    private void updateTree() {
        if (this.fSelectedItem == null || ((IStructuredSelection)this.fTree.getSelection()).getFirstElement() == null) {
            StructuredSelection selection = new StructuredSelection((Object)Messages.StatisticsTreeBrowser_Summary_Item);
            this.fTree.setSelection((ISelection)selection, true);
        }
        this.fTree.refresh();
        this.fTree.expandAll();
    }

    private void updateLeftPart() {
        if (this.fSelectedItem != null) {
            if (this.fSelectedItem instanceof String && ((String)this.fSelectedItem).equals(Messages.StatisticsTreeBrowser_Summary_Item)) {
                this.updateSummaryComposite();
            } else if (this.fSelectedItem instanceof IOVMComplianceCategory) {
                this.updateCategoriesComposite((IOVMComplianceCategory)this.fSelectedItem);
            } else if (this.fSelectedItem instanceof IOVMComplianceStatistic) {
                this.updateStatisticsComposite((IOVMComplianceStatistic)this.fSelectedItem);
            }
            Object element = ((IStructuredSelection)this.fCategoriesTable.getSelection()).getFirstElement();
            if (element == null) {
                this.fCategoriesTableDetails.setText("");
            } else if (element instanceof IOVMComplianceCheckBase) {
                this.fCategoriesTableDetails.setText(((IOVMComplianceCheckBase)element).getDescription());
            }
            this.fRightPartComposite.layout(true, true);
        }
    }

    private void updateSummaryComposite() {
        this.fSummaryTable.setInput(this.fTree.getInput());
        this.updateStatisticStatusAndPropertiesControls(null);
        this.updateTitleAndDescription(Messages.StatisticsTreeBrowser_Summary_Table_Title, Messages.StatisticsTreeBrowser_Summary_Table_Description);
        this.fContentsStack.topControl = this.fSummaryComposite;
    }

    private void updateCategoriesComposite(IOVMComplianceCategory category) {
        ArrayList<IOVMComplianceStatistic> statistics = new ArrayList<IOVMComplianceStatistic>();
        statistics.addAll(category.getStatistics());
        this.fCategoriesTable.setInput(statistics);
        this.updateStatisticStatusAndPropertiesControls(null);
        this.updateTitleAndDescription(category.getName(), category.getDescription());
        this.fContentsStack.topControl = this.fCategoriesComposite;
    }

    private void updateStatisticsComposite(IOVMComplianceStatistic statistic) {
        this.fStatisticsTable.setInput(statistic.getHits());
        this.updateStatisticStatusAndPropertiesControls(statistic);
        this.updateTitleAndDescription(String.valueOf(statistic.getUserId(false)) + ": " + statistic.getTitle(), statistic.getDescription());
        this.fContentsStack.topControl = this.fStatisticsComposite;
    }

    private void updateTitleAndDescription(String title, String description) {
        this.fDetailsTitle.setText(title == null ? "" : title);
        this.fDetailsDescription.setText(description == null ? "" : description);
    }

    private void updateStatisticStatusAndPropertiesControls(IOVMComplianceStatistic statistic) {
        boolean visible = false;
        if (statistic != null && !statistic.isGenerated()) {
            this.fStatisticStatusIcon.setImage(OVMComplianceStatisticsUtil.getImage(statistic));
            this.fStatisticStatusText.setText(String.valueOf(Messages.StatisticsTreeBrowser_Statistic_Status) + OVMComplianceStatisticsUtil.getDetailsText(statistic));
            visible = true;
        }
        this.fStatisticProperties.setVisible(visible);
        this.fStatisticStatusDetailsContainer.setVisible(visible);
        ((GridData)this.fStatisticStatusDetailsContainer.getLayoutData()).exclude = !visible;
        ((GridData)this.fDetailsTitle.getLayoutData()).grabExcessHorizontalSpace = !visible;
        ((GridData)this.fStatisticProperties.getLayoutData()).grabExcessHorizontalSpace = visible;
    }

    private String getFileShortName(String fileName) {
        if (fileName == null) {
            return "";
        }
        File f = new File(fileName);
        String name = f.getName();
        return name == null ? "" : name;
    }

    public void setInput(ArrayList<IOVMComplianceCategory> input) {
        this.fTree.setInput(input);
        this.updateTree();
    }

    @Override
    public void reportUpdate() {
        this.updateTree();
        this.updateLeftPart();
    }

    public void dispose() {
        if (this.fFontFactory != null) {
            this.fFontFactory.dispose();
        }
    }

    private static final class CategoriesTableContentProvider
    implements IStructuredContentProvider {
        private CategoriesTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class CategoriesTableDubleClickListener
    implements IDoubleClickListener {
        private CategoriesTableDubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && (element = selection.getFirstElement()) instanceof IOVMComplianceStatistic) {
                StatisticsTreeBrowser.this.fTree.setSelection((ISelection)selection);
            }
        }
    }

    private static final class CategoriesTableLabelProvider
    implements ITableLabelProvider {
        private CategoriesTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return OVMComplianceStatisticsUtil.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof IOVMComplianceStatistic) {
                IOVMComplianceStatistic statistic = (IOVMComplianceStatistic)element;
                if (columnIndex == 0) {
                    return statistic.getUserId(true);
                }
                if (columnIndex == 1) {
                    return Integer.toString(statistic.getNofHits());
                }
                if (columnIndex == 2) {
                    return statistic.getDescription();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class CategoriesTableSelectionChangedListener
    implements ISelectionChangedListener {
        private CategoriesTableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof IOVMComplianceStatistic) {
                StatisticsTreeBrowser.this.fCategoriesTableDetails.setText(((IOVMComplianceStatistic)element).getDescription());
            }
        }
    }

    private final class StatisticsPropertiesButtonListener
    implements SelectionListener {
        private StatisticsPropertiesButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    StatisticsPropertiesDialog propertiesDialog;
                    int status;
                    if (((StatisticsPropertiesButtonListener)StatisticsPropertiesButtonListener.this).StatisticsTreeBrowser.this.fSelectedItem != null && ((StatisticsPropertiesButtonListener)StatisticsPropertiesButtonListener.this).StatisticsTreeBrowser.this.fSelectedItem instanceof IOVMComplianceStatistic && (status = (propertiesDialog = new StatisticsPropertiesDialog((IOVMComplianceStatistic)((StatisticsPropertiesButtonListener)StatisticsPropertiesButtonListener.this).StatisticsTreeBrowser.this.fSelectedItem)).open()) == 0) {
                        if (((StatisticsPropertiesButtonListener)StatisticsPropertiesButtonListener.this).StatisticsTreeBrowser.this.fSelectedItem instanceof IOVMComplianceStatistic) {
                            ((StatisticsPropertiesButtonListener)StatisticsPropertiesButtonListener.this).StatisticsTreeBrowser.this.fStatisticsTable.refresh();
                        }
                        StatisticsTreeBrowser.this.updateStatisticStatusAndPropertiesControls((IOVMComplianceStatistic)((StatisticsPropertiesButtonListener)StatisticsPropertiesButtonListener.this).StatisticsTreeBrowser.this.fSelectedItem);
                        ((StatisticsPropertiesButtonListener)StatisticsPropertiesButtonListener.this).StatisticsTreeBrowser.this.fRightPartComposite.layout(true, true);
                        StatisticsTreeBrowser.this.updateTree();
                    }
                }
            });
        }
    }

    private static final class StatisticsPropertiesDialog
    extends MessageDialog {
        private Button fEnableRadio;
        private Button fDisableRadio;
        private final IOVMComplianceStatistic fStatistic;

        public StatisticsPropertiesDialog(IOVMComplianceStatistic statistic) {
            super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.StatisticsTreeBrowser_Statistic_Properties_Dialog_Title, null, Messages.StatisticsTreeBrowser_Statistic_Properties_Dialog_Description, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.fStatistic = statistic;
        }

        public int open() {
            if (this.fStatistic != null) {
                return super.open();
            }
            return -1;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                IOVMComplianceStatistic statistic = this.fStatistic;
                if (this.fEnableRadio.getSelection() && !statistic.isEnabled()) {
                    statistic.setEnabledAndSave(true);
                    statistic.performCheck();
                } else if (this.fDisableRadio.getSelection() && statistic.isEnabled()) {
                    statistic.setEnabledAndSave(false);
                    statistic.performCheck();
                }
            }
            this.setReturnCode(buttonId);
            this.close();
        }

        protected Control createDialogArea(Composite parent) {
            Composite contents = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, true);
            gl.horizontalSpacing = 20;
            gl.verticalSpacing = 15;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            contents.setLayout((Layout)gl);
            Group endisGroup = new Group(contents, 4);
            endisGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            endisGroup.setText(Messages.StatisticsTreeBrowser_Statistic_Properties_Dialog_Enable_Disable_Group);
            endisGroup.setLayout((Layout)new GridLayout(1, false));
            this.fEnableRadio = new Button((Composite)endisGroup, 16);
            this.fEnableRadio.setText(Messages.StatisticsTreeBrowser_Statistic_Properties_Dialog_Enable_Radio);
            this.fEnableRadio.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fDisableRadio = new Button((Composite)endisGroup, 16);
            this.fDisableRadio.setText(Messages.StatisticsTreeBrowser_Statistic_Properties_Dialog_Disable_Radio);
            this.fDisableRadio.setLayoutData((Object)new GridData(4, 4, true, true));
            if (this.fStatistic.isEnabled()) {
                this.fEnableRadio.setSelection(true);
            } else {
                this.fDisableRadio.setSelection(true);
            }
            Label dummy = new Label(contents, 0);
            dummy.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            Button defaultPush = new Button(contents, 8);
            defaultPush.setText(Messages.OVMComplianceReport_Main_Page_Checks_Restore_Button);
            defaultPush.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            defaultPush.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    fStatistic.restoreDefaults();
                    if (fStatistic.isEnabled()) {
                        fEnableRadio.setSelection(true);
                        fDisableRadio.setSelection(false);
                    } else {
                        fEnableRadio.setSelection(false);
                        fDisableRadio.setSelection(true);
                    }
                }
            });
            return contents;
        }
    }

    private static final class StatisticsTableContentProvider
    implements IStructuredContentProvider {
        private StatisticsTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class StatisticsTableDubleClickListener
    implements IDoubleClickListener {
        private StatisticsTableDubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && (element = selection.getFirstElement()) instanceof IOVMComplianceStatisticHit) {
                EDTFileUtils.getInstance().openFile((AbstractEModelManager)EModelManager.getInstance(), StatisticsTreeBrowser.this.fProject, ((IOVMComplianceStatisticHit)element).getFile(), ((IOVMComplianceStatisticHit)element).getLine(), null);
            }
        }
    }

    private final class StatisticsTableLabelProvider
    implements ITableLabelProvider {
        private StatisticsTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return OVMComplianceStatisticsUtil.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof IOVMComplianceStatisticHit) {
                IOVMComplianceStatisticHit hit = (IOVMComplianceStatisticHit)element;
                if (columnIndex == 1) {
                    return Integer.toString(hit.getLine());
                }
                if (columnIndex == 2) {
                    return StatisticsTreeBrowser.this.getFileShortName(hit.getFile());
                }
                if (columnIndex == 3) {
                    return StatisticsTreeBrowser.this.getFileShortName(hit.getDetails());
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class StatisticsTreeContentProvider
    implements ITreeContentProvider {
        private StatisticsTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IOVMComplianceCategory) {
                return ((IOVMComplianceCategory)parentElement).getStatistics().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IOVMComplianceStatistic) {
                return ((IOVMComplianceStatistic)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ArrayList || element instanceof IOVMComplianceCategory;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                ArrayList inputElementTmp = (ArrayList)inputElement;
                ArrayList<Object> children = new ArrayList<Object>();
                children.add(Messages.StatisticsTreeBrowser_Summary_Item);
                for (IOVMComplianceCategory category : inputElementTmp) {
                    if (category.getNofStatistics() <= 0) continue;
                    children.add(category);
                }
                return children.toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static final class StatisticsTreeLabelProvider
    implements ILabelProvider {
        private StatisticsTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return OVMComplianceStatisticsUtil.getImage(element);
        }

        public String getText(Object element) {
            return OVMComplianceStatisticsUtil.getTreeText(element);
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    private final class StatisticsTreeSelectionChangedListener
    implements ISelectionChangedListener {
        private StatisticsTreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element;
            StatisticsTreeBrowser.this.fSelectedItem = element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            StatisticsTreeBrowser.this.updateLeftPart();
        }
    }

    private static final class SummaryTableContentProvider
    implements IStructuredContentProvider {
        private SummaryTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                ArrayList inputElementTmp = (ArrayList)inputElement;
                ArrayList<IOVMComplianceCategory> children = new ArrayList<IOVMComplianceCategory>();
                for (IOVMComplianceCategory category : inputElementTmp) {
                    if (category.getNofStatistics() <= 0) continue;
                    children.add(category);
                }
                return children.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class SummaryTableDubleClickListener
    implements IDoubleClickListener {
        private SummaryTableDubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && (element = selection.getFirstElement()) instanceof IOVMComplianceCategory) {
                StatisticsTreeBrowser.this.fTree.setSelection((ISelection)selection);
            }
        }
    }

    private static final class SummaryTableLabelProvider
    implements ITableLabelProvider {
        private SummaryTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return OVMComplianceStatisticsUtil.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof IOVMComplianceCategory) {
                IOVMComplianceCategory category = (IOVMComplianceCategory)element;
                if (columnIndex == 0) {
                    return category.getName();
                }
                if (columnIndex == 1) {
                    return String.valueOf(Integer.toString(category.getNofEnabledStatistics())) + " / " + Integer.toString(category.getNofStatistics());
                }
                if (columnIndex == 2) {
                    return category.getDescription();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class SummaryTableSelectionChangedListener
    implements ISelectionChangedListener {
        private SummaryTableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof IOVMComplianceCategory) {
                StatisticsTreeBrowser.this.fSummaryTableDetails.setText(((IOVMComplianceCategory)element).getDescription());
            }
        }
    }
}

