/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.edt.base.model.reflection.RfAssert;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.specador.Wrapper;

public class CheckWrapper
extends Wrapper {
    private static final Pattern WORD_MATCHER = Pattern.compile("\\w*");
    public static final String ANONYMOUS_NAME = "[anonymous]";
    private RfStruct enclosingStruct;

    public CheckWrapper(SpecadorModel model, RfNamedElement namedElement) {
        super(model, namedElement);
    }

    public CheckWrapper(SpecadorModel model, RfNamedElement namedElement, RfStruct enclosingStruct) {
        this(model, namedElement);
        this.enclosingStruct = enclosingStruct;
    }

    public String getName() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return "";
        }
        RfDefElement relevantLayer = this.getRelevantLayer();
        if (namedElement instanceof RfExpect && relevantLayer == null) {
            return "";
        }
        String literal = null;
        String name = null;
        if (namedElement instanceof RfAssert) {
            literal = ((RfAssert)namedElement).getLiteral();
        } else if (namedElement instanceof RfCheckThat) {
            name = ((RfCheckThat)namedElement).getName();
            if (name.equals(ANONYMOUS_NAME)) {
                name = null;
            }
            literal = ((RfCheckThat)namedElement).getLiteral();
        } else if (namedElement instanceof RfExpect && relevantLayer != null) {
            name = ((RfExpectLayer)relevantLayer).getName();
            if (((RfExpect)namedElement).isAnonymous()) {
                name = null;
            }
            literal = ((RfExpectLayer)relevantLayer).getLiteral();
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        if (literal != null && !literal.isEmpty() && !literal.trim().equals("...")) {
            Matcher wordMatcher = WORD_MATCHER.matcher(literal);
            wordMatcher.find();
            name = wordMatcher.group();
        }
        if (name == null) {
            name = ANONYMOUS_NAME;
        }
        return name;
    }

    public String getLinkToRef() {
        if (this.isAnonymous() && this.enclosingStruct != null) {
            return this.getLinkToRef((IRfNamedElement)this.enclosingStruct);
        }
        return this.getLinkToRef((IRfNamedElement)this.namedElement);
    }

    public boolean isAnonymous() {
        return ANONYMOUS_NAME.equals(this.getName());
    }

    public String getType() {
        if (this.getNamedElement() instanceof RfAssert) {
            return "assert";
        }
        if (this.getNamedElement() instanceof RfCheckThat) {
            return "check";
        }
        if (this.getNamedElement() instanceof RfExpect) {
            return "expect";
        }
        return "";
    }

    private RfDefElement getRelevantLayer() {
        if (!(this.getNamedElement() instanceof RfExpect)) {
            return null;
        }
        List layers = ((RfExpect)this.getNamedElement()).getLayers();
        if (layers == null) {
            return null;
        }
        RfDefElement result = null;
        for (RfDefElement layer : layers) {
            if (layer.getLayerKind() == 378) {
                result = layer;
                continue;
            }
            if (layer.getLayerKind() != 377) continue;
            return layer;
        }
        return result;
    }

    public String getExpression() {
        String expression = "";
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement instanceof RfAssert) {
            expression = ((RfAssert)namedElement).getExpression();
        }
        if (namedElement instanceof RfCheckThat) {
            expression = ((RfCheckThat)namedElement).getExpression();
        }
        RfDefElement relevantLayer = this.getRelevantLayer();
        if (namedElement instanceof RfExpect && relevantLayer != null) {
            expression = ((RfExpectLayer)relevantLayer).getExpression();
        }
        return expression != null ? expression : "";
    }

    public String getEnclosingStruct() {
        if (this.enclosingStruct != null) {
            return this.enclosingStruct.getName();
        }
        return "";
    }

    public String getEnclosingPackage() {
        if (this.enclosingStruct != null) {
            return this.enclosingStruct.getPackageName();
        }
        return "";
    }

    public String getPackageLink() {
        if (this.enclosingStruct != null) {
            return this.getLinkToRef((IRfNamedElement)this.enclosingStruct.getRfProject().getPackage(this.enclosingStruct.getPackageName()));
        }
        return "";
    }
}

