/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.specador.templates.IDesignInstanceWrapper;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IPackageWrapper;
import ro.amiq.dvt.specador.templates.ISpecadorContributor;
import ro.amiq.dvt.specador.templates.ITestWrapper;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedScalar;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.base.model.reflection.views.EVHTopUnitContributor;
import ro.amiq.edt.model.reflection.RfManager;
import ro.amiq.edt.specador.CheckWrapper;
import ro.amiq.edt.specador.EventWrapper;
import ro.amiq.edt.specador.MacroWrapper;
import ro.amiq.edt.specador.PackageWrapper;
import ro.amiq.edt.specador.SpecadorELinkResolver;
import ro.amiq.edt.specador.TestWrapper;
import ro.amiq.edt.specador.UnitWrapper;

public class Contributor
implements ISpecadorContributor {
    private SpecadorModel model;

    public LanguageKind getLanguageKind() {
        return LanguageKind.E;
    }

    public List<String> getPackages(IProject project) {
        ArrayList<String> packages = new ArrayList<String>();
        block0: for (RfStruct rfPackage : RfManager.getInstance().getRfProject(project).getAllPackages()) {
            Collection types = rfPackage.getTypes();
            if (types.isEmpty()) continue;
            for (RfType rfType : types) {
                if (rfType.isPredefined()) continue;
                packages.add(rfPackage.getName());
                continue block0;
            }
        }
        return packages;
    }

    public List<String> getPackages(RfMixedLangProject rfMixedLangProject) {
        RfProject rfProject = (RfProject)rfMixedLangProject.getSingleLangProject(LanguageKind.E.NATURE_ID);
        return this.getPackages(rfProject.getProject());
    }

    public String getVerificationTopPath(IRfNamedElement element) {
        if (!(element instanceof RfStruct)) {
            return "";
        }
        return "packages/" + ((RfStruct)element).getPackageName();
    }

    public String getHyperlink(IRfNamedElement namedElement) {
        if (!(namedElement instanceof RfNamedElement)) {
            return "";
        }
        if (namedElement instanceof RfPredefinedStruct) {
            return "";
        }
        RfNamedElement element = (RfNamedElement)namedElement;
        if (this.shouldFilter((IRfNamedElement)element)) {
            return "";
        }
        if (element instanceof RfPredefinedScalar) {
            return "";
        }
        String link = SpecadorELinkResolver.getInstance().getLinkToElement(element, ".html", "#");
        if (link.isEmpty()) {
            return "";
        }
        return link;
    }

    public Map<String, List<IFreeMarkerWrapper>> getMacros(SpecadorModel model) {
        if (!model.hasEdtNature() || !model.isExportEdtMacros()) {
            return Collections.emptyMap();
        }
        IProject project = model.getProject();
        if (project == null) {
            return Collections.emptyMap();
        }
        Set selectedPackages = model.getEdtSelectedPackageNames();
        HashSet<String> uniqueMacros = new HashSet<String>();
        LinkedHashMap<String, List<IFreeMarkerWrapper>> result = new LinkedHashMap<String, List<IFreeMarkerWrapper>>();
        List allMacros = RfManager.getInstance().getRfProject(project).getAllMacros(true, false);
        for (RfMacro macro : allMacros) {
            MacroWrapper wrapper;
            if (this.shouldFilter((IRfNamedElement)macro) || macro.isPredefined() || macro.getModule() == null || macro.getModule().isDefinedInTest() || !uniqueMacros.add(macro.getName()) || macro.isPreprocessing() && !macro.isNotConditional() || macro.getModule() == null || !selectedPackages.contains(macro.getModule().getPackageName()) || (wrapper = new MacroWrapper(this.getModel(), macro)).getType().isEmpty()) continue;
            if (!result.containsKey(wrapper.getType())) {
                result.put(wrapper.getType(), new LinkedList());
            }
            ((List)result.get(wrapper.getType())).add(wrapper);
        }
        return result;
    }

    public List<IPackageWrapper> getPackages(SpecadorModel model) {
        if (!model.hasEdtNature() || !model.isExportEdtPackages()) {
            return Collections.emptyList();
        }
        IProject project = model.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        return rfProject.getAllPackages().stream().filter(p -> !this.shouldFilter((IRfNamedElement)p)).filter(pkg -> this.getModel().getEdtSelectedPackageNames().contains(pkg.getName())).map(p -> new PackageWrapper(this.getModel(), (RfStruct)p, rfProject)).collect(Collectors.toList());
    }

    public boolean isPublic(IRfNamedElement namedElement) {
        return ((RfNamedElement)namedElement).isPublic();
    }

    public boolean isFilteredByName(IRfNamedElement namedElement) {
        StringMatcher[] namePatterns = this.getModel().getNamePatterns();
        if (namePatterns == null) {
            return false;
        }
        RfNamedElement element = (RfNamedElement)namedElement;
        StringMatcher[] stringMatcherArray = namePatterns;
        int n = namePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            StringMatcher matcher = stringMatcherArray[n2];
            if (matcher.match(element.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IDesignInstanceWrapper getInstance(IRfDesignElement namedElement, ElementPath elementPath, String name) {
        return null;
    }

    public String getKind(IRfNamedElement element) {
        return RfKind.of((IRfNamedElement)element).getName().replace(" ", "-");
    }

    public String getURL(IRfNamedElement element) {
        RfNamedElement namedElement = (RfNamedElement)element;
        SpecadorModel model = this.getModel();
        if (model == null) {
            return "";
        }
        StringBuilder url = new StringBuilder(File.separator);
        url.append(model.getOutputFolderName()).append(File.separator);
        if (!(namedElement instanceof RfStruct)) {
            return "";
        }
        url.append("packages/").append(((RfStruct)namedElement).getPackageName()).append("/");
        return url.toString();
    }

    public List<ITestWrapper> getTests(IProject project) {
        return RfManager.getInstance().getRfProject(project).getAllTests().stream().filter(test -> !this.shouldFilter((IRfNamedElement)test)).map(test -> new TestWrapper(this.getModel(), (RfModule)test)).collect(Collectors.toList());
    }

    public List<IRfNamedElement> getVerificationTops(SpecadorModel model) {
        if (!model.hasEdtNature() || !model.isExportEdtPackages()) {
            return Collections.emptyList();
        }
        IProject project = model.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        Map tops = EVHTopUnitContributor.INSTANCE.getTops(RfManager.getInstance().getRfProject(project), false);
        return tops.values().stream().filter(top -> model.getEdtSelectedPackageNames().contains(top.getPackageName())).collect(Collectors.toList());
    }

    public String getPackageName(IRfNamedElement element) {
        if (!(element instanceof RfStruct)) {
            return "";
        }
        return ((RfStruct)element).getPackageName();
    }

    public List<IFreeMarkerWrapper> getChecks(SpecadorModel model) {
        if (!model.hasEdtNature() || !model.isExportEdtChecks()) {
            return Collections.emptyList();
        }
        if (model.getProject() == null) {
            return Collections.emptyList();
        }
        Set selectedPackages = model.getEdtSelectedPackageNames();
        return RfManager.getInstance().getRfProject(model.getProject()).getAllStructs().stream().map(s -> new UnitWrapper(this.getModel(), (RfStruct)s).getChecks()).flatMap(Collection::stream).filter(c -> !this.shouldFilter((IRfNamedElement)((CheckWrapper)c).namedElement)).filter(e -> selectedPackages.contains(((CheckWrapper)e).getEnclosingPackage())).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getCovergroups(SpecadorModel model) {
        if (!model.hasEdtNature() || !model.isExportEdtCovergroups()) {
            return Collections.emptyList();
        }
        if (model.getProject() == null) {
            return Collections.emptyList();
        }
        Set selectedPackages = model.getEdtSelectedPackageNames();
        return RfManager.getInstance().getRfProject(model.getProject()).getAllStructs().stream().map(s -> new UnitWrapper(this.getModel(), (RfStruct)s).getEvents()).flatMap(Collection::stream).filter(e -> !((EventWrapper)e).getCoverItems().isEmpty()).filter(e -> !this.shouldFilter((IRfNamedElement)((EventWrapper)e).event)).filter(e -> selectedPackages.contains(((EventWrapper)e).getEnclosingPackage())).collect(Collectors.toList());
    }

    public IFreeMarkerWrapper getWrapper(IRfNamedElement namedElement) {
        UnitWrapper wrapper;
        if (namedElement instanceof RfStruct && !(wrapper = new UnitWrapper(this.getModel(), (RfStruct)namedElement)).getUnitType().isEmpty()) {
            return wrapper;
        }
        return null;
    }

    public boolean isValidForHTMLPreview(IRfNamedElement namedElement) {
        return namedElement instanceof RfStruct;
    }

    public void addSpecadorPreviewListenerToBuildListeners() {
        BuildEventManager.getInstance().registerListener((IBuildEventManagerListener)SpecadorPreviewListener.INSTANCE);
    }

    public void removeSpecadorPreviewListenerFromBuildListeners() {
        BuildEventManager.getInstance().unregisterListener((IBuildEventManagerListener)SpecadorPreviewListener.INSTANCE);
    }

    public String getFullPath(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return "";
        }
        String file = SpecadorELinkResolver.getInstance().getLinkToElement((RfNamedElement)element, ".rst", "#");
        if (file.isEmpty()) {
            return "";
        }
        if (file.contains("#")) {
            file = file.substring(0, file.indexOf("#"));
        }
        return String.valueOf(this.getModel().getLocation()) + File.separator + "source" + File.separator + file;
    }

    public String getFullNameLabel(IRfNamedElement element) {
        return Integer.toHexString(Objects.hashCode(element.getFullNameLabel()));
    }

    public SpecadorModel getModel() {
        return this.model;
    }

    public void setModel(SpecadorModel model) {
        SpecadorELinkResolver.getInstance().setModel(model);
        this.model = model;
    }
}

