/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.specador.CoverItemWrapper;
import ro.amiq.edt.specador.Wrapper;

public class EventWrapper
extends Wrapper {
    RfEvent event;
    private RfStruct parent;
    private RfStruct enclosingStruct;

    public EventWrapper(SpecadorModel model, RfEvent event) {
        super(model, (RfNamedElement)event);
        this.event = event;
    }

    public EventWrapper(SpecadorModel model, RfEvent event, RfStruct enclosingStruct) {
        this(model, event);
        this.enclosingStruct = enclosingStruct;
    }

    @Override
    protected RfModule getModule() {
        if (this.event.getCoverItems().isEmpty()) {
            return super.getModule();
        }
        for (RfDefElement layer : this.event.getLayers()) {
            if (!(layer instanceof RfCoverLayer)) continue;
            return layer.getDefFile() == null ? super.getModule() : layer.getLayerModule();
        }
        return super.getModule();
    }

    public String getDeclarationLocation() {
        if (this.event.getCoverItems().isEmpty()) {
            return super.getDeclarationLocation();
        }
        for (RfDefElement layer : this.event.getLayers()) {
            if (!(layer instanceof RfCoverLayer)) continue;
            return layer.getDefFile() == null ? super.getDeclarationLocation() : ((IRfScopeElement)layer.getDefFile()).getName();
        }
        return super.getDeclarationLocation();
    }

    public String getDeclarationLine() {
        if (this.event.getCoverItems().isEmpty()) {
            return super.getDeclarationLine();
        }
        for (RfDefElement layer : this.event.getLayers()) {
            if (!(layer instanceof RfCoverLayer)) continue;
            return layer.getDefFile() == null ? super.getDeclarationLine() : String.valueOf(layer.getStartLine()).replace(",", "");
        }
        return super.getDeclarationLine();
    }

    public List<CoverItemWrapper> getCoverItems() {
        return this.event.getCoverItems().stream().filter(item -> item.getKind() == 0).filter(item -> item instanceof RfCoverItem).map(item -> new CoverItemWrapper(this.getModel(), (RfCoverItem)item)).collect(Collectors.toList());
    }

    public List<CoverItemWrapper> getCoverCrosses() {
        return this.event.getCoverItems().stream().filter(item -> item.getKind() == 1).filter(item -> item instanceof RfCoverItem).map(item -> new CoverItemWrapper(this.getModel(), (RfCoverItem)item)).collect(Collectors.toList());
    }

    public List<CoverItemWrapper> getCoverTransitions() {
        return this.event.getCoverItems().stream().filter(item -> item.getKind() == 2).filter(item -> item instanceof RfCoverItem).map(item -> new CoverItemWrapper(this.getModel(), (RfCoverItem)item)).collect(Collectors.toList());
    }

    public void setParent(RfStruct parent) {
        this.parent = parent;
    }

    public RfStruct getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public String getParentName() {
        return this.parent.getName();
    }

    public String getParentPackageName() {
        return this.parent.getPackageName();
    }

    public String getLinkToParent() {
        if (this.parent.isPredefined() || this.parent instanceof RfPredefinedStruct) {
            return "";
        }
        return this.getLinkToRef((IRfNamedElement)this.parent);
    }

    public String getLinkToPackage() {
        return this.getLinkToRef((IRfNamedElement)this.parent.getRfProject().getPackage(this.getParentPackageName()));
    }

    public String getLinkToParentEvent() {
        if (this.parent.isPredefined() || this.parent instanceof RfPredefinedStruct) {
            return "";
        }
        RfEvent localEvent = this.parent.getLocalEvent(this.event.getName());
        if (localEvent == null) {
            return "";
        }
        return this.getLinkToRef((IRfNamedElement)localEvent);
    }

    public String getLinkToRef() {
        return this.getLinkToRef((IRfNamedElement)this.event);
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this.enclosingStruct != null ? String.valueOf(this.getEnclosingPackage()) + "::" + this.enclosingStruct.getName() + "." : "") + this.getName();
    }

    public String getEnclosingPackage() {
        return this.enclosingStruct.getPackageName();
    }
}

