/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.specador.ArgumentWrapper;
import ro.amiq.edt.specador.Wrapper;

public class MethodWrapper
extends Wrapper {
    RfMethod method;
    private RfStruct parent;

    public MethodWrapper(SpecadorModel model, RfMethod method) {
        super(model, (RfNamedElement)method);
        this.method = method;
    }

    public void setParent(RfStruct parent) {
        this.parent = parent;
    }

    public RfStruct getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public String getParentName() {
        return this.parent.getName();
    }

    public String getParentPackageName() {
        return this.parent.getPackageName();
    }

    public String getLinkToParent() {
        if (this.parent.isPredefined() || this.parent instanceof RfPredefinedStruct) {
            return "";
        }
        return this.getLinkToRef((IRfNamedElement)this.parent);
    }

    public String getLinkToPackage() {
        return this.getLinkToRef((IRfNamedElement)this.parent.getRfProject().getPackage(this.getParentPackageName()));
    }

    public String getLinkToParentMethod() {
        if (this.parent.isPredefined() || this.parent instanceof RfPredefinedStruct) {
            return "";
        }
        RfMethod localMethod = this.parent.getLocalMethod(this.method.getName());
        if (localMethod == null) {
            return "";
        }
        return this.getLinkToRef((IRfNamedElement)localMethod);
    }

    public String getReturnTypeName() {
        return this.method.getAssociatedFullTypeName() == null ? "void" : this.method.getAssociatedFullTypeName();
    }

    public List<ArgumentWrapper> getFunctionArgumentsList() {
        ArrayList<ArgumentWrapper> result = new ArrayList<ArgumentWrapper>();
        RfMethodLayer declaration = (RfMethodLayer)this.method.getDeclaration(true);
        if (declaration == null) {
            return result;
        }
        List arguments = declaration.getArgumentsWithPrefix(2, "");
        if (arguments == null || arguments.isEmpty()) {
            return result;
        }
        arguments.stream().forEach(a -> {
            boolean bl = result.add(new ArgumentWrapper(this.getModel(), (RfArg)a));
        });
        return result;
    }

    public IRfNamedElement getReturnType() {
        RfType type;
        block7: {
            try {
                type = this.method.getAssociatedBaseType();
                if (type != null) break block7;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        if (type instanceof RfStruct) {
            return type;
        }
        if (type instanceof RfListType) {
            return ((RfListType)type).getAssociatedType();
        }
        if (type instanceof IRfAssociatedType) {
            return ((IRfAssociatedType)type).getResolvedType(true);
        }
        if (type instanceof RfScalarType) {
            return type;
        }
        return null;
    }

    public String getLinkToReturnType() {
        return this.getLinkToRef(this.getReturnType());
    }

    public String getQualifiers() {
        if (this.method.isPrivate()) {
            return "private";
        }
        if (this.method.isProtected()) {
            return "protected";
        }
        if (this.method.isPackage()) {
            return "package";
        }
        return "";
    }

    @Override
    public String getDeterminant() {
        return super.getDeterminant().replace(this.method.getParentStruct().getName(), "");
    }

    public List<SpecadorCommentWrapper> getComment() {
        if (!this.method.isByEvent()) {
            return super.getComment();
        }
        LinkedList<SpecadorCommentWrapper> result = new LinkedList<SpecadorCommentWrapper>();
        List layers = this.method.getLayers();
        for (RfDefElement layer : layers) {
            if (layer.isEmptyLayer()) continue;
            result.addAll(this.getComment(layer.getLayerCommentBlock()));
        }
        return result;
    }

    public String getSamplingEvent() {
        if (!this.method.isTCM()) {
            return "";
        }
        String eventName = this.method.getEvent() != null ? "@" + this.method.getEvent() : "";
        return eventName;
    }

    public String getSamplingEventUrl() {
        if (!this.method.isTCM()) {
            return "";
        }
        if (this.method.getEvent() == null) {
            return "";
        }
        String eventName = this.method.getEvent();
        if (eventName.contains(".")) {
            String[] split = DVTStringUtil.split((String)".", (String)eventName);
            RfField field = this.method.getParentStruct().getField(split[0]);
            if (field == null) {
                return "";
            }
            eventName = DVTStringUtil.replace((String)eventName, (String)split[0], (String)field.getAssociatedTypeName(), (boolean)true);
        }
        RfStruct struct = this.method.getParentStruct();
        RfEvent event = struct.getEvent(eventName);
        return this.getLinkToRef((IRfNamedElement)event);
    }

    public int getOffset() {
        if (!this.method.isByEvent()) {
            return super.getOffset();
        }
        List layers = this.method.getLayers();
        for (RfDefElement layer : layers) {
            if (layer.isEmptyLayer()) continue;
            return layer.getStartOffset();
        }
        return super.getOffset();
    }

    public IRfFileDef getFileDef() {
        if (!this.method.isByEvent()) {
            return super.getFileDef();
        }
        List layers = this.method.getLayers();
        for (RfDefElement layer : layers) {
            if (layer.isEmptyLayer()) continue;
            return layer.getLayerModule();
        }
        return super.getFileDef();
    }

    public String getDeclarationLocation() {
        if (!this.method.isByEvent()) {
            return super.getDeclarationLocation();
        }
        List layers = this.method.getLayers();
        for (RfDefElement layer : layers) {
            if (layer.isEmptyLayer() || layer.getDefFile() == null) continue;
            return ((IRfScopeElement)layer.getDefFile()).getName();
        }
        return super.getDeclarationLocation();
    }

    public String getDeclarationLine() {
        if (!this.method.isByEvent()) {
            return super.getDeclarationLine();
        }
        List layers = this.method.getLayers();
        for (RfDefElement layer : layers) {
            if (layer.isEmptyLayer()) continue;
            return String.valueOf(layer.getStartLine()).replace(",", "");
        }
        return super.getDeclarationLine();
    }

    @Override
    protected RfModule getModule() {
        if (!this.method.isByEvent()) {
            return super.getModule();
        }
        List layers = this.method.getLayers();
        for (RfDefElement layer : layers) {
            if (layer.isEmptyLayer()) continue;
            return layer.getLayerModule();
        }
        return super.getModule();
    }

    public List<String> getFunctionArguments() {
        return this.getFunctionArgumentsList().stream().map(argument -> argument.getName()).collect(Collectors.toList());
    }
}

