/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IPackageWrapper;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.specador.ScalarWrapper;
import ro.amiq.edt.specador.UnitWrapper;
import ro.amiq.edt.specador.Wrapper;

public class PackageWrapper
extends Wrapper
implements IPackageWrapper {
    RfStruct pkg;
    private RfProject project;

    public PackageWrapper(SpecadorModel model, RfStruct namedElement, RfProject project) {
        super(model, (RfNamedElement)namedElement);
        this.pkg = namedElement;
        this.project = project;
    }

    public String getPackageName() {
        return this.pkg.getName();
    }

    private List<IFreeMarkerWrapper> getStructsByCondition(Predicate<RfStruct> condition) {
        List allStructs = this.project.getAllStructs();
        return allStructs.stream().filter(str -> str.getPackageName().equals(this.pkg.getName()) && condition.test((RfStruct)str) && str.getModule() != null && !str.getModule().isDefinedInTest()).filter(str -> !LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)str)).map(struct -> new UnitWrapper(this.getModel(), (RfStruct)struct)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getStructs() {
        return this.getStructsByCondition(str -> !str.isUnit() && !str.isSequence());
    }

    public List<IFreeMarkerWrapper> getUnits() {
        return this.getStructsByCondition(str -> str.isUnit());
    }

    public List<IFreeMarkerWrapper> getSequences() {
        return this.getStructsByCondition(str -> str.isSequence());
    }

    public List<IFreeMarkerWrapper> getScalars() {
        return this.pkg.getTypes().stream().filter(type -> type instanceof RfScalarType && type.getModule() != null && !type.getModule().isDefinedInTest()).filter(type -> !LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)type)).map(type -> new ScalarWrapper(this.getModel(), (RfScalarType)type)).collect(Collectors.toList());
    }

    public int getNumberOfClasses() {
        return (int)this.project.getAllStructs().stream().filter(str -> str.getPackageName().equals(this.pkg.getName()) && str.getModule() != null && !str.getModule().isDefinedInTest() && !LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)str)).count();
    }
}

