/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.specador.EnumItemWrapper;
import ro.amiq.edt.specador.Wrapper;

public class ScalarWrapper
extends Wrapper {
    RfScalarType scalar;
    private int offset;

    ScalarWrapper(SpecadorModel model, RfScalarType scalar) {
        super(model, (RfNamedElement)scalar);
        this.scalar = scalar;
        this.offset = scalar.getOffset();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<EnumItemWrapper> getEnumItems() {
        ArrayList<EnumItemWrapper> result = new ArrayList<EnumItemWrapper>();
        List layers = this.scalar.getLayers();
        if (layers == null || layers.isEmpty()) {
            return result;
        }
        for (RfDefElement layer : layers) {
            List<RfEnum> enums;
            RfModule layerModule = layer.getLayerModule();
            if (layerModule == null || layerModule.isDefinedInTest() || (enums = this.getEnumItemsFromLayer(layer)) == null || enums.isEmpty()) continue;
            result.addAll(enums.stream().map(enumItem -> new EnumItemWrapper(this.getModel(), (RfEnum)enumItem)).collect(Collectors.toList()));
        }
        return result;
    }

    private List<RfEnum> getEnumItemsFromLayer(RfDefElement layer) {
        if (!(layer instanceof RfScalarTypeLayer)) {
            return Collections.emptyList();
        }
        RfScalarTypeLayer scalarTypeLayer = (RfScalarTypeLayer)layer;
        Collection enums = scalarTypeLayer.getEnums();
        if (enums == null || enums.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<RfEnum>(enums);
    }

    public String getDocumentationLocation(File codeLocation) {
        String packageName = this.scalar.getPackageName();
        String documentationPath = SpecadorConstants.getMessage((String)SpecadorConstants.documentationLocation, (Object[])new Object[]{this.getFullPath(), packageName});
        StringBuilder link = new StringBuilder(codeLocation.toPath().relativize(Paths.get(documentationPath, new String[0])).toString());
        link.append("#").append(this.getID());
        return link.toString();
    }
}

