/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.ITestWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.edt.base.model.reflection.RfAssert;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.specador.CheckWrapper;
import ro.amiq.edt.utils.EDTLinkResolver;

public class SpecadorELinkResolver
extends EDTLinkResolver {
    private static SpecadorELinkResolver instance;
    private SpecadorModel model;

    private SpecadorELinkResolver() {
    }

    public static SpecadorELinkResolver getInstance() {
        if (instance == null) {
            instance = new SpecadorELinkResolver();
        }
        return instance;
    }

    public void setModel(SpecadorModel model) {
        this.model = model;
    }

    public String linkInternalDocumentation(IRfNamedElement element, String linkElementName, String label, ITextEditor editor) {
        ArrayList<IRfNamedElement> candidates;
        Object[] parsedLink;
        int indexOfPackageDelimiter;
        boolean isAbsolutePath = false;
        String packageName = "";
        String originalLinkElementName = label;
        if (linkElementName.contains("#")) {
            linkElementName = linkElementName.substring(0, linkElementName.indexOf("#")).trim();
        }
        if ((indexOfPackageDelimiter = linkElementName.indexOf("::")) > 0 && !(packageName = linkElementName.substring(0, indexOfPackageDelimiter)).isEmpty() && !packageName.contains(".")) {
            linkElementName = linkElementName.substring(indexOfPackageDelimiter + 2);
            isAbsolutePath = true;
        }
        if (CommentUtils.getInstance().containsUnpermittedPatterns(linkElementName)) {
            return "";
        }
        boolean startsLikeAMacro = linkElementName.contains("`");
        if (startsLikeAMacro) {
            linkElementName = linkElementName.substring(1);
        }
        if ((parsedLink = DVTStringUtil.split((Pattern)CommentConstants.LINK_SPLIT_PATTERN, (String)DVTStringUtil.unescapeXMLString((String)linkElementName, (boolean)true))).length == 0 || startsLikeAMacro && parsedLink.length > 1) {
            return "";
        }
        parsedLink = CommentUtils.getInstance().cleanArray((String[])parsedLink);
        List<Object> list = candidates = isAbsolutePath ? this.getPackageCandidates(packageName, this.model.getProject()) : this.getInitialCandidates(element, null);
        if ((candidates == null || candidates.isEmpty()) && isAbsolutePath) {
            candidates = this.getInitialCandidates(element, null);
            parsedLink = (String[])ArrayUtils.add((Object[])parsedLink, (int)0, (Object)packageName);
            isAbsolutePath = false;
        }
        if (candidates == null) {
            candidates = new ArrayList<IRfNamedElement>();
        }
        if (!isAbsolutePath) {
            candidates.add(element);
        }
        try {
            IRfNamedElement foundElement = this.solveHyperlinkForAllCandidates(element, candidates, (String[])parsedLink, System.currentTimeMillis() + 500L);
            if (foundElement == null) {
                foundElement = this.getTest((String)parsedLink[0]);
            }
            if (foundElement != null) {
                return this.createLinkToElement(element, foundElement, originalLinkElementName);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (linkElementName.endsWith("s")) {
            return this.linkInternalDocumentation(element, linkElementName.substring(0, linkElementName.length() - 1), originalLinkElementName, editor);
        }
        return "";
    }

    private IRfNamedElement getTest(String testName) {
        List tests = LanguageContributor.get((LanguageKind)LanguageKind.E).getTests(this.model.getProject());
        for (ITestWrapper test : tests) {
            if (!test.getName().equals(testName)) continue;
            return test.getNamedElement();
        }
        return null;
    }

    protected String createLinkToElement(IRfNamedElement commentOrigin, IRfNamedElement element, String elementName) {
        if (!(element instanceof RfNamedElement) || !this.isDocumented((RfNamedElement)element)) {
            return elementName;
        }
        if (this.model.isForPDF()) {
            return "[" + elementName.replace("_", "\\\\_") + "](" + this.getID(element) + ")";
        }
        String extension = ".html";
        String anchor = "#";
        String link = this.getLinkToElement((RfNamedElement)element, extension, anchor);
        if (link.isEmpty()) {
            return "";
        }
        return CommentUtils.getInstance().wrapIntoA(link, elementName, true);
    }

    private boolean isDocumented(RfNamedElement element) {
        if (LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)element)) {
            return false;
        }
        if (element instanceof RfMacro) {
            return this.model.isExportEdtMacros();
        }
        if (element instanceof RfModule && ((RfModule)element).isDefinedInTest()) {
            return this.model.isExportEdtTests();
        }
        String packageName = this.getPackageName(element);
        if (packageName == null || packageName.isEmpty()) {
            return this.model.isExportEdtPackages();
        }
        return this.model.getEdtSelectedPackageNames().contains(packageName);
    }

    protected String getPackageName(RfNamedElement element) {
        String packageName = "";
        if (element instanceof RfType) {
            packageName = ((RfType)element).getPackageName();
        }
        if (element instanceof RfStructMember) {
            packageName = ((RfStructMember)element).getPackageName();
        }
        if (element instanceof RfAssert) {
            packageName = ((RfAssert)element).getPackageName();
        }
        if (element instanceof RfCheckThat) {
            packageName = ((RfCheckThat)element).getPackageName();
        }
        return packageName;
    }

    protected String getModuleName(RfModule module) {
        String moduleName = module.getName();
        if (moduleName.contains(".")) {
            moduleName = moduleName.substring(0, moduleName.lastIndexOf("."));
        }
        return moduleName;
    }

    public String getKind(IRfNamedElement element) {
        return LanguageContributor.get((LanguageKind)element.getLanguageKind()).getKind(element);
    }

    public String getFullNameLabel(IRfNamedElement element) {
        return LanguageContributor.get((LanguageKind)element.getLanguageKind()).getFullNameLabel(element);
    }

    public String getID(IRfNamedElement element) {
        return SpecadorConstants.getMessage((String)SpecadorConstants.elementID, (Object[])new Object[]{this.getKind(element), this.getFullNameLabel(element)});
    }

    public String getLinkToRef(IRfNamedElement type) {
        if (type == null || type.isPredefined()) {
            return "";
        }
        if (this.isDocumented((RfNamedElement)type)) {
            return this.getID(type);
        }
        return "";
    }

    private String getLocation(RfNamedElement element) {
        boolean definedInTest = element.getModule() != null && element.getModule().isDefinedInTest();
        StringBuilder location = new StringBuilder();
        location.append(definedInTest ? "tests/" : "packages/");
        location.append(definedInTest ? this.getModuleName(element.getModule()) : this.getPackageName(element));
        return location.toString();
    }

    public String getLinkToType(RfNamedElement element, String extension, String anchor) {
        if (element == null || element.isPredefined() || !this.isDocumented(element)) {
            return "";
        }
        if (element instanceof RfModule) {
            String moduleName = this.getModuleName((RfModule)element);
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{"tests/" + moduleName, String.valueOf(moduleName) + extension, anchor, this.getID((IRfNamedElement)element)});
        }
        if (element instanceof RfStruct) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{this.getLocation(element), String.valueOf(element.getName()) + extension, anchor, this.getID((IRfNamedElement)element)});
        }
        if (element instanceof RfScalarType) {
            boolean definedInTest = element.getModule() != null && element.getModule().isDefinedInTest();
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{this.getLocation(element), String.valueOf(definedInTest ? this.getModuleName(element.getModule()) : this.getPackageName(element)) + extension, anchor, this.getID((IRfNamedElement)element)});
        }
        return "";
    }

    public String getLinkToElement(RfNamedElement element, String extension, String anchor) {
        String link = this.getLinkToType(element, extension, anchor);
        if (!link.isEmpty()) {
            return link;
        }
        if (element.isPredefined()) {
            return "";
        }
        if (element instanceof RfStructMember) {
            RfStruct enclosingScope = ((RfStructMember)element).getParentStruct();
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{this.getLocation((RfNamedElement)enclosingScope), String.valueOf(enclosingScope.getName()) + extension, anchor, this.getID((IRfNamedElement)element)});
        }
        if ((element instanceof RfAssert || element instanceof RfCheckThat || element instanceof RfExpect) && new CheckWrapper(this.model, element).isAnonymous()) {
            return "";
        }
        if (element instanceof RfAssert) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{this.getLocation(element), String.valueOf(((RfAssert)element).getStructName()) + extension, anchor, this.getID((IRfNamedElement)element)});
        }
        if (element instanceof RfCheckThat) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{this.getLocation(element), String.valueOf(((RfCheckThat)element).getStructName()) + extension, anchor, this.getID((IRfNamedElement)element)});
        }
        if (element instanceof RfMacro) {
            return SpecadorConstants.getMessage((String)SpecadorConstants.linkLocation, (Object[])new Object[]{".", "index-macros" + extension, anchor, this.getID((IRfNamedElement)element)});
        }
        return "";
    }
}

