/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.semantic.RfStructQualifier;
import ro.amiq.edt.specador.UnitWrapper;
import ro.amiq.edt.specador.Wrapper;

public class SubtypeWrapper
extends Wrapper {
    private RfStructLayer layer;

    public SubtypeWrapper(SpecadorModel model, RfStructLayer layer) {
        super(model, layer.getNamedElement());
        this.layer = layer;
    }

    public String getName() {
        Determinant determinant = this.layer.getDeterminant();
        return determinant != null ? determinant.toString().replace(this.layer.getStruct().getName(), "").trim() : "";
    }

    public Map<String, String> getQualifiers() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List structQualifiers = this.layer.getStructQualifiers();
        if (structQualifiers == null) {
            return result;
        }
        for (RfStructQualifier qualifier : structQualifiers) {
            RfEnum enumm = qualifier.getEnum();
            if (enumm == null) {
                result.put(qualifier.getName(), "");
                continue;
            }
            StringBuilder name = new StringBuilder(enumm.getName());
            name.append("'").append(qualifier.getElement().getName());
            String associatedType = this.getLinkToRef((IRfNamedElement)enumm.getAssociatedType());
            result.put(this.formatSpecialCharacters(name.toString()), associatedType);
        }
        return result;
    }

    public UnitWrapper getStruct() {
        return new UnitWrapper(this.getModel(), this.layer.getStruct());
    }

    public boolean structHasLink() {
        RfStruct struct = this.layer.getStruct();
        return this.getModel().getEdtSelectedPackageNames().contains(struct.getPackageName()) && !struct.isPredefined();
    }

    public String getID() {
        return String.valueOf(this.getName().replace(" ", "-")) + "-" + super.getID();
    }

    @Override
    public CommentBlock getCommentBlock() {
        return this.layer.getLayerCommentBlock();
    }
}

