/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.ITestWrapper;
import ro.amiq.dvt.specador.templates.IUnitWrapper;
import ro.amiq.dvt.specador.templates.SpecadorCommentWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.specador.ScalarWrapper;
import ro.amiq.edt.specador.SubtypeWrapper;
import ro.amiq.edt.specador.UnitWrapper;
import ro.amiq.edt.specador.Wrapper;

public class TestWrapper
extends Wrapper
implements ITestWrapper {
    private RfModule test;

    public TestWrapper(SpecadorModel model, RfModule test) {
        super(model, (RfNamedElement)test);
        this.test = test;
    }

    public String getName() {
        String fileName = this.test.getName();
        if (!fileName.contains(".")) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public String getDeclarationLine() {
        return "0";
    }

    @Override
    protected RfModule getModule() {
        return this.test;
    }

    public String getDeclarationLocation() {
        return this.test.getName();
    }

    public List<SpecadorCommentWrapper> getComment() {
        StringBuilder comment = new StringBuilder();
        File sourceCodeFile = new File(this.test.getParserPath().path);
        if (!sourceCodeFile.exists()) {
            return Collections.emptyList();
        }
        String content = DVTFileUtils.getInstance().readFileContent(sourceCodeFile);
        int codeSegmentOffset = content.indexOf("\n<'");
        if (codeSegmentOffset < 0) {
            return Collections.emptyList();
        }
        comment.append(this.clearComment(content.substring(0, codeSegmentOffset), Comment.CommentStyle.ML_KIND));
        return this.splitComment(comment).stream().filter(cw -> !cw.getContent().trim().isEmpty()).collect(Collectors.toList());
    }

    public List<? extends IFreeMarkerWrapper> getSubtypes() {
        List subTypeLayers = this.test.getChildren();
        if (subTypeLayers == null) {
            return Collections.emptyList();
        }
        LinkedList<SubtypeWrapper> subtypes = new LinkedList<SubtypeWrapper>();
        for (RfDefElement layer : subTypeLayers) {
            if (!(layer instanceof RfStructLayer) || !layer.isExtend() && !layer.isWhen() || LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)layer.getNamedElement())) continue;
            SubtypeWrapper subtype = new SubtypeWrapper(this.getModel(), (RfStructLayer)layer);
            if (subtypes.stream().anyMatch(element -> element.getName().equals(subtype.getName()))) continue;
            subtypes.add(subtype);
        }
        return subtypes;
    }

    public List<IUnitWrapper> getStructs() {
        return this.getStructByType(struct -> struct.isUnit() || struct.isSequence());
    }

    public List<IUnitWrapper> getUnits() {
        return this.getStructByType(struct -> !struct.isUnit());
    }

    public List<IUnitWrapper> getSequences() {
        return this.getStructByType(struct -> !struct.isSequence());
    }

    private List<IUnitWrapper> getStructByType(Predicate<RfStruct> condition) {
        List subTypeLayers = this.test.getChildren();
        if (subTypeLayers == null) {
            return Collections.emptyList();
        }
        LinkedList<IUnitWrapper> structs = new LinkedList<IUnitWrapper>();
        for (RfDefElement layer : subTypeLayers) {
            RfStruct struct;
            if (!(layer instanceof RfStructLayer) || !(layer.getNamedElement() instanceof RfStruct) || layer.isExtend() || layer.isWhen() || LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)layer.getNamedElement()) || condition.test(struct = (RfStruct)layer.getNamedElement())) continue;
            UnitWrapper subtype = new UnitWrapper(this.getModel(), struct, true);
            structs.add(subtype);
        }
        return structs;
    }

    public List<IFreeMarkerWrapper> getScalars() {
        List subTypeLayers = this.test.getChildren();
        if (subTypeLayers == null) {
            return Collections.emptyList();
        }
        HashSet<RfScalarType> scalars = new HashSet<RfScalarType>();
        for (RfDefElement layer : subTypeLayers) {
            if (!(layer instanceof RfScalarTypeLayer) || !(layer.getNamedElement() instanceof RfScalarType) || LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)layer.getNamedElement())) continue;
            scalars.add((RfScalarType)layer.getNamedElement());
        }
        return scalars.stream().map(scalar -> new ScalarWrapper(this.getModel(), (RfScalarType)scalar)).collect(Collectors.toList());
    }
}

