/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.SpecadorProgressMonitor;
import ro.amiq.dvt.specador.templates.FreeMarkerFileGenerator;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.specador.templates.IUnitWrapper;
import ro.amiq.dvt.specador.templates.SpecadorConstants;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.dvt.wizards.specador.SpecadorSVGDiagramFactory;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.diagrams.uml.model.EUMLModel;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfEventLayer;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.core.EPluginConfig;
import ro.amiq.edt.specador.CheckWrapper;
import ro.amiq.edt.specador.EventWrapper;
import ro.amiq.edt.specador.FieldWrapper;
import ro.amiq.edt.specador.MethodWrapper;
import ro.amiq.edt.specador.SpecadorELinkResolver;
import ro.amiq.edt.specador.SubtypeWrapper;
import ro.amiq.edt.specador.Wrapper;

public class UnitWrapper
extends Wrapper
implements IUnitWrapper {
    RfStruct struct;
    private int offset;
    private boolean definedInTest;
    private static final String PACKAGE_UNIT_SEPARATOR = " :: ";
    private static final String LINK_END = ">`";
    private static final String FILE_SEPARATOR = "/";
    private static final String LINK_START = " <../../";
    private static final String DOC_START = ":doc:`";

    UnitWrapper(SpecadorModel model, RfStruct namedElement, boolean definedInTest) {
        this(model, namedElement);
        this.definedInTest = definedInTest;
    }

    UnitWrapper(SpecadorModel model, RfStruct namedElement) {
        super(model, (RfNamedElement)namedElement);
        this.struct = namedElement;
        this.offset = this.struct.getOffset();
    }

    public String getUnitType() {
        if (!this.struct.isUnit() && !this.struct.isSequence()) {
            return "Struct";
        }
        if (this.struct.isUnit()) {
            return "Unit";
        }
        if (this.struct.isSequence()) {
            return "Sequence";
        }
        return "";
    }

    private String getPackageName() {
        return this.struct.getPackageName() != null ? this.struct.getPackageName() : "";
    }

    public List<IFreeMarkerWrapper> getFields() {
        return this.struct.getFields().stream().filter(field -> !LanguageContributor.get((LanguageKind)field.getLanguageKind()).shouldFilter((IRfNamedElement)field) && field instanceof RfField).filter(field -> (!(field.getAssociatedType() instanceof RfStruct) || !((RfStruct)field.getAssociatedType()).isLike("any_port")) && !((RfField)field).isPort()).filter(field -> this.definedInTest || field.getFirstLayer() != null && field.getFirstLayer().getLayerModule() != null && !field.getFirstLayer().getLayerModule().isDefinedInTest()).map(field -> new FieldWrapper(this.getModel(), (RfField)field)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getPorts() {
        return this.struct.getFields().stream().filter(field -> !LanguageContributor.get((LanguageKind)field.getLanguageKind()).shouldFilter((IRfNamedElement)field) && field instanceof RfField).filter(field -> ((RfField)field).isPort() && (this.definedInTest || field.getFirstLayer() != null && field.getFirstLayer().getLayerModule() != null && !field.getFirstLayer().getLayerModule().isDefinedInTest())).map(field -> new FieldWrapper(this.getModel(), (RfField)field)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getMethods() {
        return this.struct.getMethods().stream().filter(method -> !LanguageContributor.get((LanguageKind)method.getLanguageKind()).shouldFilter((IRfNamedElement)method) && (this.definedInTest || method.getModule() != null && !method.getModule().isDefinedInTest())).filter(method -> method instanceof RfMethod && this.struct.equals(((RfMethod)method).getMethodInLikeParent(true)) && !((RfMethod)method).isTCM() && !this.isByEvent((RfMethod)method)).map(method -> new MethodWrapper(this.getModel(), (RfMethod)method)).collect(Collectors.toList());
    }

    private boolean isByEvent(RfMethod method) {
        return method.isByEvent() && (method.hasNoLayers() || method.getLayers().stream().allMatch(layer -> layer.isEmptyLayer()));
    }

    public List<IFreeMarkerWrapper> getTCMs() {
        return this.struct.getMethods().stream().filter(method -> !LanguageContributor.get((LanguageKind)method.getLanguageKind()).shouldFilter((IRfNamedElement)method) && (this.definedInTest || method.getModule() != null && !method.getModule().isDefinedInTest())).filter(method -> method instanceof RfMethod && this.struct.equals(((RfMethod)method).getMethodInLikeParent(true)) && ((RfMethod)method).isTCM()).map(method -> new MethodWrapper(this.getModel(), (RfMethod)method)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getEvents() {
        return this.struct.getEvents().stream().filter(event -> !LanguageContributor.get((LanguageKind)event.getLanguageKind()).shouldFilter((IRfNamedElement)event) && (this.definedInTest || event.getModule() != null && !event.getModule().isDefinedInTest())).filter(event -> this.struct.equals(((RfEvent)event).getEventInLikeParent(RfEventLayer.class, true))).map(event -> new EventWrapper(this.getModel(), (RfEvent)event, this.struct)).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getSubtypes() {
        List layers = this.struct.getSubTypeLayers();
        if (layers == null) {
            return Collections.emptyList();
        }
        return layers.stream().filter(layer -> layer.getLayerModule() != null && !layer.getLayerModule().isDefinedInTest()).map(layer -> new SubtypeWrapper(this.getModel(), (RfStructLayer)layer)).sorted(this.alphabeticComparator).collect(Collectors.toList());
    }

    public List<IFreeMarkerWrapper> getChecks() {
        LinkedList<IFreeMarkerWrapper> result = new LinkedList<IFreeMarkerWrapper>();
        List candidates = this.struct.getExpects();
        HashSet checksAndAsserts = new HashSet();
        for (RfStructMember candidate : candidates) {
            if (!(candidate instanceof RfExpect) || LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)candidate)) continue;
            result.add(new CheckWrapper(this.getModel(), (RfNamedElement)candidate, this.struct));
        }
        List layers = this.struct.getLayers();
        if (layers == null) {
            return result;
        }
        for (RfDefElement layer : layers) {
            RfModule layerModule = layer.getLayerModule();
            if (layerModule == null || layerModule.isDefinedInTest()) continue;
            List checks = layerModule.getCheckThatActions();
            checksAndAsserts.addAll(checks.stream().filter(check -> this.getName().equals(check.getStructName()) && this.getPackageName().equals(check.getPackageName())).filter(check -> !LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)check)).collect(Collectors.toSet()));
            List asserts = layerModule.getAssertActions();
            checksAndAsserts.addAll(asserts.stream().filter(check -> this.getName().equals(check.getStructName()) && this.getPackageName().equals(check.getPackageName())).filter(check -> !LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)check)).collect(Collectors.toSet()));
        }
        result.addAll(checksAndAsserts.stream().map(check -> new CheckWrapper(this.getModel(), (RfNamedElement)check, this.struct)).collect(Collectors.toList()));
        result.sort((o1, o2) -> ((CheckWrapper)o1).getExpression().compareTo(((CheckWrapper)o2).getExpression()));
        return result;
    }

    public List<String> getStructHierarchy(boolean isPreview) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.struct.getParentStruct() == null) {
            return result;
        }
        RfStruct parent = this.struct;
        ArrayList<RfStruct> hierarchy = new ArrayList<RfStruct>();
        hierarchy.add(parent);
        while (parent.getParentStruct() != null) {
            if (hierarchy.contains(parent = parent.getParentStruct())) break;
            hierarchy.add(parent);
        }
        for (RfStruct struct : hierarchy) {
            boolean definedInTest = struct.getFirstLayer() != null && struct.getFirstLayer().getLayerModule() != null && struct.getFirstLayer().getLayerModule().isDefinedInTest();
            String packageName = struct.getPackageName();
            StringBuilder sb = new StringBuilder();
            if (!this.getModel().getEdtSelectedPackageNames().contains(packageName) || isPreview) {
                sb.append(packageName).append(PACKAGE_UNIT_SEPARATOR).append(struct.getName());
            } else {
                sb.append(DOC_START).append(packageName);
                sb.append(LINK_START).append("packages/").append(packageName).append(FILE_SEPARATOR).append(packageName).append(LINK_END);
                sb.append(PACKAGE_UNIT_SEPARATOR);
                if (struct.isPredefined() || isPreview) {
                    sb.append(struct.getName());
                } else {
                    sb.append(DOC_START).append(struct.getName());
                    String location = definedInTest ? SpecadorELinkResolver.getInstance().getModuleName(struct.getModule()) : struct.getPackageName();
                    sb.append(LINK_START).append(definedInTest ? "tests/" : "packages/").append(location).append(FILE_SEPARATOR).append(struct.getName()).append(LINK_END);
                }
            }
            result.add(0, sb.toString());
        }
        return result;
    }

    public void addLinks(List<String> segments, List<String> insertions, File codeLocation, IRfFileDef file) {
        this.addLinksToAPI(segments, insertions, this.getMethods(), codeLocation, file);
        this.addLinksToAPI(segments, insertions, this.getTCMs(), codeLocation, file);
        this.addLinksToAPI(segments, insertions, this.getEvents(), codeLocation, file);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean generateUMLInheritanceDiagram(File location, IProgressMonitor progressMonitor) {
        SpecadorModel model = this.getModel();
        if (!model.getUMLClassInheritanceDiagram()) {
            return false;
        }
        if ((this.struct.getChildStructs() == null || this.struct.getChildStructs().isEmpty()) && (this.struct.getSubTypeLayers() == null || this.struct.getSubTypeLayers().isEmpty())) {
            return false;
        }
        ArrayList<RfStruct> elements = new ArrayList<RfStruct>();
        elements.add(this.struct);
        UMLDiagramConfiguration config = UMLDiagramConfiguration.getSpecadorConfig((boolean)model.getOrthogonalClassDiagrams());
        EUMLModel umlModel = EUMLModel.createModel((UMLDiagramConfiguration)config, (IProject)model.getProject(), (IEPluginConfig)EPluginConfig.getInstance());
        umlModel.setDiagramKind(UMLModel.DiagramKind.INHERITANCE);
        umlModel.setRightTypes(elements);
        umlModel.publicAssociationsOnly = model.isPublicOnlyAPI();
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"uml", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.E.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newUMLDiagram((String)this.getName(), (UMLModel)umlModel, (String)"", (boolean)true, (LanguageKind)LanguageKind.E);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)model, (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    public boolean generateUMLCollaborationDiagram(File location, IProgressMonitor progressMonitor) {
        SpecadorModel model = this.getModel();
        if (!model.getUMLCollaborationDiagram()) {
            return false;
        }
        List fields = this.struct.getFields();
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        boolean hasAssociations = false;
        for (RfStructMember field : fields) {
            RfType associatedType = field.getAssociatedType();
            if (field.getFullName() != null && field.getFullName().getDeterminant() != null && !field.getFullName().getDeterminant().equals((Object)this.struct.getDeterminant()) || field instanceof RfField && ((RfField)field).isPort()) continue;
            if (associatedType instanceof RfListType) {
                associatedType = ((RfListType)associatedType).getAssociatedType();
            }
            if (field.isPrivate() || !(associatedType instanceof RfStruct) || associatedType instanceof RfPredefinedStruct || ((RfStruct)associatedType).equals(this.struct)) continue;
            hasAssociations = true;
        }
        if (!hasAssociations) {
            return false;
        }
        ArrayList<RfNamedElement> elements = new ArrayList<RfNamedElement>();
        elements.add(this.namedElement);
        UMLDiagramConfiguration config = UMLDiagramConfiguration.getSpecadorCollaborationConfig((boolean)model.getOrthogonalClassDiagrams());
        EUMLModel umlModel = EUMLModel.createModel((UMLDiagramConfiguration)config, (IProject)model.getProject(), (IEPluginConfig)EPluginConfig.getInstance());
        umlModel.setDiagramKind(UMLModel.DiagramKind.COLLABORATION);
        umlModel.setRightTypes(elements);
        umlModel.publicAssociationsOnly = model.isPublicOnlyAPI();
        File file = new File(location, SpecadorConstants.getMessage((String)SpecadorConstants.diagramFileName, (Object[])new Object[]{"collaboration", this.getName()}));
        progressMonitor.subTask(SpecadorConstants.getMessage((String)SpecadorConstants.generateFileMessage, (Object[])new Object[]{SpecadorProgressMonitor.SpecadorLanguageKind.E.getName(), file.getName()}));
        String svg = SpecadorSVGDiagramFactory.newUMLDiagram((String)this.getName(), (UMLModel)umlModel, (String)"", (boolean)true, (LanguageKind)LanguageKind.E);
        location.mkdirs();
        return FreeMarkerFileGenerator.writeFileContent((SpecadorModel)model, (File)file, (String)svg, (IProgressMonitor)progressMonitor, (int)0);
    }

    public List<IFreeMarkerWrapper> getExtendedMethods() {
        LinkedList<IFreeMarkerWrapper> result = new LinkedList<IFreeMarkerWrapper>();
        RfStruct parent = this.struct;
        while ((parent = parent.getParentStruct()) != null) {
            List methods = parent.getMethods();
            for (RfStructMember method : methods) {
                RfMethod baseMethod;
                if (LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)method) || (baseMethod = this.struct.getLocalMethod(method.getName())) == null || baseMethod.getModule() == null || baseMethod.getModule().isDefinedInTest() || baseMethod.isTCM() || this.isByEvent(baseMethod)) continue;
                MethodWrapper methodWrapper = new MethodWrapper(this.getModel(), baseMethod);
                methodWrapper.setParent(parent);
                result.add(methodWrapper);
            }
        }
        return result;
    }

    public List<IFreeMarkerWrapper> getExtendedTCMs() {
        LinkedList<IFreeMarkerWrapper> result = new LinkedList<IFreeMarkerWrapper>();
        RfStruct parent = this.struct;
        while ((parent = parent.getParentStruct()) != null) {
            List methods = parent.getMethods();
            for (RfStructMember method : methods) {
                RfMethod baseMethod;
                if (LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)method) || (baseMethod = this.struct.getLocalMethod(method.getName())) == null || baseMethod.getModule() == null || baseMethod.getModule().isDefinedInTest() || !baseMethod.isTCM()) continue;
                MethodWrapper methodWrapper = new MethodWrapper(this.getModel(), baseMethod);
                methodWrapper.setParent(parent);
                result.add(methodWrapper);
            }
        }
        return result;
    }

    public List<IFreeMarkerWrapper> getExtendedEvents() {
        LinkedList<IFreeMarkerWrapper> result = new LinkedList<IFreeMarkerWrapper>();
        RfStruct parent = this.struct;
        while ((parent = parent.getParentStruct()) != null) {
            List events = parent.getEvents();
            for (RfStructMember event : events) {
                RfEvent baseEvent;
                if (LanguageContributor.get((LanguageKind)LanguageKind.E).shouldFilter((IRfNamedElement)event) || (baseEvent = this.struct.getLocalEvent(event.getName())) == null || baseEvent.getModule() == null || baseEvent.getModule().isDefinedInTest()) continue;
                EventWrapper eventWrapper = new EventWrapper(this.getModel(), baseEvent);
                eventWrapper.setParent(parent);
                result.add(eventWrapper);
            }
        }
        return result;
    }
}

