/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.specador;

import java.io.File;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.specador.ScalarWrapper;
import ro.amiq.edt.specador.SpecadorELinkResolver;
import ro.amiq.edt.specador.UnitWrapper;

public abstract class Wrapper
implements IFreeMarkerWrapper {
    protected final RfNamedElement namedElement;
    protected final SpecadorModel model;
    final Comparator<Wrapper> alphabeticComparator = (o1, o2) -> o1.getName().compareTo(o2.getName());

    Wrapper(SpecadorModel model, RfNamedElement namedElement) {
        this.namedElement = namedElement;
        this.model = model;
    }

    public SpecadorModel getModel() {
        return this.model;
    }

    public IRfNamedElement getNamedElement() {
        return this.namedElement;
    }

    public String getKind() {
        return RfKind.of((IRfNamedElement)this.namedElement).getName().replace(" ", "-");
    }

    public CommentBlock getCommentBlock() {
        if (this.namedElement.getDeclaration() == null) {
            return null;
        }
        return this.namedElement.getDeclaration().getLayerCommentBlock();
    }

    public String getFullPath() {
        if (this.getModule() != null && this.getModule().isDefinedInTest()) {
            String testName = this.getModule().getName();
            testName = testName.contains(".") ? testName.substring(0, testName.lastIndexOf(".")) : testName;
            return String.valueOf(super.getFullPath()) + "tests" + File.separator + testName;
        }
        return String.valueOf(super.getFullPath()) + "packages" + File.separator + SpecadorELinkResolver.getInstance().getPackageName(this.namedElement);
    }

    public ICommentLinkResolver getLinker() {
        return SpecadorELinkResolver.getInstance();
    }

    protected RfModule getModule() {
        return this.namedElement.getDeclaration().getLayerModule();
    }

    public String createFileReferenceContent(File codeLocation) {
        LinkedList<Wrapper> list = new LinkedList<Wrapper>();
        RfModule fileDef = this.getModule();
        if (fileDef == null) {
            return "";
        }
        ParserPath parserPath = fileDef.getParserPath();
        List children = fileDef.getChildren();
        for (RfDefElement child : children) {
            RfNamedElement element = child.getNamedElement();
            if (element instanceof RfStruct) {
                UnitWrapper struct = new UnitWrapper(this.getModel(), (RfStruct)element);
                struct.setOffset(child.getStartOffset());
                list.add(struct);
            }
            if (!(element instanceof RfScalarType)) continue;
            ScalarWrapper scalar = new ScalarWrapper(this.getModel(), (RfScalarType)element);
            scalar.setOffset(child.getStartOffset());
            list.add(scalar);
        }
        IPath fileLocation = Path.fromOSString((String)parserPath.toString());
        String sourceCodeFileContent = this.readSourceCodeFileForExporting(fileLocation.toFile());
        LinkedList<String> segments = new LinkedList<String>();
        LinkedList insertions = new LinkedList();
        segments.add(sourceCodeFileContent);
        this.addLinksToPage(segments, insertions, list, codeLocation, (IRfFileDef)fileDef);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < insertions.size()) {
            sb.append(StringEscapeUtils.escapeHtml((String)((String)segments.get(i)))).append((String)insertions.get(i));
            ++i;
        }
        sb.append(StringEscapeUtils.escapeHtml((String)((String)segments.get(segments.size() - 1))));
        return sb.toString();
    }

    public String getLanguageKind() {
        return "eLanguage";
    }

    public String getDeterminant() {
        if (this.namedElement.getFullName() == null || this.namedElement.getFullName().getDeterminant() == null) {
            return "";
        }
        return this.namedElement.getFullName().getDeterminant().toString();
    }

    protected String getLinkToRef(IRfNamedElement element) {
        return SpecadorELinkResolver.getInstance().getLinkToRef(element);
    }

    public String getLinkToElement(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return "";
        }
        String extenstion = this.getModel().isForPDF() ? "" : ".html";
        String anchor = this.getModel().isForPDF() ? ":" : "#";
        return SpecadorELinkResolver.getInstance().getLinkToElement((RfNamedElement)element, extenstion, anchor);
    }
}

