/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ui.editor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.diagrams.chd.ECHDiagramHelper;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedStruct;
import ro.amiq.edt.core.EPluginConfig;
import ro.amiq.edt.ui.editor.EVHBreadcrumbUtilsCommon;

public class EVHBreadcrumbUtils
extends EVHBreadcrumbUtilsCommon {
    private static EVHBreadcrumbUtils INSTANCE;
    private static final Object SYNC_OBJECT;
    private IRfBreadcrumbElement cursorScopeForBreadcrumb;
    protected int editorCursor;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EVHBreadcrumbUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new EVHBreadcrumbUtils();
            }
        }
        return INSTANCE;
    }

    public void openElement(IDVTBreadcrumbHost editor, IProject project, IRfVHBreadcrumbElement vhBCElement, BreadcrumbInput breadcrumbInput) {
        try {
            if (!(vhBCElement instanceof RfFieldLayer) && !(vhBCElement instanceof RfStructLayer)) {
                return;
            }
            List segments = breadcrumbInput.getInputSegments();
            if (segments == null) {
                return;
            }
            if (editor instanceof DVTEditor) {
                if (vhBCElement instanceof RfFieldLayer) {
                    if (this.isInsideMacro(vhBCElement)) {
                        this.openFieldDeclaration(vhBCElement, breadcrumbInput);
                        return;
                    }
                    RfNamedElement namedElement = (RfNamedElement)vhBCElement.getNamedElement();
                    if (namedElement == null) {
                        return;
                    }
                    RfStructLayer structFromField = this.getStructFromField(namedElement);
                    if (structFromField == null) {
                        this.openFieldDeclaration(vhBCElement, breadcrumbInput.removeLastSegment());
                        return;
                    }
                    if (structFromField.getNamedElement() instanceof RfPredefinedStruct) {
                        if (segments.isEmpty()) {
                            return;
                        }
                        segments.remove(segments.size() - 1);
                        this.openFieldDeclaration(vhBCElement, new BreadcrumbInput(project, segments, this.getBreadcrumbSerializer()));
                        return;
                    }
                    this.setBreadcrumbDataAndOpenEditor(breadcrumbInput, structFromField);
                    return;
                }
                this.setBreadcrumbDataAndOpenEditor(breadcrumbInput, (RfStructLayer)vhBCElement);
                return;
            }
            if (editor instanceof DDiagramEditor) {
                IDVTElementWrapper wrapper = this.createElementWrapper(project, vhBCElement);
                if (wrapper == null) {
                    return;
                }
                this.setPathForWrapper(wrapper, segments);
                TreePath treePath = TreePathUtils.getTreePathFromBreadcrumb((List)segments, (IVHLabelProvider)this.vhLabelProvider);
                wrapper.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH, (Object)treePath);
                CHConfig config = new CHConfig(null, LanguageKind.E);
                config.setBreadcrumbInput(new BreadcrumbInput(wrapper.getProject(), segments, this.getBreadcrumbSerializer()));
                ECHDiagramHelper.makeComponentDiagramFor((IEPluginConfig)EPluginConfig.getInstance(), (IDVTElementWrapper)wrapper, (IProject)project, (CHConfig)config);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(e.getMessage());
        }
    }

    private void setBreadcrumbDataAndOpenEditor(BreadcrumbInput breadcrumbInput, RfStructLayer declaration) {
        try {
            IRfFileDef defFile = declaration.getDefFile();
            if (defFile == null) {
                return;
            }
            IFile file = (IFile)defFile.getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)breadcrumbInput);
            DVTFileUtils.getInstance().openEditor(file, declaration.getStartLine(), declaration.getName(), true, defFile.getLanguageKind().EDITOR_ID);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(e.getMessage());
        }
    }

    public void openCreate(IProject project, IRfVHBreadcrumbElement element, BreadcrumbInput breadcrumbInput) {
    }

    protected BreadcrumbInput getPreservedInput(IDVTBreadcrumbHost editor) {
        DVTEditor lastActiveEditor = null;
        for (IEditorReference reference : Utils.getCurrentlyOpenEditorReferences()) {
            IEditorPart lastEditorCandidate = reference.getEditor(false);
            if (!(lastEditorCandidate instanceof DVTEditor) || lastEditorCandidate == editor || lastActiveEditor != null && ((DVTEditor)lastEditorCandidate).fLastFocusedTimestamp <= lastActiveEditor.fLastFocusedTimestamp) continue;
            lastActiveEditor = (DVTEditor)lastEditorCandidate;
        }
        if (lastActiveEditor == null) {
            return null;
        }
        BreadcrumbInput bcCache = lastActiveEditor.getBCCache(VHBreadcrumbViewer.class);
        if (bcCache == null) {
            return null;
        }
        List<BreadcrumbSegment> preservedSegments = this.getPreservedBCSegments(editor, bcCache);
        if (preservedSegments == null || preservedSegments.isEmpty()) {
            return null;
        }
        return new BreadcrumbInput(lastActiveEditor.getProject(), preservedSegments, this.getBreadcrumbSerializer());
    }

    private List<BreadcrumbSegment> getPreservedBCSegments(final IDVTBreadcrumbHost editor, BreadcrumbInput bcInput) {
        List inputSegments;
        if (!(editor instanceof DVTEditor)) {
            return null;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EVHBreadcrumbUtils.this.cursorScopeForBreadcrumb = ((DVTEditor)editor).getCursorScopeForBreadcrumb(false);
            }
        });
        if (!(this.cursorScopeForBreadcrumb instanceof IRfScope)) {
            return null;
        }
        IRfScope cursorScope = (IRfScope)this.cursorScopeForBreadcrumb;
        while (!(cursorScope instanceof RfStructLayer)) {
            if (cursorScope == null) break;
            if (!((cursorScope = cursorScope.getEnclosingScope()) instanceof RfStructLayer) || ((RfStructLayer)cursorScope).isUnit()) continue;
            cursorScope = null;
        }
        if ((inputSegments = bcInput.getInputSegments()) == null) {
            return null;
        }
        for (BreadcrumbSegment segment : inputSegments) {
            if (!this.determinantContains((IRfBreadcrumbElement)cursorScope, segment.getElement())) continue;
            List segmentsUpTo = bcInput.getSegmentsUpTo(segment.getElement());
            return segmentsUpTo;
        }
        return null;
    }

    private boolean determinantContains(IRfBreadcrumbElement containedStructLayer, IRfBreadcrumbElement containerStructLayer) {
        if (containerStructLayer instanceof RfFieldLayer) {
            containerStructLayer = this.getStructFromField(((RfFieldLayer)containerStructLayer).getNamedElement());
        }
        if (!(containerStructLayer instanceof RfStructLayer) || !(containedStructLayer instanceof RfStructLayer)) {
            return false;
        }
        Determinant containerDet = ((RfStructLayer)containerStructLayer).getDeterminant();
        Determinant containedDet = ((RfStructLayer)containedStructLayer).getDeterminant();
        if (containerDet == null || containedDet == null) {
            return false;
        }
        if (containerDet.equals((Object)containedDet)) {
            return true;
        }
        return containerDet.contains(containedDet);
    }

    @Override
    protected int getCursor(final IDVTBreadcrumbHost editor) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EVHBreadcrumbUtils.this.editorCursor = editor.getCursor();
            }
        });
        return this.editorCursor;
    }
}

