/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ui.editor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSerializerRepo;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.StopComputeVHBCInstacePathsException;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbInstancePath;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbInstancePathsResult;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldLayer;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfSpecman;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.VHLabelProvider;
import ro.amiq.edt.base.ui.editor.AbstractEVHBreadcrumbUtils;
import ro.amiq.edt.core.EPluginConfig;
import ro.amiq.edt.model.reflection.RfManager;
import ro.amiq.edt.ui.editor.EVHBreadcrumbSerializer;

public abstract class EVHBreadcrumbUtilsCommon
extends AbstractEVHBreadcrumbUtils {
    protected IVHLabelProvider vhLabelProvider;
    private static final Comparator<RfDefElement> DEF_COMPARATOR = (o1, o2) -> o1.getStartOffset() - o2.getStartOffset();

    public IBreadcrumbSerializer getBreadcrumbSerializer() {
        return BreadcrumbSerializerRepo.getSerializer((LanguageKind)LanguageKind.E, EVHBreadcrumbSerializer.class);
    }

    public VHBreadcrumbUtils getUtils() {
        return this;
    }

    public LanguageKind getNature() {
        return LanguageKind.E;
    }

    public boolean validateScopeForBreadcrumb(IRfBreadcrumbElement elem) {
        return true;
    }

    public RfStructLayer getStructFromField(RfNamedElement element) {
        if (element instanceof RfField) {
            RfType type = ((RfField)element).getAssociatedType();
            Determinant associatedTypeDeterminant = ((RfField)element).getAssociatedTypeDeterminant();
            if (type instanceof RfListType) {
                type = ((RfListType)type).getAssociatedType();
            }
            if (!((RfField)element).isInstance() || !(type instanceof RfStruct)) {
                return null;
            }
            for (RfDefElement layer : ((RfStruct)type).getLayers()) {
                if (!(layer instanceof RfStructLayer) || !associatedTypeDeterminant.equals((Object)((RfStructLayer)layer).getDeterminant())) continue;
                return (RfStructLayer)layer;
            }
            return (RfStructLayer)type.getFirstLayer();
        }
        if (element instanceof RfStruct) {
            Determinant determinant = ((RfStruct)element).getDeterminant();
            for (RfDefElement layer : ((RfStruct)element).getLayers()) {
                if (!(layer instanceof RfStructLayer) || !determinant.equals((Object)((RfStructLayer)layer).getDeterminant())) continue;
                return (RfStructLayer)layer;
            }
            return null;
        }
        return null;
    }

    public IDVTElementWrapper createElementWrapper(IProject project, IRfVHBreadcrumbElement element) {
        Determinant determinant = null;
        if (!(element instanceof RfStructLayer)) {
            element = (IRfVHBreadcrumbElement)element.getNamedElement();
        } else {
            determinant = ((RfStructLayer)element).getDeterminant();
        }
        RfTreeElementWrapper rootTop = new RfTreeElementWrapper((Object)element);
        this.addChildren(rootTop, determinant);
        return rootTop;
    }

    private void addChildren(RfTreeElementWrapper rootTop, Determinant determinant) {
        Object element = rootTop.getRfElement();
        if (element instanceof IRfDefElement) {
            element = ((RfDefElement)element).getNamedElement();
        }
        if (!(element instanceof RfNamedElement)) {
            return;
        }
        HashSet<Determinant> visited = new HashSet<Determinant>();
        if (determinant == null && element instanceof RfField) {
            determinant = ((RfField)element).getAssociatedTypeDeterminant();
        }
        if (element instanceof RfListType) {
            RfType associatedType = ((RfListType)element).getAssociatedType();
            if (!(associatedType instanceof RfStruct)) {
                return;
            }
            element = associatedType;
        }
        Iterator fieldsIterator = null;
        if (element instanceof RfStruct) {
            fieldsIterator = ((RfStruct)element).getRawFieldsIterator(true);
        } else {
            RfType associatedType = ((RfStructMember)element).getAssociatedType();
            if (element instanceof RfField && !((RfField)element).isInstance() || !(associatedType instanceof RfStruct)) {
                return;
            }
            if (associatedType instanceof RfListType && !((associatedType = ((RfListType)associatedType).getAssociatedBaseType()) instanceof RfStruct)) {
                return;
            }
            element = associatedType;
            fieldsIterator = ((RfStruct)associatedType).getRawFieldsIterator(true);
        }
        if (determinant == null && element instanceof RfType) {
            determinant = ((RfType)element).getDeterminant();
        }
        visited.add(determinant);
        if (fieldsIterator != null) {
            while (fieldsIterator.hasNext()) {
                String associatedTypeName;
                RfStructMember field = (RfStructMember)fieldsIterator.next();
                if (field == null) continue;
                RfType associatedType = field.getAssociatedType();
                if (!((RfField)field).isInstance() || !(associatedType instanceof RfStruct) || associatedType instanceof RfListType && !((associatedType = ((RfListType)associatedType).getAssociatedBaseType()) instanceof RfStruct) || field instanceof RfField && ((associatedTypeName = associatedType.getName()).equals("any_simple_port") || associatedTypeName.equals("any_event_port") || associatedTypeName.equals("any_interface_port") || associatedTypeName.equals("any_buffer_port") || associatedTypeName.equals("any_method_port") || RfSpecman.isTLMPort((String)associatedTypeName))) continue;
                HashMap<Determinant, RfStructLayer> detList = new HashMap<Determinant, RfStructLayer>();
                for (RfDefElement layer : ((RfNamedElement)element).getLayers()) {
                    detList.put(((RfStructLayer)layer).getDeterminant(), (RfStructLayer)layer);
                }
                AbstractRfTreeElementWrapper fieldWrapper = EPluginConfig.getInstance().createElementTreeWrapper(field);
                Determinant fieldDeterminant = field.getFullName().getDeterminant();
                if (detList.containsKey(fieldDeterminant) && !fieldDeterminant.equals((Object)determinant)) {
                    if (determinant == null || !determinant.contains(fieldDeterminant, true)) continue;
                    fieldWrapper.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.WHEN_SUBTYPE, (Object)fieldDeterminant.toString());
                    rootTop.addChild((IDVTElementWrapper)fieldWrapper);
                    continue;
                }
                if (determinant != null && !determinant.contains(fieldDeterminant, true) && !((RfStruct)element).isLike(field.getParentStruct().getName())) continue;
                rootTop.addChild((IDVTElementWrapper)fieldWrapper);
            }
        }
    }

    protected IRfVHBreadcrumbElement getVHElemFromNamedElem(IProject project, IRfNamedElement vhBCElement) {
        if (!(vhBCElement instanceof RfStruct)) {
            return null;
        }
        List children = ((RfStruct)vhBCElement).getDeclarations();
        for (RfDefElement child : children) {
            if (!(child instanceof RfStructLayer) || !((RfStructLayer)child).isUnit()) continue;
            return child;
        }
        return null;
    }

    protected IRfBreadcrumbElement getEnclosingClassOrUnit(IRfBreadcrumbElement element) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof RfFieldLayer)) {
            return (IRfNamedElement)element.getEnclosingScope();
        }
        RfField field = ((RfFieldLayer)element).getField();
        RfType enclosingScope = field.getAssociatedType();
        if (enclosingScope instanceof RfListType) {
            enclosingScope = ((RfListType)enclosingScope).getAssociatedType();
        }
        if (enclosingScope instanceof RfStruct) {
            return (IRfBreadcrumbElement)((IRfNamedElement)enclosingScope).getDeclaration();
        }
        return null;
    }

    protected String getVElementName(IRfVHBreadcrumbElement element) {
        if (!(element instanceof IRfDefElement)) {
            return "";
        }
        IRfBreadcrumbElement enclosingClassOrUnit = this.getEnclosingClassOrUnit((IRfBreadcrumbElement)element);
        if (enclosingClassOrUnit == null) {
            return "";
        }
        return enclosingClassOrUnit.getName();
    }

    public boolean checkClassesInFile(IDVTBreadcrumbHost editor) {
        if (editor instanceof DVTEditor) {
            List<IRfBreadcrumbElement> vClassesInFile = this.getVClassesInFile(editor, 1, false);
            if (vClassesInFile == null) {
                return false;
            }
            return !vClassesInFile.isEmpty();
        }
        if (editor instanceof DDiagramEditor) {
            DDiagramEditor diagramEditor = (DDiagramEditor)editor;
            DDiagramEditorInput diagramEditorInput = diagramEditor.getInput();
            if (diagramEditorInput == null) {
                return false;
            }
            DDiagram diagram = diagramEditorInput.getDiagram();
            return diagram instanceof CHDiagram2;
        }
        return false;
    }

    protected void setDummyParent(IDVTElementWrapper wrapper) {
        wrapper.setParent((IDVTElementWrapper)new RfTreeElementWrapper());
    }

    public String getUnitOrComponentLabel() {
        return "unit layers";
    }

    public VHBreadcrumbInstancePathsResult computeVHBreadcrumbInstancePaths(IRfBreadcrumbElement root, IRfVHBreadcrumbElement xvmType, int limit, IProgressMonitor monitor) {
        VHBreadcrumbInstancePathsResult result;
        block10: {
            result = new VHBreadcrumbInstancePathsResult();
            if (!monitor.isCanceled()) break block10;
            return null;
        }
        try {
            if (!(xvmType instanceof RfDefElement)) {
                return result;
            }
            RfProject rfProject = ((RfDefElement)xvmType).getRfProject();
            if (rfProject == null) {
                return result;
            }
            if (xvmType instanceof RfFieldLayer) {
                IRfNamedElement field = xvmType.getNamedElement();
                if (!(field instanceof RfField)) {
                    return result;
                }
                RfType associatedBaseType = ((RfField)field).getAssociatedBaseType();
                if (associatedBaseType == null) {
                    return result;
                }
                xvmType = associatedBaseType.getDeclaration();
            }
            if (!(xvmType instanceof RfStructLayer)) {
                return result;
            }
            Set<VHBreadcrumbInstancePathsResult> isVisited = Collections.newSetFromMap(new IdentityHashMap());
            this.internalRecursiveComputeXVMInstancePaths(rfProject, (RfStructLayer)xvmType, new ArrayDeque<RfFieldLayer>(), result, limit, isVisited, monitor);
        }
        catch (StopComputeVHBCInstacePathsException stopComputeVHBCInstacePathsException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void internalRecursiveComputeXVMInstancePaths(RfProject rfProject, RfStructLayer xvmType, Deque<RfFieldLayer> partial, VHBreadcrumbInstancePathsResult result, int limit, Set<VHBreadcrumbInstancePathsResult> isVisited, IProgressMonitor monitor) throws StopComputeVHBCInstacePathsException {
        if (monitor.isCanceled()) {
            return;
        }
        List<RfFieldLayer> instances = this.computeXVMInstances(rfProject, xvmType, limit, monitor);
        if (instances == null || instances.isEmpty()) {
            List paths = result.instancePaths;
            VHBreadcrumbInstancePath instancePath = new VHBreadcrumbInstancePath(new ArrayList<RfFieldLayer>(partial), (IRfVHBreadcrumbElement)xvmType);
            if (!paths.contains(instancePath)) {
                paths.add(instancePath);
            }
            if (paths.size() >= limit) {
                result.limitExceeded = true;
                throw new StopComputeVHBCInstacePathsException();
            }
            return;
        }
        for (RfFieldLayer instance : instances) {
            RfStructLayer enclosingScope;
            if (monitor.isCanceled()) {
                return;
            }
            if (!instance.isInstance() || (enclosingScope = instance.getStructLayer()) == null || partial.contains(instance)) continue;
            partial.push(instance);
            this.internalRecursiveComputeXVMInstancePaths(rfProject, enclosingScope, partial, result, limit, isVisited, monitor);
            partial.pop();
        }
    }

    private List<RfFieldLayer> computeXVMInstances(RfProject rfProject, RfStructLayer structLayer, int limit, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (structLayer == null) {
            return Collections.emptyList();
        }
        ArrayList<RfFieldLayer> result = new ArrayList<RfFieldLayer>(0);
        Comparator comparator = (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getName() == null && o2.getName() == null) {
                return 0;
            }
            if (o1.getName() == null) {
                return -1;
            }
            if (o2.getName() == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        };
        Collection rfModules = rfProject.getAllModules();
        if (rfModules == null || rfModules.isEmpty()) {
            return Collections.emptyList();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        List<RfModule> modules = new ArrayList<RfModule>(rfModules);
        modules = this.sort(modules, comparator);
        for (RfModule module : modules) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            List refModChildren = module.getChildren();
            if (refModChildren == null || refModChildren.isEmpty()) continue;
            ArrayList moduleChildren = new ArrayList(refModChildren);
            Collections.sort(moduleChildren, comparator);
            for (RfDefElement moduleChild : moduleChildren) {
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                List refChildren = moduleChild.getChildren();
                if (refChildren == null) continue;
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                ArrayList children = new ArrayList(refChildren);
                Collections.sort(children, comparator);
                for (RfDefElement child : children) {
                    if (monitor.isCanceled()) {
                        return Collections.emptyList();
                    }
                    RfNamedElement field = child.getNamedElement();
                    if (!(field instanceof RfField) || !((RfField)field).isInstance()) continue;
                    Determinant searchedDeterminant = structLayer.getDeterminant();
                    Determinant determinant = ((RfField)field).getAssociatedTypeDeterminant();
                    if (determinant == null) continue;
                    if (determinant.contains(searchedDeterminant) || determinant.equals((Object)searchedDeterminant)) {
                        result.add((RfFieldLayer)child);
                    }
                    if (result.size() < limit) continue;
                    return result;
                }
            }
        }
        return result;
    }

    private List<RfModule> sort(Collection<RfModule> collection, Comparator<IRfBreadcrumbElement> comparator) {
        ArrayList<RfModule> list = new ArrayList<RfModule>(collection);
        list.sort(comparator);
        return list;
    }

    public IVHLabelProvider getVHLabelProvider() {
        return this.vhLabelProvider == null ? new VHLabelProvider((IEPluginConfig)EPluginConfig.getInstance()) : this.vhLabelProvider;
    }

    public boolean shouldOpenCreate() {
        return false;
    }

    public boolean isInsideMacro(IRfVHBreadcrumbElement element) {
        if (element instanceof RfNamedElement) {
            return this.isInsideMacro((IRfVHBreadcrumbElement)((RfNamedElement)element).getDeclaration());
        }
        if (!(element instanceof RfDefElement)) {
            return false;
        }
        return ((RfDefElement)element).getStartVirtualOffset() != -1;
    }

    public List<IRfBreadcrumbElement> getPathSegmentsForDiagram(CHContainer component, boolean isSIMGenerated) {
        if (component == null) {
            return Collections.emptyList();
        }
        CHContainer enclosingGate = component.getParent();
        if (component.getParent() == null) {
            return Collections.emptyList();
        }
        Object element = component.getWrapper().getRfElement();
        if (!(element instanceof IRfBreadcrumbElement)) {
            return Collections.emptyList();
        }
        if (element instanceof IRfNamedElement) {
            element = this.getDefElementUsingDeterminant((IRfNamedElement)element);
        }
        ArrayList<IRfBreadcrumbElement> result = new ArrayList<IRfBreadcrumbElement>();
        result.add((IRfBreadcrumbElement)element);
        result.addAll(this.getPathSegmentsForDiagram(enclosingGate, false));
        return result;
    }

    public boolean initializeVHBCModel(IProject project) {
        return true;
    }

    protected List<IRfBreadcrumbElement> getVClassesInFile(IDVTBreadcrumbHost editor, int numberOfClasses) {
        return this.getVClassesInFile(editor, numberOfClasses, true);
    }

    protected List<IRfBreadcrumbElement> getVClassesInFile(IDVTBreadcrumbHost editor, int numberOfClasses, boolean shouldSort) {
        if (editor == null) {
            return null;
        }
        IProject project = editor.getProject();
        if (project == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof FileEditorInput)) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        IFile fileEditorInput = ((FileEditorInput)editorInput).getFile();
        RfModule fileDef = rfProject.getModule((IResource)fileEditorInput);
        if (fileDef == null) {
            return null;
        }
        List children = fileDef.getChildren();
        if (children == null) {
            return null;
        }
        ArrayList sortedChildren = new ArrayList(children);
        if (shouldSort) {
            int editorCursor = this.getCursor(editor);
            try {
                Collections.sort(sortedChildren, new CursorComparator(editorCursor).thenComparing(DEF_COMPARATOR));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        ArrayList<IRfBreadcrumbElement> vClassesInFile = new ArrayList<IRfBreadcrumbElement>();
        for (RfDefElement child : sortedChildren) {
            if (child instanceof RfStructLayer && ((RfStructLayer)child).isUnit()) {
                vClassesInFile.add((IRfBreadcrumbElement)child);
            }
            if (vClassesInFile.size() != numberOfClasses) continue;
            return vClassesInFile;
        }
        return vClassesInFile;
    }

    protected abstract int getCursor(IDVTBreadcrumbHost var1);

    static class CursorComparator
    implements Comparator<RfDefElement> {
        private int cursorOffset;

        public CursorComparator(int cursorOffset) {
            this.cursorOffset = cursorOffset;
        }

        @Override
        public int compare(RfDefElement o1, RfDefElement o2) {
            if (this.contains(o1, this.cursorOffset)) {
                return -1;
            }
            if (this.contains(o2, this.cursorOffset)) {
                return 1;
            }
            return 0;
        }

        private boolean contains(RfDefElement def, int cursorOffset) {
            return def.getStartOffset() <= cursorOffset && def.getEndOffset() >= cursorOffset;
        }
    }
}

