/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ui.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.settings.DVTSManagedCommonTab;
import ro.amiq.dvt.startup.core.DVTLogger;

public class SpecmanLaunchShortcut
implements ILaunchShortcut,
IObjectActionDelegate {
    private IWorkbenchPage fTargetPage;

    public void launch(ISelection selection, String mode) {
        IStructuredSelection structured = (IStructuredSelection)selection;
        if (structured.getFirstElement() instanceof IFile) {
            this.launch(this.findConfiguration((IFile)structured.getFirstElement()), mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        this.launch(this.findConfiguration(file), mode);
    }

    private void launch(ILaunchConfiguration config, String mode) {
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    private ILaunchConfiguration findConfiguration(IFile file) {
        try {
            ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
            IProject project = file.getProject();
            IPath fileLocation = file.getLocation();
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType specmanLaunchConfigurationType = launchManager.getLaunchConfigurationType("ro.amiq.edt.launch.SpecmanConfigurationType");
            ILaunchConfiguration[] allConfigs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(specmanLaunchConfigurationType);
            int i = 0;
            while (i < allConfigs.length) {
                ILaunchConfiguration candidate = allConfigs[i];
                if (candidate.getAttribute("ro.amiq.edt.launch.TEST_ATTR", "").equals(fileLocation.toOSString()) && candidate.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", "").equals(project.getName())) {
                    candidateConfigs.add(candidate);
                }
                ++i;
            }
            int candidateCount = candidateConfigs.size();
            if (candidateCount < 1) {
                ILaunchConfigurationWorkingCopy wc = specmanLaunchConfigurationType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(file.getName()));
                DVTSManagedCommonTab.setAsShared((ILaunchConfigurationWorkingCopy)wc);
                IPath projectLocation = project.getLocation();
                IPath projectPath = projectLocation.uptoSegment(projectLocation.segmentCount() - 1);
                wc.setAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", project.getName());
                wc.setAttribute("ro.amiq.edt.launch.TEST_ATTR", file.getLocation().toOSString());
                wc.setAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", projectPath.toOSString());
                wc.setAttribute("ro.amiq.dvt.launch.PROJECT_LOCATION_ATTR", projectLocation.toOSString());
                wc.setAttribute("ro.amiq.edt.launch.SPECMAN_EXECUTABLE_ATTR", "specman");
                wc.setAttribute("ro.amiq.edt.launch.COMMAND_ATTR", "");
                ILaunchConfiguration newConfig = wc.doSave();
                return newConfig;
            }
            if (candidateCount == 1) {
                return (ILaunchConfiguration)candidateConfigs.get(0);
            }
            return this.chooseConfiguration(candidateConfigs);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        ConfigLabelProvider labelProvider = new ConfigLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DVTPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select Test");
        dialog.setMessage("Select existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPage = targetPart.getSite().getPage();
    }

    public void run(IAction action) {
        if (this.fTargetPage == null) {
            return;
        }
        IWorkbenchPart activePart = this.fTargetPage.getActivePart();
        if (activePart instanceof IEditorPart) {
            this.launch((IEditorPart)activePart, "run");
        } else {
            ISelection selection = this.fTargetPage.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.launch(selection, "run");
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            Object obj;
            boolean enabled = false;
            if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource && !(obj instanceof IProject) && ((IResource)obj).getProject().hasNature("ro.amiq.edt.enature")) {
                enabled = true;
            }
            action.setEnabled(enabled);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static class ConfigLabelProvider
    extends LabelProvider {
        private ConfigLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ILaunchConfiguration) {
                return ((ILaunchConfiguration)element).getName();
            }
            return null;
        }
    }
}

