/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ui.launch;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.launch.ui.DVTBaseLaunchConfigurationTab;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.edt.model.CoreModel;
import ro.amiq.edt.ui.EFileLabelProvider;

public class TestTab
extends DVTBaseLaunchConfigurationTab {
    private IProject fProject;
    private Text fProjectText;
    private Button fProjectButton;
    private Text fTestText;
    private Button fTestButton;
    private Text fDirectoryText;
    private Button fDirectoryButton;
    private Text fSpecmanText;
    private Button fSpecmanButton;
    private Text fCommandText;
    private Label fInvocationLabel;

    public String getName() {
        return "Test";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DESC_LAUNCH_MAIN_TAB);
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(3, false);
        composite.setLayout((Layout)compositeLayout);
        Label projectLabel = new Label(composite, 0);
        projectLabel.setText("Project:");
        GridData projectLabelGridData = new GridData(128);
        projectLabel.setLayoutData((Object)projectLabelGridData);
        this.fProjectText = new Text(composite, 2048);
        GridData projectTextGridData = new GridData(768);
        this.fProjectText.setLayoutData((Object)projectTextGridData);
        this.fProjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjectButton = new Button(composite, 8);
        this.fProjectButton.setText("Browse...");
        GridData projectButtonGridData = new GridData(32);
        this.fProjectButton.setLayoutData((Object)projectButtonGridData);
        this.fProjectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(TestTab.this.getShell(), (ILabelProvider)labelProvider);
                dialog.setTitle("Project");
                dialog.setMessage("Select the project");
                dialog.setElements((Object[])CoreModel.getInstance().getEModel().getEProjects());
                if (dialog.open() == 0) {
                    TestTab.this.fProjectText.setText(((IProject)dialog.getFirstResult()).getName());
                }
                if (labelProvider != null) {
                    labelProvider.dispose();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label testLabel = new Label(composite, 0);
        testLabel.setText("Test File:");
        GridData nameLabelGridData = new GridData(128);
        testLabel.setLayoutData((Object)nameLabelGridData);
        this.fTestText = new Text(composite, 2048);
        GridData testTextGridData = new GridData(768);
        this.fTestText.setLayoutData((Object)testTextGridData);
        this.fTestText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fTestButton = new Button(composite, 8);
        this.fTestButton.setText("Browse...");
        GridData testButtonGridData = new GridData(32);
        this.fTestButton.setLayoutData((Object)testButtonGridData);
        this.fTestButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                final ArrayList files = new ArrayList();
                if (TestTab.this.fProject != null) {
                    try {
                        final String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.edt.ESource", false);
                        TestTab.this.fProject.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (resource instanceof IFile && DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
                                    files.add((IFile)resource);
                                }
                                return true;
                            }
                        });
                    }
                    catch (Exception x) {
                        DVTLogger.INSTANCE.logError((Throwable)x);
                    }
                }
                EFileLabelProvider labelProvider = new EFileLabelProvider();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(TestTab.this.getShell(), (ILabelProvider)labelProvider);
                dialog.setTitle("Test File");
                dialog.setMessage("Select the test file");
                dialog.setElements(files.toArray());
                if (dialog.open() == 0) {
                    TestTab.this.fTestText.setText(((IFile)dialog.getFirstResult()).getLocation().toOSString());
                }
                if (labelProvider != null) {
                    labelProvider.dispose();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label directoryLabel = new Label(composite, 0);
        directoryLabel.setText("Working Directory:");
        GridData directoryLabelGridData = new GridData(128);
        directoryLabel.setLayoutData((Object)directoryLabelGridData);
        this.fDirectoryText = new Text(composite, 2048);
        GridData directoryTextGridData = new GridData(768);
        this.fDirectoryText.setLayoutData((Object)directoryTextGridData);
        this.fDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fDirectoryButton = new Button(composite, 8);
        this.fDirectoryButton.setText("Browse...");
        GridData directoryButtonGridData = new GridData(32);
        this.fDirectoryButton.setLayoutData((Object)directoryButtonGridData);
        this.fDirectoryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File f = new File(TestTab.this.fDirectoryText.getText());
                String filterPath = f.exists() ? TestTab.this.fDirectoryText.getText() : (TestTab.this.fProject != null && TestTab.this.fProject.getLocation() != null ? TestTab.this.fProject.getLocation().toOSString() : EDTFileUtils.getInstance().getLastDirectory());
                DirectoryDialog directoryDialog = new DirectoryDialog(TestTab.this.getShell());
                directoryDialog.setFilterPath(filterPath);
                String selectedDirectory = directoryDialog.open();
                if (selectedDirectory != null) {
                    TestTab.this.fDirectoryText.setText(selectedDirectory);
                    EDTFileUtils.getInstance().setLastDirectory(selectedDirectory);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label specmanLabel = new Label(composite, 0);
        specmanLabel.setText("Specman Executable:");
        GridData specmanLabelGridData = new GridData(128);
        specmanLabel.setLayoutData((Object)specmanLabelGridData);
        this.fSpecmanText = new Text(composite, 2048);
        GridData specmanTextGridData = new GridData(768);
        this.fSpecmanText.setLayoutData((Object)specmanTextGridData);
        this.fSpecmanText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSpecmanButton = new Button(composite, 8);
        this.fSpecmanButton.setText("Browse...");
        GridData specmanButtonGridData = new GridData(32);
        this.fSpecmanButton.setLayoutData((Object)specmanButtonGridData);
        this.fSpecmanButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File f = new File(TestTab.this.fSpecmanText.getText());
                String filterPath = f.exists() ? f.getParent() : (TestTab.this.fProject != null && TestTab.this.fProject.getLocation() != null ? TestTab.this.fProject.getLocation().toOSString() : EDTFileUtils.getInstance().getLastDirectory());
                FileDialog fileDialog = new FileDialog(TestTab.this.getShell());
                fileDialog.setFilterPath(filterPath);
                String selectedFile = fileDialog.open();
                if (selectedFile != null) {
                    TestTab.this.fSpecmanText.setText(selectedFile);
                    EDTFileUtils.getInstance().setLastDirectory(selectedFile);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label commandLabel = new Label(composite, 0);
        commandLabel.setText("Test Command:");
        GridData commandLabelGridData = new GridData(128);
        commandLabel.setLayoutData((Object)commandLabelGridData);
        this.fCommandText = new Text(composite, 2048);
        GridData commandTextGridData = new GridData(768);
        commandTextGridData.horizontalSpan = 2;
        this.fCommandText.setLayoutData((Object)commandTextGridData);
        this.fCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label iLabel = new Label(composite, 0);
        iLabel.setText("Invocation:");
        GridData iLabelGridData = new GridData(128);
        iLabel.setLayoutData((Object)iLabelGridData);
        this.fInvocationLabel = new Label(composite, 64);
        this.fInvocationLabel.setText(String.valueOf(this.fSpecmanText.getText()) + " -c 'loa " + this.fTestText.getText() + ";" + this.fCommandText.getText() + "';");
        GridData infoLabelGridData = new GridData(768);
        infoLabelGridData.horizontalSpan = 3;
        this.fInvocationLabel.setLayoutData((Object)infoLabelGridData);
        this.setControl((Control)composite);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.fInvocationLabel.setText(String.valueOf(this.fSpecmanText.getText()) + " -c 'loa " + this.fTestText.getText() + ";" + this.fCommandText.getText() + "';");
        this.setErrorMessage(null);
        this.setMessage(null);
        this.fTestButton.setEnabled(false);
        this.fDirectoryButton.setEnabled(false);
        String projectName = this.fProjectText.getText();
        if (projectName.length() == 0) {
            this.setErrorMessage("Project not specified.");
            return false;
        }
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage("Wrong project name. " + nameStatus.getMessage());
            return false;
        }
        this.fProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!this.fProject.exists()) {
            this.setErrorMessage("Project '" + projectName + "' does not exist.");
            this.fProject = null;
            return false;
        }
        this.fTestButton.setEnabled(true);
        this.fDirectoryButton.setEnabled(true);
        String testName = this.fTestText.getText();
        if (testName.length() == 0) {
            this.setErrorMessage("Test not specified.");
            return false;
        }
        IFile test = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(testName));
        if (test == null || test.getProject() != this.fProject || !test.exists()) {
            this.setErrorMessage("Test '" + testName + "' not found in project '" + projectName + "'.");
            return false;
        }
        String directoryName = this.fDirectoryText.getText();
        if (directoryName.length() == 0) {
            this.setErrorMessage("Workind directory not specified.");
            return false;
        }
        File directory = new File(directoryName);
        if (!directory.exists()) {
            this.setErrorMessage("Working directory '" + directoryName + "' does not exist.");
            return false;
        }
        String specmanExecutable = this.fSpecmanText.getText();
        if (specmanExecutable.length() == 0) {
            this.setErrorMessage("Specman executable not specified.");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", null);
        config.setAttribute("ro.amiq.edt.launch.TEST_ATTR", null);
        config.setAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", null);
        config.setAttribute("ro.amiq.edt.launch.SPECMAN_EXECUTABLE_ATTR", "specman");
        config.setAttribute("ro.amiq.edt.launch.COMMAND_ATTR", "");
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String projectName = "";
        String testName = "";
        String directoryName = "";
        String specmanExecutable = "";
        String testCommand = "";
        try {
            projectName = config.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", "");
            testName = config.getAttribute("ro.amiq.edt.launch.TEST_ATTR", "");
            directoryName = config.getAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", "");
            specmanExecutable = config.getAttribute("ro.amiq.edt.launch.SPECMAN_EXECUTABLE_ATTR", "specman");
            testCommand = config.getAttribute("ro.amiq.edt.launch.COMMAND_ATTR", "");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fProjectText.setText(projectName);
        this.fTestText.setText(testName);
        this.fDirectoryText.setText(directoryName);
        this.fSpecmanText.setText(specmanExecutable);
        this.fCommandText.setText(testCommand);
        this.setCurrentLaunchConfiguration(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", this.getAttributeValueFrom(this.fProjectText));
        config.setAttribute("ro.amiq.edt.launch.TEST_ATTR", this.getAttributeValueFrom(this.fTestText));
        config.setAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", this.getAttributeValueFrom(this.fDirectoryText));
        config.setAttribute("ro.amiq.edt.launch.SPECMAN_EXECUTABLE_ATTR", this.getAttributeValueFrom(this.fSpecmanText));
        config.setAttribute("ro.amiq.edt.launch.COMMAND_ATTR", this.getAttributeValueFrom(this.fCommandText));
    }
}

