/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ui.launch.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.edt.model.EModelManager;

public class SpecmanConsoleTracker
implements IConsoleScanListener {
    private TextConsole fConsole;
    private TextConsoleViewer fConsoleViewer;
    private static final Pattern fPattern = Pattern.compile("at\\sline\\s(\\d+)\\sin\\s(\\S+)\\s");

    public TextConsole getConsole() {
        return this.fConsole;
    }

    public TextConsoleViewer getConsoleViewer() {
        return this.fConsoleViewer;
    }

    public void connect(TextConsole console) {
        this.fConsole = console;
    }

    public void disconnect() {
        this.fConsole = null;
        this.fConsoleViewer = null;
    }

    public String getPattern() {
        return fPattern.toString();
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return "at line";
    }

    public void addHyperlink(int offset, int length) {
        try {
            IDocument document = this.fConsole.getDocument();
            Matcher m = fPattern.matcher(document.get(offset, length));
            if (!m.matches()) {
                return;
            }
            int line = Integer.parseInt(m.group(1));
            String file = m.group(2);
            if (line == -1) {
                return;
            }
            IProcess process = (IProcess)this.fConsole.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS");
            if (process == null) {
                return;
            }
            ILaunch launch = process.getLaunch();
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            if (launchConfiguration == null) {
                return;
            }
            String projectName = launchConfiguration.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", "");
            SpecmanHyperlink link = new SpecmanHyperlink(projectName, file, line);
            this.fConsole.addHyperlink((IHyperlink)link, offset, length);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Pattern getWholePattern() {
        return fPattern;
    }

    public void setConsoleViewer(TextConsoleViewer newConsoleViewer) {
        this.fConsoleViewer = newConsoleViewer;
    }

    private static class SpecmanHyperlink
    implements IHyperlink {
        private String fProjectName;
        private String fFileName;
        private int fLine;

        SpecmanHyperlink(String project, String file, int line) {
            this.fProjectName = project;
            if (file.charAt(0) == '@') {
                file = file.substring(1);
            }
            if (!file.endsWith(".e")) {
                file = String.valueOf(file) + ".e";
            }
            this.fFileName = file;
            this.fLine = line;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            try {
                IProject project = null;
                if (this.fProjectName == null || this.fProjectName.length() == 0) {
                    return;
                }
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjectName);
                if (project == null) {
                    return;
                }
                EDTFileUtils.getInstance().openFile((AbstractEModelManager)EModelManager.getInstance(), project, this.fFileName, this.fLine, null);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

