/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ui.syntaxerrors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.IDVTReparseListener;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.model.IEReparseListener;
import ro.amiq.edt.base.model.problems.Bridge;
import ro.amiq.edt.model.EModelManager;
import ro.amiq.etools.eparser.EToolsException;

public abstract class SyntaxErrorsManagerCommon
implements IEReparseListener {
    public void startup() {
        EModelManager.getInstance().addReparseListener((IDVTReparseListener)this);
    }

    public void shutdown() {
        EModelManager.getInstance().removeReparseListener((IDVTReparseListener)this);
    }

    public void reparsed(int buildKind, int type, IResource resource, List errors, List warnings, List tasks) {
        boolean isNonTopFile;
        if (resource == null || !resource.isAccessible() || !(resource instanceof IFile)) {
            return;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F65")) {
            return;
        }
        DVTProblemManager.getInstance().removeProblemsWithCategoryAndPath(project, EProblemCategories.E_SYNTAX, Utils.canonicPath((IPath)resource.getLocation()));
        boolean bl = isNonTopFile = PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE) == null && PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_ACTIVE_TEST_FILE) == null && PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_TEST_FILE) == null;
        if (errors != null && !errors.isEmpty()) {
            for (Object error : errors) {
                EToolsException eSyntaxError = (EToolsException)error;
                if (eSyntaxError.getLine() == -1234567890) continue;
                if (isNonTopFile) {
                    eSyntaxError.errorCode = "_" + eSyntaxError.errorCode;
                }
                DVTProblemManager.getInstance().reportProblem(Bridge.from((IProject)project, (EToolsException)eSyntaxError, (String)Utils.canonicPath((IPath)resource.getLocation()), (buildKind == 1 ? 1 : 0) != 0, (boolean)false));
            }
        }
        if (warnings != null && !warnings.isEmpty()) {
            for (Object warning : warnings) {
                EToolsException eSyntaxWarning = (EToolsException)warning;
                if (eSyntaxWarning.getLine() == -1234567890) continue;
                if (isNonTopFile) {
                    eSyntaxWarning.errorCode = "_" + eSyntaxWarning.errorCode;
                }
                DVTProblemManager.getInstance().reportProblem(Bridge.from((IProject)project, (EToolsException)eSyntaxWarning, (String)Utils.canonicPath((IPath)resource.getLocation()), (buildKind == 1 ? 1 : 0) != 0, (boolean)false));
            }
        }
        DVTProblemsUiUpdaterRegistry.get((String)EProblemCategories.E_SYNTAX.getId()).update((IFile)resource, buildKind == 1);
    }

    public abstract void updateProblemsUI(IProject var1, List<EToolsException> var2);
}

