/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ui.wizards;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.wizards.AbstractWizardPage;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ui.wizards.OVMComplianceWizard;

public class OVMCompliancePackagePage
extends AbstractWizardPage {
    private OVMProject fOVMProject;
    protected CheckboxTableViewer fTableViewer;

    public void dispose() {
        this.fTableViewer = null;
        super.dispose();
    }

    protected OVMCompliancePackagePage(String pageName, ImageDescriptor image) {
        super(pageName);
        this.setTitle("Package name selection");
        this.setDescription("Select the package to review.");
        this.setImageDescriptor(image);
    }

    protected void setOVMProject(OVMProject ovmProject) {
        this.fOVMProject = ovmProject;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Table table = new Table(composite, 67618);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new PackageContentProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OVMCompliancePackagePage.this.updatePageProperties();
            }
        });
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
        this.setInput(((OVMComplianceWizard)this.getWizard()).getPackagePageInput());
    }

    private void updatePageProperties() {
        boolean pageValid = this.isValid();
        this.setPageComplete(pageValid);
        if (!pageValid) {
            return;
        }
        this.fOVMProject.setPackageName(this.getSelectedPackage());
    }

    private String getSelectedPackage() {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.fTableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                return (String)item.getData();
            }
            ++n2;
        }
        return null;
    }

    private int getSelectedPackagesNumber() {
        TableItem[] items;
        int result = 0;
        TableItem[] tableItemArray = items = this.fTableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    private boolean isValid() {
        block4: {
            try {
                this.setErrorMessage(null);
                this.setMessage(null);
                if (this.getSelectedPackagesNumber() != 0) break block4;
                this.setErrorMessage("One package name must be selected.");
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        if (this.getSelectedPackagesNumber() > 1) {
            this.setErrorMessage("Only one package name must be selected.");
            return false;
        }
        return true;
    }

    private void setInput(ArrayList<String> input) {
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput(input);
            this.fTableViewer.setAllChecked(false);
            if (input != null && !input.isEmpty()) {
                this.fTableViewer.setChecked((Object)input.get(0), true);
            }
            this.updatePageProperties();
        }
    }

    class PackageContentProvider
    implements IStructuredContentProvider {
        PackageContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList packages = (ArrayList)inputElement;
            if (packages != null) {
                return packages.toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                OVMCompliancePackagePage.this.updatePageProperties();
            }
        }

        public void dispose() {
        }
    }

    static class PackageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PackageLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }
    }
}

