/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.edt.ovmcompliance.OVMComplianceBuilder;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;
import ro.amiq.edt.ovmcompliance.ui.OVMComplianceReportInput;
import ro.amiq.edt.ui.wizards.OVMCompliancePackagePage;
import ro.amiq.edt.ui.wizards.actions.InterruptedBuildException;

public class OVMComplianceWizard
extends Wizard
implements INewWizard,
IPageChangedListener {
    private OVMCompliancePackagePage fPackagePage;
    private IProject fProject;
    private int xvmMode;
    private ArrayList<String> fPackagePageInput;

    public OVMComplianceWizard(IResource resource, int aXVMMode) throws InterruptedBuildException {
        if (resource == null) {
            return;
        }
        this.fProject = resource.getProject();
        this.xvmMode = aXVMMode;
        try {
            MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Project Build", null, "It is recommended to build the project before generating the Compliance Review report.", 4, new String[]{"Build Now", "Skip"}, 0);
            int doBuild = messageDialog.open();
            if (doBuild == 0 && !DVTBuildUtils.buildWithProgressDialog((IProject)this.fProject)) {
                throw new InterruptedBuildException();
            }
            OVMProject ovmProject = OVMComplianceBuilder.getInstance().initializeOVMProject(resource.getProject(), this.xvmMode);
            ArrayList<String> packages = ovmProject.getAllRelevantPackages();
            this.fPackagePage = new OVMCompliancePackagePage(XVMModeUtils.getTitle(aXVMMode), XVMModeUtils.getWizardImageDescriptor(aXVMMode));
            if (packages.size() == 1) {
                ovmProject.setPackageName(packages.get(0));
                this.fPackagePage.setPageComplete(true);
                this.fPackagePage.setOVMProject(ovmProject);
                this.fPackagePageInput = packages;
            } else if (packages.size() == 2 && packages.get(1).equals("main")) {
                ovmProject.setPackageName(packages.get(0));
                this.fPackagePage.setPageComplete(true);
                this.fPackagePage.setOVMProject(ovmProject);
                this.fPackagePageInput = packages;
            } else if (packages.size() > 1) {
                this.fPackagePage.setPageComplete(false);
                this.fPackagePage.setOVMProject(ovmProject);
                this.fPackagePageInput = packages;
            }
        }
        catch (InterruptedBuildException e1) {
            throw e1;
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
        }
    }

    public boolean performFinish() {
        Job generateSpec = new Job("Compliance Review..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.subTask("Compliance Review for project: " + OVMComplianceWizard.this.fProject.getName());
                    monitor.beginTask("Compliance Review for project: " + OVMComplianceWizard.this.fProject.getName(), 1);
                    monitor.worked(1);
                    monitor.done();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!DVTPlugin.getDefault().collect().c((this).OVMComplianceWizard.this.fProject, "F65")) {
                                    return;
                                }
                                OVMComplianceReportInput editorInput = new OVMComplianceReportInput((this).OVMComplianceWizard.this.fProject, (this).OVMComplianceWizard.this.xvmMode);
                                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)editorInput, (String)XVMModeUtils.getEditorId((this).OVMComplianceWizard.this.xvmMode), (boolean)true);
                                OVMComplianceWizard.this.maximizeEditor((IWorkbenchPart)editorPart);
                            }
                            catch (Exception e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        generateSpec.schedule();
        return true;
    }

    private void maximizeEditor(IWorkbenchPart editorPart) {
        try {
            if (editorPart == null) {
                return;
            }
            IWorkbenchPartSite site = editorPart.getSite();
            if (site == null) {
                return;
            }
            IWorkbenchPage page = site.getPage();
            if (page == null) {
                return;
            }
            IWorkbenchPartReference partReference = page.getActivePartReference();
            if (partReference == null) {
                return;
            }
            page.setPartState(partReference, 1);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void dispose() {
        if (this.fPackagePage != null) {
            this.fPackagePage.dispose();
        }
        super.dispose();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            this.setWindowTitle(XVMModeUtils.getTitle(this.xvmMode));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void pageChanged(PageChangedEvent event) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.fPackagePage);
    }

    public ArrayList<String> getPackagePageInput() {
        return this.fPackagePageInput;
    }
}

