/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.buildconfig.splitinvocation;

import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.ResolvedDirective;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationConfig;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationUtils;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.buildconfig.splitinvocation.OriginalInvocationState;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationDVStrategy;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationLibraryStrategy;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationLineCountStrategy;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationMonitor;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationStrategy;
import ro.amiq.vlogdt.buildconfig.splitinvocation.VlogSplitInvocationUtils;
import ro.amiq.vlogdt.buildconfig.splitinvocation.VlogSplitInvocationUtilsCommon;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.IRfFileInstanceVisitor;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class SplitInvocation {
    public static final String INVOCATION_START_DELIMITER = "// --- ";
    public static final String INVOCATION_END_DELIMITER = " INVOCATION --- ";
    public static final String MACRO_FILE_NAME_PREFIX = "glue_macro_";
    private static final String INVALID_INVOCATION_TYPE_ERROR_DIALOG_MESSAGE = "Split cannot be done if using altera or xilinx";
    private static final String XILINX = "xilinx";
    private static final String ALTERA = "altera";
    private static final String PLUS_DEFINE = "+define";
    private static final String PLUS_DEFINEALL = "+defineall";
    private static final String INEXISTENT_PATH = " // Path is inexistent";
    private static final String UVM_INVOCATION = "UVM";
    private static final String PREPEND_INVOCATION = "PREPEND";
    private static final String IMPORT_FILE_NAME_PREFIX = "glue_import_";
    private static final String PREPEND_DASH_F_FILE_NAME_PREFIX = "glue_prepend_";
    private static final String ORIGINAL_INVOCATION_LINE_START = "ORIGINAL INVOCATION LINE START: ";
    private static final Pattern DIRECTIVE_DELIMITER = Pattern.compile("[+\\s]");
    private IProject project;
    private RfProject rfProject;
    private String projectLocation;
    private SplitInvocationMonitor monitor;
    private List<Invocation> invocations;
    private VlogFileInstance topFile;
    private List<SplitInvocationStrategy> splitStrategies;
    private Map<Integer, String> importFilePaths;
    private StringBuilder currentInvocation;
    private StringBuilder allInvocations;
    private int currentCompiledFileStartIndex;
    private OriginalInvocationState currentOriginalInvocationState;
    private List<VlogFileInstance> compiledTopFiles;

    public SplitInvocation(IProject project, SplitInvocationConfig splitConfig, SplitInvocationMonitor monitor) {
        this.project = project;
        this.monitor = monitor;
        this.rfProject = RfManager.getInstance().getRfProject(project);
        this.projectLocation = project.getLocation().makeAbsolute().toOSString();
        this.invocations = BuildConfigManagerCommon.getActiveBuildConfig((IProject)project).getCachedInfo();
        this.splitStrategies = new ArrayList<SplitInvocationStrategy>();
        if (splitConfig.isSplitDesignVerification()) {
            this.splitStrategies.add(new SplitInvocationDVStrategy(this.rfProject));
        }
        if (splitConfig.isSplitLineCount()) {
            this.splitStrategies.add(new SplitInvocationLineCountStrategy(splitConfig));
        }
        if (splitConfig.isSplitLibraries()) {
            this.splitStrategies.add(new SplitInvocationLibraryStrategy(this.rfProject));
        }
        this.currentCompiledFileStartIndex = -1;
        this.currentOriginalInvocationState = new OriginalInvocationState();
    }

    public boolean split() throws Exception {
        for (ResolvedDirective resolvedDirective : BuildConfigManager.getDirectiveList((IProject)this.project)) {
            String fullDirective = resolvedDirective.getDirective();
            if (!IBuildConfigParserConstants.DVT_INIT_PATTERN.matcher(fullDirective).matches() || !fullDirective.contains(XILINX) && !fullDirective.contains(ALTERA)) continue;
            VlogSplitInvocationUtils.displayError(INVALID_INVOCATION_TYPE_ERROR_DIALOG_MESSAGE);
            return false;
        }
        this.topFile = this.rfProject.getPreprocessingTable().getTopFileInstance();
        if (this.topFile != null) {
            this.compiledTopFiles = this.topFile.getIncludedInstances();
        }
        if (this.topFile == null || this.compiledTopFiles.isEmpty()) {
            return false;
        }
        this.clearGlueDirectory();
        this.processFileInstances();
        List<ResolvedDirective> resolvedDirectivesList = this.computeResolvedDirectives();
        this.importFilePaths = this.createImportGlueFiles();
        this.createSplitFile(this.splitInvocation(resolvedDirectivesList));
        return true;
    }

    private void clearGlueDirectory() throws Exception {
        Path glueDirPath = Paths.get(this.projectLocation, ".dvt", "split_config");
        if (glueDirPath.toFile().exists()) {
            DVTFileUtils.getInstance().removeRecursive(glueDirPath);
        }
    }

    private void processFileInstances() throws Exception {
        IRfFileInstanceVisitor fileVisitor = new IRfFileInstanceVisitor(){

            @Override
            public void preVisit(VlogFileInstance fileInstance) {
                for (SplitInvocationStrategy strategy : SplitInvocation.this.splitStrategies) {
                    strategy.preprocessFileInstance(fileInstance);
                }
            }

            @Override
            public boolean visit(VlogFileInstance fileInstance) {
                if (SplitInvocation.this.monitor.isCanceled()) {
                    throw new BuildCancelException();
                }
                boolean shouldVisit = false;
                for (SplitInvocationStrategy strategy : SplitInvocation.this.splitStrategies) {
                    if (strategy.isFileVisited(fileInstance)) continue;
                    shouldVisit = true;
                    break;
                }
                if (!shouldVisit) {
                    return false;
                }
                boolean shouldVisitChildren = false;
                for (SplitInvocationStrategy strategy : SplitInvocation.this.splitStrategies) {
                    if (!strategy.shouldVisitIncludedFiles(fileInstance)) continue;
                    shouldVisitChildren = true;
                    break;
                }
                return shouldVisitChildren;
            }

            @Override
            public void postVisit(VlogFileInstance fileInstance) {
                for (SplitInvocationStrategy strategy : SplitInvocation.this.splitStrategies) {
                    strategy.postprocessFileInstance(fileInstance);
                }
            }
        };
        this.topFile.visitInstances(fileVisitor);
    }

    private List<ResolvedDirective> computeResolvedDirectives() {
        ArrayList<ResolvedDirective> resolvedDirectivesList = new ArrayList<ResolvedDirective>();
        HashSet<String> prependDirectives = new HashSet<String>();
        for (ResolvedDirective originalDirective : BuildConfigManager.getDirectiveList((IProject)this.project)) {
            List resolvedPathList;
            String fullDirective = originalDirective.getDirective();
            if (fullDirective == null) continue;
            if (originalDirective.isFromPrepend()) {
                if (prependDirectives.contains(fullDirective)) continue;
                prependDirectives.add(fullDirective);
            }
            if ((resolvedPathList = originalDirective.getFullPaths()).size() == 1) {
                List fullPaths;
                DVTPair resolvedPathEntry = (DVTPair)resolvedPathList.get(0);
                String path = (String)resolvedPathEntry.getKey();
                if (path == null || (fullPaths = (List)resolvedPathEntry.getValue()) == null) continue;
                for (String fullPath : fullPaths) {
                    ResolvedDirective resolvedDirective;
                    if (fullPath == null) {
                        resolvedDirective = originalDirective.createDirectiveFromDirectiveName(fullDirective);
                        resolvedDirective.setInexistentPath(true);
                    } else {
                        String replacedFullDirective = fullDirective.replace(path, fullPath);
                        resolvedDirective = originalDirective.createDirectiveFromDirectiveName(replacedFullDirective);
                    }
                    resolvedDirectivesList.add(resolvedDirective);
                }
                continue;
            }
            String replacedFullDirective = fullDirective;
            int replaceIndex = 0;
            for (DVTPair resolvedPathEntry : resolvedPathList) {
                int index;
                List fullPaths;
                String path = (String)resolvedPathEntry.getKey();
                if (path == null || (fullPaths = (List)resolvedPathEntry.getValue()) == null || fullPaths.isEmpty()) continue;
                String fullPath = (String)fullPaths.get(0);
                if (fullPath == null) {
                    originalDirective.setInexistentPath(true);
                    continue;
                }
                if (replaceIndex >= replacedFullDirective.length() || (index = replacedFullDirective.indexOf(path, replaceIndex)) == -1) break;
                replacedFullDirective = String.valueOf(replacedFullDirective.substring(0, index)) + fullPath + replacedFullDirective.substring(index + path.length());
                replaceIndex = index + fullPath.length();
            }
            resolvedDirectivesList.add(originalDirective.createDirectiveFromDirectiveName(replacedFullDirective));
        }
        return resolvedDirectivesList;
    }

    private Map<Integer, String> createImportGlueFiles() throws Exception {
        HashMap<Integer, String> invocationImportsFilePaths = new HashMap<Integer, String>();
        Map<Integer, Set<String>> allImports = this.getAllImports();
        if (allImports.isEmpty()) {
            return invocationImportsFilePaths;
        }
        Path glueDirPath = SplitInvocationUtils.getOrCreateGlueDirectory((IProject)this.project);
        for (Map.Entry<Integer, Set<String>> invocationImports : allImports.entrySet()) {
            Integer invocationNo = invocationImports.getKey();
            Set<String> imports = invocationImports.getValue();
            String glueFileName = IMPORT_FILE_NAME_PREFIX + invocationNo + ".sv";
            Path filePath = Paths.get(glueDirPath.toString(), glueFileName);
            Throwable throwable = null;
            Object var11_12 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);){
                for (String imported : imports) {
                    String importedString = "import " + imported + ";";
                    writer.write(importedString);
                    writer.newLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            invocationImportsFilePaths.put(invocationNo, filePath.toAbsolutePath().toString());
        }
        return invocationImportsFilePaths;
    }

    private Map<Integer, Set<String>> getAllImports() {
        HashMap<Integer, Set<String>> allImports = new HashMap<Integer, Set<String>>();
        Collection<RfLibrary> rfLibraries = this.rfProject.getLibraries();
        if (rfLibraries == null) {
            return allImports;
        }
        for (RfLibrary library : rfLibraries) {
            NullProtectedList<ImportInfo> allLibraryImports = library.getAllImportDeclarations();
            if (allLibraryImports == null || allLibraryImports.isEmpty()) continue;
            for (ImportInfo libraryImport : allLibraryImports) {
                if (libraryImport.getInvocNumber() == -1) continue;
                String importStr = String.valueOf(libraryImport.getPackageName()) + "::";
                if (libraryImport instanceof ExplicitImportInfo) {
                    ExplicitImportInfo explicitLibraryImport = (ExplicitImportInfo)libraryImport;
                    importStr = String.valueOf(importStr) + explicitLibraryImport.getElementName();
                } else {
                    importStr = String.valueOf(importStr) + "*";
                }
                HashSet<String> currentInvocationLibraryImports = (HashSet<String>)allImports.get(libraryImport.getInvocNumber());
                if (currentInvocationLibraryImports == null) {
                    currentInvocationLibraryImports = new HashSet<String>();
                    allImports.put(libraryImport.getInvocNumber(), currentInvocationLibraryImports);
                }
                currentInvocationLibraryImports.add(importStr);
            }
        }
        return allImports;
    }

    private void createSplitFile(String splitString) throws Exception {
        String splitFileName = String.valueOf(BuildConfigManagerCommon.getActiveBuildConfig((IProject)this.project).getName()) + ".build.split";
        Path splitFilePath = Paths.get(this.projectLocation, ".dvt", splitFileName);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(splitFilePath, new OpenOption[0]);){
            writer.write(splitString);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        IFolder dvtFolder = this.project.getFolder(".dvt");
        IFolder glueFolder = this.project.getFolder(Paths.get(".dvt", "split_config").toString());
        dvtFolder.refreshLocal(1, null);
        glueFolder.refreshLocal(1, null);
        IFile iSplitFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(this.project, splitFilePath.toAbsolutePath().toString());
        if (iSplitFile != null) {
            VlogSplitInvocationUtils.openSplitFile(iSplitFile);
        }
    }

    private String splitInvocation(List<ResolvedDirective> resolvedDirectivesList) throws Exception {
        StringBuilder splitBuild = new StringBuilder();
        StringBuilder implicitInvocation = new StringBuilder();
        StringBuilder prependInvocation = new StringBuilder();
        StringBuilder uvmInvocation = new StringBuilder();
        this.allInvocations = new StringBuilder();
        this.currentInvocation = new StringBuilder();
        for (ResolvedDirective resolvedDirective : resolvedDirectivesList) {
            if (this.monitor.isCanceled()) {
                throw new BuildCancelException();
            }
            String fullDirective = resolvedDirective.getDirective();
            String directiveName = this.getDirectiveNameOnly(fullDirective);
            if (fullDirective == null || directiveName.equals("-f") || directiveName.equals("-F")) continue;
            if (directiveName.equals("-uvm")) {
                this.createUvmInvocation(uvmInvocation, fullDirective);
                continue;
            }
            if (directiveName.equals("+dvt_prepend_init")) continue;
            if (resolvedDirective.isFromPrepend()) {
                this.initPrependInvocation(prependInvocation);
                this.addDirectiveToInvocation(resolvedDirective, prependInvocation);
                this.updateCurrentCompiledFileStartIndex(directiveName);
                continue;
            }
            if (IBuildConfigParserConstants.DVT_INIT_PATTERN.matcher(fullDirective).matches()) {
                this.endOriginalInvocation();
                this.currentOriginalInvocationState.resetInvocationState(fullDirective, this.invocations);
                continue;
            }
            if (this.isGlobalDirective(resolvedDirective)) {
                this.addDirectiveToInvocation(resolvedDirective, implicitInvocation);
                continue;
            }
            if (fullDirective.startsWith("-") || fullDirective.startsWith("+")) {
                this.addDirectiveToInvocation(resolvedDirective, this.currentOriginalInvocationState.prependDashF);
                continue;
            }
            if (!this.rfProject.isCompiled(new ParserPath(fullDirective))) {
                this.addDirectiveToInvocation(resolvedDirective, this.currentOriginalInvocationState.prependDashF);
                continue;
            }
            boolean shouldSplit = false;
            for (SplitInvocationStrategy strategy : this.splitStrategies) {
                if (!strategy.shouldSplit(fullDirective, this.currentOriginalInvocationState)) continue;
                shouldSplit = true;
                break;
            }
            if (shouldSplit) {
                this.createInvocation(fullDirective);
                for (SplitInvocationStrategy strategy : this.splitStrategies) {
                    strategy.initInvocation(fullDirective);
                }
            }
            this.addDirectiveToInvocation(resolvedDirective, this.currentInvocation);
            for (SplitInvocationStrategy strategy : this.splitStrategies) {
                strategy.updateInvocation(fullDirective);
            }
            this.updateCurrentCompiledFileStartIndex(directiveName);
        }
        if (implicitInvocation.length() != 0) {
            implicitInvocation.append("\n");
        }
        if (prependInvocation.length() != 0) {
            prependInvocation.append("\n");
        }
        if (uvmInvocation.length() != 0) {
            uvmInvocation.append("\n");
        }
        this.endOriginalInvocation();
        splitBuild.append((CharSequence)implicitInvocation).append((CharSequence)prependInvocation).append((CharSequence)uvmInvocation);
        for (SplitInvocationStrategy strategy : this.splitStrategies) {
            if (this.monitor.isCanceled()) {
                throw new BuildCancelException();
            }
            splitBuild.append((CharSequence)strategy.createStrategyInvocation(this.currentOriginalInvocationState));
        }
        splitBuild.append((CharSequence)this.allInvocations);
        return splitBuild.toString();
    }

    private String getDirectiveNameOnly(String fullDirective) {
        if (fullDirective == null) {
            return "";
        }
        if (!fullDirective.startsWith("+") && !fullDirective.startsWith("-")) {
            return fullDirective;
        }
        if (fullDirective.startsWith("-I")) {
            return "-I";
        }
        if (fullDirective.startsWith("-L")) {
            return "-D";
        }
        if (fullDirective.startsWith("-L")) {
            return "-L";
        }
        char directiveNameStartDelim = fullDirective.charAt(0);
        String[] directiveTokens = (fullDirective = fullDirective.substring(1)).split(DIRECTIVE_DELIMITER.toString());
        return directiveTokens.length == 0 ? "" : String.valueOf(directiveNameStartDelim) + directiveTokens[0];
    }

    private void createUvmInvocation(StringBuilder uvmInvocation, String directiveName) {
        if (uvmInvocation.length() == 0) {
            uvmInvocation.append("+dvt_init").append("\n");
            uvmInvocation.append(INVOCATION_START_DELIMITER).append(UVM_INVOCATION).append(INVOCATION_END_DELIMITER).append("\n");
            uvmInvocation.append(directiveName).append("\n");
        }
    }

    private void endOriginalInvocation() throws Exception {
        this.endSplitInvocation();
        this.addAllInvocations(this.allInvocations);
        this.currentOriginalInvocationState.currentInvocationSplits.clear();
    }

    private void addDirectiveToInvocation(ResolvedDirective resolvedDirective, StringBuilder invocation) {
        String directiveName = resolvedDirective.getDirective();
        String resolvedDir = this.checkSpacesInDirective(directiveName);
        if (!resolvedDirective.isInexistentPath()) {
            invocation.append(resolvedDir).append("\n");
        } else {
            invocation.append(resolvedDir).append(INEXISTENT_PATH).append("\n");
        }
    }

    private String checkSpacesInDirective(String fullDirective) {
        String[] argToks;
        String directiveName = this.getDirectiveNameOnly(fullDirective);
        if (directiveName.equals("+dvt_setenv") || directiveName.equals("+dvt_env") || directiveName.equals(PLUS_DEFINE) || directiveName.equals(PLUS_DEFINEALL)) {
            int startIdx;
            String[] dirArgs = fullDirective.split("\\+");
            int i = startIdx = fullDirective.startsWith("-") ? 1 : 2;
            while (i < dirArgs.length) {
                String dirArg = dirArgs[i];
                if (!dirArg.isEmpty()) {
                    String[] argToks2 = dirArg.split("=", 2);
                    int j = 0;
                    while (j < argToks2.length) {
                        String argTok = argToks2[j];
                        if (argTok.contains(" ")) {
                            fullDirective = fullDirective.replace(argTok, "\"" + argTok + "\"");
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if ((directiveName.equals("-define") || directiveName.equals("-defineall") || directiveName.equals("-sndefine")) && (argToks = fullDirective.split("=", 2)).length > 1 && argToks[1].contains(" ")) {
            fullDirective = fullDirective.replace(argToks[1], "\"" + argToks[1] + "\"");
        }
        if (!fullDirective.startsWith("-") && !fullDirective.startsWith("+") && fullDirective.contains(" ")) {
            return "\"" + fullDirective + "\"";
        }
        return fullDirective;
    }

    private boolean isGlobalDirective(ResolvedDirective resolvedDirective) {
        String directiveName = this.getDirectiveNameOnly(resolvedDirective.getDirective());
        for (String globalDirective : SplitInvocationUtils.globalDirectives) {
            if (!directiveName.equals(globalDirective)) continue;
            return true;
        }
        for (IBuildConfigParserConstants.Directive directive : IBuildConfigParserConstants.Directive.values()) {
            if (!directive.isFirstInvocationOnly() || !directiveName.equals("+" + directive.toString())) continue;
            return true;
        }
        return false;
    }

    private void initPrependInvocation(StringBuilder prependInvocation) {
        if (prependInvocation.length() == 0) {
            prependInvocation.append("+dvt_prepend_init").append("\n");
            prependInvocation.append(INVOCATION_START_DELIMITER).append(PREPEND_INVOCATION).append(INVOCATION_END_DELIMITER).append("\n");
        }
    }

    private VlogFileInstance getLastTopFileInstance(String directiveName) {
        if (directiveName.startsWith("-") || directiveName.startsWith("+")) {
            return null;
        }
        VlogFileInstance lastTopFileInstance = null;
        ParserPath directiveParserPath = new ParserPath(directiveName);
        int i = this.currentCompiledFileStartIndex + 1;
        while (i < this.compiledTopFiles.size()) {
            VlogFileInstance compiledFile = this.compiledTopFiles.get(i);
            if (directiveParserPath.equals((Object)compiledFile.getParserPath())) {
                if (i <= 0) break;
                lastTopFileInstance = this.compiledTopFiles.get(i - 1);
                break;
            }
            ++i;
        }
        return lastTopFileInstance;
    }

    private void updateCurrentCompiledFileStartIndex(String directiveName) {
        if (directiveName.startsWith("-") || directiveName.startsWith("+")) {
            return;
        }
        ParserPath directiveParserPath = new ParserPath(directiveName);
        int i = 0;
        while (i < this.compiledTopFiles.size()) {
            VlogFileInstance compiledFile = this.compiledTopFiles.get(i);
            if (compiledFile.getParserPath().equals((Object)directiveParserPath) && i > this.currentCompiledFileStartIndex) {
                this.currentCompiledFileStartIndex = i;
                return;
            }
            ++i;
        }
    }

    private void createInvocation(String directiveName) throws Exception {
        VlogFileInstance lastTopCompiledFile;
        if (!this.currentOriginalInvocationState.isFirstFileCompiled) {
            this.currentOriginalInvocationState.isFirstFileCompiled = true;
        }
        if ((lastTopCompiledFile = this.getLastTopFileInstance(directiveName)) == null) {
            return;
        }
        this.endSplitInvocation();
        String macroFilePath = this.createMacroGlueFile(lastTopCompiledFile);
        String importFilePath = this.importFilePaths.get(this.currentOriginalInvocationState.invocationIndex);
        if (macroFilePath != null) {
            this.currentInvocation.append(macroFilePath).append("\n");
        }
        if (importFilePath != null) {
            this.currentInvocation.append(importFilePath).append("\n");
        }
    }

    private void endSplitInvocation() {
        if (this.currentInvocation.length() == 0) {
            return;
        }
        StringBuilder lastInvocationContent = new StringBuilder(this.currentInvocation);
        StringBuilder lastInvocationComment = this.getInvocationTypeComment();
        this.currentOriginalInvocationState.currentInvocationSplits.add((DVTPair<StringBuilder, StringBuilder>)new DVTPair((Object)lastInvocationContent, (Object)lastInvocationComment));
        this.currentInvocation.setLength(0);
    }

    private void addAllInvocations(StringBuilder allInvocations) throws Exception {
        for (DVTPair<StringBuilder, StringBuilder> currentInvocationSplit : this.currentOriginalInvocationState.currentInvocationSplits) {
            StringBuilder invocationContent = (StringBuilder)currentInvocationSplit.getKey();
            StringBuilder invocationComment = (StringBuilder)currentInvocationSplit.getValue();
            StringBuilder invocationPrependDashF = this.createPrependDashF();
            allInvocations.append(this.currentOriginalInvocationState.dvtInitInvocation).append("\n").append((CharSequence)invocationComment).append((CharSequence)invocationPrependDashF).append((CharSequence)invocationContent).append("\n");
        }
    }

    private StringBuilder createPrependDashF() throws Exception {
        StringBuilder prependDashF = new StringBuilder();
        if (this.currentOriginalInvocationState.prependDashF.length() == 0) {
            return prependDashF;
        }
        Path glueDirPath = SplitInvocationUtils.getOrCreateGlueDirectory((IProject)this.project);
        String glueFileName = PREPEND_DASH_F_FILE_NAME_PREFIX + this.currentOriginalInvocationState.invocationIndex + ".f";
        Path filePath = Paths.get(glueDirPath.toString(), glueFileName);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);){
            writer.write(this.currentOriginalInvocationState.prependDashF.toString());
            writer.newLine();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        prependDashF.append("-f ").append(filePath.toAbsolutePath().toString()).append("\n");
        return prependDashF;
    }

    private StringBuilder getInvocationTypeComment() {
        StringBuilder invocationTypeComment = new StringBuilder();
        invocationTypeComment.append(INVOCATION_START_DELIMITER);
        for (SplitInvocationStrategy strategy : this.splitStrategies) {
            strategy.getInvocationComment(invocationTypeComment);
        }
        invocationTypeComment.append(ORIGINAL_INVOCATION_LINE_START).append(this.currentOriginalInvocationState.invocationStartLine).append(" ---\n");
        return invocationTypeComment;
    }

    private String createMacroGlueFile(VlogFileInstance lastCompiledFile) throws Exception {
        ArrayList<VlogMacroInfo> allDefines = new ArrayList<VlogMacroInfo>();
        lastCompiledFile.getAllDefines(allDefines);
        StringBuilder allDefinesString = new StringBuilder();
        int i = allDefines.size() - 1;
        while (i >= 0) {
            VlogMacroInfo define = (VlogMacroInfo)allDefines.get(i);
            if (!VlogSplitInvocationUtilsCommon.skipDefine(define, this.topFile)) {
                if (define.getFileInstance().getInvocNumber() != this.currentOriginalInvocationState.invocationIndex) break;
                String defineString = VlogSplitInvocationUtilsCommon.buildDefineMacro(define);
                allDefinesString.append(defineString).append("\n");
            }
            --i;
        }
        if (allDefinesString.length() == 0) {
            return null;
        }
        Path glueDirPath = SplitInvocationUtils.getOrCreateGlueDirectory((IProject)this.project);
        ++this.currentOriginalInvocationState.glueMacroFileNumber;
        String glueFileName = MACRO_FILE_NAME_PREFIX + this.currentOriginalInvocationState.invocationIndex + "_" + this.currentOriginalInvocationState.glueMacroFileNumber + ".sv";
        Path filePath = Paths.get(glueDirPath.toString(), glueFileName);
        Throwable throwable = null;
        Object var8_10 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);){
            writer.write(allDefinesString.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return filePath.toAbsolutePath().toString();
    }
}

