/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.buildconfig.splitinvocation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.buildconfig.splitinvocation.OriginalInvocationState;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationStrategy;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;

class SplitInvocationDVStrategy
implements SplitInvocationStrategy {
    private static final String DESIGN_INVOCATION = "DESIGN INVOCATION";
    private static final String VERIFICATION_INVOCATION = "VERIFICATION INVOCATION";
    private RfProject rfProject;
    private Map<String, FileType> fileTypes;
    private FileType currentInvocationType;

    public SplitInvocationDVStrategy(RfProject rfProject) {
        this.rfProject = rfProject;
        this.fileTypes = new HashMap<String, FileType>();
        this.currentInvocationType = FileType.NONE;
    }

    @Override
    public boolean shouldSplit(String fullDirective, OriginalInvocationState originalInvocationState) throws Exception {
        FileType fileType = this.fileTypes.get(fullDirective);
        switch (fileType) {
            case DESIGN: {
                if (originalInvocationState.isFirstFileCompiled && this.currentInvocationType != FileType.VERIFICATION) break;
                return true;
            }
            case VERIFICATION: {
                if (originalInvocationState.isFirstFileCompiled && this.currentInvocationType != FileType.DESIGN) break;
                return true;
            }
            case DONT_CARE: {
                if (originalInvocationState.isFirstFileCompiled) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFileVisited(VlogFileInstance fileInstance) {
        ParserPath parserPath = fileInstance.getParserPath();
        String fileFullPath = parserPath.getCanonicalPath();
        return this.fileTypes.get(fileFullPath) != null;
    }

    @Override
    public boolean shouldVisitIncludedFiles(VlogFileInstance fileInstance) {
        ParserPath parserPath = fileInstance.getParserPath();
        String fileFullPath = parserPath.getCanonicalPath();
        RfFileDef fileDef = this.rfProject.getFileDefUsingParserPath(parserPath);
        FileType fileType = this.checkDesignOrVerification(fileDef);
        if (fileType == FileType.VERIFICATION) {
            this.fileTypes.put(fileFullPath, fileType);
            return false;
        }
        return true;
    }

    @Override
    public void initInvocation(String fullDirective) {
        FileType fileType;
        this.currentInvocationType = fileType = this.fileTypes.get(fullDirective);
    }

    @Override
    public void updateInvocation(String fullDirective) {
        FileType fileType = this.fileTypes.get(fullDirective);
        this.currentInvocationType = fileType == FileType.DONT_CARE ? this.currentInvocationType : fileType;
    }

    @Override
    public void getInvocationComment(StringBuilder invocationTypeComment) {
        switch (this.currentInvocationType) {
            case DESIGN: {
                invocationTypeComment.append(DESIGN_INVOCATION);
                break;
            }
            case VERIFICATION: {
                invocationTypeComment.append(VERIFICATION_INVOCATION);
                break;
            }
        }
        invocationTypeComment.append(" --- ");
    }

    @Override
    public void postprocessFileInstance(VlogFileInstance fileInstance) {
        ParserPath parserPath = fileInstance.getParserPath();
        String fileFullPath = parserPath.getCanonicalPath();
        RfFileDef fileDef = this.rfProject.getFileDefUsingParserPath(parserPath);
        FileType fileType = this.checkDesignOrVerification(fileDef);
        if (fileType != FileType.VERIFICATION) {
            for (VlogFileInstance childInstance : fileInstance.getIncludedInstances()) {
                String childFullPath;
                if (childInstance == null || this.fileTypes.get(childFullPath = childInstance.getParserPath().getCanonicalPath()) != FileType.VERIFICATION) continue;
                fileType = FileType.VERIFICATION;
                break;
            }
        }
        this.fileTypes.put(fileFullPath, fileType);
    }

    @Override
    public StringBuilder createStrategyInvocation(OriginalInvocationState originalInvocationState) throws Exception {
        return new StringBuilder("");
    }

    private FileType checkDesignOrVerification(RfDefElement defElement) {
        FileType fileType = FileType.DONT_CARE;
        Collection<RfDefElement> children = defElement.getChildren();
        if (children == null) {
            return fileType;
        }
        for (RfDefElement child : children) {
            RfNamedElement namedElement = child.getNamedElement();
            if (namedElement instanceof IRfDesignElement || namedElement instanceof RfInstance.RfBindInstance) {
                fileType = this.checkDesignOrVerification(child);
                if (fileType != FileType.DONT_CARE) continue;
                fileType = FileType.DESIGN;
                continue;
            }
            if (!(namedElement instanceof RfClass) && !(namedElement instanceof RfPackage) && !(namedElement instanceof RfProgram) && !(namedElement instanceof RfChecker)) continue;
            fileType = FileType.VERIFICATION;
            break;
        }
        return fileType;
    }

    private static enum FileType {
        DESIGN,
        VERIFICATION,
        DONT_CARE,
        NONE;

    }
}

