/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.buildconfig.splitinvocation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.buildconfig.splitinvocation.OriginalInvocationState;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationStrategy;
import ro.amiq.vlogdt.buildconfig.splitinvocation.VlogSplitInvocationUtilsCommon;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

class SplitInvocationLibraryStrategy
implements SplitInvocationStrategy {
    private static final String LIBRARY_FILES_INVOCATION = "LIBRARY FILES";
    private static final String LIBRARY_FILE_NAME_PREFIX = "glue_library_file_";
    private static final String LIBRARY_VCS_FOLDER_NAME_PREFIX = "glue_library_folder_";
    private RfProject rfProject;
    private Set<VlogFileInstance> originalLibfiles;
    private List<String> libraryFiles;

    public SplitInvocationLibraryStrategy(RfProject rfProject) {
        this.rfProject = rfProject;
        this.originalLibfiles = new LinkedHashSet<VlogFileInstance>();
        this.libraryFiles = new ArrayList<String>();
    }

    @Override
    public boolean shouldSplit(String fullDirective, OriginalInvocationState originalInvocationState) throws Exception {
        return false;
    }

    @Override
    public boolean shouldVisitIncludedFiles(VlogFileInstance fileInstance) {
        return true;
    }

    @Override
    public void initInvocation(String fullDirective) {
    }

    @Override
    public void updateInvocation(String fullDirective) {
    }

    @Override
    public void getInvocationComment(StringBuilder invocationTypeComment) {
    }

    @Override
    public void postprocessFileInstance(VlogFileInstance fileInstance) {
    }

    @Override
    public boolean isFileVisited(VlogFileInstance fileInstance) {
        return false;
    }

    @Override
    public void preprocessFileInstance(VlogFileInstance fileInstance) {
        IDVTFileInstance parentInstance = fileInstance.getIncludingInstance();
        if (!(parentInstance instanceof VlogFileInstance)) {
            return;
        }
        String parentShortFileName = ((VlogFileInstance)parentInstance).getShortFileName();
        if (parentShortFileName == null) {
            return;
        }
        if (parentShortFileName.startsWith("__vlog__") && parentShortFileName.endsWith(".libfile") || this.originalLibfiles.contains(parentInstance)) {
            this.originalLibfiles.add(fileInstance);
        }
    }

    @Override
    public StringBuilder createStrategyInvocation(OriginalInvocationState originalInvocationState) throws Exception {
        String projectMacroFile;
        HashMap<String, Integer> glueLibraryFileVCSModeMap = new HashMap<String, Integer>();
        HashMap<String, Integer> glueLibraryFileMap = new HashMap<String, Integer>();
        ArrayList<String> compiledLibraryFilesElements = new ArrayList<String>();
        ArrayList<String> compiledLibraryFolderElements = new ArrayList<String>();
        String libraryInvocationMinusWork = null;
        SplitInvocationUtils.createLibraryLastModified((IProject)this.rfProject.getProject());
        for (VlogFileInstance originalLibraryFile : this.originalLibfiles) {
            Collection<RfDefElement> compiledLibraryFileChildren;
            RfFileDef fileDef;
            if (libraryInvocationMinusWork == null) {
                libraryInvocationMinusWork = originalLibraryFile.getSemanticScope().getName();
            }
            HashSet<String> undeclaredElements = originalLibraryFile.getUndeclaredElements() == null ? null : new HashSet<String>(originalLibraryFile.getUndeclaredElements());
            String originalLibraryFilePath = originalLibraryFile.getParserPath().getCanonicalPath();
            if (undeclaredElements != null) {
                if (originalLibraryFile.getIsVcsModeForMinusY()) {
                    if (undeclaredElements.size() == 1) continue;
                    String compiledLibraryFileParentDirectoryPath = Paths.get(originalLibraryFilePath, new String[0]).getParent().toString();
                    Integer glueLibraryFileVCSModeIndex = (Integer)glueLibraryFileVCSModeMap.get(compiledLibraryFileParentDirectoryPath);
                    if (glueLibraryFileVCSModeIndex == null) {
                        glueLibraryFileVCSModeIndex = glueLibraryFileVCSModeMap.size() + 1;
                        glueLibraryFileVCSModeMap.put(compiledLibraryFileParentDirectoryPath, glueLibraryFileVCSModeIndex);
                    }
                    this.createOrAppendLibraryFile(originalLibraryFile, undeclaredElements, glueLibraryFileVCSModeIndex, false, compiledLibraryFolderElements);
                    continue;
                }
                if (undeclaredElements.size() == 1) continue;
                Integer glueLibraryFileIndex = (Integer)glueLibraryFileMap.get(originalLibraryFilePath);
                if (glueLibraryFileIndex == null) {
                    glueLibraryFileIndex = glueLibraryFileMap.size() + 1;
                    glueLibraryFileMap.put(originalLibraryFilePath, glueLibraryFileIndex);
                }
                this.createOrAppendLibraryFile(originalLibraryFile, undeclaredElements, glueLibraryFileIndex, true, compiledLibraryFilesElements);
                continue;
            }
            String parentShortFileName = ((VlogFileInstance)originalLibraryFile.getIncludingInstance()).getShortFileName();
            if (parentShortFileName.startsWith("__vlog__") && parentShortFileName.endsWith(".libfile")) {
                this.libraryFiles.add(originalLibraryFilePath);
            }
            if ((fileDef = this.rfProject.getFileDefUsingParserPath(originalLibraryFile.getParserPath())) == null || (compiledLibraryFileChildren = fileDef.getChildren()) == null) continue;
            for (RfDefElement compiledLibraryFileChild : compiledLibraryFileChildren) {
                String compiledLibraryFileChildName = compiledLibraryFileChild.getName();
                compiledLibraryFolderElements.add(compiledLibraryFileChildName);
            }
        }
        SplitInvocationUtils.getOrCreateGlueDirectory((IProject)this.rfProject.getProject());
        VlogSplitInvocationUtilsCommon.saveLibraryElements(this.rfProject.getProject(), compiledLibraryFilesElements, "glue_compiled_library_files_elements");
        VlogSplitInvocationUtilsCommon.saveLibraryElements(this.rfProject.getProject(), compiledLibraryFolderElements, "glue_compiled_library_folder_elements");
        List<String> undeclaredElements = VlogSplitInvocationUtilsCommon.getUndeclaredElements();
        VlogSplitInvocationUtilsCommon.saveLibraryElements(this.rfProject.getProject(), undeclaredElements, "glue_undeclared_elements");
        List<String> unresolvedElements = VlogSplitInvocationUtilsCommon.getUnresolvedElements();
        VlogSplitInvocationUtilsCommon.saveLibraryElements(this.rfProject.getProject(), unresolvedElements, "glue_unresolved_elements");
        StringBuilder libraryFilesInvocation = new StringBuilder();
        if (this.libraryFiles == null || this.libraryFiles.isEmpty()) {
            return libraryFilesInvocation;
        }
        libraryFilesInvocation.append("+dvt_init").append("\n");
        libraryFilesInvocation.append("// --- ").append(LIBRARY_FILES_INVOCATION).append(" INVOCATION --- ").append("\n");
        if (libraryInvocationMinusWork != null && !libraryInvocationMinusWork.equals("work")) {
            libraryFilesInvocation.append("-work ").append(libraryInvocationMinusWork).append("\n");
        }
        if ((projectMacroFile = this.createProjectGlueMacroFile(originalInvocationState)) != null) {
            libraryFilesInvocation.append(projectMacroFile).append("\n");
        }
        for (String libraryFile : this.libraryFiles) {
            libraryFilesInvocation.append(libraryFile).append("\n");
        }
        libraryFilesInvocation.append("\n");
        return libraryFilesInvocation;
    }

    private void createOrAppendLibraryFile(VlogFileInstance fileInstance, Set<String> compiledElements, Integer glueLibraryFileIndex, boolean isMinusV, List<String> compiledLibraryElements) throws IOException {
        RfFileDef fileDef = this.rfProject.getFileDefUsingParserPath(fileInstance.getParserPath());
        if (fileDef == null) {
            return;
        }
        Collection<RfDefElement> children = fileDef.getChildren();
        if (children == null) {
            return;
        }
        Path glueDirPath = SplitInvocationUtils.getOrCreateGlueDirectory((IProject)this.rfProject.getProject());
        String glueLibraryFileName = null;
        glueLibraryFileName = isMinusV ? LIBRARY_FILE_NAME_PREFIX + glueLibraryFileIndex + ".v" : LIBRARY_VCS_FOLDER_NAME_PREFIX + glueLibraryFileIndex + ".v";
        Path outputFilePath = Paths.get(glueDirPath.toString(), glueLibraryFileName);
        if (!Files.exists(outputFilePath, new LinkOption[0])) {
            this.libraryFiles.add(outputFilePath.toString());
        }
        Path inputFilePath = Paths.get(fileInstance.getParserPath().getCanonicalPath(), new String[0]);
        ArrayList<VlogMacroInfo> fileDefines = new ArrayList<VlogMacroInfo>();
        fileInstance.getDefinesInFile(fileDefines);
        for (VlogMacroInfo fileDefine : fileDefines) {
            if (VlogSplitInvocationUtilsCommon.skipDefine(fileDefine, this.rfProject.getPreprocessingTable().getTopFileInstance())) continue;
            int defineStartLine = fileDefine.getLine();
            int defineEndLine = fileDefine.getEndLine();
            this.copyLines(inputFilePath, outputFilePath, defineStartLine, defineEndLine, false);
        }
        String originalFileString = String.valueOf(fileDefines.isEmpty() ? "" : "\n") + "// Original file: " + fileInstance.getParserPath().getCanonicalPath();
        this.copyString(outputFilePath, originalFileString);
        for (RfDefElement child : children) {
            if (!compiledElements.contains(child.getName())) continue;
            int childStartLine = child.getStartLine();
            int childEndLine = child.getEndLine();
            this.copyLines(inputFilePath, outputFilePath, childStartLine, childEndLine, true);
            compiledLibraryElements.add(child.getName());
        }
    }

    private String createProjectGlueMacroFile(OriginalInvocationState originalInvocationState) throws IOException {
        List<VlogMacroInfo> allProjectDefines = this.rfProject.getAllMacros();
        StringBuilder allDefinesString = new StringBuilder();
        int i = 0;
        while (i < allProjectDefines.size()) {
            VlogMacroInfo define = allProjectDefines.get(i);
            if (!VlogSplitInvocationUtilsCommon.skipDefine(define, this.rfProject.getPreprocessingTable().getTopFileInstance())) {
                String defineString = VlogSplitInvocationUtilsCommon.buildDefineMacro(define);
                allDefinesString.append(defineString).append("\n");
            }
            ++i;
        }
        if (allDefinesString.length() == 0) {
            return null;
        }
        Path glueDirPath = SplitInvocationUtils.getOrCreateGlueDirectory((IProject)this.rfProject.getProject());
        ++originalInvocationState.glueMacroFileNumber;
        String glueFileName = "glue_macro_project.v";
        Path filePath = Paths.get(glueDirPath.toString(), glueFileName);
        Throwable throwable = null;
        Object var8_10 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);){
            writer.write(allDefinesString.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return filePath.toAbsolutePath().toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyLines(Path inputFilePath, Path outputFilePath, int startLine, int endLine, boolean endWithNewline) throws IOException {
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            BufferedReader reader = Files.newBufferedReader(inputFilePath);
            try {
                try (BufferedWriter writer = Files.newBufferedWriter(outputFilePath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                    String line;
                    int currentLine = 1;
                    while ((line = reader.readLine()) != null) {
                        if (currentLine >= startLine && currentLine <= endLine) {
                            writer.write(line);
                            writer.newLine();
                        }
                        if (currentLine > endLine) break;
                        ++currentLine;
                    }
                    if (endWithNewline) {
                        writer.newLine();
                    }
                }
                if (reader == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void copyString(Path outputFilePath, String data) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(outputFilePath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                writer.write(String.valueOf(data) + "\n");
                writer.newLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

