/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.buildconfig.splitinvocation;

import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationConfig;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.buildconfig.splitinvocation.OriginalInvocationState;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationStrategy;
import ro.amiq.vlogdt.parser.VlogFileInstance;

class SplitInvocationLineCountStrategy
implements SplitInvocationStrategy {
    private static final String LINE_COUNT_INVOCATION = "LINE COUNT";
    private Map<String, Long> fileExpandedLineCount;
    private long currentInvocationLineCount;
    private long lineThreshold;

    public SplitInvocationLineCountStrategy(SplitInvocationConfig splitConfig) {
        this.lineThreshold = splitConfig.getLineThreshold();
        this.fileExpandedLineCount = new HashMap<String, Long>();
    }

    @Override
    public boolean shouldSplit(String fullDirective, OriginalInvocationState originalInvocationState) throws Exception {
        return !originalInvocationState.isFirstFileCompiled || this.currentInvocationLineCount > this.lineThreshold;
    }

    @Override
    public boolean isFileVisited(VlogFileInstance fileInstance) {
        ParserPath parserPath = fileInstance.getParserPath();
        String fileFullPath = parserPath.getCanonicalPath();
        return this.fileExpandedLineCount.get(fileFullPath) != null;
    }

    @Override
    public boolean shouldVisitIncludedFiles(VlogFileInstance fileInstance) {
        return true;
    }

    @Override
    public void initInvocation(String fullDirective) {
        this.currentInvocationLineCount = 0L;
    }

    @Override
    public void updateInvocation(String fullDirective) {
        this.currentInvocationLineCount += this.fileExpandedLineCount.get(fullDirective).longValue();
    }

    @Override
    public void getInvocationComment(StringBuilder invocationTypeComment) {
        invocationTypeComment.append(LINE_COUNT_INVOCATION).append(": ").append(this.currentInvocationLineCount).append(" --- ");
    }

    @Override
    public void postprocessFileInstance(VlogFileInstance fileInstance) {
        String fileFullPath = fileInstance.getParserPath().getCanonicalPath();
        Long fileLineCount = fileInstance.getNofRawLines();
        for (VlogFileInstance childInstance : fileInstance.getIncludedInstances()) {
            String childFullPath;
            Long childLineCount;
            if (childInstance == null || (childLineCount = this.fileExpandedLineCount.get(childFullPath = childInstance.getParserPath().getCanonicalPath())) == null) continue;
            fileLineCount = fileLineCount + childLineCount;
        }
        this.fileExpandedLineCount.put(fileFullPath, fileLineCount);
    }

    @Override
    public StringBuilder createStrategyInvocation(OriginalInvocationState originalInvocationState) throws Exception {
        return new StringBuilder("");
    }
}

