/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.buildconfig.splitinvocation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationConfig;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationUtils;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.StringReplace;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationFactory;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocation;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationMonitor;
import ro.amiq.vlogdt.buildconfig.splitinvocation.VlogSplitInvocationUtils;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroParameter;
import ro.amiq.vlogdt.parser.VlogMacroText;

public class VlogSplitInvocationUtilsCommon {
    protected static final String SPLIT_FAILED_MESSAGE = "Error occured while splitting";
    public static final String COMPILED_LIBRARY_FILES_ELEMENTS_FILE_NAME = "glue_compiled_library_files_elements";
    public static final String COMPILED_LIBRARY_FOLDER_ELEMENTS_FILE_NAME = "glue_compiled_library_folder_elements";
    public static final String UNDECLARED_ELEMENTS_FILE_NAME = "glue_undeclared_elements";
    public static final String UNRESOLVED_ELEMENTS_FILE_NAME = "glue_unresolved_elements";
    private static List<String> undeclaredElements;
    private static List<String> unresolvedElements;

    public static void init() {
        undeclaredElements = null;
        unresolvedElements = null;
    }

    public static void setUndeclaredElements(List<String> undeclaredElements) {
        VlogSplitInvocationUtilsCommon.undeclaredElements = undeclaredElements;
    }

    public static void setUnresolvedElements(List<String> unresolvedElements) {
        VlogSplitInvocationUtilsCommon.unresolvedElements = unresolvedElements;
    }

    public static List<String> getUndeclaredElements() {
        return undeclaredElements;
    }

    public static List<String> getUnresolvedElements() {
        return unresolvedElements;
    }

    public static void saveLibraryElements(IProject project, List<String> libraryElements, String libraryElementsFileName) throws IOException {
        if (libraryElements == null || libraryElements.isEmpty()) {
            return;
        }
        String libraryElementsFile = VlogSplitInvocationUtilsCommon.getGlueFile(project, libraryElementsFileName);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(libraryElementsFile, new String[0]), new OpenOption[0]);){
            writer.write(String.join((CharSequence)DVTStringUtil.COMMA.pattern(), libraryElements));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<String> getLibraryElements(IProject project, String libraryElementsFileName) {
        if (!SplitInvocationUtils.isSplitConfigUsed((IProject)project)) {
            return null;
        }
        ArrayList<String> libraryElements = new ArrayList();
        String libraryElementsFile = VlogSplitInvocationUtilsCommon.getGlueFile(project, libraryElementsFileName);
        if (!Files.exists(Path.of(libraryElementsFile, new String[0]), new LinkOption[0])) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(libraryElementsFile, new String[0]));){
                String line = reader.readLine();
                String[] tokens = DVTStringUtil.split((Pattern)DVTStringUtil.COMMA, (String)line);
                libraryElements = Arrays.asList(tokens);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new ArrayList<String>();
        }
        return libraryElements;
    }

    public static void resolveSplitUndeclaredElements(IProject project, Set<String> invocationUndeclaredElements) {
        List<String> unresolvedElements;
        if (invocationUndeclaredElements == null) {
            return;
        }
        SplitInvocationConfig splitInvocationConfig = BuildConfigManager.getAutoSplitInvocation((IProject)project);
        if (splitInvocationConfig == null || !splitInvocationConfig.isSplitLibraries()) {
            return;
        }
        if (undeclaredElements == null) {
            undeclaredElements = new ArrayList<String>();
        }
        undeclaredElements.addAll(new ArrayList<String>(invocationUndeclaredElements));
        if (!SplitInvocationUtils.isSplitConfigUsed((IProject)project)) {
            return;
        }
        List<String> compiledLibraryFilesElements = VlogSplitInvocationUtilsCommon.getLibraryElements(project.getProject(), COMPILED_LIBRARY_FILES_ELEMENTS_FILE_NAME);
        List<String> compiledLibraryFolderElements = VlogSplitInvocationUtilsCommon.getLibraryElements(project.getProject(), COMPILED_LIBRARY_FOLDER_ELEMENTS_FILE_NAME);
        if (compiledLibraryFilesElements != null) {
            invocationUndeclaredElements.removeAll(compiledLibraryFilesElements);
        }
        if (compiledLibraryFolderElements != null) {
            invocationUndeclaredElements.removeAll(compiledLibraryFolderElements);
        }
        if ((unresolvedElements = VlogSplitInvocationUtilsCommon.getLibraryElements(project.getProject(), UNRESOLVED_ELEMENTS_FILE_NAME)) != null) {
            invocationUndeclaredElements.removeAll(unresolvedElements);
        }
        if (!invocationUndeclaredElements.isEmpty()) {
            DVTLogger.INSTANCE.logDebug("Added unresolved elements:" + invocationUndeclaredElements.toString());
        }
    }

    public static void checkSplitInvocationCompiledLibraryElements(IProject project, Set<String> unresolvedElements) {
        SplitInvocationConfig splitInvocationConfig = BuildConfigManager.getAutoSplitInvocation((IProject)project);
        if (splitInvocationConfig == null || !splitInvocationConfig.isSplitLibraries()) {
            return;
        }
        VlogSplitInvocationUtilsCommon.unresolvedElements = new ArrayList<String>();
        if (unresolvedElements != null && !unresolvedElements.isEmpty()) {
            VlogSplitInvocationUtilsCommon.unresolvedElements.addAll(unresolvedElements);
        }
        if (!SplitInvocationUtils.isSplitConfigUsed((IProject)project)) {
            return;
        }
        List<String> oldUndeclaredElements = VlogSplitInvocationUtilsCommon.getLibraryElements(project, UNDECLARED_ELEMENTS_FILE_NAME);
        if (oldUndeclaredElements != null && undeclaredElements != null && !oldUndeclaredElements.equals(undeclaredElements)) {
            ArrayList<String> added = new ArrayList<String>(undeclaredElements);
            for (String oldUndeclaredElement : oldUndeclaredElements) {
                added.remove(oldUndeclaredElement);
            }
            ArrayList<String> removed = new ArrayList<String>(oldUndeclaredElements);
            for (String undeclaredElement : undeclaredElements) {
                removed.remove(undeclaredElement);
            }
            if (!removed.isEmpty()) {
                FNotificationFactory.INSTANCE.addDirtySplitInvocationLibraryElement(removed, SplitInvocationUtils.SplitInvocationLibraryElementsMessageType.REMOVED);
            }
            if (!added.isEmpty()) {
                FNotificationFactory.INSTANCE.addDirtySplitInvocationLibraryElement(added, SplitInvocationUtils.SplitInvocationLibraryElementsMessageType.ADDED);
            }
        }
    }

    public static void triggerSplitInvocation(IProject project, SplitInvocationMonitor monitor) {
        SplitInvocationConfig splitInvocationConfig = BuildConfigManager.getAutoSplitInvocation((IProject)project);
        SplitInvocation splitInvocationAction = new SplitInvocation(project, splitInvocationConfig, monitor);
        try {
            try {
                if (splitInvocationAction.split()) {
                    SplitInvocationUtils.serializeBuildConfig((IProject)project);
                }
            }
            catch (BuildCancelException buildCancelException) {
                ObjectionManager.getInstance().clear(Objection.SPLIT_INVOCATION);
            }
            catch (Exception e) {
                VlogSplitInvocationUtils.displayError(SPLIT_FAILED_MESSAGE);
                DVTLogger.INSTANCE.logError((Throwable)e);
                ObjectionManager.getInstance().clear(Objection.SPLIT_INVOCATION);
            }
        }
        finally {
            ObjectionManager.getInstance().clear(Objection.SPLIT_INVOCATION);
        }
    }

    public static String getGlueFile(IProject project, String compiledLibraryElementsFileName) {
        String projectLocation = project.getLocation().makeAbsolute().toOSString();
        String glueDirPath = Paths.get(projectLocation, ".dvt", "split_config").toAbsolutePath().toString();
        return Paths.get(glueDirPath, compiledLibraryElementsFileName).toAbsolutePath().toString();
    }

    public static boolean skipDefine(VlogMacroInfo define, VlogFileInstance topFile) {
        return define.isPredefined() || define.isUndefConfigMacro() || define.isUndef() || define.getFileInstance().equals(topFile);
    }

    public static String buildDefineMacro(VlogMacroInfo define) {
        StringBuilder result = new StringBuilder();
        VlogMacroText macroText = define.getMacroText();
        if (macroText == null) {
            result.append("`define ").append(define.getName());
        } else {
            StringBuilder params = new StringBuilder();
            StringBuilder text = new StringBuilder();
            List<VlogMacroParameter> macroParameters = macroText.getMacroParameters();
            if (macroParameters != null && !macroParameters.isEmpty()) {
                String paramName = macroParameters.get(0).getName();
                String paramValue = macroParameters.get(0).getValue();
                params.append("(").append(paramName);
                if (paramValue != null) {
                    params.append("=").append(paramValue);
                }
                int i = 1;
                while (i < macroParameters.size()) {
                    paramName = macroParameters.get(i).getName();
                    paramValue = macroParameters.get(i).getValue();
                    params.append(",").append(paramName);
                    if (paramValue != null) {
                        params.append("=").append(paramValue);
                    }
                    ++i;
                }
                params.append(")");
            }
            for (StringReplace textPiece : macroText.getReplacement()) {
                String pieceStr = textPiece.getString();
                pieceStr = pieceStr.replace("\n", "\\\n");
                text.append(pieceStr);
            }
            result.append("`define ").append(define.getName()).append(params.toString()).append(" ").append(text.toString());
        }
        return result.toString();
    }
}

