/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.builders;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.Invocation;

class BuildProgressMonitoring {
    private static final String LABEL_PREFIX = "[SystemVerilog build] ";
    private IProgressMonitor fBuildMonitor;
    private int fTotalBuildWork;
    private int fCurrentInvocation;
    private List<InvocationProgressMonitor> fInvocationMonitors = new ArrayList<InvocationProgressMonitor>();

    public BuildProgressMonitoring(IProgressMonitor monitor, List<Invocation> invocations) {
        this.fBuildMonitor = monitor;
        this.makeMonitors(invocations);
        this.fBuildMonitor.beginTask(LABEL_PREFIX, this.fTotalBuildWork);
        this.fBuildMonitor.subTask(LABEL_PREFIX);
    }

    private void makeMonitors(List<Invocation> invocations) {
        if (invocations == null || invocations.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < invocations.size()) {
            ArrayList<String> topFiles = new ArrayList<String>();
            int nofLibDirs = 0;
            int nofLibFiles = 0;
            int nofIncdirs = 0;
            for (BuildConfigProperty p : invocations.get(i).getProperties()) {
                if (p.getKind() == 0) {
                    topFiles.add(p.getValue());
                    continue;
                }
                if (p.getKind() == 4) {
                    ++nofLibDirs;
                    continue;
                }
                if (p.getKind() == 5) {
                    ++nofLibFiles;
                    continue;
                }
                if (p.getKind() != 2) continue;
                ++nofIncdirs;
            }
            InvocationProgressMonitor invocationProgressMonitor = new InvocationProgressMonitor(i, topFiles, nofIncdirs, nofLibDirs, nofLibFiles);
            this.fTotalBuildWork += invocationProgressMonitor.fTotalInvocWork;
            this.fInvocationMonitors.add(invocationProgressMonitor);
            ++i;
        }
    }

    public void fileStarted(String path) {
        this.fInvocationMonitors.get(this.fCurrentInvocation).topBegin(path);
    }

    public void fileDone(String path) {
        this.fInvocationMonitors.get(this.fCurrentInvocation).topDone(path);
    }

    public void invocBegin(int invocNumber) {
        this.fCurrentInvocation = invocNumber;
        this.fInvocationMonitors.get(this.fCurrentInvocation).invocBegin();
    }

    public void invocDone(int invocNumber) {
        this.fInvocationMonitors.get(this.fCurrentInvocation).invocDone();
    }

    public void libsBegin(int invocNumber) {
        this.fInvocationMonitors.get(this.fCurrentInvocation).libsBegin();
    }

    public void libsDone(int invocNumber) {
        this.fInvocationMonitors.get(this.fCurrentInvocation).libsDone();
    }

    class InvocationProgressMonitor {
        int fTopFileNo;
        Set<String> fTopFilesSet;
        int fNofTopFiles;
        int fNofLibFiles;
        int fNofLibDirs;
        int fNofIncdirs;
        int fTopFilesWork;
        int fLibWork;
        int fTotalInvocWork;
        int fInvocationNumber;
        IProgressMonitor fInvocationMonitor;
        IProgressMonitor fTopFilesMonitor;
        IProgressMonitor fLibMonitor;

        public InvocationProgressMonitor(int invocationNumber, List<String> topFiles, int nofIncdirs, int nofLibDirs, int nofLibFiles) {
            this.fInvocationNumber = invocationNumber;
            this.fTopFilesSet = new HashSet<String>(topFiles);
            this.fNofTopFiles = topFiles.size();
            this.fNofLibFiles = nofLibFiles;
            this.fNofLibDirs = nofLibDirs;
            this.fNofIncdirs = nofIncdirs;
            this.fTopFilesWork = this.fNofTopFiles * (nofIncdirs + 1);
            this.fLibWork = 3 * nofLibFiles + 3 * nofLibDirs;
            this.fTotalInvocWork = this.fTopFilesWork + this.fLibWork;
            this.fInvocationMonitor = new SubProgressMonitor(BuildProgressMonitoring.this.fBuildMonitor, this.fTotalInvocWork, 4);
            this.fTopFilesMonitor = new SubProgressMonitor(this.fInvocationMonitor, this.fTopFilesWork, 4);
            this.fLibMonitor = new SubProgressMonitor(this.fInvocationMonitor, this.fLibWork, 4);
        }

        public void libsBegin() {
            this.fLibMonitor.beginTask("Scanning libraries", this.fLibWork);
            this.fLibMonitor.subTask("...");
        }

        public void libsDone() {
            this.fLibMonitor.done();
        }

        public void topBegin(String top) {
            if (this.fTopFilesSet.contains(top)) {
                ++this.fTopFileNo;
                this.fTopFilesMonitor.subTask("(" + this.fTopFileNo + "/" + this.fNofTopFiles + ") " + top);
            }
        }

        public void topDone(String top) {
            if (!this.fTopFilesSet.contains(top)) {
                return;
            }
            this.fTopFilesMonitor.worked(this.fNofIncdirs + 1);
            this.fTopFilesSet.remove(top);
            if (this.fTopFilesSet.isEmpty()) {
                this.fTopFilesMonitor.done();
            }
        }

        public void invocBegin() {
            this.fInvocationMonitor.beginTask("[SystemVerilog build] [Invocation #" + (this.fInvocationNumber + 1) + "/" + BuildProgressMonitoring.this.fInvocationMonitors.size() + "] ", this.fTotalInvocWork);
            this.fTopFilesMonitor.beginTask("Loading top ", this.fTopFilesWork);
        }

        public void invocDone() {
            this.fInvocationMonitor.done();
        }
    }
}

