/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.builders;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class DVTProcessJob
extends Job {
    private static final String BUILD_PROCESS_CONFIG = "ro.amiq.vlogdt.prebuild.launch.PreBuildLaunchConfiguration";
    private File fWorkingDirectory;
    private String[] fCommand;
    private List<IPatternMatchListener> fListeners;
    private Object fFamily;
    private String fTitle;

    public DVTProcessJob(String title, String name, List<String> commands, File workingDirectory, Object family) {
        super(String.valueOf(title) + ": " + name);
        this.setPriority(10);
        this.fCommand = this.customizeCommand(commands);
        this.fWorkingDirectory = workingDirectory;
        this.fFamily = family;
        this.fTitle = title;
    }

    public void addPatternMatchListener(IPatternMatchListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList<IPatternMatchListener>();
        }
        this.fListeners.add(listener);
    }

    private String[] customizeCommand(List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            return null;
        }
        String fullCommand = commands.get(0);
        int i = 1;
        while (i < commands.size()) {
            fullCommand = String.valueOf(fullCommand) + ";" + commands.get(i);
            ++i;
        }
        StringTokenizer st = new StringTokenizer(fullCommand);
        String[] cmdarray = new String[st.countTokens()];
        int i2 = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i2] = st.nextToken();
            ++i2;
        }
        return cmdarray;
    }

    public boolean belongsTo(Object family) {
        return family == this.fFamily;
    }

    public IStatus run(IProgressMonitor monitor) {
        Process process = null;
        IStatus result = Status.OK_STATUS;
        try {
            if (this.fCommand == null) {
                IStatus iStatus = result;
                return iStatus;
            }
            try {
                process = DebugPlugin.exec((String[])this.fCommand, (File)this.fWorkingDirectory, null);
                IProcess runtimeProcess = null;
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(BUILD_PROCESS_CONFIG);
                ILaunchConfigurationWorkingCopy wc = type.newInstance(null, "Pre-build Command");
                wc.setAttribute("org.eclipse.debug.core.capture_output", "true");
                ILaunchConfiguration configuration = wc.doSave();
                Launch launch = new Launch(configuration, "run", null);
                launch.setAttribute("org.eclipse.debug.core.capture_output", "true");
                if (process != null) {
                    monitor.beginTask(NLS.bind((String)ExternalToolsMessages.ProgramLaunchDelegate_3, (Object[])new String[]{this.fTitle}), 100);
                    runtimeProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.fTitle);
                }
                if (process == null || runtimeProcess == null) {
                    if (process != null) {
                        process.destroy();
                    }
                    throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 150, ExternalToolsMessages.ProgramLaunchDelegate_4, null));
                }
                launch.addProcess(runtimeProcess);
                launchManager.addLaunch((ILaunch)launch);
                if (this.fListeners != null) {
                    IConsole console = DVTJobsUtils.waitForConsole(runtimeProcess, (IProgressMonitor)monitor);
                    for (IPatternMatchListener listener : this.fListeners) {
                        ((IOConsole)console).addPatternMatchListener(listener);
                    }
                }
                this.fListeners = null;
                while (!runtimeProcess.isTerminated()) {
                    try {
                        if (monitor.isCanceled()) {
                            runtimeProcess.terminate();
                            break;
                        }
                        monitor.worked(1);
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        result = Status.CANCEL_STATUS;
                    }
                }
            }
            catch (CoreException e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DVTExceptionHandler.handle((CoreException)e, (String)DVTProcessJob.this.fTitle, (String)(String.valueOf(DVTProcessJob.this.fTitle) + " Error"));
                    }
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            if (process != null) {
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)process.getOutputStream());
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)process.getInputStream());
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)process.getErrorStream());
                process.destroy();
            }
            monitor.done();
        }
        return result;
    }
}

