/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.builders;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.Svp2SvCommentMap;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationUtils;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.builders.ParserProfileManager;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.AbstractBuildContributor;
import ro.amiq.dvt.model.BuildState;
import ro.amiq.dvt.model.BuildStateProvider;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.preproc.PreprocConstCommon;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledLoadedDB;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.smartcopy.SmartCopyPrincipal;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MD5InputStream;
import ro.amiq.vlogdt.buildconfig.splitinvocation.SplitInvocationMonitor;
import ro.amiq.vlogdt.buildconfig.splitinvocation.VlogSplitInvocationUtilsCommon;
import ro.amiq.vlogdt.builders.BuildProgressMonitoring;
import ro.amiq.vlogdt.builders.DVTProcessJob;
import ro.amiq.vlogdt.builders.VlogBuilderUtils;
import ro.amiq.vlogdt.builders.VlogPoolingCancelThread;
import ro.amiq.vlogdt.linter.launch.BuildContributorDummyLaunchShortcut;
import ro.amiq.vlogdt.linter.launch.VerissimoAfterCompilationLauncher;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.IVlogProject;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.floatingwidgets.VlogFNotificationProvider;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.IParsingInfo;
import ro.amiq.vlogdt.parser.IParsingListener;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogLoadedInfo;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.parser.VlogSVlog;
import ro.amiq.vlogdt.parser.VlogSkipInfo;
import ro.amiq.vlogdt.parser.VlogStartedInfo;
import ro.amiq.vlogdt.precompiled.VlogPrecompiledDBUtils;
import ro.amiq.vlogdt.test.TestHelper;
import ro.amiq.vlogdt.utils.Utils;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogBuildContributor
extends AbstractBuildContributor
implements IParsingListener,
VlogBuilderUtils.IBuildStatusProvider {
    public static final String ID = "ro.amiq.vlogdt.VlogBuilder";
    private static final Object FAMILY_SHELL = new Object();
    private static final String VLOGDT_BUILDER_CALLER_NAME = "SystemVerilog Builder";
    private final Set<FileCompileInfo> fDeltaChanged = new LinkedHashSet<FileCompileInfo>();
    private final Set<IFile> fDeltaRenamed = new LinkedHashSet<IFile>(1);
    private final Set<IFile> fDeltaRemoved = new LinkedHashSet<IFile>();
    private SubProgressMonitor fIncrMonitor;
    private boolean fIncrMonitorBegin;
    private boolean fIncrMonitorDone;
    private IProgressMonitor fGlobalFullBuildMonitor;
    private BuildProgressMonitoring fBuildProgressMonitoring;
    private VlogSVlog fCurrentParser;
    private boolean fBuildSuccess;
    private List<IResource> fRefreshTopFilesList = new ArrayList<IResource>();
    private VlogPoolingCancelThread fCancelPoolingThread;
    private boolean fDisableMD5ChangeDetection;
    private boolean fAutoLinkedResourcesEnable;
    private boolean fVLibraryFile;
    private boolean fYLibraryFile;
    private boolean fYVCSLibraryFile;
    private boolean fHideScanFileStartMessage;
    private boolean fHideScanFileEndMessage;
    private Set<ParserPath> fAlreadyCompiledFiles;
    private Map<String, AutoLinkRoot> fAutoLinkedRoots;
    private boolean fNotifyAfterIncremental;
    private int fTotalNofLines;
    private Map<String, Integer> fNofCompiledLinesPerFile = new HashMap<String, Integer>();
    public final Deque<VlogBuilderUtils.FileCompilationTime> fCompilationTimeStack = new ArrayDeque<VlogBuilderUtils.FileCompilationTime>();
    private boolean precompiledDbLoadFailed;
    private long fTimestamp = 0L;
    private int fFileIndex;
    private int fSkippedFileIndex;
    private final Map<ParserPath, IBuildConfigParserConstants.LanguageSyntax> fResources2CreateMap = new LinkedHashMap<ParserPath, IBuildConfigParserConstants.LanguageSyntax>();
    private long scanTime;

    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature("ro.amiq.vlogdt.VlogNature");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasNature(String natureID) {
        return "ro.amiq.vlogdt.VlogNature".equals(natureID);
    }

    public boolean notifyAfterIncremental() {
        return this.fNotifyAfterIncremental;
    }

    public IProject[] build(int kind, Map args, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        this.fNotifyAfterIncremental = true;
        IDebugTarget[] debugTargets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        if (debugTargets != null && debugTargets.length > 0) {
            IDebugTarget[] iDebugTargetArray = debugTargets;
            int n = debugTargets.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget debugTarget = iDebugTargetArray[n2];
                if (debugTarget instanceof IntrpDebugTarget && ((IntrpDebugTarget)debugTarget).getProject() == this.getProject()) {
                    ((IntrpDebugTarget)debugTarget).setLastExecutedStatement(null);
                }
                ++n2;
            }
        }
        if (args != null && args.containsKey("justClean") && args.get("justClean").equals("true")) {
            return null;
        }
        final IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
            return null;
        }
        Utils.setReadOnlyBreadcrumbs();
        this.fRefreshTopFilesList.clear();
        this.fResources2CreateMap.clear();
        if (!project.hasNature("ro.amiq.vlogdt.VlogNature")) {
            return null;
        }
        this.fDisableMD5ChangeDetection = BuildConfigManager.isDisableMD5ChangeDetection((IProject)project);
        this.fAutoLinkedResourcesEnable = BuildConfigManager.isAutoLinkedResources((IProject)project);
        this.fAutoLinkedRoots = BuildConfigManager.getAutoLinkedRoots((IProject)project);
        DesignPathManager.getInstance().freeze(project);
        if (kind == 6) {
            FIncrementalNotificationTracker.INSTANCE.unregisterProject(this.getProject());
            DVTMixedLangModelManager.getInstance().addBuildDoneListener(new IBuildDoneListener(){

                public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
                    if (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason)) {
                        return;
                    }
                    DVTMixedLangModelManager.getInstance().removeBuildDoneListener((IBuildDoneListener)this);
                    if (!SplitInvocationUtils.shouldGenerateSplitBuildConfiguration((IProject)project)) {
                        return;
                    }
                    ro.amiq.dvt.ui.Utils.asyncExec(() -> {
                        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        try {
                            progressDialog.run(true, true, monitor -> {
                                monitor.beginTask("Split invocation ...", -1);
                                VlogSplitInvocationUtilsCommon.triggerSplitInvocation(project, new SplitInvocationMonitor(monitor));
                            });
                        }
                        catch (Exception exception) {
                            return;
                        }
                    });
                }
            });
            DVTMixedLangModelManager.getInstance().addBuildDoneListener(new IBuildDoneListener(){

                public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
                    if (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason)) {
                        return;
                    }
                    FNotificationFactory.INSTANCE.createSplitInvocationFloatingNotification(project);
                    DVTMixedLangModelManager.getInstance().removeBuildDoneListener((IBuildDoneListener)this);
                }
            });
            this.fullBuild(monitor);
            RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
            rfProject.getChangedFilesManager().clear();
            this.createAutoLinkedResources(project, monitor);
            VlogModelManager.getInstance().cbPostFullBuild(project, this.fBuildSuccess);
            int uniqueFiles = this.computeUniqueFilesCount(rfProject);
            this.consolePrintSection("Files summary [" + this.fFileIndex + " total, " + uniqueFiles + " unique, " + this.fSkippedFileIndex + " optimized]");
        } else if (kind == 10 || kind == 9) {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
                this.createAutoLinkedResources(project, monitor);
                VlogModelManager.getInstance().cbPostFullBuild(project, this.fBuildSuccess);
            } else {
                this.fAlreadyCompiledFiles = null;
                RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
                if (rfProject != null) {
                    this.fAlreadyCompiledFiles = rfProject.getCompiledFilesSet();
                }
                this.incrementalBuild(monitor, changedFiles == null ? null : changedFiles.get(LanguageKind.VLOG));
            }
        }
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])this.fRefreshTopFilesList.toArray());
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.DifferentColorsDecorator", (Object[])this.fRefreshTopFilesList.toArray());
        this.fRefreshTopFilesList.clear();
        this.fResources2CreateMap.clear();
        return null;
    }

    public static void deleteMarkersAndProperties(IProject project) {
        try {
            DVTProblemsUiUpdaterRegistry.get((String)VlogProblemCategories.SVLOG_SYNTAX.getId()).resetNofMarkers(project);
            project.deleteMarkers(VlogProblemCategories.SVLOG_SYNTAX.getMarkerId(), true, 2);
            DVTProblemManager.getInstance().removeProblemsWithCategory(project, VlogProblemCategories.SVLOG_SYNTAX);
            project.deleteMarkers("ro.amiq.vlogdt.PersistentTaskMarker", true, 2);
            LintingProblemsManager.getInstance().clearMarkers(project);
            final ArrayList refreshList = new ArrayList();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE) != null || PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_ENCRYPTED_FILE) != null || PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_TEST_FILE) != null) {
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_ENCRYPTED_FILE, null);
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_TEST_FILE, null);
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE, null);
                        refreshList.add(resource);
                        return true;
                    }
                    return false;
                }
            });
            DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])refreshList.toArray());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void clean(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        VlogModelManager.getInstance().cleanVlogProject(project);
        IVlogProject vlogProject = VlogModelManager.getInstance().getVlogModel().getVlogProject(project);
        vlogProject.getParserPaths().clear();
        this.fFileIndex = 0;
        this.fSkippedFileIndex = 0;
        this.fAlreadyCompiledFiles = null;
        this.precompiledDbLoadFailed = false;
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            this.fAlreadyCompiledFiles = rfProject.getCompiledFilesSet();
        }
        VlogBuildContributor.deleteMarkersAndProperties(project);
        vlogProject.createNewVlogParser();
        SmartCopyPrincipal.INSTANCE.flushOrders(project);
        VlogModelManager.getInstance().cbClean(project);
        this.fCompilationTimeStack.clear();
    }

    /*
     * Unable to fully structure code
     */
    protected VlogSVlog fullBuild(IProgressMonitor monitor) {
        this.fFileIndex = 0;
        this.fSkippedFileIndex = 0;
        this.fCompilationTimeStack.clear();
        time = System.currentTimeMillis();
        vlogParser = null;
        this.fBuildSuccess = false;
        project = this.getProject();
        this.fTimestamp = System.currentTimeMillis();
        loadedInvocations = new IdentityHashMap<Invocation, Future<PrecompiledLoadedDB>>();
        TestHelper.fParseTime = 0.0;
        TestHelper.fLexTime = 0L;
        TestHelper.fSuccessfullGuessingTime = 0L;
        TestHelper.fUnSuccessfullGuessingTime = 0L;
        TestHelper.fPrecompiledLoadStats = null;
        this.fTotalNofLines = 0;
        rfProject = null;
        try {
            if (!project.exists() || RfManager.getInstance().getRfProjectWithoutRestore(project) == null) ** GOTO lbl83
            this.fGlobalFullBuildMonitor = monitor;
            RfManager.getInstance().getRfProjectWithoutRestore(project).setLastFullBuildStartMemory();
            RfManager.getInstance().getRfProjectWithoutRestore(project).setLastFullBuildStartTime();
            vlogProject = VlogModelManager.getInstance().getVlogModel().getVlogProject(project);
            vlogParser = vlogProject.createNewVlogParser();
            vlogParser.addParsingListener(this);
            this.fCurrentParser = vlogParser;
            vlogParser.resetIndex();
            rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
            rfProject.clean();
            if (!BuildConfigManager.hasActiveBuildConfig((IProject)project)) {
                return null;
            }
            try {
                shellCmds = BuildConfigManager.getShellCommands((IProject)project);
                fullBuildCmds = BuildConfigManager.getFullBuildCommands((IProject)project);
                if (!fullBuildCmds.isEmpty()) {
                    try {
                        shellJob = new DVTProcessJob("Full Build Precommand", "[" + project.getName() + "]", fullBuildCmds, project.getLocation().toFile(), VlogBuildContributor.FAMILY_SHELL);
                        shellJob.addPatternMatchListener(new RefreshListerer(this.fGlobalFullBuildMonitor));
                        DVTJobsUtils.scheduleAndJoin((Job)shellJob);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                if (!shellCmds.isEmpty()) {
                    try {
                        shellJob = new DVTProcessJob("Shell Command", "[" + project.getName() + "]", shellCmds, project.getLocation().toFile(), VlogBuildContributor.FAMILY_SHELL);
                        DVTJobsUtils.scheduleAndJoin((Job)shellJob);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                if (BuildConfigManager.isPrecompiledDbSaveMode((IProject)project)) {
                    vlogParser.setPrecompiledDb(true);
                }
                if (!(precompiledDbMode = BuildConfigManager.getPrecompiledDbMode((IProject)project, (boolean)true)).isAny(new BuildConfigManagerCommon.PrecompileGlobalMode[]{BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_SAVE, BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_SAVE})) {
                    try {
                        precompiledInvocations = VlogPrecompiledDBUtils.getPrecompiledInvocations(project);
                        VlogPrecompiledDBUtils.startLoadingPrecompiledDatabases(rfProject, precompiledInvocations, precompiledDbMode, loadedInvocations);
                        this.fFileIndex += VlogPrecompiledDBUtils.mergeManualPrecompiledLibraries(rfProject, precompiledInvocations, loadedInvocations, vlogParser, this.fFileIndex, this.fResources2CreateMap);
                    }
                    catch (PersistenceBase.PrecompiledDbLoadFailException v0) {
                        this.fGlobalFullBuildMonitor.setCanceled(true);
                        this.precompiledDbLoadFailed = true;
                    }
                }
                preprocessing = rfProject.getPreprocessingTable();
                this.installPVlogCommentProcessor(rfProject);
                translatePragmas = BuildConfigManager.getPreprocessTranslatePragmas((IProject)project);
                customPragmas = BuildConfigManager.getCustomPragmas((IProject)project);
                topPath = RfProject.getVlogTopPath(project);
                collectMacroCallsWithoutParams = false;
                collectMacroCallsWithParams = false;
                commentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)this.getProject());
                maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)project);
                this.fBuildProgressMonitoring = new BuildProgressMonitoring(this.fGlobalFullBuildMonitor, BuildConfigManager.getInvocations((IProject)this.getProject()));
                try {
                    this.fBuildSuccess = VlogBuilderUtils.internalFullBuild(this, vlogParser, project, preprocessing, rfProject, customPragmas, translatePragmas, topPath, collectMacroCallsWithoutParams, collectMacroCallsWithParams, commentsPreferences, maxIssuesKindNumber, this.fResources2CreateMap, loadedInvocations);
                }
                catch (PersistenceBase.PrecompiledDbLoadFailException v1) {
                    this.fGlobalFullBuildMonitor.setCanceled(true);
                    this.precompiledDbLoadFailed = true;
                }
                vlogParser.removeFullBuildMacroLookupMap();
                vlogParser.removeFullBuildCachedInfos();
                vlogParser.removeParsingListener(this);
                vlogParser.resetIndex();
                this.fCurrentParser = null;
                this.createPVlogAutoLinkFiles(rfProject.getProject());
                this.fGlobalFullBuildMonitor.done();
lbl83:
                // 2 sources

                DVTLogger.INSTANCE.logDebug("DEBUG: Full build time = " + (-time + System.currentTimeMillis()));
                if (this.precompiledDbLoadFailed) {
                    throw new PersistenceBase.PrecompiledDbLoadFailException("Failed to load precompiled database.");
                }
                if (TestHelper.fPrecompiledLoadStats == null || TestHelper.fLexTime != 0L && TestHelper.fParseTime != 0.0) {
                    this.consolePrintSection("Done parsing [LT " + TestHelper.fLexTime + " ms, " + "PT " + TestHelper.fParseTime + " ms]");
                }
                if (TestHelper.fPrecompiledLoadStats == null || this.fTotalNofLines != 0) {
                    symbols = new DecimalFormatSymbols();
                    symbols.setGroupingSeparator(' ');
                    df = new DecimalFormat("###,###", symbols);
                    this.consolePrintSection("Total number of lines [" + df.format(this.fTotalNofLines) + "]");
                }
                if (TestHelper.fPrecompiledLoadStats != null) {
                    this.consolePrintSection("Done precompiled database loading [load time " + (TestHelper.fPrecompiledLoadStats.loadEndTime.get() - TestHelper.fPrecompiledLoadStats.loadStartTime) + " ms, " + "merge time " + TestHelper.fPrecompiledLoadStats.copyReflectionTime + " ms]");
                }
            }
            catch (PersistenceBase.PrecompiledDbLoadFailException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            BuildStateProvider.getInstance().setBuildState(BuildState.SEMANTIC);
        }
        return vlogParser;
    }

    private void installPVlogCommentProcessor(RfProject rfProject) {
        if (PreprocUtils.getInstance().isPreprocSupportEnabled(this.getProject())) {
            return;
        }
        Svp2SvCommentMap commentMap = BuildConfigManager.getSvp2SvCommentMap((IProject)rfProject.getProject());
        if (commentMap == null || !commentMap.hasPatterns()) {
            return;
        }
    }

    private void createPVlogAutoLinkFiles(IProject project) {
        List preprocAutoLinkFilePaths = PreprocUtils.getInstance().collectUncompiledAutoLinkFilePaths(project);
        if (preprocAutoLinkFilePaths == null) {
            return;
        }
        for (ParserPath path : preprocAutoLinkFilePaths) {
            this.fResources2CreateMap.put(path, null);
        }
    }

    @Override
    public boolean checkCancel() {
        if (this.fGlobalFullBuildMonitor != null && this.fCurrentParser != null && (this.fGlobalFullBuildMonitor.isCanceled() || MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState()) || this.hasLintingTimedout())) {
            this.fCurrentParser.interrupt();
            return true;
        }
        return false;
    }

    @Override
    public void parsing(IParsingInfo info) {
        if (this.fCancelPoolingThread != null) {
            this.fCancelPoolingThread.resetPoolingThread();
        }
        ParserProfileManager parserProfileManager = ParserProfileManager.getInstance();
        int infoKind = info.getKind();
        switch (infoKind) {
            case 1: {
                String message;
                if (this.checkCancel()) {
                    return;
                }
                VlogStartedInfo msInfo = (VlogStartedInfo)info;
                ParserPath parserPath = msInfo.getParserPath();
                IBuildConfigParserConstants.LanguageSyntax languageSyntax = msInfo.getLanguageSyntax();
                this.fBuildProgressMonitoring.fileStarted(parserPath.path);
                parserProfileManager.startParserProfileIfNecessary(parserPath.path);
                if (!this.fCompilationTimeStack.isEmpty()) {
                    VlogBuilderUtils.FileCompilationTime lastFileInfo = this.fCompilationTimeStack.peek();
                    lastFileInfo.parsingTime += System.currentTimeMillis() - lastFileInfo.lastParsingStartTimestamp;
                }
                this.fCompilationTimeStack.push(new VlogBuilderUtils.FileCompilationTime(System.currentTimeMillis(), parserPath.path));
                this.createResource(parserPath, languageSyntax);
                if (parserPath.path.indexOf("__vlog__") != -1) break;
                if (!this.fHideScanFileStartMessage) {
                    ++this.fFileIndex;
                }
                if (this.fYLibraryFile) {
                    if (this.fHideScanFileStartMessage && this.fYVCSLibraryFile) break;
                    message = DVTStringUtil.appendString((Object[])new Object[]{"Loading -y lib (", this.fFileIndex, ") ", parserPath, " ..."});
                    this.consolePrint(message);
                    break;
                }
                if (this.fVLibraryFile) {
                    if (this.fHideScanFileStartMessage) break;
                    this.scanTime = 0L;
                    message = DVTStringUtil.appendString((Object[])new Object[]{"Scanning -v lib (", this.fFileIndex, ") ", parserPath, " ..."});
                    this.consolePrint(message);
                    break;
                }
                message = DVTStringUtil.appendString((Object[])new Object[]{"Loading (", this.fFileIndex, ") ", parserPath, " ..."});
                this.consolePrint(message);
                break;
            }
            case 2: {
                if (this.checkCancel()) {
                    return;
                }
                VlogLoadedInfo mlInfo = (VlogLoadedInfo)info;
                ParserPath parserPath = mlInfo.getParserPath();
                IBuildConfigParserConstants.LanguageSyntax languageSyntax = mlInfo.getLanguageSyntax();
                int nofRawLines = mlInfo.getNofRawLines() + 1;
                this.fBuildProgressMonitoring.fileDone(parserPath.path);
                this.createResource(parserPath, languageSyntax);
                parserProfileManager.stopProfiling();
                if (parserPath.path.indexOf("__vlog__") == -1) {
                    this.fTotalNofLines += nofRawLines;
                    this.fNofCompiledLinesPerFile.put(parserPath.path, nofRawLines);
                    long time = 0L;
                    long currentTime = System.currentTimeMillis();
                    VlogBuilderUtils.FileCompilationTime lastFileInfo = this.fCompilationTimeStack.pop();
                    time = lastFileInfo.parsingTime + currentTime - lastFileInfo.lastParsingStartTimestamp;
                    if (!this.fCompilationTimeStack.isEmpty()) {
                        lastFileInfo = this.fCompilationTimeStack.peek();
                        lastFileInfo.lastParsingStartTimestamp = currentTime;
                        parserProfileManager.startParserProfileIfNecessary(lastFileInfo.filePath);
                    }
                    if (this.fVLibraryFile) {
                        time = currentTime - this.fTimestamp;
                        this.scanTime += time;
                        time = this.scanTime;
                    }
                    if (!this.fHideScanFileEndMessage) {
                        String shallowCompiledMessage = mlInfo.isShallowCompiled() ? " (shallow) " : "";
                        String message = DVTStringUtil.appendString((Object[])new Object[]{"Done ", shallowCompiledMessage, parserPath, " [", time, " ms, ", nofRawLines, " lines, ", languageSyntax.getFirstName(), "] ..."});
                        this.consolePrint(message);
                    }
                    DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).getReportModel().updateTopStatsForProject(parserPath, nofRawLines, time, this.fVLibraryFile);
                }
                this.fTimestamp = System.currentTimeMillis();
                break;
            }
            case 3: {
                if (this.checkCancel()) {
                    return;
                }
                VlogSkipInfo mkInfo = (VlogSkipInfo)info;
                ParserPath parserPath = mkInfo.getParserPath();
                IBuildConfigParserConstants.LanguageSyntax languageSyntax = mkInfo.getLanguageSyntax();
                this.createResource(parserPath, languageSyntax);
                if (parserPath.path.indexOf("__vlog__") != -1) break;
                if (!this.fHideScanFileStartMessage && mkInfo.getReason() != 0) {
                    ++this.fSkippedFileIndex;
                    ++this.fFileIndex;
                }
                String message = DVTStringUtil.appendString((Object[])new Object[]{mkInfo.getReason() == 0 ? "Skipping " : "Optimizing (" + this.fFileIndex + ") ", parserPath, " ..."});
                this.consolePrint(message);
                break;
            }
        }
    }

    @Override
    public void consolePrint(String message) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(message);
    }

    @Override
    public void consolePrintSection(String message) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection(message);
    }

    private void createResource(ParserPath parserPath, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        this.fResources2CreateMap.put(parserPath, languageSyntax);
    }

    private void createAutoLinkedResources(IProject project, IProgressMonitor monitor) throws CoreException {
        VlogBuildContributor.createAutoLinkedResources(project, monitor, this.fResources2CreateMap, this.fRefreshTopFilesList, this.fAutoLinkedResourcesEnable, this.fAutoLinkedRoots, true);
    }

    public static void createResource(IProject project, ParserPath parserPath, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int fileInstanceIndex) throws CoreException {
        boolean autoLinkedResourcesEnable = BuildConfigManager.isAutoLinkedResources((IProject)project);
        Map autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots((IProject)project);
        ArrayList<IResource> refreshTopFilesList = new ArrayList<IResource>();
        HashMap<ParserPath, IBuildConfigParserConstants.LanguageSyntax> resources2CreateMap = new HashMap<ParserPath, IBuildConfigParserConstants.LanguageSyntax>();
        resources2CreateMap.put(parserPath, languageSyntax);
        if (fileInstanceIndex > 0 || fileInstanceIndex == -1) {
            VlogBuildContributor.createAutoLinkedResources(project, (IProgressMonitor)new NullProgressMonitor(), resources2CreateMap, refreshTopFilesList, autoLinkedResourcesEnable, autoLinkedRoots, true);
        }
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])refreshTopFilesList.toArray());
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.DifferentColorsDecorator", (Object[])refreshTopFilesList.toArray());
    }

    public static void createAutoLinkedResources(final IProject project, IProgressMonitor monitor, final Map<ParserPath, IBuildConfigParserConstants.LanguageSyntax> resources2CreateMap, final List<IResource> refreshTopFilesList, final boolean autoLinkedResourcesEnable, final Map<String, AutoLinkRoot> autoLinkedRoots, boolean createWorkspaceOp) throws CoreException {
        if (!resources2CreateMap.isEmpty()) {
            TestHelper.fAutoLinkTime -= (double)System.currentTimeMillis();
        }
        if (createWorkspaceOp) {
            DVTAutoLinkManager.getInstance().startWorkspaceOperation(project, true);
        }
        DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                long time = System.currentTimeMillis();
                HashSet<String> files = new HashSet<String>();
                for (ParserPath parserPath : resources2CreateMap.keySet()) {
                    files.add(new File(parserPath.path).getName());
                }
                HashMap<String, List<IFile>> fileCandidates = new HashMap<String, List<IFile>>();
                HashMap<IPath, IPath> directorySymlinks = new HashMap<IPath, IPath>();
                DVTFileUtils.getInstance().cacheDirectories(project, files, fileCandidates, directorySymlinks);
                DVTLogger.INSTANCE.logDebug("AUTO_LINKED: Time to collect " + directorySymlinks.size() + " symlinked directories takes " + (System.currentTimeMillis() - time));
                for (Map.Entry entry : resources2CreateMap.entrySet()) {
                    ParserPath parserPath = (ParserPath)entry.getKey();
                    IFile resource = VlogBuildContributor.createAutoLinkedResource(project, Path.fromOSString((String)parserPath.path), fileCandidates, directorySymlinks, cachedLinksMap, autoLinkedResourcesEnable, autoLinkedRoots);
                    IVlogProject vlogProject = VlogModelManager.getInstance().getVlogModel().getVlogProject(project);
                    vlogProject.addParserPath(parserPath, resource);
                    if (resource == null) continue;
                    IBuildConfigParserConstants.LanguageSyntax languageSyntax = (IBuildConfigParserConstants.LanguageSyntax)entry.getValue();
                    if (languageSyntax != null) {
                        String languageSyntaxText = languageSyntax.id;
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE, (String)languageSyntaxText);
                        IFile parent = resource;
                        while (parent != null && (parent = parent.getParent()) != null && PropertiesManager.getSessionProperty((IResource)parent, (String)PropertyTypes.QN_IMPORTED_FILE) == null) {
                            PropertiesManager.addSessionProperty((IResource)parent, (String)PropertyTypes.QN_IMPORTED_FILE, (String)languageSyntaxText);
                        }
                    }
                    refreshTopFilesList.add(resource);
                }
            }
        };
        DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, VLOGDT_BUILDER_CALLER_NAME, op, false);
        if (createWorkspaceOp) {
            DVTAutoLinkManager.getInstance().endWorkspaceOperation(project, false);
        }
        if (!resources2CreateMap.isEmpty()) {
            TestHelper.fAutoLinkTime += (double)System.currentTimeMillis();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IFile createAutoLinkedResource(IProject project, IPath parserPath, Map<String, List<IFile>> fileCandidates, Map<IPath, IPath> directorySymlinks, Map<IPath, LinkDescription> cachedLinksMap, boolean autoLinkedResourcesEnable, Map<String, AutoLinkRoot> autoLinkedRoots) {
        try {
            if (parserPath.lastSegment() == null) {
                return null;
            }
            if (parserPath.lastSegment().startsWith("__vlog__")) {
                return null;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file != null && file.getLocation() != null) {
                if (autoLinkedResourcesEnable) {
                    DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
                    return file;
                }
                if (!file.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) return file;
                return null;
            }
            if (!autoLinkedResourcesEnable) {
                return null;
            }
            if (DVTAutoLinkManager.getInstance().hasError(project, 2)) return null;
            if (DVTAutoLinkManager.getInstance().hasError(project, 1)) {
                return null;
            }
            file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file == null || file.getLocation() == null) {
                IFile projectFile = project.getFile(".project");
                boolean autolinkUsingLinks = DVTAutoLinkManager.getInstance().autolinkUsingLinksForProject(project);
                boolean readOnly = projectFile.getResourceAttributes().isReadOnly();
                if (readOnly && autolinkUsingLinks) {
                    DVTAutoLinkManager.getInstance().reportError(project, 1);
                } else {
                    file = DVTAutoLinkManager.getInstance().createAutoLink(project, parserPath, autoLinkedRoots, cachedLinksMap, false);
                }
            } else {
                DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
            }
            if (file == null) return file;
            String resourcePath = file.getProjectRelativePath().toOSString();
            PropertiesManager.addParser2ResourceMapProperty((IProject)project, (String)parserPath.toOSString(), (String)resourcePath);
            return file;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            DVTAutoLinkManager.getInstance().reportError(project, 2);
            return null;
        }
    }

    public int analyzeDelta(IResourceDelta delta, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        IProject project = this.getProject();
        String projectPrefix = String.valueOf(project.getName()) + ": ";
        monitor.beginTask(String.valueOf(projectPrefix) + "Analyzing Deltas ...", 1000);
        this.fDeltaChanged.clear();
        this.fDeltaRemoved.clear();
        this.fDeltaRenamed.clear();
        this.fAlreadyCompiledFiles = null;
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            this.fAlreadyCompiledFiles = rfProject.getCompiledFilesSet();
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", false);
        delta.accept((IResourceDeltaVisitor)new ChangedModulesVisitor(fileExtensions));
        changedFiles.put(LanguageKind.VLOG, this.fDeltaChanged);
        return this.fDeltaChanged.size() + this.fDeltaRemoved.size();
    }

    protected void incrementalBuild(IProgressMonitor monitor, Set<FileCompileInfo> changedFiles) throws CoreException {
        String projectPrefix = String.valueOf(this.getProject().getName()) + ": ";
        boolean notifyAfterIncremental = false;
        IProject project = this.getProject();
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        boolean cancelIncremental = PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
        if (cancelIncremental) {
            ChangedFilesManager changedFilesManager = rfProject.getChangedFilesManager();
            this.fDeltaChanged.addAll(changedFilesManager.getBacklogElements());
            changedFilesManager.addBacklogElements(this.fDeltaChanged);
        }
        Map documentsInEditors = DVTFileUtils.getInstance().evalNonFileBufferParserPathDocuments();
        if (this.fDeltaChanged.size() + this.fDeltaRemoved.size() != 0) {
            block14: {
                this.fIncrMonitor = new SubProgressMonitor(monitor, 1000);
                int deltaStep = 1000 / (this.fDeltaChanged.size() + this.fDeltaRemoved.size());
                this.fIncrMonitor.beginTask(String.valueOf(projectPrefix) + "Processing Deltas ...", 1000);
                this.fIncrMonitorBegin = true;
                int i = 0;
                int workSize = this.fDeltaChanged.size();
                for (FileCompileInfo fileCompileInfo : this.fDeltaChanged) {
                    List incrBuildCmds;
                    IFile file;
                    if (fileCompileInfo == null || (file = fileCompileInfo.getFile()) == null || PreprocUtils.getInstance().shouldSkipCompilation(file.getProject(), DVTFileUtils.getInstance().resource2parser((IResource)file))) continue;
                    ++i;
                    if (this.fIncrMonitor.isCanceled()) break block14;
                    this.fIncrMonitor.subTask(String.valueOf(projectPrefix) + "Loading (" + i + "/" + workSize + ") " + file.getLocation().toOSString() + "...");
                    IVlogModule vlogModule = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule(file);
                    if (vlogModule != null) {
                        vlogModule.cancelReparse();
                    }
                    if (!(incrBuildCmds = BuildConfigManager.getIncrBuildCommands((IProject)project)).isEmpty()) {
                        String cmd = String.valueOf((String)incrBuildCmds.get(incrBuildCmds.size() - 1)) + " " + file.getLocation().toOSString();
                        incrBuildCmds.set(incrBuildCmds.size() - 1, cmd);
                        try {
                            DVTProcessJob shellJob = new DVTProcessJob("Incremental Build Precommand", "[" + project.getName() + "]", incrBuildCmds, project.getLocation().toFile(), FAMILY_SHELL);
                            shellJob.addPatternMatchListener(new RefreshListerer(monitor));
                            DVTJobsUtils.scheduleAndJoin((Job)shellJob);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    if (DVTFileUtils.getInstance().shouldIncrementalBuild(null, fileCompileInfo, project)) {
                        VlogModelManager.getInstance().cbIncrementalBuild(monitor, fileCompileInfo, vlogModule == null ? null : (IDocument)documentsInEditors.get(vlogModule.getParserPath()), true);
                        notifyAfterIncremental = true;
                    } else if (!this.isFileRenamed(file)) {
                        FIncrementalNotificationTracker.INSTANCE.addDirtyResource(this.getProject(), (FNotificationDirtyResource)new FIncrementalDirtyFile(fileCompileInfo.getFile(), FNotificationDirtyReason.MAX_LINES_EXCEEDED, (DVTFNotificationProvider)VlogFNotificationProvider.getInstance()));
                        FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC);
                    }
                    this.fIncrMonitor.worked(deltaStep);
                }
                i = 0;
                workSize = this.fDeltaRemoved.size();
                for (IFile file : this.fDeltaRemoved) {
                    ++i;
                    if (!this.fIncrMonitor.isCanceled()) {
                        this.fIncrMonitor.subTask(String.valueOf(projectPrefix) + "Removing (" + i + "/" + workSize + ") " + file.getLocation().toOSString() + "...");
                        VlogModelManager.getInstance().cbRemove(file);
                        this.fIncrMonitor.worked(deltaStep);
                        continue;
                    }
                    break block14;
                }
                rfProject.reparseFilesAffectedByMacroChanges(rfProject, changedFiles, (IProgressMonitor)this.fIncrMonitor);
            }
            if (this.fIncrMonitorBegin && !this.fIncrMonitorDone) {
                this.fIncrMonitor.done();
                this.fIncrMonitorDone = true;
            }
        }
        if (!notifyAfterIncremental) {
            this.fNotifyAfterIncremental = false;
        }
    }

    private boolean isFileRenamed(IFile file) {
        if (file == null) {
            return false;
        }
        for (IFile renamedFile : this.fDeltaRenamed) {
            if (!file.equals((Object)renamedFile)) continue;
            return true;
        }
        return false;
    }

    public void startLinting(String options) {
        new LintingJob(options).schedule();
    }

    public void setupLinting(IProject project, IProgressMonitor monitor, boolean fullBuild) {
        VerissimoAfterCompilationLauncher.getInstance().setupLinting(project, monitor, fullBuild);
    }

    public IRfSingleLangProject getIRfProject() {
        return RfManager.getInstance().getRfProjectWithoutRestore(this.getProject());
    }

    @Override
    public void newCancelPoolingThread() {
        this.fCancelPoolingThread = new VlogPoolingCancelThread();
    }

    @Override
    public void startCancelPoolingThread(VlogSVlog vlogParser, boolean linting) {
        this.fCancelPoolingThread.startPoolingThread(this.fGlobalFullBuildMonitor, vlogParser, this.getProject(), false, linting);
    }

    @Override
    public void stopCancelPoolingThread() {
        this.fCancelPoolingThread.stopPoolingThread();
    }

    @Override
    public void setCancelPoolingThreadFileName(String fileName) {
        this.fCancelPoolingThread.setFileName(fileName);
    }

    @Override
    public void setYLibraryFile(boolean libFile) {
        this.fYLibraryFile = libFile;
    }

    @Override
    public void setVLibraryFile(boolean libFile) {
        this.fVLibraryFile = libFile;
    }

    @Override
    public void setYVCSLibraryFile(boolean libFile) {
        this.fYVCSLibraryFile = libFile;
    }

    @Override
    public void setHideScanFileStartMessage(boolean hideScanFileStartMessage) {
        this.fHideScanFileStartMessage = hideScanFileStartMessage;
    }

    @Override
    public void setHideScanFileEndMessage(boolean hideScanFileEndMessage) {
        this.fHideScanFileEndMessage = hideScanFileEndMessage;
    }

    @Override
    public void setTimestamp() {
        this.fTimestamp = System.currentTimeMillis();
    }

    @Override
    public void beginInvocation(int invocNumber) {
        this.fBuildProgressMonitoring.invocBegin(invocNumber);
    }

    @Override
    public void endInvocation(int invocNumber) {
        this.fBuildProgressMonitoring.invocDone(invocNumber);
    }

    @Override
    public void beginLibraries(int invocNumber) {
        this.fBuildProgressMonitoring.libsBegin(invocNumber);
    }

    @Override
    public void endLibraries(int invocNumber) {
        this.fBuildProgressMonitoring.libsDone(invocNumber);
    }

    public String getDisplayName() {
        return "SystemVerilog";
    }

    public int getTotalNofLines() {
        return this.fTotalNofLines;
    }

    public Map<String, Integer> getNofCompiledLinesPerFile() {
        return this.fNofCompiledLinesPerFile;
    }

    public DVTFNotificationProvider getFNotificationProvider() {
        return VlogFNotificationProvider.getInstance();
    }

    private boolean hasLintingTimedout() {
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(this.getProject());
        if (rfProject == null) {
            return false;
        }
        return rfProject.hasLintingTimedOut();
    }

    private int computeUniqueFilesCount(RfProject rfProject) {
        Set<ParserPath> uniqueFilesSet = rfProject.getCompiledFilesSet();
        if (uniqueFilesSet == null) {
            return 0;
        }
        int uniqueFiles = 0;
        for (ParserPath file : uniqueFilesSet) {
            if (file.path.indexOf("__vlog__") != -1) continue;
            ++uniqueFiles;
        }
        return uniqueFiles;
    }

    @Override
    public void updateFileIndex(int fileIndex) {
        this.fFileIndex += fileIndex;
    }

    private class ChangedModulesVisitor
    implements IResourceDeltaVisitor {
        private String[] fFileExtensions;

        public ChangedModulesVisitor(String[] fileExtensions) {
            this.fFileExtensions = fileExtensions;
        }

        public boolean visit(IResourceDelta delta) {
            block10: {
                RfProject rfProject;
                ParserPath parserPath;
                IPath location;
                IProject project;
                IResource resource;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block9: {
                                    if (VlogBuildContributor.this.fDeltaRemoved.size() + VlogBuildContributor.this.fDeltaChanged.size() <= 50) break block9;
                                    return false;
                                }
                                resource = delta.getResource();
                                if (resource.getType() == 4) {
                                    IProject project2 = (IProject)resource;
                                    return project2.hasNature("ro.amiq.vlogdt.VlogNature");
                                }
                                if (resource.getType() != 1) break block10;
                                if (delta.getFlags() != 0x100000) break block11;
                                return false;
                            }
                            project = resource.getProject();
                            location = resource.getLocation();
                            if (location != null) break block12;
                            return false;
                        }
                        parserPath = DVTFileUtils.getInstance().resource2parser(resource);
                        if (parserPath != null) break block13;
                        return false;
                    }
                    rfProject = RfManager.getInstance().getRfProjectWithoutRestore(resource.getProject());
                    if (rfProject != null) break block14;
                    return false;
                }
                try {
                    if (PreprocUtils.getInstance().shouldSkipCompilation(project, parserPath)) {
                        return this.handlePVlogUncompiledFile(delta, resource, project, location, parserPath, rfProject);
                    }
                    return this.processDelta(delta, resource, project, location, parserPath, rfProject, false);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            return true;
        }

        private boolean handlePVlogUncompiledFile(IResourceDelta delta, IResource resource, IProject project, IPath location, ParserPath parserPath, RfProject rfProject) throws CoreException, IOException, NoSuchAlgorithmException {
            PreprocConstCommon.PreprocFileType fileType = PreprocUtils.getInstance().getPreprocFileType(project, parserPath);
            if (fileType == null) {
                return false;
            }
            if (fileType == PreprocConstCommon.PreprocFileType.P_FILE) {
                IDocument document = DVTFileUtils.getInstance().getOpenDocument((IFile)resource);
                if (document == null) {
                    return false;
                }
                PreprocUtils.getInstance().onPChange(project, parserPath, document.get());
                Utils.getInstance().connectPreprocCodePositions(document, parserPath);
                return this.processDelta(delta, resource, project, location, parserPath, rfProject, true);
            }
            PreprocUtils.getInstance().onGChange(project, parserPath);
            String pairFilePath = PreprocUtils.getInstance().getPPath(parserPath.toString(), project);
            if (pairFilePath == null) {
                return false;
            }
            resource = DVTFileUtils.getInstance().findProjectFile(project, pairFilePath);
            return this.processDelta(delta, resource, project, Path.fromOSString((String)pairFilePath), new ParserPath(pairFilePath), rfProject, true);
        }

        private boolean processDelta(IResourceDelta delta, IResource resource, IProject project, IPath location, ParserPath parserPath, RfProject rfProject, boolean ignoreMD5Check) throws CoreException, IOException, NoSuchAlgorithmException {
            boolean isAlreadyCompiled;
            boolean bl = isAlreadyCompiled = VlogBuildContributor.this.fAlreadyCompiledFiles != null && VlogBuildContributor.this.fAlreadyCompiledFiles.contains(parserPath);
            if (!isAlreadyCompiled && delta.getKind() == 1) {
                VlogPreprocessingInfo preprocessing = rfProject.getPreprocessingTable();
                if (preprocessing != null) {
                    List<VlogFileInstance> instancesToRecompile = preprocessing.getInstancesToRecompile(location);
                    for (VlogFileInstance fileInstance : instancesToRecompile) {
                        IResource fileAdapter;
                        RfFileDef recompileFile;
                        ParserPath recompileParserPath = fileInstance.getParserPath();
                        if (recompileParserPath == null || (recompileFile = rfProject.getFileDefUsingParserPath(recompileParserPath)) == null || (fileAdapter = recompileFile.getFileAdapter()) == null) continue;
                        this.addFileAsChangedOrRenamed(delta, fileAdapter);
                    }
                }
            } else if (delta.getKind() == 2) {
                DVTAutoLinkManager.getInstance().removeFileInfo(location);
                rfProject.disconnectFileFromDocument(parserPath);
            }
            if (isAlreadyCompiled || DVTFileUtils.getInstance().validExtension(this.fFileExtensions, resource.getName())) {
                if (BuildConfigManager.isSkip((IProject)project, (ParserPath)parserPath)) {
                    return false;
                }
                RfFileDef defFile = rfProject.getFile(resource);
                if (defFile != null) {
                    if (delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0) {
                        boolean disableMD5ChangeDetection;
                        long oldSize = defFile.getParserPath().getSize();
                        byte[] oldMd5 = defFile.getParserPath().getMd5();
                        boolean bl2 = disableMD5ChangeDetection = VlogBuildContributor.this.fDisableMD5ChangeDetection || ignoreMD5Check || resource.getSessionProperty(DISABLE_MD5) != null;
                        if (!disableMD5ChangeDetection && new File(parserPath.path).length() == oldSize) {
                            byte[] newMd5 = new byte[]{};
                            Throwable throwable = null;
                            Object var16_19 = null;
                            try (MD5InputStream currentVerifFileStream = new MD5InputStream(new File(parserPath.path));){
                                while (currentVerifFileStream.read() != -1) {
                                }
                                newMd5 = currentVerifFileStream.getMD5();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            if (!Arrays.equals(oldMd5, newMd5)) {
                                this.addFileAsChangedOrRenamed(delta, resource);
                            } else if (DVTLogger.INSTANCE.isDebugMode()) {
                                TestHelper.out.println("Skip compiling touched file (md5 unchanged): " + resource.getFullPath());
                            }
                        } else {
                            this.addFileAsChangedOrRenamed(delta, resource);
                        }
                    } else if (delta.getKind() == 2 && !DVTFileUtils.getInstance().isAutoLinkedResource(project, location)) {
                        VlogBuildContributor.this.fDeltaRemoved.add((IFile)resource);
                    }
                } else if (rfProject.getEditor(parserPath) != null) {
                    if (delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0) {
                        this.addFileAsChangedOrRenamed(delta, resource);
                    } else if (delta.getKind() == 2) {
                        VlogBuildContributor.this.fDeltaRemoved.add((IFile)resource);
                    }
                }
            }
            return false;
        }

        private void addFileAsChangedOrRenamed(IResourceDelta delta, IResource resource) {
            if (delta == null || !(resource instanceof IFile)) {
                return;
            }
            if (delta.getMovedFromPath() != null) {
                VlogBuildContributor.this.fDeltaRenamed.add((IFile)resource);
            }
            VlogBuildContributor.this.fDeltaChanged.add(new FileCompileInfo((IFile)resource));
        }
    }

    class LintingJob
    extends UIJob {
        private final String options;

        public LintingJob(String options) {
            super(PlatformUI.getWorkbench().getDisplay(), "Linting Job");
            this.options = options;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            BuildContributorDummyLaunchShortcut launchShortcut = new BuildContributorDummyLaunchShortcut(VlogBuildContributor.this.getProject(), this.options);
            launchShortcut.launch();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
        }
    }

    class RefreshListerer
    implements IPatternMatchListener {
        private Pattern fPattern = Pattern.compile("dvt_refresh:\\s+(.*)");
        private TextConsole fConsole;
        private IProgressMonitor fMonitor;

        protected RefreshListerer(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void matchFound(PatternMatchEvent event) {
            try {
                int offset = event.getOffset();
                int length = event.getLength();
                IDocument document = this.fConsole.getDocument();
                Matcher m = this.fPattern.matcher(document.get(offset, length));
                if (m.find()) {
                    String fileName = m.group(1).trim();
                    IFile file = VlogFileUtils.getInstance().findProjectFile(VlogBuildContributor.this.getProject(), fileName);
                    if (file != null) {
                        SubProgressMonitor refreshMonitor = new SubProgressMonitor(this.fMonitor, 100);
                        file.refreshLocal(1, (IProgressMonitor)refreshMonitor);
                        refreshMonitor.done();
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public void disconnect() {
            this.fConsole = null;
        }

        public void connect(TextConsole console) {
            this.fConsole = console;
        }

        public String getPattern() {
            return this.fPattern.pattern();
        }

        public String getLineQualifier() {
            return null;
        }

        public int getCompilerFlags() {
            return 0;
        }
    }
}

