/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.builders;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import ro.amiq.dvt.builders.DVTConsoleButtonsDescription;
import ro.amiq.dvt.builders.DVTMessageConsole;
import ro.amiq.dvt.externaltools.ConsoleHighlightModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.IMacroTraceListener;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogMacroTraceConsoleViewer
implements IMacroTraceListener {
    private DVTMessageConsole fConsole;
    private IConsoleScanListener fListener;
    private IProject fProject;
    private IConsoleManager fConsoleManager;

    public void dispose() {
        if (this.fConsole == null || this.fListener == null) {
            return;
        }
        this.fConsole.removePatternMatchListener((IPatternMatchListener)this.fListener);
        this.fConsoleManager.removeConsoles(new IConsole[]{this.fConsole});
    }

    private void createConsole() {
        if (this.fConsole != null) {
            return;
        }
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        this.fConsoleManager = plugin.getConsoleManager();
        this.fConsole = new DVTMessageConsole(this.fProject, "[" + this.fProject.getName() + "] trace macro error", null, new DVTConsoleButtonsDescription(false, false, true));
        this.fConsoleManager.addConsoles(new IConsole[]{this.fConsole});
        this.setListeners();
    }

    private void setListeners() {
        ConsoleHighlightModelManager.getInstance().fConsoleToListeners.putIfAbsent(this.fConsole, new ConcurrentLinkedQueue());
        Queue listeners = (Queue)ConsoleHighlightModelManager.getInstance().fConsoleToListeners.get(this.fConsole);
        this.fListener = new ConsoleListener(this.fProject);
        if (!listeners.contains(this.fListener)) {
            this.fConsole.addPatternMatchListener((IPatternMatchListener)this.fListener);
            listeners.add(this.fListener);
        }
        this.setProcessConsole();
    }

    private void setProcessConsole() {
        ExternalToolsConfiguration config = new ExternalToolsConfiguration();
        ExternalToolsModelManager.getInstance().setProcessConsole((IConsole)this.fConsole, this.fProject, (IExternalToolsConfiguration)config, null, 1, this.fProject.getLocation().toOSString());
    }

    public void notifyMacroTraceError(final String message, String projectName) {
        if (message == null || projectName == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.fProject = workspace.getRoot().getProject(projectName);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (VlogMacroTraceConsoleViewer.this.fConsole == null) {
                        VlogMacroTraceConsoleViewer.this.createConsole();
                    }
                    VlogMacroTraceConsoleViewer.this.fConsole.getDocument().set("");
                    VlogMacroTraceConsoleViewer.this.setListeners();
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (MessageConsoleStream out = VlogMacroTraceConsoleViewer.this.fConsole.newMessageStream();){
                        out.setColor(DVTColorUtil.INSTANCE.getColor(255, 0, 0));
                        out.setActivateOnWrite(true);
                        out.println(message);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    static class ConsoleListener
    implements IConsoleScanListener {
        private static final Pattern fPattern = Pattern.compile("at\\sline\\s(\\d+)\\sin\\s[']([^']+)[']");
        private TextConsole fConsole;
        private TextConsoleViewer fConsoleViewer;
        private IProject fProject;

        public ConsoleListener(IProject project) {
            this.fProject = project;
        }

        public TextConsole getConsole() {
            return this.fConsole;
        }

        public TextConsoleViewer getConsoleViewer() {
            return this.fConsoleViewer;
        }

        public void connect(TextConsole console) {
            this.fConsole = console;
        }

        public void disconnect() {
            this.fConsole = null;
            this.fConsoleViewer = null;
        }

        public void addHyperlink(int offset, int length) {
            try {
                IDocument document = this.fConsole.getDocument();
                int line = -1;
                String file = "";
                Matcher m = fPattern.matcher(document.get(offset, length));
                if (!m.matches() || m.groupCount() != 2) {
                    return;
                }
                line = DVTStringUtil.parseInt((String)m.group(1), (int)-1);
                file = m.group(2);
                if (this.fProject == null) {
                    return;
                }
                if (line != -1) {
                    Hyperlink link = new Hyperlink(this.fProject, file, line);
                    this.fConsole.addHyperlink((IHyperlink)link, offset, length);
                }
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
            }
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return "at\\sline";
        }

        public String getPattern() {
            return fPattern.pattern();
        }

        public Pattern getWholePattern() {
            return fPattern;
        }

        public void setConsoleViewer(TextConsoleViewer newConsoleViewer) {
            this.fConsoleViewer = newConsoleViewer;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fProject == null ? 0 : this.fProject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConsoleListener other = (ConsoleListener)obj;
            return !(this.fProject == null ? other.fProject != null : !this.fProject.equals((Object)other.fProject));
        }
    }

    private static class Hyperlink
    implements IHyperlink {
        private IProject project;
        private String file;
        private int line;

        Hyperlink(IProject project, String file, int line) {
            this.project = project;
            this.file = file;
            this.line = line;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            if (this.project == null) {
                return;
            }
            VlogFileUtils.getInstance().openFile(this.project, this.file, this.line);
        }
    }
}

