/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.core;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;
import ro.amiq.dvt.DVTActivator;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.actions.IMacroTraceListener;
import ro.amiq.dvt.ui.actions.MacroTraceActionManager;
import ro.amiq.vlogdt.builders.VlogMacroTraceConsoleViewer;
import ro.amiq.vlogdt.core.VlogPluginCommon;
import ro.amiq.vlogdt.externaltools.VlogExternalToolsDelegate;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditStrategyManager;
import ro.amiq.vlogdt.ui.encrypted.EncryptedLabelManager;
import ro.amiq.vlogdt.ui.persistenttask.PersistentTaskManager;
import ro.amiq.vlogdt.ui.syntaxerrors.SyntaxErrorsManager;

public class VlogPlugin
extends VlogPluginCommon {
    private static VlogPlugin fPlugin;
    public static final String VERILOG_EXTERNAL_BUILDER = "ro.amiq.vlogdtpattern.conventions";
    public static final String DEFAULT_VERILOG_EXTERNAL_BUILDER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><conventions></conventions>";
    public static final String DESCRIPTION_OVM_COMPLIANCE_OPTIONS = "Edit OVM Compliance checks and statistics";
    public static final String DESCRIPTION_OVM_STATISTICS_OPTIONS = "Enable or disable rules:";
    private IPreferenceStore fCombinedPreferenceStore;

    public VlogPlugin() {
        fPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DVTLogger.INSTANCE.logDebug(">> Started VLOGVT Plugin (version: " + (String)this.getBundle().getHeaders().get("Bundle-Version") + ").");
        context.addBundleListener(event -> {
            if (event.getType() == 2 && event.getBundle().getSymbolicName().equals("ro.amiq.vlogdt")) {
                DVTLogger.INSTANCE.logDebug(">> Started VLOGDT initialization.");
                new DVTActivator();
                SyntaxErrorsManager.getInstance().startup();
                EncryptedLabelManager.getInstance().startup();
                MacroTraceActionManager.getInstance().addMacroTraceListener("ro.amiq.vlogdt", (IMacroTraceListener)new VlogMacroTraceConsoleViewer());
                ExternalToolsModelManager.getInstance().addExternalToolsDelegate((IExternalToolsDelegate)VlogExternalToolsDelegate.getInstance());
                LintingProblemsManager.getInstance().startup();
                try {
                    while (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                        Thread.sleep(50L);
                    }
                }
                catch (InterruptedException interruptedException) {}
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    DVTLogger.INSTANCE.logDebug(">> Started VLOGDT UI initialization.");
                    VlogPlugin.getDefault().getPreferenceStore().setDefault(VERILOG_EXTERNAL_BUILDER, DEFAULT_VERILOG_EXTERNAL_BUILDER);
                    PersistentTaskManager.getInstance().startup();
                    DVTMixedLangModelManager.getInstance().registerModelManager((DVTModelManager)VlogModelManager.getInstance());
                    VlogAutoEditStrategyManager.INSTANCE.init();
                    ObjectionManager.getInstance().clear(Objection.VLOGDT_INITIALIZED);
                    DVTLogger.INSTANCE.logDebug("<< Ended VLOGDT UI initialization.");
                });
                DVTLogger.INSTANCE.logDebug("<< Ended VLOGDT initialization.");
            }
        });
    }

    @Override
    public void stop(BundleContext context) {
        try {
            super.stop(context);
            LintingProblemsManager.getInstance().shutdown();
            MacroTraceActionManager.getInstance().removeMacroTraceListener("ro.amiq.vlogdt");
            VlogAutoEditStrategyManager.INSTANCE.dispose();
            DVTPlugin.getDefault().collect().i("F7376");
            DVTLogger.INSTANCE.logDebug("<< Ended VLOGDT Plugin.");
        }
        finally {
            fPlugin = null;
            super.stop(context);
        }
    }

    public static VlogPlugin getDefault() {
        return fPlugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ro.amiq.vlogdt", (String)path);
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public void savePreferences() {
        try {
            InstanceScope instance = new InstanceScope();
            instance.getNode("ro.amiq.vlogdt").flush();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

