/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.debug.ui.editor.hover;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorInput;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.model.DebugTarget;
import ro.amiq.dvt.debug.core.model.StackFrame;
import ro.amiq.dvt.debug.core.model.variables.Value;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.debug.ui.editor.hover.VlogDebugTextHoverParticipantCommon;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;

public class VlogDebugTextHoverParticipant
extends VlogDebugTextHoverParticipantCommon {
    public void makeInfo(ITextViewer textViewer, IRegion region, DVTTooltipContent tooltipContent) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        String info = "";
        int i = 0;
        while (i < launches.length) {
            if (launches[i] != null) {
                String subInfo;
                IDebugTarget target = launches[i].getDebugTarget();
                if (target instanceof DebugTarget) {
                    subInfo = this.getInfo(textViewer, region, (DebugTarget)target);
                    if (subInfo != null) {
                        if (launches.length > 1) {
                            try {
                                targetName = target.getName();
                            }
                            catch (DebugException debugException) {
                                targetName = String.valueOf(i);
                            }
                            info = DVTStringUtil.appendString((Object[])new Object[]{info, "<br>[", targetName, "]: ", subInfo, "</br>"});
                        } else {
                            info = DVTStringUtil.appendString((Object[])new Object[]{info, "<br>", subInfo, "</br>"});
                        }
                    }
                } else if (target instanceof IntrpDebugTarget && (subInfo = this.getInfo(textViewer, region, (IntrpDebugTarget)target)) != null) {
                    if (launches.length > 1) {
                        try {
                            targetName = target.getName();
                        }
                        catch (DebugException debugException) {
                            targetName = String.valueOf(i);
                        }
                        info = DVTStringUtil.appendString((Object[])new Object[]{info, "<br>[", targetName, "]: ", subInfo, "</br>"});
                    } else {
                        info = DVTStringUtil.appendString((Object[])new Object[]{info, "<br>", subInfo, "</br>"});
                    }
                }
            }
            ++i;
        }
        tooltipContent.set(DVTTooltipContent.TooltipContent.DEBUG_INFO, info);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getInfo(ITextViewer textViewer, IRegion region, DebugTarget target) {
        IWatchExpressionResult request;
        String result;
        block9: {
            block8: {
                IDocument document;
                block7: {
                    block6: {
                        try {
                            document = textViewer.getDocument();
                            result = "";
                            if (document != null) break block6;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    int offset = region.getOffset();
                    region = VlogWordFinder.getDefault().getExpressionAtOffset(document, offset);
                    if (region != null) break block7;
                    return null;
                }
                result = document.get(region.getOffset(), region.getLength());
                if (result != null) break block8;
                return null;
            }
            result = result.trim();
            if (target.getActiveThread() == null || target.getActiveThread().getCurrentStackFrame() == null) return "<b>" + result + "</b>";
            StackFrame stack = target.getActiveThread().getCurrentStackFrame();
            request = target.tGetWatchExpressionResult(result, (IDebugElement)stack);
            if (request != null && !request.hasErrors()) break block9;
            return null;
        }
        result = String.valueOf(result) + " = " + ((Value)request.getValue()).getValueString();
        return "<b>" + result + "</b>";
    }

    @Override
    protected IFile getFile() {
        if (this.textEditor == null) {
            return null;
        }
        IEditorInput editorInput = this.textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }
}

