/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.debug.ui.editor.hover;

import com.google.re2j.Pattern;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpValue;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;

public abstract class VlogDebugTextHoverParticipantCommon
implements ITextHoverParticipant {
    protected ITextEditor textEditor;
    private static final Pattern WHITE_SPACES_PATTERN = Pattern.compile((String)"\\s+");

    public void setTextEditor(ITextEditor textEditor) {
        this.textEditor = textEditor;
    }

    protected ITextEditor getEditor() {
        return this.textEditor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getInfo(ITextViewer textViewer, IRegion region, IntrpDebugTarget target) {
        try {
            String cursorOffsetPartition;
            IDocument document = textViewer.getDocument();
            String result = "";
            if (document == null) {
                return null;
            }
            int offset = region.getOffset();
            IRfScopeElement cursorScope = null;
            RfWNamedElementAndScope namedElementAndScope = null;
            ITextEditor textEditor = this.getEditor();
            IFile file = null;
            RfProject rfProject = null;
            if (textEditor instanceof DVTEditor) {
                file = this.getFile();
                if (file == null) {
                    return null;
                }
                IProject project = file.getProject();
                if (project == null) {
                    return null;
                }
                rfProject = RfManager.getInstance().getRfProject(project);
                if (rfProject == null) {
                    return null;
                }
                namedElementAndScope = RfUtils.getRfElement(rfProject, file, document, offset, (DVTEditor)textEditor);
                if (namedElementAndScope != null) {
                    if (namedElementAndScope.getIRfNamedElement() instanceof IRfMethodElement) {
                        return null;
                    }
                    cursorScope = namedElementAndScope.getScope();
                }
            }
            if ("__vlog_escaped_id".equals(cursorOffsetPartition = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", offset, false))) {
                ITypedRegion typedRegion = VlogWordFinder.getDefault().getTypedRegion(document, offset);
                region = new Region(typedRegion.getOffset() + 1, typedRegion.getLength() - 1);
            } else {
                region = VlogWordFinder.getDefault().getExpressionAtOffset(document, offset);
            }
            if (region == null) {
                return null;
            }
            result = document.get(region.getOffset(), region.getLength());
            if (result == null || result.isEmpty()) {
                return null;
            }
            int startOffset = region.getOffset() + (result.length() - (String.valueOf(result) + ";").trim().length() + 1);
            result = result.trim();
            Map<String, IRfNamedElementAndScope> indexElementMap = this.extractArrayIndicesNamedElementsByName(rfProject, this.getFile(), document, result, startOffset, textEditor instanceof DVTEditor ? (DVTEditor)textEditor : null);
            result = result.replace(" ", "");
            IntrpDebugThread activeThread = target.getActiveThread();
            if (activeThread != null && activeThread.getStackFrames() != null) {
                IStackFrame[] stackFrames = activeThread.getStackFrames();
                IWatchExpressionResult request = target.getWatchExpressionResult(result, (IRfNamedElementAndScope)namedElementAndScope, cursorScope, stackFrames, indexElementMap);
                String watchExpressionResult = "N/A";
                if (request != null && !request.hasErrors()) {
                    watchExpressionResult = ((IntrpValue)request.getValue()).getValueString();
                }
                result = String.valueOf(result) + " = " + watchExpressionResult;
            }
            return "<b>" + result + "</b>";
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public Map<String, IRfNamedElementAndScope> extractArrayIndicesNamedElementsByName(IRfSingleLangProject project, IFile file, IDocument document, String variableName, int startOffset, DVTEditor editor) {
        HashMap<String, IRfNamedElementAndScope> indices = new HashMap<String, IRfNamedElementAndScope>();
        int startIndex = variableName.indexOf(91);
        if (startIndex == -1) {
            return indices;
        }
        StringBuilder currentIndex = new StringBuilder("");
        int nested = 0;
        int i = startIndex;
        while (i < variableName.length()) {
            char ch = variableName.charAt(i);
            if (ch == ']') {
                --nested;
            }
            if (ch == ']' && nested == 0) {
                String currentIndexStr = currentIndex.toString();
                int currentOffset = startOffset + i;
                int indexFinalOffset = currentOffset - (currentIndexStr.length() - (";" + currentIndexStr).trim().length() + 1);
                RfWNamedElementAndScope currentElement = RfUtils.getRfElement(project, file, document, indexFinalOffset - 1, editor);
                Map<String, IRfNamedElementAndScope> innerResults = this.extractArrayIndicesNamedElementsByName(project, file, document, currentIndexStr, currentOffset - currentIndexStr.length(), editor);
                String indexVarName = currentIndexStr.trim();
                indices.put(WHITE_SPACES_PATTERN.matcher((CharSequence)indexVarName).replaceAll(""), currentElement);
                indices.putAll(innerResults);
            } else {
                if (ch == '[') {
                    ++nested;
                }
                if (ch == '[' && nested == 1) {
                    currentIndex = new StringBuilder("");
                } else {
                    currentIndex.append(ch);
                }
            }
            ++i;
        }
        return indices;
    }

    protected abstract IFile getFile();
}

