/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.diagrams.chd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.ICHModel;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHDesign;
import ro.amiq.dvt.diagrams.ch.model.CHInterface;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.model.CHUVMPort;
import ro.amiq.dvt.diagrams.ch.model.CHVif;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.exceptions.DMessageException;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetGetCallInfo;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.config.db.ConfigDBViewFilters;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.interpreter.factory.chs.XXVMConfigDBSetValueHolderCallInfo;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XCustomPortComponent;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMPortComponent;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VHViewUtil;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmField;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmPort;

public class VlogCHModel
implements ICHModel {
    private static final Pattern NONWORD_PATTERN = Pattern.compile("\\[\\w+\\]");
    private static final String DESIGN_BLOCK_NAME = "design";
    private static VlogCHModel instance;
    private static final Object syncInstance;
    private static final Pattern DOT;

    static {
        syncInstance = new Object();
        DOT = Pattern.compile("\\.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogCHModel getInstance() {
        if (instance == null) {
            Object object = syncInstance;
            synchronized (object) {
                instance = new VlogCHModel();
            }
        }
        return instance;
    }

    public CHRoot makeComponentDiagramFor(ICHDiagram input, DProgressMonitor monitor) throws DCanceledException {
        XXVMComponent xvmTreeComponent;
        monitor.checkCanceled();
        if (input == null) {
            return null;
        }
        int depth = input.getDepth();
        boolean isExplicitVifConnections = input.isExplicitVifConnections();
        IDVTElementWrapper wrapper = input.getWrapper();
        if (wrapper == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.project = wrapper.getProject();
        String path = this.getPath(wrapper, "");
        if (path.contains(".")) {
            bundle.initialPathSegment = path.substring(0, path.lastIndexOf(46) + 1);
        }
        RfXvmBase rfXvmBase = (RfXvmBase)wrapper.getRfElement(RfXvmBase.class);
        boolean isTop = false;
        if (wrapper.getParent() != null && wrapper.getParent().getParent() == null && !(rfXvmBase instanceof RfXvmObjectInstance)) {
            isTop = true;
        }
        if ((xvmTreeComponent = (XXVMComponent)wrapper.getRfElement(XXVMComponent.class)) != null) {
            if (xvmTreeComponent instanceof XXVMPortComponent || xvmTreeComponent instanceof XCustomPortComponent) {
                return null;
            }
            RfTreeElementWrapper root = new RfTreeElementWrapper(xvmTreeComponent);
            VHViewUtil.getRecursiveInstancesXXVMTreeComponent(new LinkedHashSet<RfClass>(), root, xvmTreeComponent, false, false, null, null);
            int[] nArray = new int[2];
            nArray[0] = 1;
            int[] currentDepth = nArray;
            bundle.initialPathSegment = DVTStringUtil.split((String)xvmTreeComponent.getName(), (String)xvmTreeComponent.getFullName())[0];
            CHContainer firstComponent = this.createCHObjectsFromXVMComponent(root, null, currentDepth, depth, isTop, bundle, monitor);
            LinkedHashSet<CHConnection> connections = new LinkedHashSet<CHConnection>();
            this.createCHConnectionsXVMComponents(xvmTreeComponent, connections, this.getPath(root, bundle.initialPathSegment), bundle, monitor);
            CHDesign designNode = new CHDesign();
            LinkedHashMap<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls = new LinkedHashMap<String, List<IXXVMConfigDBSetGetCallInfo>>(XXVMBuilder.INSTANCE.getConfigDBCalls());
            configDBCalls.remove(ConfigDBViewFilters.GETTERS_WITHOUT_SETTERS.getLabel());
            this.createDesignConnectionsXVMComponents(root, connections, designNode, configDBCalls, isExplicitVifConnections, bundle, monitor);
            CHRoot chRoot = new CHRoot((CHUVMComponent)firstComponent, designNode, new ArrayList<CHConnection>(connections), currentDepth[0] - 1, LanguageKind.VLOG);
            chRoot.setCustomDepth(depth);
            input.setGeneratedAfterElab(true);
            return chRoot;
        }
        if (rfXvmBase == null || rfXvmBase instanceof RfXvmPort || rfXvmBase instanceof RfXvmField) {
            return null;
        }
        RfXvmObject xvmObject = this.getXvmObject(wrapper);
        RfTreeElementWrapper root = new RfTreeElementWrapper(rfXvmBase);
        VHViewUtil.getRecursiveInstances(new LinkedHashSet<RfClass>(), root, xvmObject, false, false, PrefConst.getVHViewShowComponentsOnly(), null, null);
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] currentDepth = nArray;
        CHContainer firstComponent = this.createCHObjects(root, null, currentDepth, depth, isTop, bundle, monitor);
        LinkedHashSet<CHConnection> connections = new LinkedHashSet<CHConnection>();
        this.createCHConnections(root, connections, this.getPath(root, bundle.initialPathSegment), bundle, monitor);
        this.createCHOrientedConnections(bundle.project, connections);
        CHDesign designNode = new CHDesign();
        this.createDesignConnections(root, connections, designNode, bundle, monitor);
        CHRoot chRoot = new CHRoot((CHUVMComponent)firstComponent, designNode, new ArrayList<CHConnection>(connections), currentDepth[0] - 1, LanguageKind.VLOG);
        chRoot.setCustomDepth(depth);
        input.setGeneratedAfterElab(false);
        return chRoot;
    }

    private void createCHOrientedConnections(IProject project, Set<CHConnection> connections) {
        CHPort connectionDestination;
        CHPort connectionSource;
        HashSet<CHPort> visitedPorts = new HashSet<CHPort>();
        HashSet<CHConnection> addedConnectionsForBidirectionalPorts = new HashSet<CHConnection>();
        for (CHConnection connection : connections) {
            connectionSource = connection.getSource();
            connectionDestination = connection.getDestination();
            if (connectionSource.isEndpointSource() || connectionSource.isEndpointDestination()) {
                this.computeOrientedConnection(connectionSource, connectionSource.isEndpointSource(), visitedPorts, new HashSet<CHConnection>(), addedConnectionsForBidirectionalPorts, project, null);
                continue;
            }
            if (!connectionDestination.isEndpointSource() && !connectionDestination.isEndpointDestination()) continue;
            this.computeOrientedConnection(connectionDestination, connectionDestination.isEndpointSource(), visitedPorts, new HashSet<CHConnection>(), addedConnectionsForBidirectionalPorts, project, null);
        }
        for (CHConnection connection : connections) {
            CHPort orientedConnectionDestination;
            CHPort orientedConnectionSource;
            boolean invertedDirection;
            connectionSource = connection.getSource();
            if (visitedPorts.contains(connectionSource) || connectionSource.getKind() != CHPort.Kind.PORT && connectionSource.getKind() != CHPort.Kind.EXPORT || visitedPorts.contains(connectionDestination = connection.getDestination()) || connectionDestination.getKind() != CHPort.Kind.PORT && connectionDestination.getKind() != CHPort.Kind.EXPORT) continue;
            boolean sameDirection = connectionSource.getKind() == CHPort.Kind.PORT && connectionDestination.getKind() == CHPort.Kind.EXPORT;
            boolean bl = invertedDirection = connectionSource.getKind() == CHPort.Kind.EXPORT && connectionDestination.getKind() == CHPort.Kind.PORT;
            Object object = sameDirection ? connectionSource : (orientedConnectionSource = invertedDirection ? connectionDestination : null);
            Object object2 = sameDirection ? connectionDestination : (orientedConnectionDestination = invertedDirection ? connectionSource : null);
            if (orientedConnectionSource == null || orientedConnectionDestination == null) continue;
            if (invertedDirection) {
                connection.swapDirection();
            }
            HashSet<CHConnection> parentConnections = new HashSet<CHConnection>();
            parentConnections.add(connection);
            this.computeOrientedConnection(orientedConnectionDestination, true, new HashSet<CHPort>(), parentConnections, addedConnectionsForBidirectionalPorts, project, connection);
            this.computeOrientedConnection(orientedConnectionSource, false, new HashSet<CHPort>(), parentConnections, addedConnectionsForBidirectionalPorts, project, connection);
        }
        connections.addAll(addedConnectionsForBidirectionalPorts);
    }

    private void computeOrientedConnection(CHPort port, boolean isSource, Set<CHPort> visitedPorts, Set<CHConnection> parentConnections, Set<CHConnection> bidirectionalConnections, IProject project, CHConnection baseConnection) {
        if (visitedPorts.contains(port)) {
            return;
        }
        visitedPorts.add(port);
        HashSet<CHConnection> addedConnectionsForBidirectionalPorts = new HashSet<CHConnection>();
        List connections = port.getConnections();
        for (CHConnection connection : connections) {
            CHPort portDestination;
            CHPort portSource;
            if (connection.equals((Object)baseConnection)) continue;
            CHPort cHPort = isSource ? port : (portSource = port.equals((Object)connection.getSource()) ? connection.getDestination() : connection.getSource());
            CHPort cHPort2 = isSource ? (port.equals((Object)connection.getSource()) ? connection.getDestination() : connection.getSource()) : (portDestination = port);
            if (portSource.getDirectionKind() == CHPort.DirectionKind.BIDIRECTIONAL || portDestination.getDirectionKind() == CHPort.DirectionKind.BIDIRECTIONAL) {
                if (portSource.equals((Object)connection.getSource())) {
                    this.addBidirectionalConnection(new CHConnection(portDestination, portSource, this.getLanguageKind(), project), connections, addedConnectionsForBidirectionalPorts);
                } else {
                    this.addBidirectionalConnection(new CHConnection(portSource, portDestination, this.getLanguageKind(), project), connections, addedConnectionsForBidirectionalPorts);
                }
            } else {
                boolean isForcedReversedDirection;
                boolean bl = isForcedReversedDirection = portSource.isEndpointDestination() && portDestination.isEndpointSource();
                if (isForcedReversedDirection || parentConnections.contains(connection)) {
                    if (portSource.equals((Object)connection.getSource())) {
                        connection.swapDirection();
                    }
                } else if (!portSource.equals((Object)connection.getSource())) {
                    connection.swapDirection();
                }
            }
            parentConnections.add(connection);
            this.computeOrientedConnection(isSource ? portDestination : portSource, isSource, visitedPorts, parentConnections, bidirectionalConnections, project, baseConnection);
            parentConnections.remove(connection);
        }
        bidirectionalConnections.addAll(addedConnectionsForBidirectionalPorts);
        for (CHConnection connection : addedConnectionsForBidirectionalPorts) {
            port.addConnection(connection);
        }
    }

    private void addBidirectionalConnection(CHConnection chConnection, List<CHConnection> connections, Set<CHConnection> addedConnectionsForBidirectionalPorts) {
        if (connections.contains(chConnection)) {
            return;
        }
        chConnection.setIsVisible(false);
        addedConnectionsForBidirectionalPorts.add(chConnection);
    }

    private void createDesignConnectionsXVMComponents(IDVTElementWrapper wrapper, Set<CHConnection> connections, CHDesign designNode, Map<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls, boolean isExplicitVifConnections, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        RfClass rfClass;
        monitor.checkCanceled();
        Object rfElement = wrapper.getRfElement();
        if (rfElement instanceof RfDummyElement) {
            return;
        }
        RfClass rfClass2 = rfClass = rfElement instanceof XXVMComponent ? (RfClass)((XXVMComponent)rfElement).getRfClass() : null;
        if (rfClass == null) {
            return;
        }
        List<RfField> fields = rfClass.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
        if (fields == null) {
            return;
        }
        String containerPath = this.getPath(wrapper, bundle.initialPathSegment);
        CHUVMComponent parent = (CHUVMComponent)bundle.containerMap.get(containerPath);
        if (parent == null) {
            return;
        }
        for (RfField field : fields) {
            boolean isVirtualInterface;
            IRfNamedElement associatedType = field.getAssociatedType();
            boolean bl = isVirtualInterface = field.getDataType() != null && field.getDataType().isVirtualInterface();
            if (!isVirtualInterface && associatedType instanceof IRfTypeAliasElement) {
                boolean bl2 = isVirtualInterface = DesignUtils.getDesignKind((Object)((IRfTypeAliasElement)associatedType).getTranslatedType()) == IRfNamedElement.ElementKind.VLOG_INTERFACE;
            }
            if (!isVirtualInterface || associatedType == null) continue;
            this.createVifConnectionXVMComponents(wrapper, parent, field, designNode, connections, configDBCalls, isExplicitVifConnections, bundle);
        }
        if (wrapper.getChildren() != null) {
            for (IDVTElementWrapper child : wrapper.getChildren()) {
                this.createDesignConnectionsXVMComponents(child, connections, designNode, configDBCalls, isExplicitVifConnections, bundle, monitor);
            }
        }
    }

    private void createVifConnectionXVMComponents(IDVTElementWrapper wrapper, CHUVMComponent parent, RfField vif, CHDesign designNode, Set<CHConnection> connections, Map<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls, boolean isExplicitVifConnections, Bundle bundle) {
        IRfNamedElement associatedType = vif.getAssociatedType();
        if (associatedType instanceof IRfTypeAliasElement) {
            associatedType = ((IRfTypeAliasElement)associatedType).getTranslatedType();
        }
        String vifTypeName = associatedType.getName();
        String containerPath = this.getPath(wrapper, bundle.initialPathSegment);
        CHVif port = new CHVif(String.valueOf(containerPath) + "." + vif.getName(), vif.getName(), vifTypeName, parent);
        parent.addPort((CHPort)port);
        for (List<IXXVMConfigDBSetGetCallInfo> callInfoList : configDBCalls.values()) {
            for (IXXVMConfigDBSetGetCallInfo callInfo : callInfoList) {
                String interfaceType;
                if (!(callInfo instanceof XXVMConfigDBSetValueHolderCallInfo) || !vifTypeName.equals(interfaceType = callInfo.getParameterizedTypeName())) continue;
                CHPort interfacePort = null;
                if (!isExplicitVifConnections) {
                    interfacePort = this.createSimpleVifConnectionPort(designNode, bundle, associatedType, vifTypeName);
                } else {
                    interfacePort = this.createExplicitVifConnectionPortXVMComponents(containerPath, vif, designNode, (XXVMConfigDBSetValueHolderCallInfo)callInfo, bundle, vifTypeName);
                    if (interfacePort == null) continue;
                }
                CHConnection connection = new CHConnection((CHPort)port, interfacePort, this.getLanguageKind(), bundle.project);
                connection.setInspectViewMarker(callInfo.getGoToInfo());
                port.addConnection(connection);
                interfacePort.addConnection(connection);
                connections.add(connection);
                port.getParent().setIsConnected();
                interfacePort.getParent().setIsConnected();
            }
        }
    }

    private CHPort createExplicitVifConnectionPortXVMComponents(String containerPath, RfField vif, CHDesign designNode, XXVMConfigDBSetValueHolderCallInfo callInfo, Bundle bundle, String vifTypeName) {
        List ports;
        String valueName;
        int pointerCharIndex;
        StringMatcher matcher;
        Object[] split;
        String actualTestName;
        if (!callInfo.getFieldName().equals(vif.getName())) {
            return null;
        }
        String vifPath = String.valueOf(containerPath) + "." + vif.getName();
        String instName = callInfo.getInstName();
        if (instName.startsWith(actualTestName = XXVMBuilder.INSTANCE.getActualTestName(null)) && (split = DVTStringUtil.split((String)".", (String)instName)) != null && split.length != 0) {
            split[0] = "vm_test_top";
            instName = DVTStringUtil.join((Object[])split, (String)".");
        }
        if (!ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)(matcher = ViewsUtilsCommon.createCamelCaseOrRegexMatcher((String)instName, (boolean)false, (boolean)false)), (String)vifPath)) {
            return null;
        }
        IRfNamedElement valueNamedElement = callInfo.getValueNamedElement();
        if (valueNamedElement == null) {
            return null;
        }
        IRfSingleLangProject rfProject = valueNamedElement.getRfProject();
        ELManager elManager = rfProject == null ? null : rfProject.getELManager();
        ElementPath moduleHierarchyPath = this.extractElementHierarchyPath(valueNamedElement, elManager);
        if (moduleHierarchyPath == null) {
            return null;
        }
        moduleHierarchyPath = moduleHierarchyPath.removeLastSegment();
        IRfNamedElement valueEnclosingElement = (IRfNamedElement)valueNamedElement.getEnclosingScope();
        String valueEnclosingName = valueEnclosingElement.getName();
        CHUVMComponent topContainer = (CHUVMComponent)bundle.containerMap.get("design." + moduleHierarchyPath);
        if (topContainer == null) {
            topContainer = this.createTopContainer(designNode, bundle, instName, moduleHierarchyPath, valueEnclosingElement, valueEnclosingName);
        }
        if ((pointerCharIndex = (valueName = callInfo.getValue()).indexOf(64)) > 0) {
            valueName = callInfo.getValue().substring(0, pointerCharIndex);
        }
        String valueShortName = valueName.substring(valueName.lastIndexOf(46) + 1, valueName.length());
        CHUVMComponent valueContainer = (CHUVMComponent)bundle.containerMap.get("design." + valueName);
        if (valueContainer == null) {
            valueContainer = this.createValueContainer(bundle, vifTypeName, valueNamedElement, topContainer, valueShortName, valueName);
        }
        if ((ports = valueContainer.getPorts()).isEmpty()) {
            return null;
        }
        return (CHPort)ports.get(0);
    }

    private ElementPath extractElementHierarchyPath(IRfNamedElement valueNamedElement, ELManager elManager) {
        List instancesFor;
        if (elManager != null && valueNamedElement instanceof IRfInstanceElement && (instancesFor = elManager.getMemory().getInstancesFor((IRfInstanceElement)valueNamedElement, Integer.MAX_VALUE)) != null) {
            for (ELInstance instanceFor : instancesFor) {
                if (instanceFor.getDescription() != valueNamedElement) continue;
                ElementPath elementHierarchyPath = instanceFor.getHierarchyPath();
                return elementHierarchyPath;
            }
        }
        return null;
    }

    private void createCHConnectionsXVMComponents(IXXVMComponent component, Set<CHConnection> result, String path, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (!(component instanceof XXVMComponent)) {
            return;
        }
        XXVMComponent xxvmTreeComponent = (XXVMComponent)component;
        if (xxvmTreeComponent.getPorts() != null && !xxvmTreeComponent.getPorts().isEmpty()) {
            for (IXXVMComponent port : xxvmTreeComponent.getPorts()) {
                if (!(port instanceof XXVMPortComponent)) continue;
                XXVMPortComponent sourceComponent = (XXVMPortComponent)port;
                for (XXVMPortComponent destinationComponent : sourceComponent.getConnectedTo()) {
                    int j;
                    String sourceFullName = sourceComponent.getFullName();
                    String destinationFullName = destinationComponent.getFullName();
                    if (sourceComponent.isInsideTLMFIFO()) {
                        String[] sourcePath = DVTStringUtil.split((Pattern)DOT, (String)sourceFullName);
                        DVTStringBuilder sourceParent = new DVTStringBuilder();
                        j = 0;
                        while (j < sourcePath.length - 1) {
                            sourceParent.append(sourcePath[j]).append(".");
                            ++j;
                        }
                        sourceParent.deleteLastChar();
                        sourceFullName = sourceParent.toString();
                    }
                    if (destinationComponent.isInsideTLMFIFO()) {
                        String[] destinationPath = DVTStringUtil.split((Pattern)DOT, (String)destinationFullName);
                        DVTStringBuilder destinationParent = new DVTStringBuilder();
                        j = 0;
                        while (j < destinationPath.length - 1) {
                            destinationParent.append(destinationPath[j]).append(".");
                            ++j;
                        }
                        destinationParent.deleteLastChar();
                        destinationFullName = destinationParent.toString();
                    }
                    CHPort sourcePort = bundle.portsMap.get(sourceFullName);
                    CHPort destinationPort = bundle.portsMap.get(destinationFullName);
                    if (sourcePort == null || destinationPort == null) continue;
                    CHConnection connection = new CHConnection(sourcePort, destinationPort, this.getLanguageKind(), bundle.project);
                    sourcePort.addConnection(connection);
                    destinationPort.addConnection(connection);
                    if (sourcePort.getParent() == null || destinationPort.getParent() == null) continue;
                    sourcePort.getParent().setIsConnected();
                    destinationPort.getParent().setIsConnected();
                    result.add(connection);
                }
            }
        }
        for (IXXVMComponent child : xxvmTreeComponent.getChildren()) {
            this.createCHConnectionsXVMComponents(child, result, path, bundle, monitor);
        }
    }

    private CHContainer createCHObjectsFromXVMComponent(IDVTElementWrapper wrapper, CHUVMComponent parent, int[] currentDepth, int maxDepth, boolean isTop, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        XXVMComponent component = (XXVMComponent)wrapper.getRfElement(XXVMComponent.class);
        if (component == null) {
            return null;
        }
        String name = null;
        String type = null;
        if (isTop) {
            name = component.getTypeName();
            type = null;
        } else {
            name = component.getName();
            type = component.getTypeName();
        }
        currentDepth[1] = currentDepth[1] + 1;
        currentDepth[0] = Math.max(currentDepth[0], currentDepth[1]);
        if (type != null && IXXVMComponent.XVM_COMPONENT_PATTERN.matches(type)) {
            type = component.getSVType() != null ? component.getSVType() : type;
        }
        String path = this.getPath(wrapper, bundle.initialPathSegment);
        CHUVMComponent diagramComponent = new CHUVMComponent(path, name, type, type, parent, this.getLanguageKind(), null, bundle.project, wrapper);
        diagramComponent.setInterpMode(true);
        diagramComponent.setDepth(currentDepth[1] - 1);
        diagramComponent.computeNames();
        diagramComponent.computeTypes();
        if (diagramComponent.getDepth() > maxDepth) {
            diagramComponent.setIsVisible(false, true);
            diagramComponent.setIsRelevant(false);
        }
        bundle.containerMap.put(path, (CHContainer)diagramComponent);
        if (parent != null) {
            parent.addChild((CHContainer)diagramComponent);
        } else {
            diagramComponent.setIsRelevant(false);
        }
        List<IXXVMComponent> ports = component.getPorts();
        if (ports != null && !ports.isEmpty()) {
            for (IXXVMComponent port : ports) {
                XXVMComponent xxvmTreePortComponent = (XXVMComponent)port;
                String svType = xxvmTreePortComponent.getSVType();
                String portPath = String.valueOf(path) + "." + xxvmTreePortComponent.getName();
                CHUVMPort chPort = new CHUVMPort(portPath, xxvmTreePortComponent.getName(), svType, svType, CHPort.Kind.fromString(null, (String)xxvmTreePortComponent.getSanitizedType(LanguageKind.VLOG, false)), CHPort.DirectionKind.fromString((String)xxvmTreePortComponent.getSanitizedType(LanguageKind.VLOG, false)), diagramComponent, bundle.project, this.getLanguageKind());
                chPort.setInterpMode(true);
                chPort.computeParentsNames();
                chPort.computeParentsTypes();
                diagramComponent.addPort((CHPort)chPort);
                bundle.portsMap.put(portPath, (CHPort)chPort);
            }
        }
        if (wrapper.getChildren() != null) {
            for (IDVTElementWrapper child : wrapper.getChildren()) {
                this.createCHObjectsFromXVMComponent(child, diagramComponent, currentDepth, maxDepth, false, bundle, monitor);
                currentDepth[1] = currentDepth[1] - 1;
            }
        }
        return diagramComponent;
    }

    private CHContainer createCHObjects(IDVTElementWrapper wrapper, CHUVMComponent parent, int[] currentDepth, int maxDepth, boolean isTop, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        Object rfElement = wrapper.getRfElement();
        if (rfElement instanceof RfDummyElement && parent != null) {
            String name = ((RfDummyElement)rfElement).getName();
            if ("[...recurrence detected]".equals(name)) {
                parent.setProblemLabel(name);
            }
            return parent;
        }
        String type = this.getType(rfElement);
        String name = null;
        if (isTop) {
            name = type;
            type = null;
        } else {
            name = this.getName(wrapper);
        }
        name = String.valueOf(this.appendShallowInformation(wrapper)) + name;
        currentDepth[1] = currentDepth[1] + 1;
        currentDepth[0] = Math.max(currentDepth[0], currentDepth[1]);
        String path = this.getPath(wrapper, bundle.initialPathSegment);
        CHUVMComponent component = new CHUVMComponent(path, name, type, type, parent, this.getLanguageKind(), null, bundle.project, wrapper);
        component.setDepth(currentDepth[1] - 1);
        component.computeNames();
        component.computeTypes();
        if (component.getDepth() > maxDepth) {
            component.setIsVisible(false, true);
            component.setIsRelevant(false);
        }
        bundle.containerMap.put(path, (CHContainer)component);
        if (parent != null) {
            parent.addChild((CHContainer)component);
        } else {
            component.setIsRelevant(false);
        }
        RfXvmObject xvmObject = this.getXvmObject(wrapper);
        List<RfXvmPort> ports = RfXvmFactory.getAllPorts(xvmObject);
        if (ports != null) {
            for (RfXvmPort port : ports) {
                String svType = this.getSVTypeForPort(port, xvmObject == null ? null : xvmObject.getNamedElement());
                RfNamedElement portTypeElement = port.getPortType();
                RfNamedElement portTypeBaseElement = portTypeElement instanceof IRfTypeAliasElement ? ((IRfTypeAliasElement)portTypeElement).getTranslatedType() : portTypeElement;
                String portTypeText = portTypeElement != null ? portTypeElement.getName() : "";
                String portTypeBaseText = portTypeBaseElement != null ? portTypeBaseElement.getName() : "";
                String portPath = String.valueOf(path) + "." + port.getName();
                CHUVMPort chPort = new CHUVMPort(portPath, port.getName(), portTypeText, svType, CHPort.Kind.fromString(null, (String)portTypeBaseText), CHPort.DirectionKind.fromString((String)portTypeBaseText), component, bundle.project, this.getLanguageKind());
                chPort.computeParentsNames();
                chPort.computeParentsTypes();
                component.addPort((CHPort)chPort);
                bundle.portsMap.put(portPath, (CHPort)chPort);
            }
        }
        if (wrapper.getChildren() != null) {
            for (IDVTElementWrapper child : wrapper.getChildren()) {
                this.createCHObjects(child, component, currentDepth, maxDepth, false, bundle, monitor);
                currentDepth[1] = currentDepth[1] - 1;
            }
        }
        return component;
    }

    private void createCHConnections(IDVTElementWrapper wrapper, Set<CHConnection> result, String path, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        RfXvmObject object;
        monitor.checkCanceled();
        RfXvmObject rfXvmObject = object = wrapper.getRfElement() instanceof RfXvmObjectInstance ? ((RfXvmObjectInstance)wrapper.getRfElement(RfXvmObjectInstance.class)).getObject() : (RfXvmObject)wrapper.getRfElement(RfXvmObject.class);
        if (object == null) {
            return;
        }
        IRfNamedElement rfClass = object.getNamedElement();
        if (rfClass == null) {
            return;
        }
        ConnectionVisitor visitor = new ConnectionVisitor(path, result, bundle);
        rfClass.visitHidObject(null, (IHidVisitor)visitor);
        if (wrapper.getChildren() == null) {
            return;
        }
        for (IDVTElementWrapper child : wrapper.getChildren()) {
            this.createCHConnections(child, result, this.getPath(child, bundle.initialPathSegment), bundle, monitor);
        }
    }

    private void createDesignConnections(IDVTElementWrapper wrapper, Set<CHConnection> connections, CHDesign designNode, Bundle bundle, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (wrapper.getRfElement() instanceof RfDummyElement) {
            return;
        }
        IRfNamedElement element = wrapper.getRfElement() instanceof RfXvmBase ? ((RfXvmBase)wrapper.getRfElement()).getNamedElement() : null;
        RfClass rfClass = null;
        if (element instanceof RfField && ((RfField)element).getEnclosingScope() instanceof RfClass) {
            rfClass = this.getTranslatedType(((RfField)element).getAssociatedType());
        } else if (element instanceof RfClass) {
            rfClass = (RfClass)element;
        }
        if (rfClass == null) {
            return;
        }
        List<RfField> fields = rfClass.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
        if (fields == null) {
            return;
        }
        String containerPath = this.getPath(wrapper, bundle.initialPathSegment);
        CHUVMComponent parent = (CHUVMComponent)bundle.containerMap.get(containerPath);
        if (parent == null) {
            return;
        }
        for (RfField field : fields) {
            boolean isVirtualInterface;
            IRfNamedElement associatedType = field.getAssociatedType();
            boolean bl = isVirtualInterface = field.getDataType() != null && field.getDataType().isVirtualInterface();
            if (!isVirtualInterface && associatedType instanceof IRfTypeAliasElement) {
                boolean bl2 = isVirtualInterface = DesignUtils.getDesignKind((Object)((IRfTypeAliasElement)associatedType).getTranslatedType()) == IRfNamedElement.ElementKind.VLOG_INTERFACE;
            }
            if (!isVirtualInterface || associatedType == null) continue;
            if (associatedType instanceof IRfTypeAliasElement) {
                associatedType = ((IRfTypeAliasElement)associatedType).getTranslatedType();
            }
            String typeName = associatedType.getName();
            CHVif port = new CHVif(String.valueOf(containerPath) + "." + field.getName(), field.getName(), typeName, parent);
            parent.addPort((CHPort)port);
            CHPort interf = null;
            for (CHPort dPort : designNode.getPorts()) {
                if (!dPort.getName().equals("(" + typeName + ")")) continue;
                interf = dPort;
            }
            if (interf == null) {
                interf = new CHInterface("design." + typeName, "(" + typeName + ")", typeName, (CHContainer)designNode);
                GoToInfo marker = GoToInfo.sourceOf((IRfNamedElement)associatedType);
                ((CHInterface)interf).setTypeMarker(marker);
                designNode.addPort(interf);
            }
            CHConnection connection = new CHConnection((CHPort)port, interf, this.getLanguageKind(), bundle.project);
            port.addConnection(connection);
            interf.addConnection(connection);
            connections.add(connection);
            port.getParent().setIsConnected();
            interf.getParent().setIsConnected();
        }
        if (wrapper.getChildren() != null) {
            for (IDVTElementWrapper child : wrapper.getChildren()) {
                this.createDesignConnections(child, connections, designNode, bundle, monitor);
            }
        }
    }

    private CHPort createSimpleVifConnectionPort(CHDesign designNode, Bundle bundle, IRfNamedElement associatedType, String typeName) {
        CHPort designNodeInterfPort = null;
        for (CHPort dPort : designNode.getPorts()) {
            if (!dPort.getName().equals("(" + typeName + ")")) continue;
            designNodeInterfPort = dPort;
            break;
        }
        if (designNodeInterfPort == null) {
            designNodeInterfPort = new CHInterface("design." + typeName, "(" + typeName + ")", typeName, (CHContainer)designNode);
            GoToInfo marker = GoToInfo.sourceOf((IRfNamedElement)associatedType);
            ((CHInterface)designNodeInterfPort).setTypeMarker(marker);
            designNode.addPort(designNodeInterfPort);
            String portPath = "design." + designNodeInterfPort.getName();
            bundle.portsMap.put(portPath, designNodeInterfPort);
        }
        CHPort interfacePort = designNodeInterfPort;
        return interfacePort;
    }

    private CHUVMComponent createValueContainer(Bundle bundle, String typeName, IRfNamedElement valueElement, CHUVMComponent topContainer, String valueName, String valueFullPath) {
        CHUVMComponent valueContainer = new CHUVMComponent("design." + valueFullPath, valueName, typeName, typeName, topContainer, this.getLanguageKind(), "", bundle.project, (IDVTElementWrapper)new RfTreeElementWrapper(valueElement));
        valueContainer.setIsVisible(true, true);
        CHInterface intrfPort = new CHInterface("design." + valueFullPath + typeName, "", typeName, (CHContainer)valueContainer);
        valueContainer.addPort((CHPort)intrfPort);
        GoToInfo marker = GoToInfo.sourceOf((IRfNamedElement)valueElement);
        valueContainer.setInstanceMarker(marker);
        if (valueElement instanceof RfInstance) {
            IRfNamedElement valueAssociatedType = ((RfInstance)valueElement).getAssociatedType();
            if (valueAssociatedType instanceof RfInstance.RfInstanceList) {
                valueAssociatedType = ((RfInstance.RfInstanceList)valueAssociatedType).getAssociatedType();
            }
            marker = GoToInfo.sourceOf((IRfNamedElement)valueAssociatedType.getDeclaration().getNamedElement());
            valueContainer.setTypeMarker(marker);
        }
        topContainer.addChild((CHContainer)valueContainer);
        bundle.containerMap.put("design." + valueFullPath, (CHContainer)valueContainer);
        String portPath = "design." + valueFullPath + typeName;
        bundle.portsMap.put(portPath, (CHPort)intrfPort);
        return valueContainer;
    }

    private CHUVMComponent createTopContainer(CHDesign designContainer, Bundle bundle, String instNameString, ElementPath moduleHierarchyPath, IRfNamedElement valueEnclosingElement, String valueEnclosingName) {
        CHUVMComponent topContainer = new CHUVMComponent(moduleHierarchyPath.toString(), moduleHierarchyPath.toString(), valueEnclosingName, valueEnclosingName, null, this.getLanguageKind(), instNameString, bundle.project, (IDVTElementWrapper)new RfTreeElementWrapper(valueEnclosingElement));
        topContainer.setIsVisible(true, true);
        GoToInfo marker = GoToInfo.sourceOf((IRfNamedElement)valueEnclosingElement);
        topContainer.setTypeMarker(marker);
        designContainer.addChild((CHContainer)topContainer);
        bundle.containerMap.put("design." + moduleHierarchyPath.toString(), (CHContainer)topContainer);
        return topContainer;
    }

    private String getName(IDVTElementWrapper wrapper) {
        DataType dataType;
        if (wrapper == null) {
            return "";
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfXvmBase)) {
            return "";
        }
        IRfNamedElement rfElement = ((RfXvmBase)element).getNamedElement();
        if (rfElement == null) {
            return "";
        }
        String name = ((RfXvmBase)element).getName();
        if (name == null || name.isEmpty()) {
            name = rfElement.getName();
        }
        if (rfElement instanceof RfField && (dataType = ((RfField)rfElement).getDataType()) != null && dataType.isArray()) {
            name = String.valueOf(name) + "[]";
        }
        return name;
    }

    private String appendShallowInformation(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return "";
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfXvmBase)) {
            return "";
        }
        IRfNamedElement rfElement = ((RfXvmBase)element).getNamedElement();
        if (rfElement == null) {
            return "";
        }
        return rfElement.isShallowCompiled() ? "[S] " : (rfElement.isIncrementalShallowCompiled() ? "[iS] " : "");
    }

    private RfXvmObject getXvmObject(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        Object rfElement = wrapper.getRfElement();
        if (rfElement instanceof RfXvmObject) {
            return (RfXvmObject)rfElement;
        }
        if (rfElement instanceof RfXvmObjectInstance) {
            return ((RfXvmObjectInstance)rfElement).getObject();
        }
        return null;
    }

    private String getType(Object rfElement) {
        String type = "";
        if (rfElement instanceof RfXvmObjectInstance) {
            RfXvmObject object = ((RfXvmObjectInstance)rfElement).getObject();
            if (object != null) {
                return object.getName();
            }
        } else if (rfElement instanceof RfXvmObject) {
            type = ((RfXvmObject)rfElement).getName();
        }
        if (type.contains("::")) {
            type = type.substring(type.indexOf(58) + 2);
        }
        return type;
    }

    public String getPath(IDVTElementWrapper wrapper, String initialPath) {
        String path = ViewsUtilsCommon.pathToRoot((Object)wrapper, (String)".", elemWrapper -> {
            if (!(elemWrapper instanceof IDVTElementWrapper)) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            Object obj = ((IDVTElementWrapper)elemWrapper).getRfElement();
            if (obj instanceof RfXvmObjectInstance) {
                RfField lhField = ((RfXvmObjectInstance)obj).getLHField();
                if (lhField != null) {
                    result.append(lhField.getName());
                } else {
                    result.append(((RfXvmObjectInstance)obj).getName());
                }
            } else if (obj instanceof RfXvmObject) {
                result.append(((RfXvmObject)obj).getName());
            } else if (obj instanceof XXVMComponent) {
                result.append(((XXVMComponent)obj).getName());
            }
            return result.toString();
        });
        return String.valueOf(initialPath) + path;
    }

    public String getNameFor(Object rfElement) {
        if (rfElement instanceof RfXvmBase) {
            return ((RfXvmBase)rfElement).getName();
        }
        if (rfElement instanceof XXVMComponent) {
            return ((XXVMComponent)rfElement).getSVType();
        }
        return "";
    }

    private String getSVTypeForPort(RfXvmPort port, IRfNamedElement scope) {
        if (port == null) {
            return "";
        }
        RfField field = port.getRfField();
        if (scope instanceof RfClass) {
            scope = ((RfClass)scope).getDefaultSpecialization(null);
        }
        String associatedTypeName = field.getAssociatedTypeName((IRfScopeElement)scope, 50);
        if (field == null || associatedTypeName == null) {
            return "";
        }
        return associatedTypeName;
    }

    private RfClass getTranslatedType(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RfClass) {
            return (RfClass)object;
        }
        IRfNamedElement translatedType = (IRfNamedElement)object;
        HashSet<String> typeAliasNames = new HashSet<String>(4);
        while (translatedType instanceof RfListType || translatedType instanceof RfTypeAlias) {
            if (typeAliasNames.contains(translatedType.getName())) break;
            if (translatedType instanceof RfListType) {
                typeAliasNames.add(translatedType.getName());
                translatedType = ((RfListType)translatedType).getAssociatedType();
            }
            if (!(translatedType instanceof RfTypeAlias)) continue;
            typeAliasNames.add(translatedType.getName());
            translatedType = ((RfTypeAlias)translatedType).getTranslatedType2();
        }
        return translatedType instanceof RfClass ? (RfClass)translatedType : null;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public void checkInput(IDVTElementWrapper wrapper) {
        Object element = wrapper.getRfElement();
        if (element instanceof XXVMComponent) {
            return;
        }
        if (!(element instanceof RfXvmBase)) {
            throw new DMessageException("Could not generate diagram!");
        }
        RfXvmBase xvmComponent = (RfXvmBase)element;
        if (xvmComponent.getNamedElement() == null) {
            throw new DMessageException("Could not generate diagram!\nInternal database has been changed since diagram was previously created!");
        }
    }

    static class Bundle {
        Map<String, CHContainer> containerMap = new LinkedHashMap<String, CHContainer>();
        Map<String, CHPort> portsMap = new LinkedHashMap<String, CHPort>();
        CHDesign designNode = new CHDesign();
        String initialPathSegment = "";
        IProject project;

        Bundle() {
        }
    }

    class ConnectionVisitor
    implements IHidVisitor<RfHidAccess> {
        private String path;
        private Set<CHConnection> connections;
        Bundle bundle;
        private IRfNamedElement currentScope;

        public ConnectionVisitor(String path, Set<CHConnection> result, Bundle bundle) {
            this.path = path;
            this.connections = result;
            this.bundle = bundle;
        }

        public void setHolder(IHidHolder holder) {
            this.currentScope = ((HidHolder)holder).getScope();
        }

        public boolean visit(RfHidAccess hidAccess) {
            String left;
            if (!(hidAccess instanceof RfHidAccessArgs)) {
                return true;
            }
            Hid hid = hidAccess.getParentHid();
            if (hid == null) {
                return true;
            }
            if ("put".equals(hid.getName()) || "get".equals(hid.getName())) {
                this.computePortEndpointInfoForMethodCall(hid);
                return true;
            }
            if (!"connect".equals(hid.getName())) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                return true;
            }
            IRfScopeElement enclosingScope = element.getEnclosingScope();
            if (!RfXvmFactory.checkPort(enclosingScope)) {
                return true;
            }
            Hid portHid = hid.getParentHid();
            if (portHid == null) {
                return true;
            }
            boolean checkPortFIFO = RfXvmFactory.checkPortFIFO(portHid);
            if (checkPortFIFO) {
                portHid = portHid.getParentHid();
            }
            if ((left = String.valueOf(this.path) + "." + this.adjustPortPath(portHid)).equals(this.path)) {
                return true;
            }
            String right = null;
            MethodCall methodCall = ((RfHidAccessArgs)hidAccess).getMethodCall();
            if (methodCall == null || methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) {
                return true;
            }
            for (Map.Entry assocEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                Hid parentHid;
                IHidObject value = (IHidObject)assocEntry.getValue();
                if (value == null || HidUtils.isOperator((IHidObject)value)) continue;
                if (value instanceof Hid && RfXvmFactory.checkPortFIFO((Hid)value)) {
                    value = ((Hid)value).getParentHid();
                }
                if (value instanceof RfHidAccess && (parentHid = ((RfHidAccess)value).getParentHid()) != null) {
                    value = parentHid.getAncestorHid();
                }
                right = String.valueOf(this.path) + "." + this.adjustPortPath((Hid)value);
                break;
            }
            if (right == null || right.equals(this.path)) {
                return true;
            }
            left = DVTStringUtil.replaceAll((Pattern)NONWORD_PATTERN, (CharSequence)left, (String)"");
            right = DVTStringUtil.replaceAll((Pattern)NONWORD_PATTERN, (CharSequence)right, (String)"");
            CHPort leftPort = this.bundle.portsMap.get(left);
            CHPort rightPort = this.bundle.portsMap.get(right);
            if (leftPort == null || rightPort == null) {
                return true;
            }
            this.computeEndpointInfo(leftPort);
            this.computeEndpointInfo(rightPort);
            CHConnection connection = new CHConnection(leftPort, rightPort, VlogCHModel.this.getLanguageKind(), this.bundle.project);
            leftPort.addConnection(connection);
            rightPort.addConnection(connection);
            HidOccurrence occurrence = ((RfHidAccessArgs)hidAccess).getOccurrence();
            IRfDefElement declaration = this.currentScope.getDeclaration();
            GoToInfo marker = null;
            if (occurrence != null && declaration != null) {
                marker = GoToInfo.of((String)declaration.getParserPath().path, (int)occurrence.getOffset(), (int)occurrence.getVirtualOffset(), (int)occurrence.getLine(), (String)"", (LanguageKind)VlogCHModel.this.getLanguageKind());
            }
            if (marker != null) {
                connection.setInspectViewMarker(marker);
            }
            this.connections.add(connection);
            leftPort.getParent().setIsConnected();
            rightPort.getParent().setIsConnected();
            return true;
        }

        private void computeEndpointInfo(CHPort port) {
            if (port.getKind() == CHPort.Kind.PORT && port.getDirectionKind() == CHPort.DirectionKind.ANALYSIS) {
                port.setEndpointSource();
            }
            if (port.getKind() == CHPort.Kind.IMPLEMENTATION) {
                if (port.getDirectionKind() == CHPort.DirectionKind.GET) {
                    port.setEndpointSource();
                }
                if (port.getDirectionKind() == CHPort.DirectionKind.PUT || port.getDirectionKind() == CHPort.DirectionKind.ANALYSIS) {
                    port.setEndpointDestination();
                }
            }
        }

        private void computePortEndpointInfoForMethodCall(Hid hid) {
            String left;
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                return;
            }
            IRfScopeElement enclosingScope = element.getEnclosingScope();
            if (!RfXvmFactory.checkPort(enclosingScope)) {
                return;
            }
            Hid portHid = hid.getParentHid();
            if (portHid == null) {
                return;
            }
            boolean checkPortFIFO = RfXvmFactory.checkPortFIFO(portHid);
            if (checkPortFIFO) {
                portHid = portHid.getParentHid();
            }
            if ((left = String.valueOf(this.path) + "." + this.adjustPortPath(portHid)).equals(this.path)) {
                return;
            }
            CHPort leftPort = this.bundle.portsMap.get(left = DVTStringUtil.replaceAll((Pattern)NONWORD_PATTERN, (CharSequence)left, (String)""));
            if (leftPort.getKind() != CHPort.Kind.PORT) {
                return;
            }
            if (leftPort.getDirectionKind() == CHPort.DirectionKind.GET && "get".equals(hid.getName())) {
                leftPort.setEndpointDestination();
            }
            if (leftPort.getDirectionKind() == CHPort.DirectionKind.PUT && "put".equals(hid.getName())) {
                leftPort.setEndpointSource();
            }
        }

        private String adjustPortPath(Hid portHid) {
            String result = HidUtils.toNiceString((IHidObject)portHid);
            if (result.startsWith("this.")) {
                result = result.substring(5);
            }
            return result;
        }

        public Class<RfHidAccess> getType() {
            return RfHidAccess.class;
        }
    }
}

