/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.diagrams.uml;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.editor.DUMLEditorFactory;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.vlogdt.diagrams.uml.model.VlogUMLModel;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

public enum VlogUMLHelper {
    INSTANCE;


    public UMLDiagram makeStructDiagramFor(Set<Object> structList, IProject project) {
        UMLDiagramConfiguration config = UMLDiagramConfiguration.getDefault();
        VlogUMLModel model = VlogUMLModel.createModel(config, project);
        if (model == null) {
            return null;
        }
        model.setRightTypes(structList);
        model.setGatherAllTypes(true);
        return new UMLDiagram(model.getTooltip(), model.getName(), (UMLModel)model);
    }

    public UMLDiagram makeArchitectureDiagramFor(String uvmIncludePrefConst, String uvmExcludePrefConst, IProject project, UMLModel.DiagramKind kind) {
        UMLDiagramConfiguration config = UMLDiagramConfiguration.getArchDefault();
        VlogUMLModel model = VlogUMLModel.createModel(config, project);
        if (model == null) {
            return null;
        }
        model.setGatherAllTypes(true);
        model.setDiagramKind(kind);
        String includePrefVal = DVTPlugin.getDefault().getPreferenceStore().getString(uvmIncludePrefConst);
        String excludePrefVal = DVTPlugin.getDefault().getPreferenceStore().getString(uvmExcludePrefConst);
        model.setIncludePrefVal(includePrefVal);
        model.setExcludePrefVal(excludePrefVal);
        return new UMLDiagram(model.getTooltip(), model.getName(), (UMLModel)model);
    }

    public void openUMLDiagramEditor(UMLDiagram diagram) {
        DUMLEditorFactory.getInstance().newUMLDiagram(diagram).openEditor();
    }

    public void testMakeDiagramForClasses(String[] classes, IProject project, UMLDiagramConfiguration config) {
        VlogUMLModel model = VlogUMLModel.createModel(config, project);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        RfNamedElement[] types = rfProject.getAllTypes(false, false);
        HashMap<String, RfNamedElement> typesMap = new HashMap<String, RfNamedElement>();
        RfNamedElement[] rfNamedElementArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement type = rfNamedElementArray[n2];
            if (!(type instanceof RfForwardTypedef)) {
                typesMap.put(type.getEnclosingPackage() + "::" + type.getName(), type);
            }
            ++n2;
        }
        LinkedHashSet<RfNamedElement> rightTypes = new LinkedHashSet<RfNamedElement>();
        String[] stringArray = classes;
        int n3 = classes.length;
        n = 0;
        while (n < n3) {
            String clazz = stringArray[n];
            RfNamedElement type = (RfNamedElement)typesMap.get(clazz);
            rightTypes.add(type);
            ++n;
        }
        model.setRightTypes(rightTypes);
        DUMLEditorFactory.getInstance().newUMLDiagram((UMLModel)model).openNewEditor();
        ObjectionManager.getInstance().waitFor(new Objection[]{Objection.DIAGRAM_EDITOR});
    }
}

