/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.diagrams.uml;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.editor.IDiagramToolbarMenuItemProvider;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.vlogdt.diagrams.uml.VlogUMLHelper;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class VlogUmlDiagramToolbarMenuItemContributor
implements IDiagramToolbarMenuItemProvider {
    public void addMenuEntry(Menu menu, IStructuredSelection selection, IWorkbenchWindow window) {
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        VlogUmlDiagramToolbarMenuItemContributor.addMenuItem(menu, "SystemVerilog Architecture UML Diagram", "umldiagrams.architecture_includes", "umldiagrams.architecture_excludes", project, UMLModel.DiagramKind.ARCHITECTURE);
        VlogUmlDiagramToolbarMenuItemContributor.addMenuItem(menu, "SystemVerilog Sequences UML Diagram", "umldiagrams.sequences_includes", "umldiagrams.sequences_excludes", project, UMLModel.DiagramKind.SEQUENCE);
    }

    private static void addMenuItem(Menu menu, String text, final String uvmIncludePrefConst, final String uvmExcludePrefConst, final IProject project, final UMLModel.DiagramKind kind) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(text);
        menuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UMLDiagram umlDiagram = VlogUMLHelper.INSTANCE.makeArchitectureDiagramFor(uvmIncludePrefConst, uvmExcludePrefConst, project, kind);
                VlogUMLHelper.INSTANCE.openUMLDiagramEditor(umlDiagram);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public int compareTo(IDiagramToolbarMenuItemProvider o) {
        return this.getProviderName().compareToIgnoreCase(o.getProviderName());
    }

    public String getProviderName() {
        return "2.B. Verilog UVM";
    }
}

