/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.diagrams.uml.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.UMLAbstractEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLInheritanceEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.diagrams.uml.model.UMLNodeMember;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.CharBufferCacher;

public class VlogUMLModel
extends UMLModel {
    private RfClass uvmComponentClass;
    private Set<RfClass> uvmRegBaseClasses = new LinkedHashSet<RfClass>();
    private static final Predicate<Object> CHECK_VALID = obj -> {
        if (!(obj instanceof RfNamedElement)) {
            return false;
        }
        return !((RfNamedElement)obj).hasNoDefs(false);
    };

    private VlogUMLModel(UMLDiagramConfiguration config) {
        super(config);
    }

    public static VlogUMLModel createModel(UMLDiagramConfiguration config, IProject project) {
        if (project == null || config == null) {
            return null;
        }
        VlogUMLModel model = new VlogUMLModel(config);
        model.setProject(project);
        model.setElementPathChecker(CHECK_VALID);
        return model;
    }

    public String generateID(Object element) {
        if (!(element instanceof IRfNamedElement)) {
            return "";
        }
        IRfNamedElement namedElement = (IRfNamedElement)element;
        namedElement = this.getGenericClass(namedElement);
        return RfElementPath.path((IRfNamedElement)namedElement).toNiceString();
    }

    public List<Object> getAllClasses(IProject project, IProgressMonitor monitor) {
        RfNamedElement[] types;
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        ArrayList<Object> result = new ArrayList<Object>();
        if (rfProject == null) {
            return result;
        }
        RfNamedElement[] rfNamedElementArray = types = rfProject.getAllTypes(false, false);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement type = rfNamedElementArray[n2];
            if (monitor.isCanceled()) {
                return null;
            }
            if (!(type instanceof RfForwardTypedef)) {
                if (type instanceof RfClass) {
                    result.add(type);
                } else if (type instanceof RfTypeAlias && ((RfTypeAlias)type).getTranslatedType2() instanceof RfClass) {
                    result.add(type);
                }
            }
            ++n2;
        }
        return result;
    }

    public boolean internalStruct(Object rfStruct) {
        return false;
    }

    public String getDetails(Object object) {
        RfNamedElement element = (RfNamedElement)object;
        if (element == null) {
            return null;
        }
        return element.getFullName();
    }

    public static boolean isShowLeftPanelTypeStatic(Object o) {
        RfDefElement declaration = ((RfNamedElement)o).getDeclaration();
        if (declaration == null) {
            return false;
        }
        RfFileDef defFile = declaration.getDefFile();
        if (defFile == null) {
            return false;
        }
        IPath filePath = Path.fromOSString((String)defFile.getParserPath().path);
        return filePath != null;
    }

    public Image getIcon(Object object) {
        RfNamedElement element = (RfNamedElement)object;
        if (element == null) {
            return null;
        }
        if (element instanceof RfClass && ((RfClass)element).isInterfaceClass()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_CLASS);
        }
        if (element instanceof RfClass) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
    }

    public static boolean hasClassDiagram(Object o) {
        if (o instanceof RfForwardTypedef) {
            return false;
        }
        if (o instanceof RfClass || o instanceof RfTypeAlias && ((RfTypeAlias)o).getTranslatedType2() instanceof RfClass) {
            return VlogUMLModel.isShowLeftPanelTypeStatic(o);
        }
        return false;
    }

    public String getFullNodeName(Object struct) {
        if (!(struct instanceof RfNamedElement)) {
            return "";
        }
        String fullName = ((RfNamedElement)struct).getFullName();
        return fullName != null ? fullName : "";
    }

    public String getNodeName(Object struct) {
        String name = ((RfNamedElement)struct).getName();
        return name != null ? name : "";
    }

    protected IRfNamedElement getTranslatedType(Object object) {
        if (!(object instanceof RfTypeAlias)) {
            return null;
        }
        IRfNamedElement translatedType = (IRfNamedElement)object;
        LinkedHashSet<String> typeAliasNames = new LinkedHashSet<String>(4);
        while (translatedType instanceof RfListType || translatedType instanceof RfTypeAlias) {
            if (typeAliasNames.contains(translatedType.getName())) break;
            if (translatedType instanceof RfListType) {
                typeAliasNames.add(translatedType.getName());
                translatedType = ((RfListType)translatedType).getAssociatedType();
            }
            if (!(translatedType instanceof RfTypeAlias)) continue;
            typeAliasNames.add(translatedType.getName());
            translatedType = ((RfTypeAlias)translatedType).getTranslatedType2();
        }
        return (translatedType = this.getGenericClass(translatedType)) instanceof RfClass ? translatedType : null;
    }

    protected String getClassGenericParams(Object object) {
        String result = object instanceof RfClass ? ((RfClass)object).getGenericParameters2() : "";
        result = result.replaceAll("\\\\", "");
        return result;
    }

    protected String getClassReplacedParams(UMLInheritanceEdge edge) {
        if (edge.getChild().getElement() instanceof RfTypeAlias) {
            return "[typedef]";
        }
        return ((RfClass)edge.getChild().getElement()).getReplacedParameters2();
    }

    protected List<UMLNode> getClassParents(UMLNode structNode) {
        if (structNode.getElement() instanceof RfTypeAlias) {
            IRfNamedElement translatedType = this.getTranslatedType(structNode.getElement());
            if (translatedType instanceof RfClass) {
                return Collections.singletonList(this.createNode(translatedType));
            }
        } else if (structNode.getElement() instanceof RfClass) {
            List<RfClass> interfaces;
            RfClass element = (RfClass)structNode.getElement();
            ArrayList<UMLNode> result = new ArrayList<UMLNode>();
            IRfNamedElement parent = this.getGenericClass(element.getParent());
            if (parent instanceof RfClass) {
                result.add(this.createNode(parent));
            }
            if ((interfaces = element.getParentInterfaces()) != null && !interfaces.isEmpty()) {
                for (RfClass inter : interfaces) {
                    IRfNamedElement genericInter = this.getGenericClass(inter);
                    if (!(genericInter instanceof RfClass)) continue;
                    result.add(this.createNode(genericInter));
                }
            }
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    public UMLNode createNode(Object element) {
        if (!(element instanceof IRfNamedElement)) {
            return null;
        }
        IRfNamedElement namedElement = (IRfNamedElement)element;
        namedElement = this.getGenericClass(namedElement);
        UMLNode node = super.createNode(element, element instanceof RfClass ? ((RfClass)element).isPredefined() : false);
        if (node == null) {
            return null;
        }
        node.isInterface = element instanceof RfClass && ((RfClass)element).isInterfaceClass();
        UMLPackage umlPackage = null;
        RfPackage pack = (RfPackage)namedElement.getEnclosingScope(RfPackage.class);
        if (pack != null) {
            umlPackage = (UMLPackage)this.getPackages().get(pack.getName());
            if (umlPackage == null) {
                umlPackage = new UMLPackage(pack.getName(), GoToInfo.sourceOf((IRfNamedElement)pack));
                this.getPackages().put(umlPackage.getName(), umlPackage);
            }
        } else {
            RfModule module = (RfModule)namedElement.getEnclosingScope(RfModule.class);
            if (module != null) {
                umlPackage = (UMLPackage)this.getPackages().get(module.getName());
                if (umlPackage == null) {
                    umlPackage = new UMLPackage(module.getName(), GoToInfo.sourceOf((IRfNamedElement)module));
                    this.getPackages().put(umlPackage.getName(), umlPackage);
                }
            } else {
                RfProgram program = (RfProgram)namedElement.getEnclosingScope(RfProgram.class);
                if (program != null && (umlPackage = (UMLPackage)this.getPackages().get(program.getName())) == null) {
                    umlPackage = new UMLPackage(program.getName(), GoToInfo.sourceOf((IRfNamedElement)program));
                    this.getPackages().put(umlPackage.getName(), umlPackage);
                }
            }
        }
        if (umlPackage == null) {
            umlPackage = UMLPackage.getGlobalScope();
        }
        node.setPackage(umlPackage);
        return node;
    }

    public List<UMLNode> getClassChildren(Object object) {
        IRfNamedElement translatedType;
        RfClass clazz = null;
        if (object instanceof RfClass) {
            clazz = (RfClass)object;
        } else if (object instanceof RfTypeAlias && (translatedType = this.getTranslatedType(object)) instanceof RfClass) {
            clazz = (RfClass)translatedType;
        }
        if (clazz == null) {
            return Collections.emptyList();
        }
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UMLNode> result = new ArrayList<UMLNode>();
        for (RfClass child : children) {
            result.add(this.createNode(child));
        }
        return result;
    }

    protected List<UMLNodeMember> getFields(Object object, boolean publicOnly) {
        try {
            if (!(object instanceof RfClass)) {
                List<UMLNodeMember> list = Collections.emptyList();
                return list;
            }
            List<RfField> fields = ((RfClass)object).getFields();
            if (fields == null) {
                List<UMLNodeMember> list = Collections.emptyList();
                return list;
            }
            ArrayList<UMLNodeMember> result = new ArrayList<UMLNodeMember>();
            for (RfField member : fields) {
                DVTGUIFilterMatcher.GUIFilterResult filtered;
                if (publicOnly && !member.isPublic() || member.isPredefined() || !this.config.generateForSpecador() && (filtered = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.DIAGRAM, (IRfNamedElement)member, () -> member.getName())) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
                String fieldName = this.getFieldName(member);
                if (this.isArray(member)) {
                    fieldName = String.valueOf(fieldName) + "[]";
                }
                result.add(new UMLNodeMember((IRfNamedElement)member, fieldName, this.getFieldLabelText(member), GoToInfo.sourceOf((IRfNamedElement)member), member.isPublic()));
            }
            ArrayList<UMLNodeMember> arrayList = result;
            return arrayList;
        }
        finally {
            CharBufferCacher.getInstance().clearCache();
        }
    }

    protected List<UMLNodeMember> getMethods(Object object, boolean publicOnly) {
        try {
            if (!(object instanceof RfClass)) {
                List<UMLNodeMember> list = Collections.emptyList();
                return list;
            }
            List<RfFunction> functions = ((RfClass)object).getLocalMembers(RfFunction.class);
            if (functions == null) {
                List<UMLNodeMember> list = Collections.emptyList();
                return list;
            }
            ArrayList<UMLNodeMember> result = new ArrayList<UMLNodeMember>();
            for (RfFunction member : functions) {
                DVTGUIFilterMatcher.GUIFilterResult filtered;
                if (member.isConstructor() || publicOnly && !member.isPublic() || member.isPredefined() || !this.config.generateForSpecador() && (filtered = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.DIAGRAM, (IRfNamedElement)member, () -> member.getName())) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
                result.add(new UMLNodeMember((IRfNamedElement)member, member.getName(), this.getMethodLabelText(member), GoToInfo.sourceOf((IRfNamedElement)member), member.isPublic()));
            }
            ArrayList<UMLNodeMember> arrayList = result;
            return arrayList;
        }
        finally {
            CharBufferCacher.getInstance().clearCache();
        }
    }

    protected List<UMLNodeMember> getEvents(Object object, boolean publicOnly) {
        if (!(object instanceof RfClass)) {
            return Collections.emptyList();
        }
        List<RfField> events = ((RfClass)object).getEvents();
        if (events == null) {
            return Collections.emptyList();
        }
        ArrayList<UMLNodeMember> result = new ArrayList<UMLNodeMember>();
        for (RfField member : events) {
            DVTGUIFilterMatcher.GUIFilterResult filtered;
            if (publicOnly && !member.isPublic() || member.isPredefined() || !this.config.generateForSpecador() && (filtered = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.DIAGRAM, (IRfNamedElement)member, () -> member.getName())) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
            result.add(new UMLNodeMember((IRfNamedElement)member, member.getName(), this.getEventLabelText(member), GoToInfo.sourceOf((IRfNamedElement)member), member.isPublic()));
        }
        return result;
    }

    private String getFieldName(RfField field) {
        return field.getName();
    }

    protected String getFieldParameters(Object object) {
        String result = "";
        RfField field = (RfField)object;
        try {
            RfNamedElement enclosingScope = field.getEnclosingScope();
            if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
                return result;
            }
            IRfNamedElement assocType = field.getAssociatedType(0);
            if (assocType instanceof RfTypeAlias) {
                return result;
            }
            if (assocType instanceof RfClass) {
                List<RfField> parameters = ((RfClass)assocType).getLocalParameters(256);
                if (parameters == null || parameters.isEmpty()) {
                    return result;
                }
                int i = 0;
                while (i < parameters.size()) {
                    RfField parameter = parameters.get(i);
                    if (parameter.isInParameterPortList()) {
                        Object paramValue = null;
                        if (assocType instanceof RfSpecializedClass) {
                            paramValue = ((RfSpecializedClass)assocType).getElabConstantValue(parameter.getName());
                        }
                        String paramReplacedName = paramValue == null ? parameter.getAssociatedTypeName() : paramValue.toString();
                        result = i == 0 ? " #(" + paramReplacedName : String.valueOf(result) + ", " + paramReplacedName;
                    }
                    ++i;
                }
                if (i > 0) {
                    result = String.valueOf(result) + ")";
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    protected Object getClassTypeOfField(UMLNodeMember nodeMember) {
        IRfNamedElement aRfField = nodeMember.member;
        IRfNamedElement fieldType = ((RfField)aRfField).getAssociatedTypeForAssociationsInDiagrams();
        if (fieldType == null) {
            return null;
        }
        RfTypesResolver typesResolver = RfTypesResolver.create((IRfScopeElement)fieldType, fieldType.getRfProject(), 6);
        while (fieldType instanceof RfListType) {
            fieldType = ((RfListType)fieldType).getAssociatedType(typesResolver);
        }
        IRfNamedElement translatedType = null;
        if (fieldType instanceof RfTypeAlias) {
            translatedType = ((RfTypeAlias)fieldType).getTranslatedType(typesResolver);
        }
        return (fieldType = this.getGenericClass(fieldType)) instanceof RfClass || translatedType instanceof RfClass ? fieldType : null;
    }

    protected Object getEnclosingClassOfField(Object o) {
        return ((RfField)o).getEnclosingScope();
    }

    protected String getFieldLabelText(Object object) {
        RfField field = (RfField)object;
        String dimensions = field.getUnpackedDimensionWithMacros();
        String associatedTypeName = field.getAssociatedTypeName(null, RfTypesResolver.create((IRfScopeElement)field, field.getRfProject(), 0), 33, true, true, false);
        String text = String.valueOf(this.getFieldName(field)) + dimensions + " : " + associatedTypeName + this.getFieldParameters(field);
        text = field.isPrivate() ? "- " + text : (field.isProtected() ? "# " + text : "+ " + text);
        return text;
    }

    protected String getMethodLabelText(Object object) {
        RfFunction method = (RfFunction)object;
        List<RfField> args = method.getArgumentsWithPrefix("", 0);
        StringBuilder argsText = new StringBuilder();
        Iterator<RfField> iterator = args.iterator();
        if (this.config.fullMethodSignature()) {
            while (iterator.hasNext()) {
                RfField arg = iterator.next();
                IRfNamedElement type = arg.getAssociatedType();
                argsText.append(type.getNameForDiagram()).append(" ").append(arg.getName());
                if (!iterator.hasNext()) continue;
                argsText.append(", ");
            }
        }
        String result = String.valueOf(method.getName()) + "(" + argsText.toString() + ")";
        if (method.isFunction()) {
            String typeName = method.getAssociatedTypeName(null, RfTypesResolver.create((IRfScopeElement)method, method.getRfProject(), 0), true, true);
            result = typeName == null || "".equals(typeName) ? String.valueOf(result) + ": void" : String.valueOf(result) + ": " + typeName;
        }
        String text = result;
        text = method.isPrivate() ? "- " + text : (method.isProtected() ? "# " + text : "+ " + text);
        return text;
    }

    protected String getEventLabelText(Object object) {
        RfField field = (RfField)object;
        String text = field.getName();
        text = field.isPrivate() ? "- " + text : (field.isProtected() ? "# " + text : "+ " + text);
        return text;
    }

    protected boolean isAlias(UMLNode o) {
        return o.getElement() instanceof RfTypeAlias;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    private IRfNamedElement getGenericClass(IRfNamedElement object) {
        return object instanceof IRfSpecializedTypeElement ? ((IRfSpecializedTypeElement)object).getGenericElement() : object;
    }

    protected UMLAbstractEdge filterEdges(UMLAbstractEdge edge, UMLModel.DiagramKind diagramKind) {
        if (edge == null) {
            return null;
        }
        if (edge.getSource().isSelected() && edge.getDestination().isSelected()) {
            return edge;
        }
        boolean filterUVM = false;
        boolean keepFirstParent = false;
        boolean keepSelected = false;
        boolean keepFirstAssociation = false;
        boolean onlyComponents = false;
        boolean keepRegs = false;
        List diagramFilters = this.config.getPrefFilters();
        if (diagramFilters != null && diagramFilters.contains("__UVM")) {
            filterUVM = true;
            if (diagramFilters.contains("__KEEP_FIRST_PARENT")) {
                keepFirstParent = true;
            }
            if (diagramFilters.contains("__KEEP_FIRST_ASSOCIATION")) {
                keepFirstAssociation = true;
            }
            if (diagramFilters.contains("__KEEP_SELECTED")) {
                keepSelected = true;
            }
            if (diagramFilters.contains("__KEEP_REGS")) {
                keepRegs = true;
            }
            if (diagramFilters.contains("__COLLABORATION_ONLY_COMPONENTS")) {
                onlyComponents = true;
            }
        }
        if (!filterUVM) {
            return edge;
        }
        if (edge.getSource().getElement() instanceof IRfNamedElement && edge.getDestination().getElement() instanceof IRfNamedElement) {
            IRfNamedElement rfSource = (IRfNamedElement)edge.getSource().getElement();
            IRfNamedElement rfDestination = (IRfNamedElement)edge.getDestination().getElement();
            if (rfSource.isPredefined() || rfDestination.isPredefined()) {
                return null;
            }
            boolean matchSource = this.getFullNodeName(rfSource).startsWith("uvm_pkg");
            boolean matchDestination = this.getFullNodeName(rfDestination).startsWith("uvm_pkg");
            boolean selectedSource = edge.getSource().isSelected();
            boolean selectedDestination = edge.getDestination().isSelected();
            if (diagramKind == UMLModel.DiagramKind.INHERITANCE) {
                if (!(!matchSource || keepSelected && selectedSource && selectedDestination)) {
                    return null;
                }
                if (!(!matchDestination || !edge.isInheritance() || keepFirstParent || keepSelected && selectedDestination)) {
                    return null;
                }
            }
            if (!(!edge.isAssociation() || keepFirstAssociation || !matchDestination || keepSelected && selectedDestination)) {
                return null;
            }
            if (onlyComponents && diagramKind == UMLModel.DiagramKind.COLLABORATION && (rfSource instanceof RfClass && !this.isUVMComponent((RfClass)rfSource) || rfDestination instanceof RfClass && !this.isUVMComponent((RfClass)rfDestination))) {
                return null;
            }
            if (!keepRegs && (edge.isInheritance() && diagramKind == UMLModel.DiagramKind.NA || !edge.isInheritance())) {
                boolean sourceReg = false;
                if (rfSource instanceof RfClass && this.isUVMReg((RfClass)rfSource)) {
                    sourceReg = true;
                }
                boolean destReg = false;
                if (rfDestination instanceof RfClass && this.isUVMReg((RfClass)rfDestination)) {
                    destReg = true;
                }
                if (sourceReg && destReg) {
                    return null;
                }
            }
        }
        return edge;
    }

    public void filterUVMClasses(Collection<Object> structs) {
        Object object;
        if (!this.config.getPrefFilters().contains("__UVM")) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(this.getProject());
        if (rfProject == null && !structs.isEmpty() && (object = structs.iterator().next()) instanceof IRfNamedElement) {
            rfProject = (RfProject)((IRfNamedElement)object).getEnclosingScope(RfProject.class);
        }
        if (rfProject != null) {
            this.uvmComponentClass = rfProject.getClass("uvm_pkg::uvm_component", true);
            RfClass regClass = rfProject.getClass("uvm_pkg::uvm_reg", true);
            if (regClass != null) {
                this.uvmRegBaseClasses.add(regClass);
            }
            if ((regClass = rfProject.getClass("uvm_pkg::uvm_reg_block", true)) != null) {
                this.uvmRegBaseClasses.add(regClass);
            }
            if ((regClass = rfProject.getClass("uvm_pkg::uvm_reg_field", true)) != null) {
                this.uvmRegBaseClasses.add(regClass);
            }
            if ((regClass = rfProject.getClass("uvm_pkg::uvm_reg_map", true)) != null) {
                this.uvmRegBaseClasses.add(regClass);
            }
            if ((regClass = rfProject.getClass("uvm_pkg::uvm_reg_file", true)) != null) {
                this.uvmRegBaseClasses.add(regClass);
            }
        }
        Iterator<Object> iter = structs.iterator();
        while (iter.hasNext()) {
            Object struct = iter.next();
            if (!this.getFullNodeName(struct).startsWith("uvm_pkg")) continue;
            iter.remove();
        }
    }

    private boolean isUVMComponent(RfClass aClass) {
        if (aClass == null) {
            return false;
        }
        return this.uvmComponentClass != null && (aClass.getFullName() != null && aClass.getFullName().equals(this.uvmComponentClass.getFullName()) || aClass.isSubClass(this.uvmComponentClass));
    }

    private boolean isUVMReg(RfClass aClass) {
        if (aClass == null) {
            return false;
        }
        for (RfClass regClass : this.uvmRegBaseClasses) {
            if ((aClass.getFullName() == null || !aClass.getFullName().equals(regClass.getFullName())) && !aClass.isSubClass(regClass)) continue;
            return true;
        }
        return false;
    }

    public UMLModel getCopy(UMLDiagramConfiguration config) {
        VlogUMLModel copy = new VlogUMLModel(config);
        copy.setRightTypes(this.rightTypes.values());
        Set leftTypesSet = Collections.newSetFromMap(new IdentityHashMap());
        leftTypesSet.addAll(this.leftTypes);
        copy.setLeftTypes(leftTypesSet);
        copy.setProject(this.project);
        copy.setElementPathChecker(this.elementPathChecker);
        copy.setGatherAllTypes(this.gatherAllTypes);
        copy.setDiagramKind(this.getDiagramKind());
        copy.publicAssociationsOnly = this.publicAssociationsOnly;
        copy.setIncludePrefVal(this.getIncludePrefVal());
        copy.setExcludePrefVal(this.getExcludePrefVal());
        copy.copyNodes(this);
        return copy;
    }

    protected GoToInfo getSourceMarker(Object struct) {
        return GoToInfo.sourceOf((IRfNamedElement)((IRfNamedElement)struct));
    }

    public boolean isValid(Object element) {
        if (this.elementPathChecker == null) {
            this.setElementPathChecker(CHECK_VALID);
        }
        return this.elementPathChecker.test(element);
    }

    public boolean isPredefined(Object struct) {
        return ((IRfNamedElement)struct).isPredefined();
    }

    private boolean isArray(RfField field) {
        DataType dataType = field.getDataType();
        return dataType != null && dataType.isArray();
    }
}

