/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.emacs;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class EmacsJob
extends Job {
    private IFile fFile;
    private String fFunction;
    private static String RUNNING_EMACS = "[emacs] function '{function}' for file '{file}'";

    public EmacsJob(IFile file, String function) {
        super("");
        this.fFile = file;
        this.fFunction = function;
        this.setName(this.getJobName());
        this.setPriority(10);
        this.setUser(true);
    }

    private String getJobName() {
        return RUNNING_EMACS.replaceAll("\\{function\\}", this.fFunction).replaceAll("\\{file\\}", this.fFile.getName());
    }

    public boolean shouldSchedule() {
        return this.fFile != null && this.fFunction != null;
    }

    public boolean shouldRun() {
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        Process process = null;
        try {
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                DebugUIPlugin.getDefault();
                List envpForProcess = ExternalToolsUtil.makeEnv((Map)BuildConfigManager.getenv((IProject)this.fFile.getProject()));
                process = DebugPlugin.exec((String[])this.makeCmdLine(), null, (String[])envpForProcess.toArray(new String[envpForProcess.size()]));
                IProcess runtimeProcess = null;
                Launch launch = new Launch(null, "run", null);
                launch.setAttribute("org.eclipse.debug.core.capture_output", "true");
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                if (process != null) {
                    monitor.beginTask(this.getJobName(), -1);
                    runtimeProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.getJobName());
                }
                if (process == null || runtimeProcess == null) {
                    if (process != null) {
                        process.destroy();
                    }
                    throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 150, ExternalToolsMessages.ProgramLaunchDelegate_4, null));
                }
                launch.addProcess(runtimeProcess);
                launchManager.addLaunch((ILaunch)launch);
                while (!runtimeProcess.isTerminated()) {
                    try {
                        if (monitor.isCanceled()) {
                            runtimeProcess.terminate();
                            break;
                        }
                        monitor.worked(1);
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        result = Status.CANCEL_STATUS;
                    }
                }
                try {
                    this.fFile.refreshLocal(0, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                }
            }
            catch (CoreException e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DVTExceptionHandler.handle((CoreException)e, (String)"Internal error", (String)("DVT encountered an internal error while " + EmacsJob.this.getJobName()));
                    }
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            if (process != null) {
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)process.getOutputStream());
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)process.getInputStream());
                DVTUtilsCommon.INSTANCE.closeClosable((Closeable)process.getErrorStream());
                process.destroy();
            }
            monitor.done();
        }
        return result;
    }

    private String[] makeCmdLine() {
        boolean winOS = System.getProperty("os.name").startsWith("Windows");
        ArrayList<String> result = new ArrayList<String>();
        String emacsCommandLine = "";
        if (winOS) {
            result.add("cmd");
            result.add("/c");
        } else {
            result.add("sh");
            result.add("-c");
        }
        emacsCommandLine = this.getCustomElPath() != null ? String.valueOf(emacsCommandLine) + this.getEmacsCommand() + " --batch --no-site-file -l " + this.getCustomElPath() + " " + this.fFile.getLocation().toOSString() + " -f " + this.fFunction : String.valueOf(emacsCommandLine) + this.getEmacsCommand() + " -user " + System.getProperty("user.name") + " --batch " + this.fFile.getLocation().toOSString() + " -f " + this.fFunction;
        result.add(emacsCommandLine);
        return result.toArray(new String[result.size()]);
    }

    private String getCustomElPath() {
        IProject project = this.fFile.getProject();
        if (project == null) {
            return null;
        }
        IPath location = project.getLocation();
        if (location == null) {
            return null;
        }
        IPath path = location.append(".dvt").append("verilog-mode.el");
        if (!path.toFile().exists()) {
            return null;
        }
        return path.toOSString();
    }

    private String getEmacsCommand() {
        return DVTPlugin.getDefault().getPreferenceStore().getString("emacs.command");
    }
}

